/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.lz;

import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;
import uds.common.config.lz.ConfPropsLz;

public class LzConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfPropsLz.class);
    private String lzId = "-1";
    private String azId = "-1";
    private String tor = "-1";

    public synchronized void loadConfigFile(String propertyFile) throws ConfigurationException {
        PropertiesConfigBuilder configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(propertyFile, Character.valueOf('|'));
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.azId = this.getConfig().getString("AZ_ID", "-1");
        this.lzId = this.getConfig().getString("LZ_ID", "-1");
        this.tor = this.getConfig().getString("TOR", "-1");
    }

    @Override
    public void reloadConfig() {
        if (this.getConfigBuilder() != null) {
            this.loadConfig();
        }
    }

    public String getLzId() {
        return this.lzId;
    }

    public String getAzId() {
        return this.azId;
    }

    public String getTor() {
        return this.tor;
    }
}

