/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.mdc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.mdc.DefaultConfMdc;

public class MdcConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MdcConfig.class);
    private static final MdcConfig INSTANCE = new MdcConfig();
    private long validatePeriodTime;
    private long garbageObjectDeleteTime;
    private long dcmTaskWalkerPeriodTime;
    private long dataDumpProcessPeriodTime;
    private boolean bucketObjectsValidateSwitch;
    private int validateListObjectNumber;
    private int httpMaxConnections;
    private int httpMaxPerRoute;
    private int httpSocketTimeoutInMs;
    private int httpConnectionTimeOutInMs;
    private int dataDumpUserGroupSize;
    private int dataDumpVisitorPageSize;
    private long dataDumpVisitorExeTime;
    private long dataDumpExeOverTime;
    private int dataDumpVisitorTotalTasks;
    private long dcStatusCheckPeriod;
    private String mdcAuthVersion;
    private String allowedIpRange;
    private Long scanBucketMdcTaskExpire;
    private int maxMdcTaskDeleteQueueCount;
    private Long intervalOfSendScanMdcbucketTask;
    private long bucketCleanTime;
    private int maxMdcTaskDeleteConcurrencyNumPerBucket;
    private int flowControlPeriod;
    private int flowControlMaxCount;
    private int highLevelMiddleObjCount;
    private int highLevelBigObjTaskCount;
    private int highLevelMiddleObjCountAvrageTime;
    private double highLevelSuccessRate;
    private int middleLevelMiddleObjCount;
    private int middleLevelBigObjTaskCount;
    private int middleLevelMiddleObjCountAvrageTime;
    private double middleLevelSuccessRate;
    private boolean needAddMDCMSGVersion;
    private boolean isOSCStaitcFlowControl;
    private boolean isUseHttpBetweenRegions;
    private int sysIdleMiddleObjCount;
    private int sysIdleBigObjCount;
    private int maxMdcTaskLib2dsPerBucket;
    private int initCreateMdcTaskLib2dNum;
    private double highLevelCPUAverage;
    private double midLevelCPUAverage;
    private int parellelDataStreamTimeoutMs;
    private int remoteChannelGiveupTimes;
    private int s3ServiceTimeoutMs;
    private int forwardTimeoutMs;
    private int s3ServiceSocketTimeoutMs;
    private int forwardSocketTimeoutMs;
    private boolean timeoutNeedRetry;
    private int timeoutNeedRetryTimes;
    private String forwardScheme;
    private int forwardPort;
    private int repForWardPort;
    private long bucketLocationCacheTtl;
    private int repConnectionTimeout = 5000;
    private int repSocketTimeout = 10000;
    private int syncRepQueue = 200;
    private int syncRepNum = 20;

    private MdcConfig() {
    }

    public static MdcConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        byte[] content = new byte[]{};
        try (DigestInputStream dis = new DigestInputStream(new ByteArrayInputStream(content), MessageDigest.getInstance("MD5"));){
            dis.on(true);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("MD5 digest method can't load.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("close stream failed!!");
        }
        this.loadConfig();
    }

    private void loadConfig() throws ConfigurationException {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            return;
        }
        this.loadAuthConfig(config);
        this.loadDBConfig(config);
        this.highLevelMiddleObjCount = config.getInt("high_level_middle_obj_count", 500);
        this.highLevelBigObjTaskCount = config.getInt("high_level_big_obj_count", 430);
        this.highLevelMiddleObjCountAvrageTime = config.getInt("high_level_middle_obj_average_time", 600);
        this.highLevelSuccessRate = config.getDouble("high_level_success_rate", 0.9);
        this.middleLevelMiddleObjCount = config.getInt("middle_level_middle_obj_count", 550);
        this.middleLevelBigObjTaskCount = config.getInt("middle_level_big_obj_count", 510);
        this.middleLevelMiddleObjCountAvrageTime = config.getInt("middle_level_middle_obj_average_time", 800);
        this.middleLevelSuccessRate = config.getDouble("middle_level_success_rate", 0.8);
        this.needAddMDCMSGVersion = config.getBoolean("mdc_inner_msg_version", true);
        this.isOSCStaitcFlowControl = config.getBoolean("osc_statistic_rep_flowctrol", true);
        this.isUseHttpBetweenRegions = config.getBoolean("mdc_regions_use_https", true);
        this.sysIdleMiddleObjCount = config.getInt("sys_idle_middle_obj_count", 200);
        this.sysIdleBigObjCount = config.getInt("sys_idle_big_obj_count", 100);
        this.maxMdcTaskLib2dsPerBucket = config.getInt("max_mdc_task_lib2d_per_bucket", 50);
        this.initCreateMdcTaskLib2dNum = config.getInt("initial_create_mdc_task_lib2ds_num", 10);
        this.highLevelCPUAverage = config.getDouble("high_level_cpu_average_time", 0.45);
        this.midLevelCPUAverage = config.getDouble("mid_level_cpu_average_time", 0.55);
        this.parellelDataStreamTimeoutMs = config.getInt("pare_datastream_timeout_ms", 10000);
        this.remoteChannelGiveupTimes = config.getInt("remote_channel_giveup_times", 120000);
        this.loadConfigInner(config);
    }

    private void loadConfigInner(PropertiesConfiguration config) {
        this.s3ServiceTimeoutMs = config.getInt("s3_service_timeout_ms", 10000);
        this.forwardTimeoutMs = config.getInt("forward_timeout_ms", 10000);
        this.s3ServiceSocketTimeoutMs = config.getInt("s3_service_socket_timeout_ms", 300000);
        this.forwardSocketTimeoutMs = config.getInt("forward_socket_timeout_ms", 300000);
        this.timeoutNeedRetry = config.getBoolean("timeout_need_retry", false);
        this.timeoutNeedRetryTimes = config.getInt("timeout_need_retry_times", 4);
        this.forwardScheme = config.getString("forward_scheme", "https");
        this.forwardPort = config.getInt("forward_port", 80);
        this.bucketLocationCacheTtl = config.getLong("bucket_location_read_cache_ttl", 3000L);
        this.repConnectionTimeout = config.getInt("rep_connection_timeout", 5000);
        this.repSocketTimeout = config.getInt("rep_socket_timeout", 10000);
        this.repForWardPort = config.getInt("rep_forward_port", 5443);
        this.syncRepQueue = config.getInt("sync_rep_queue", 200);
        this.syncRepNum = config.getInt("sync_rep_num", 20);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            try {
                this.loadConfig();
            }
            catch (ConfigurationException e) {
                LOGGER.warn("Refresh file[{}] failed.", (Object)this.getConfigBuilder().getFileHandler().getFileName());
            }
        }
    }

    private void loadAuthConfig(PropertiesConfiguration config) throws ConfigurationException {
        this.mdcAuthVersion = config.getString("mdc_auth_version", "V4");
    }

    private void loadDBConfig(PropertiesConfiguration config) throws ConfigurationException {
        this.validatePeriodTime = config.getLong("user_bucket_validate_period", 720L);
        this.dcmTaskWalkerPeriodTime = config.getLong("dcm_tam_walker_period_time", 5L);
        this.dataDumpProcessPeriodTime = config.getLong("data_dump_process_period_time", 60000L);
        this.bucketObjectsValidateSwitch = config.getBoolean("validate_bucket_objects_switch", false);
        this.validateListObjectNumber = config.getInt("validate_list_object_number", 1000);
        this.httpSocketTimeoutInMs = config.getInt("mdc_http_scoket_timeout_ms", 120000);
        this.httpConnectionTimeOutInMs = config.getInt("mdc_http_connection_timeout_ms", 120000);
        this.dataDumpUserGroupSize = config.getInt("data_dump_user_group_size", 200);
        this.dataDumpVisitorPageSize = config.getInt("data_dump_visitor_page_size", 100);
        this.dataDumpVisitorExeTime = config.getLong("data_dump_visitor_exe_time", 300000L);
        this.dataDumpExeOverTime = config.getLong("data_dump_exe_over_time", 1200000L);
        this.dataDumpVisitorTotalTasks = config.getInt("data_dump_visitor_total_tasks", 200000);
        this.dcStatusCheckPeriod = config.getLong("dc_status_check_period", 60000L);
        this.allowedIpRange = config.getString("allowed_ip_range", "127.0.0.1/32");
        this.scanBucketMdcTaskExpire = config.getLong("scan_bucket_mdctask_expire", DefaultConfMdc.SCAN_BUCKET_MDC_TASK_EXPIRE);
        this.maxMdcTaskDeleteQueueCount = config.getInt("max_mdc_task_delete_queue_count", 30);
        this.intervalOfSendScanMdcbucketTask = config.getLong("send_scan_bucket_interval", DefaultConfMdc.INTERVAL_OF_SEND_SCAN_BUCKET);
        this.bucketCleanTime = this.getConfig().getLong("bucket_clean_time", 43200000L);
        this.maxMdcTaskDeleteConcurrencyNumPerBucket = this.getConfig().getInt("max_mdc_task_delete_concurrency_num_per_bucket", 10);
        this.flowControlPeriod = this.getConfig().getInt("period_mdc_replication_task", 5);
        this.flowControlMaxCount = this.getConfig().getInt("mdc_flowcontrol_max_task", 12);
    }

    public void setValidatePeriodTime(long validatePeriodTime) {
        this.validatePeriodTime = validatePeriodTime;
    }

    public long getValidatePeriodTime() {
        return this.validatePeriodTime;
    }

    public void setGarbageObjectDeleteTime(long garbageObjectDeleteTime) {
        this.garbageObjectDeleteTime = garbageObjectDeleteTime;
    }

    public long getBucketCleanTime() {
        return this.bucketCleanTime;
    }

    public void setDcmTaskWalkerPeriodTime(long dcmTaskWalkerPeriodTime) {
        this.dcmTaskWalkerPeriodTime = dcmTaskWalkerPeriodTime;
    }

    public long getDcmTaskWalkerPeriodTime() {
        return this.dcmTaskWalkerPeriodTime;
    }

    public long getDataDumpProcessPeriodTime() {
        return this.dataDumpProcessPeriodTime;
    }

    public void setDataDumpProcessPeriodTime(long dataDumpProcessPeriodTime) {
        this.dataDumpProcessPeriodTime = dataDumpProcessPeriodTime;
    }

    public void setBucketObjectsValidateSwitch(boolean bucketObjectsValidateSwitch) {
        this.bucketObjectsValidateSwitch = bucketObjectsValidateSwitch;
    }

    public boolean isValidateBucketObjects() {
        return this.bucketObjectsValidateSwitch;
    }

    public void setValidateListObjectNumber(int validateListObjectNumber) {
        this.validateListObjectNumber = validateListObjectNumber;
    }

    public int getValidateListObjectNumber() {
        return this.validateListObjectNumber;
    }

    public int getHttpMaxConnections() {
        return this.httpMaxConnections;
    }

    public int getHttpMaxPerRoute() {
        return this.httpMaxPerRoute;
    }

    public int getHttpSocketTimeoutInMs() {
        return this.httpSocketTimeoutInMs;
    }

    public int getHttpConnectionTimeOutInMs() {
        return this.httpConnectionTimeOutInMs;
    }

    public int getDataDumpUserGroupSize() {
        return this.dataDumpUserGroupSize;
    }

    public void setDataDumpUserGroupSize(int dataDumpUserGroupSize) {
        this.dataDumpUserGroupSize = dataDumpUserGroupSize;
    }

    public int getDataDumpVisitorPageSize() {
        return this.dataDumpVisitorPageSize;
    }

    public void setDataDumpVisitorPageSize(int dataDumpVisitorPageSize) {
        this.dataDumpVisitorPageSize = dataDumpVisitorPageSize;
    }

    public long getDataDumpVisitorExeTime() {
        return this.dataDumpVisitorExeTime;
    }

    public void setDataDumpVisitorExeTime(long dataDumpVisitorExeTime) {
        this.dataDumpVisitorExeTime = dataDumpVisitorExeTime;
    }

    public long getDataDumpExeOverTime() {
        return this.dataDumpExeOverTime;
    }

    public void setDataDumpExeOverTime(long dataDumpExeOverTime) {
        this.dataDumpExeOverTime = dataDumpExeOverTime;
    }

    public int getDataDumpVisitorTotalTasks() {
        return this.dataDumpVisitorTotalTasks;
    }

    public void setDataDumpVisitorTotalTasks(int dataDumpVisitorTotalTasks) {
        this.dataDumpVisitorTotalTasks = dataDumpVisitorTotalTasks;
    }

    public long getDCStatusCheckPeriod() {
        return this.dcStatusCheckPeriod;
    }

    public void setDCStatusCheckPeriod(long statusCheckPeriod) {
        this.dcStatusCheckPeriod = statusCheckPeriod;
    }

    public String getMdcAuthVersion() {
        return this.mdcAuthVersion;
    }

    public void setMdcAuthVersion(String mdcAuthVersion) {
        this.mdcAuthVersion = mdcAuthVersion;
    }

    public String getAllowedIpRange() {
        return this.allowedIpRange;
    }

    public void setAllowedIpRange(String allowedIpRange) {
        this.allowedIpRange = allowedIpRange;
    }

    public int getMaxMdcTaskDeleteQueueCount() {
        return this.maxMdcTaskDeleteQueueCount;
    }

    public Long getIntervalOfSendScanMdcbucketTask() {
        return this.intervalOfSendScanMdcbucketTask;
    }

    public void getIntervalOfSendScanMdcbucketTask(Long time) {
        this.intervalOfSendScanMdcbucketTask = time;
    }

    public void setMaxMdcTaskDeleteHandler(int minBucketMdcTaskHandler) {
        this.maxMdcTaskDeleteQueueCount = minBucketMdcTaskHandler;
    }

    public int getMaxMdcTaskDeleteConcurrencyNumPerBucket() {
        return this.maxMdcTaskDeleteConcurrencyNumPerBucket;
    }

    public Long getScanBucketMdcTaskExpire() {
        return this.scanBucketMdcTaskExpire;
    }

    public void setScanBucketMdcTaskExpire(Long scanBucketMdcTaskExpire) {
        this.scanBucketMdcTaskExpire = scanBucketMdcTaskExpire;
    }

    public int getFlowControlPeriod() {
        return this.flowControlPeriod;
    }

    public int getFlowControlMaxCount() {
        return this.flowControlMaxCount;
    }

    public int getHighLevelMiddleObjCount() {
        return this.highLevelMiddleObjCount;
    }

    public int getHighLevelBigObjTaskCount() {
        return this.highLevelBigObjTaskCount;
    }

    public int getHighLevelMiddleObjCountAvrageTime() {
        return this.highLevelMiddleObjCountAvrageTime;
    }

    public double getHighLevelSuccessRate() {
        return this.highLevelSuccessRate;
    }

    public int getMiddleLevelMiddleObjCount() {
        return this.middleLevelMiddleObjCount;
    }

    public int getMiddleLevelBigObjTaskCount() {
        return this.middleLevelBigObjTaskCount;
    }

    public int getMiddleLevelMiddleObjCountAvrageTime() {
        return this.middleLevelMiddleObjCountAvrageTime;
    }

    public double getMiddleLevelSuccessRate() {
        return this.middleLevelSuccessRate;
    }

    public boolean isNeedAddMDCMSGVersion() {
        return this.needAddMDCMSGVersion;
    }

    public boolean getOSCStaitcFlowControl() {
        return this.isOSCStaitcFlowControl;
    }

    public boolean useHttpBetweenRegions() {
        return this.isUseHttpBetweenRegions;
    }

    public int getSysIdleMiddleObjCount() {
        return this.sysIdleMiddleObjCount;
    }

    public int getSysIdleBigObjCount() {
        return this.sysIdleBigObjCount;
    }

    public int getMaxMdcTaskLib2dsPerBucket() {
        return this.maxMdcTaskLib2dsPerBucket;
    }

    public int getInitCreateMdcTaskLib2dNum() {
        return this.initCreateMdcTaskLib2dNum;
    }

    public double getHighLevelCPUAverage() {
        return this.highLevelCPUAverage;
    }

    public double getMidLevelCPUAverage() {
        return this.midLevelCPUAverage;
    }

    public void setParellelDataStreamTimeoutMs(int timeoutMs) {
        this.getConfig().setProperty("pare_datastream_timeout_ms", (Object)timeoutMs);
        this.parellelDataStreamTimeoutMs = timeoutMs;
    }

    public int getParellelDataStreamTimeoutMs() {
        if (this.parellelDataStreamTimeoutMs < 0) {
            this.parellelDataStreamTimeoutMs = 10000;
        }
        return this.parellelDataStreamTimeoutMs;
    }

    public void setRemoteChannelGiveupTimeS(int remoteChannelGiveupTimes) {
        this.getConfig().setProperty("remote_channel_giveup_times", (Object)remoteChannelGiveupTimes);
    }

    public int getRemoteChannelGiveupTimeS() {
        if (this.getConfig() == null) {
            return 120000;
        }
        if (this.remoteChannelGiveupTimes < 0) {
            this.remoteChannelGiveupTimes = 120000;
        }
        return this.remoteChannelGiveupTimes;
    }

    public void setS3ServiceTimeoutMs(int timeoutMs) {
        this.getConfig().setProperty("s3_service_timeout_ms", (Object)timeoutMs);
        this.s3ServiceTimeoutMs = timeoutMs;
    }

    public int getS3ServiceTimeoutMs() {
        if (this.s3ServiceTimeoutMs < 0) {
            this.s3ServiceTimeoutMs = 10000;
        }
        return this.s3ServiceTimeoutMs;
    }

    public void setForwardTimeoutMs(int timeoutMs) {
        this.getConfig().setProperty("forward_timeout_ms", (Object)timeoutMs);
        this.forwardTimeoutMs = timeoutMs;
    }

    public int getForwardTimeoutMs() {
        if (this.forwardTimeoutMs < 0) {
            this.forwardTimeoutMs = 10000;
        }
        return this.forwardTimeoutMs;
    }

    public void setS3ServiceSocketTimeoutMs(int timeoutMs) {
        this.getConfig().setProperty("s3_service_socket_timeout_ms", (Object)timeoutMs);
        this.s3ServiceSocketTimeoutMs = timeoutMs;
    }

    public int getS3ServiceSocketTimeoutMs() {
        if (this.s3ServiceSocketTimeoutMs < 0) {
            this.s3ServiceSocketTimeoutMs = 10000;
        }
        return this.s3ServiceSocketTimeoutMs;
    }

    public void setForwardSocketTimeoutMs(int timeoutMs) {
        this.getConfig().setProperty("forward_socket_timeout_ms", (Object)timeoutMs);
        this.forwardSocketTimeoutMs = timeoutMs;
    }

    public int getForwardSocketTimeoutMs() {
        if (this.forwardSocketTimeoutMs < 0) {
            this.forwardSocketTimeoutMs = 300000;
        }
        return this.forwardSocketTimeoutMs;
    }

    public void setTimeoutNeedRetry(boolean isNeedRetry) {
        this.getConfig().setProperty("timeout_need_retry", (Object)isNeedRetry);
        this.timeoutNeedRetry = isNeedRetry;
    }

    public boolean getTimeoutNeedRetry() {
        return this.timeoutNeedRetry;
    }

    public void setTimeoutNeedRetryTimes(int retryTimes) {
        this.getConfig().setProperty("timeout_need_retry_times", (Object)retryTimes);
        this.timeoutNeedRetryTimes = retryTimes;
    }

    public int getTimeoutNeedRetryTimes() {
        if (this.timeoutNeedRetryTimes < 0) {
            this.timeoutNeedRetryTimes = 4;
        }
        return this.timeoutNeedRetryTimes;
    }

    public String getForwardScheme() {
        return this.forwardScheme;
    }

    public int getForwardPort() {
        return this.forwardPort;
    }

    public int getRepForWardPort() {
        return this.repForWardPort;
    }

    public long getBucketLocationCacheTtl() {
        return this.bucketLocationCacheTtl;
    }

    public int getRepConnectionTimeout() {
        return this.repConnectionTimeout;
    }

    public int getRepSocketTimeout() {
        return this.repSocketTimeout;
    }

    public int getSyncRepQueue() {
        return this.syncRepQueue;
    }

    public int getSyncRepNum() {
        return this.syncRepNum;
    }
}

