/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.memcache;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;
import uds.common.constants.upf.UPFConstants;

public class MemcachConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcachConfig.class);
    private boolean isLocalCacheOpen;
    private boolean isMemcacheOpen;
    private long localCacheTimeOut;
    private long dataExpireTime;
    private long ksAccountExpireTime;
    private long ksRevokeListPeriod;
    private long ksCacheValidTimeWhenGetRevokeFailed;
    private long ksUserCacheTime;
    private long ksUserRefreshPeriod;
    private long revokeListMaxSize;
    private String localCacheCheckPeriod;
    private String localCacheOpen;
    private int threadNumber;
    private long memcacheOpTO;
    private boolean tempURLKeyEnableEnript;
    private long tempLocationCacheExpireTime;
    private boolean rosCleanSwitch;
    private String rosAPIRegisterAddr;
    private String rosAPIRegisterPoeAddr;
    private String poeActiveURL;
    private String poeStandbyURL;
    private String poeAK;
    private String poeSK;
    private String memcacheIpList;
    private boolean saslEnable;
    private String saslPassword;
    private boolean isIamAllCacheSwitchOpen;
    private long iamAllCacheTimeout;
    private int iamUserCheckPeriod;
    private int iamUserCheckTimes;
    private long defaultClusterStatusTimeout;

    public synchronized void loadConfigFile(String propertyfile) throws ConfigurationException {
        PropertiesConfigBuilder configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(propertyfile, Character.valueOf('|'));
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration memcacheProperties = this.getConfig();
        this.isLocalCacheOpen = memcacheProperties.getBoolean("UpfLocalCacheOpen", true);
        this.isMemcacheOpen = memcacheProperties.getBoolean("memcache_open", true);
        this.localCacheTimeOut = memcacheProperties.getLong("CacheTimeout", 300000L);
        this.dataExpireTime = memcacheProperties.getLong("memcache_client_timeout", 300000L);
        this.ksAccountExpireTime = memcacheProperties.getLong("memcache_client_timeout", 300000L);
        this.ksRevokeListPeriod = memcacheProperties.getLong("ks_revokelist_peroid", 60000L);
        this.ksCacheValidTimeWhenGetRevokeFailed = memcacheProperties.getLong("ks_valid_time_of_failed_get_revokelist", 86400000L);
        this.ksUserCacheTime = memcacheProperties.getLong("ks_user_cache_time", 86400000L);
        this.ksUserRefreshPeriod = memcacheProperties.getLong("ks_user_refresh_period", 780000L);
        this.revokeListMaxSize = memcacheProperties.getLong("ks_revokelist_max_size", 0xA00000L);
        this.localCacheCheckPeriod = memcacheProperties.getString("UpfCacheCheckPeriod");
        this.localCacheOpen = memcacheProperties.getString("UpfLocalCacheOpen");
        this.threadNumber = memcacheProperties.getInt("memcache_thread_number", 10);
        this.memcacheOpTO = memcacheProperties.getLong("memcache_op_timeout", 3000L);
        this.tempURLKeyEnableEnript = memcacheProperties.getBoolean("tempURLKeyEnableEncript", true);
        this.tempLocationCacheExpireTime = memcacheProperties.getLong("temp_location_memcache_timeout", 5000L);
        this.defaultClusterStatusTimeout = memcacheProperties.getLong("default_cluster_status_timeout", 30000L);
        this.loadConfigExt(memcacheProperties);
    }

    private void loadConfigExt(PropertiesConfiguration memcacheProperties) {
        this.rosCleanSwitch = memcacheProperties.getBoolean("resource_operation_service_enable", false);
        this.rosAPIRegisterAddr = memcacheProperties.getString("resource_operation_service_address", "");
        this.rosAPIRegisterPoeAddr = memcacheProperties.getString("resource_operation_service_poe_address", "");
        this.poeActiveURL = memcacheProperties.getString("poe_active_url", "");
        this.poeStandbyURL = memcacheProperties.getString("poe_standby_url", "127.0.0.1");
        this.poeAK = memcacheProperties.getString("poe_ak", "");
        this.poeSK = memcacheProperties.getString("poe_sk", "");
        this.memcacheIpList = memcacheProperties.getString("memcache_server_iplist", "").replaceAll(",", ";");
        this.saslEnable = memcacheProperties.getBoolean("mem_sasl_switch", false);
        this.saslPassword = memcacheProperties.getString("mem_sasl_password", "");
        this.isIamAllCacheSwitchOpen = memcacheProperties.getBoolean("iam_full_cache", false);
        this.iamAllCacheTimeout = memcacheProperties.getLong("iam_full_cache_timeout", 3600000L);
        this.iamUserCheckPeriod = memcacheProperties.getInt("iam_user_check_period", 86400);
        this.iamUserCheckTimes = memcacheProperties.getInt("iam_user_check_times", 5);
    }

    @Override
    public String getString(String iterm) {
        if (this.getConfig() == null) {
            return null;
        }
        String strRet = this.getConfig().getString(iterm);
        if (strRet == null) {
            return null;
        }
        return strRet.trim();
    }

    @Override
    public String getString(String iterm, String defaultValue) {
        if (this.getConfig() == null) {
            return null;
        }
        return this.getConfig().getString(iterm, defaultValue).trim();
    }

    @Override
    public boolean getBoolean(String iterm, boolean defaultValue) {
        if (this.getConfig() == null) {
            return defaultValue;
        }
        return this.getConfig().getBoolean(iterm, defaultValue);
    }

    @Override
    public int getInt(String iterm, int defaultValue) {
        if (this.getConfig() == null) {
            return defaultValue;
        }
        return this.getConfig().getInt(iterm, defaultValue);
    }

    @Override
    public long getLong(String iterm, long defaultValue) {
        if (this.getConfig() == null) {
            return defaultValue;
        }
        return this.getConfig().getLong(iterm, defaultValue);
    }

    public boolean isLocalCacheOpen() {
        if (this.getConfig() == null) {
            return true;
        }
        return this.isLocalCacheOpen;
    }

    public boolean isMemcacheOpen() {
        if (this.getConfig() == null) {
            return true;
        }
        return this.isMemcacheOpen;
    }

    public long getLocalCacheTimeOut() {
        if (this.getConfig() == null) {
            LOGGER.debug("Property file is null, use default value");
            return 300000L;
        }
        return this.localCacheTimeOut;
    }

    public long getDataExpireTime() {
        if (this.getConfig() == null) {
            LOGGER.debug("Property file is null, use default value");
            return 300000L;
        }
        return this.dataExpireTime;
    }

    public long getKSAccountExpireTime() {
        if (this.getConfig() == null) {
            return 900000L;
        }
        return this.ksAccountExpireTime;
    }

    public long getKSRevokeListPeriod() {
        if (this.getConfig() == null) {
            return 60000L;
        }
        return this.ksRevokeListPeriod;
    }

    public long getKSCacheValidTimeWhenGetRevokeFailed() {
        if (this.getConfig() == null) {
            return 86400000L;
        }
        return this.ksCacheValidTimeWhenGetRevokeFailed;
    }

    public long getKSUserCacheTime() {
        if (this.getConfig() == null) {
            return 86400000L;
        }
        return this.ksUserCacheTime;
    }

    public long getKSUserRefreshPeriod() {
        if (this.getConfig() == null) {
            return 780000L;
        }
        return this.ksUserRefreshPeriod;
    }

    public long getRevokeListMaxSize() {
        if (this.getConfig() == null) {
            return 0xA00000L;
        }
        return this.revokeListMaxSize;
    }

    public String getLocalCacheCheckPeriod() {
        return this.localCacheCheckPeriod;
    }

    public String getLocalCacheOpen() {
        return this.localCacheOpen;
    }

    public String getDefalutCipher() {
        return "KMC";
    }

    public int getThreadNumber() {
        if (this.getConfig() == null) {
            return 10;
        }
        return this.threadNumber;
    }

    public long getMemcacheOpTO() {
        if (this.getConfig() == null) {
            return 3000L;
        }
        return this.memcacheOpTO;
    }

    public boolean getTempURLKeyEnableEnript() {
        if (this.getConfig() == null) {
            return true;
        }
        return this.tempURLKeyEnableEnript;
    }

    public long getTempLocationCacheExpireTime() {
        if (null == this.getConfig()) {
            return 5000L;
        }
        return this.tempLocationCacheExpireTime;
    }

    public boolean isROSSwitchOpen() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.rosCleanSwitch;
    }

    public String getRosAPIRegisterAddr() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.rosAPIRegisterAddr;
    }

    public String getRosAPIRegisterPoeAddr() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.rosAPIRegisterPoeAddr;
    }

    public String getPoeActiveURL() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.poeActiveURL;
    }

    public String getPoeStandbyURL() {
        if (this.getConfig() == null) {
            return "127.0.0.1";
        }
        return this.poeStandbyURL;
    }

    public String getPoeAK() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.poeAK;
    }

    public String getPoeSK() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.poeSK;
    }

    public String getMemcacheIpList() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.memcacheIpList;
    }

    public boolean getSaslEnable() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.saslEnable;
    }

    public String getSaslPassword() {
        if (this.getConfig() == null) {
            return "";
        }
        return this.saslPassword;
    }

    public boolean isIamAllCacheSwitchOpen() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.isIamAllCacheSwitchOpen;
    }

    public long getIamAllCacheTimeout() {
        if (this.getConfig() == null) {
            return 3600000L;
        }
        return this.iamAllCacheTimeout;
    }

    public int getIamUserCheckPeriod() {
        if (this.getConfig() == null) {
            return 86400;
        }
        return this.iamUserCheckPeriod;
    }

    public int getIamUserCheckTimes() {
        if (this.getConfig() == null) {
            return 5;
        }
        return this.iamUserCheckTimes;
    }

    public long getDefaultClusterStatusTimeout() {
        if (this.getConfig() == null) {
            return 30000L;
        }
        return this.defaultClusterStatusTimeout;
    }

    @Override
    public void reloadConfig() {
        if (this.getConfigBuilder() != null) {
            this.loadConfig();
            this.reloadProtectedConfig();
        }
    }

    private void reloadProtectedConfig() {
        PropertiesConfiguration memcacheProperties = this.getConfigBuilder().getConfiguration();
        String redundanceDataCount = memcacheProperties.getString("redundanceDataCount");
        int reliabilityLevel = memcacheProperties.getInt("reliabilityLevel", 0);
        int redundancyNum = memcacheProperties.getInt("redundancyNum", 3);
        if (!UPFConstants.PROTECTCONFIG_SET.contains(redundanceDataCount)) {
            throw new IllegalArgumentException("The redundanceDataCount not included in +1,+2,+3,+2:1,+3:1 .");
        }
        UPFConstants.setProtectConfigDefault((String)redundanceDataCount);
        UPFConstants.setProtectConfigDefaultInt((int)redundancyNum);
        UPFConstants.setReliabilityLevelDefault((int)reliabilityLevel);
        UPFConstants.setRedundancyNumDefault((int)redundancyNum);
    }
}

