/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.mulazini;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;
import uds.common.config.sysconf.SystemFilePath;

public class MultiazConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(MultiazConfig.class);
    private static final int ERR_STATUS = -1;
    private static final int AUTH_LOCATION = 1;
    private String authType = "POE";
    private String poeRole;
    private int isMultiAZ = -1;
    private int isInitialized = -1;
    private String regionName;
    private String defaultRegion;
    private String rLSIntranetAddrM;
    private String rLSIntranetAddrS;
    private String lsSBusinessPort;
    private String lsIpList;
    private String lsRole;
    private int forwardHangCheckerTimeout;
    private String lsDomain;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        this.isInitialized = this.getConfig().getInt("Initialized", 0);
        this.regionName = this.getConfig().getString("RegionName", "");
        this.authType = this.getConfig().getString("AuthType", "POE");
        this.defaultRegion = this.getConfig().getString("DefaultRegion", "1");
        try {
            this.poeRole = this.getConfig().getString("POERole", "");
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("caught some exception when load multiaz config POERole.", (Object)e.getMessage());
            }
            this.poeRole = "";
        }
        this.rLSIntranetAddrM = this.getConfig().getString("RLSIntranetAddrM");
        this.rLSIntranetAddrS = this.getConfig().getString("RLSIntranetAddrS");
        this.lsSBusinessPort = this.getConfig().getString("LSBusinessPort");
        this.isMultiAZ = this.getConfig().getInt("Enable", 0);
        this.lsIpList = this.getConfig().getString("location_service_ip_list", "");
        this.lsRole = this.getConfig().getString("LSRole", "0");
        this.forwardHangCheckerTimeout = this.getConfig().getInt("ls_forward_checker_timeout", 20000);
        this.lsDomain = this.getConfig().getString("LSDomain", "");
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getInitialized() {
        if (this.isInitialized == -1) {
            this.isInitialized = this.getConfig().getInt("Initialized", 0);
            return this.isInitialized;
        }
        return this.isInitialized;
    }

    public void setInitialized(int status) {
        this.isInitialized = status;
    }

    public int getIsMultiAZ() {
        if (this.isMultiAZ == -1) {
            this.isMultiAZ = this.getConfig().getInt("Enable", 0);
            return this.isMultiAZ;
        }
        return this.isMultiAZ;
    }

    public void setIsMultiAZ(int status) {
        this.isMultiAZ = status;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    public int getAuthLocation() {
        return 1;
    }

    public String getAuthType() {
        if (logger.isDebugEnabled()) {
            logger.debug("Multiaz config authType: {}", (Object)this.authType);
        }
        return this.authType;
    }

    public String getRLSIntranetAddrM() {
        return this.rLSIntranetAddrM;
    }

    public String getRLSIntranetAddrS() {
        return this.rLSIntranetAddrS;
    }

    public String getLSBusinessPort() {
        return this.lsSBusinessPort;
    }

    public String getPOERole() {
        return this.poeRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(String fileContent) {
        FileOutputStream os = null;
        try {
            File file = new File(SystemFilePath.CONFIG_FILE_NAME);
            if (!file.exists()) {
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    logger.error("Create dir failed.");
                }
                if (!file.createNewFile()) {
                    logger.error("Create file failed.");
                }
            }
            os = new FileOutputStream(file);
            ((OutputStream)os).write(fileContent.getBytes(Charset.forName("UTF-8")));
            os.flush();
            MultiazConfig.closeStreamQuietly(os);
        }
        catch (IOException e) {
            logger.error("Failed to create configuration file.", (Throwable)e);
        }
        finally {
            MultiazConfig.closeStreamQuietly(os);
        }
        this.loadConfig(PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(SystemFilePath.CONFIG_FILE_NAME, null));
    }

    private static void closeStreamQuietly(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException ex) {
            logger.error("Failed to close Stream.");
        }
    }

    public String getLsIpList() {
        return this.lsIpList;
    }

    public String getLsDomain() {
        return this.lsDomain;
    }

    public String getLSRole() {
        return this.lsRole;
    }

    public int getForwardHangCheckerTimeout() {
        return this.forwardHangCheckerTimeout;
    }
}

