/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.multiaz;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.sysconf.SystemFilePath;

public class ProductVersionConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductVersionConf.class);
    private static final String PRODUCT_NAME = "ProductName";
    private static final String PRODUCT_9000 = "9000";
    private static final String PRODUCT_UDS = "UDS";
    private static PropertiesConfiguration config;
    private static String productName;

    public static boolean load() {
        try {
            config = new Configurations().properties(SystemFilePath.PRODUCT_VERSION_CONFIG_FILE_NAME);
            ProductVersionConf.refreshAll();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Failed to load configuration file.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file,unexpected exception.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static synchronized void refreshAll() {
        try {
            LOGGER.warn("the config changed, need to refresh all conf.");
            productName = config.getString(PRODUCT_NAME, PRODUCT_UDS);
            LOGGER.warn("refresh all end! productName is: {}", (Object)productName);
        }
        catch (Exception e) {
            LOGGER.warn("caught some exception when refresh all config: ", (Throwable)e);
        }
    }

    public static boolean is9000Product() {
        return productName.equals(PRODUCT_9000);
    }

    public static boolean isUDSProduct() {
        return productName.equals(PRODUCT_UDS);
    }

    public static void setProduct(String name) {
        productName = name;
    }

    static {
        productName = PRODUCT_UDS;
        ProductVersionConf.load();
    }
}

