/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.omd;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class OmdConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmdConfig.class);
    private String serverAddress;
    private int port;
    private int connPerRoute;
    private int objectServiceDBConnPerHost;
    private long mongoClientInitTime;
    private int businessRetryBaseTime;
    private long businessMaxRetryWait;
    private int businessRetryCount;
    private int maxWaitInOneTurn;
    private boolean simpleAccessLog;
    private String threadNameOnPrintingAccessLog;
    private String collectionNameOnPrintingAccessLog;
    private String methodsOnPrintingAccessLog;
    private boolean printListContentsInAccessLog;
    private int latencyOfSlowIOWarning;
    private int asyncDedupProcessThread;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.loadIndexConfig(this.getConfig());
        this.loadIndexAccesslogConfig(this.getConfig());
        this.loadMetaDataRetryConfig(this.getConfig());
        this.loadDedupConfig(this.getConfig());
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    private void loadIndexConfig(PropertiesConfiguration config) {
        this.serverAddress = config.getString("mongo_db_server_ip", "127.0.0.1");
        this.port = config.getInt("mongo_db_server_port", 27017);
        this.connPerRoute = config.getInt("mongo_db_connection_per_host", 300);
        this.objectServiceDBConnPerHost = config.getInt("object_serivce_db_connection_per_host", 50);
        this.mongoClientInitTime = config.getLong("mongo_client_init_time", 600000L);
    }

    private void loadIndexAccesslogConfig(PropertiesConfiguration config) {
        this.simpleAccessLog = config.getBoolean("indexaccesslog_simple", true);
        this.threadNameOnPrintingAccessLog = config.getString("indexaccesslog_thread_name", "qtp");
        this.collectionNameOnPrintingAccessLog = config.getString("indexaccesslog_collection", "object;bucket;");
        this.methodsOnPrintingAccessLog = config.getString("indexaccesslog_method", "");
        this.printListContentsInAccessLog = config.getBoolean("indexaccesslog_showlist", false);
        this.latencyOfSlowIOWarning = config.getInt("print_log_when_slow_timeout", 90000);
    }

    private void loadDedupConfig(PropertiesConfiguration config) {
        this.asyncDedupProcessThread = config.getInt("async_dedup_process_thread", 100);
    }

    private void loadMetaDataRetryConfig(PropertiesConfiguration config) {
        this.businessRetryBaseTime = config.getInt("business_retryBaseTime", 10);
        this.businessRetryCount = config.getInt("business_retryCount", 20);
        this.businessMaxRetryWait = config.getLong("business_maxRetryWait", 60000L);
        this.maxWaitInOneTurn = config.getInt("single_max_wait", 2000);
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnPerRoute() {
        return this.connPerRoute > 0 ? this.connPerRoute : 300;
    }

    public long getMongoClientInitTime() {
        return this.mongoClientInitTime > 0L ? this.mongoClientInitTime : 600000L;
    }

    public int getObjectServiceDBConnPerHost() {
        return this.objectServiceDBConnPerHost;
    }

    public int getBusinessRetryBaseTime() {
        return this.businessRetryBaseTime;
    }

    public int getBusinessRetryCount() {
        return this.businessRetryCount;
    }

    public long getBusinessMaxRetryWait() {
        return this.businessMaxRetryWait;
    }

    public int getAsyncDedupProcessThread() {
        return this.asyncDedupProcessThread;
    }

    public int getMaxWaitInOneTurn() {
        return this.maxWaitInOneTurn > 0 ? this.maxWaitInOneTurn : 2000;
    }

    public boolean isSimpleAccessLog() {
        return this.simpleAccessLog;
    }

    public String getThreadNameOnPrintingAccessLog() {
        return this.threadNameOnPrintingAccessLog;
    }

    public String getCollectionNameOnPrintingAccessLog() {
        return this.collectionNameOnPrintingAccessLog;
    }

    public String getMethodsOnPrintingAccessLog() {
        return this.methodsOnPrintingAccessLog;
    }

    public boolean isPrintListContentsInAccessLog() {
        return this.printListContentsInAccessLog;
    }

    public int getLatencyOfSlowIOWarning() {
        return this.latencyOfSlowIOWarning;
    }
}

