/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.osp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class OspConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OspConfig.class);
    private int uploadWaitTimeForComplete;
    private int dataTransferSize;
    private boolean enablePreRead;
    private boolean enablePreReadMemcache;
    private int preReadIOThreshold;
    private int preReadChunkSize;
    private int preReadMemcacheOpTime;
    private int stopPreReadPeriod;
    private int preReadHitRateThreshold;
    private int preReadStatisticalPeriod;
    private String[] storageClass;
    private int oscUploadExtendPoolCapacity;
    private int oscUploadExtendPoolMinIdle;
    private int gcUploadReservedPoolCapacity;
    private int oisUploadExtendPoolCapacity;
    private int gcUploadExtendPoolCapacity;
    private int gcUploadExtendPoolMinIdle;
    private int otmUploadExtendPoolCapacity;
    private int otmUploadExtendPoolMinIdle;
    private int oisUploadExtendPoolMinIdle;
    private long downloadRequestPoolTokenTimeoutMax;
    private int localTokenRetryTimes;
    private int localTokenTimeout;
    private boolean bufferDirect;
    private boolean commonBufferPoolLifo;
    private int commonBufferPoolMaxIdle;
    private int commonBufferPoolMaxWait;
    private long commonBufferPoolMinEvictableIdleTimeMillis;
    private int commonBufferPoolNumTestsPerEvictionRun;
    private boolean commonBufferPoolTestOnBorrow;
    private boolean commonBufferPoolTestOnReturn;
    private boolean commonBufferPoolTestWhileIdle;
    private long commonBufferPoolTimeBetweenEvictionRunsMillis;
    private boolean commonBufferPoolBlockWhenExhausted;
    private int maxBufferSizePerConn;
    private boolean deltaECUseMem;
    private int uploadPoolSize;
    private int uploadMaxShrinkSize;
    private int uploadMaxExpandSize;
    private int uploadShrinkThreshold;
    private int uploadLowAdviceThreshold;
    private int uploadExpandThreshold;
    private long uploadResourceMonitorPeriod;
    private int downloadPoolSize;
    private int downloadMaxShrinkSize;
    private int downloadMaxExpandSize;
    private int downloadAdviceThreshold;
    private int downloadLowAdviceThreshold;
    private int downloadNoAdviceThreshold;
    private long downloadResourceMonitorPeriod;
    private int globalTokenLogInterval;
    private int oscDefaultDataPriority;
    private int gcDefaultDataPriority;
    private int mirrorThreshold;
    private int gcWaitTime;
    private long partECAggregationWaitTime;
    private long partECAggregationWaitTime3AZ;
    private long mirrorAggregationWaitTime;
    private long smallWriteAggregationWaitTime;
    private long deltaECWriteAggregationWaitTime;
    private int gcWritePercent;
    private int maxWriteCountForOneWrite;
    private int localMaxWeightScale;
    private int idleTime;
    private int storagePoolId;
    private int ecPlogCapacity;
    private int deltaECPlogCapacity;
    private int coldEcPlogCapacity;
    private int smallEcPlogCapacity;
    private int mirrorPlogCapacity;
    private int mirrorPlogCutSize;
    private double writeBackPlogThreshold;
    private int maxNoUsedTimeToSeal;
    private int maxNoUsedTimeToForceSeal;
    private int plogUsageCacheThreshold;
    private int plogExpiredTime;
    private int plogCreatePriority;
    private int plogAppendPriority;
    private int plogReadPriority;
    private int smallWriteECThreshold;
    private boolean enterPriseEC;
    private int localTokenRetryTime;
    private int maxBorrowPlogWaitTime;
    private int initMirrorPlogNum;
    private int maxMirrorPlogNum;
    private int initECPlogNum;
    private int coldInitECPlogNum;
    private int maxECPlogNum;
    private int coldMaxECPlogNum;
    private int initPartECPlogNum;
    private int initDeltaECPlogNum;
    private int coldInitPartECPlogNum;
    private int maxPartECPlogNum;
    private int maxDeltaECPlogNum;
    private int coldMaxPartECPlogNum;
    private int initSmallECPlogNum;
    private int maxSmallECPlogNum;
    private int initMirrorFDPlogNum;
    private int maxMirrorFDPlogNum;
    private int initECFDPlogNum;
    private int maxECFDPlogNum;
    private int initPartECFDPlogNum;
    private int maxPartECFDPlogNum;
    private int initSmallECFDPlogNum;
    private int maxSmallECFDPlogNum;
    private int initFileMirrorPlogNum;
    private int maxFileMirrorPlogNum;
    private int minFileMirrorPlogNum;
    private int initFileECPlogNum;
    private int maxFileECPlogNum;
    private int minFileECPlogNum;
    private int initFilePartECPlogNum;
    private int maxFilePartECPlogNum;
    private int minFilePartECPlogNum;
    private int initFileSmallECPlogNum;
    private int maxFileSmallECPlogNum;
    private int minFileSmallECPlogNum;
    private int fsBigIoLength;
    private int gcInitMirrorPlogNum;
    private int gcInitECPlogNum;
    private int gcInitPartECPlogNum;
    private int gcInitSmallECPlogNum;
    private int gcInitMirrorFDPlogNum;
    private int gcInitECFDPlogNum;
    private int gcInitPartECFDPlogNum;
    private int coldGcInitECPlogNum;
    private int coldGcInitPartECPlogNum;
    private int gcMaxMirrorPlogNum;
    private int gcMaxECPlogNum;
    private int gcMaxPartECPlogNum;
    private int gcMaxMirrorFDPlogNum;
    private int gcMaxECFDPlogNum;
    private int gcMaxPartECFDPlogNum;
    private int coldGcMaxECPlogNum;
    private int coldGcMaxPartECPlogNum;
    private int mirrorPlogUseRate;
    private int ecPlogUseRate;
    private int partECPlogUseRate;
    private int deltaECPlogUseRate;
    private int coldEcPlogUseRate;
    private int coldPartECPlogUseRate;
    private int lowCostInitMirrorPlogNum;
    private int lowCostMaxMirrorPlogNum;
    private int lowCostInitSmallECPlogNum;
    private int lowCostMaxSmallECPlogNum;
    private int lowCostInitPartECPlogNum;
    private int lowCostMaxPartECPlogNum;
    private int lowCostInitECPlogNum;
    private int lowCostMaxECPlogNum;
    private long lowCostSmallWriteAggregationWaitTime;
    private long lowCostPartEcAggregationWaitTime;
    private int initColdInStandardMirrorPlogNum;
    private int initColdInStandardECPlogNum;
    private int initColdInStandardPartECPlogNum;
    private int initColdInStandardSmallECPlogNum;
    private int maxColdInStandardMirrorPlogNum;
    private int maxColdInStandardECPlogNum;
    private int maxColdInStandardPartECPlogNum;
    private int maxColdInStandardSmallECPlogNum;
    private long coldPoolMemMaxLength;
    private int dedicatedInitMirrorPlogNum;
    private int dedicatedMaxMirrorPlogNum;
    private int dedicatedInitSmallECPlogNum;
    private int dedicatedMaxSmallECPlogNum;
    private int dedicatedInitPartECPlogNum;
    private int dedicatedMaxPartECPlogNum;
    private int dedicatedInitECPlogNum;
    private int dedicatedMaxECPlogNum;
    private long dedicatedSmallWriteAggregationWaitTime;
    private long dedicatedPartEcAggregationWaitTime;
    private int lowCostGcInitMirrorPlogNum;
    private int lowCostGcMaxMirrorPlogNum;
    private int lowCostGcInitPartECPlogNum;
    private int lowCostGcMaxPartECPlogNum;
    private int lowCostGcInitECPlogNum;
    private int lowCostGcMaxECPlogNum;
    private int dedicatedGcInitMirrorPlogNum;
    private int dedicatedGcMaxMirrorPlogNum;
    private int dedicatedGcInitPartECPlogNum;
    private int dedicatedGcMaxPartECPlogNum;
    private int dedicatedGcInitECPlogNum;
    private int dedicatedGcMaxECPlogNum;
    private int plogHeaderMagicOffset;
    private int plogHeaderVersionOffset;
    private int plogHeaderBlocklenOffset;
    private int plogHeaderFlagOffset;
    private int plogHeaderHeaderlenOffset;
    private int plogHeaderObjectKeylenOffset;
    private int plogHeaderMagicLength;
    private int plogHeaderVersionLength;
    private int plogHeaderBlocklenLength;
    private int plogHeaderFlagLength;
    private int plogHeaderHeaderlenLength;
    private int plogHeaderObjectKeylenLength;
    private byte plogHeaderMagicValue;
    private byte plogHeaderVersionValue;
    private int plogHeaderAlignedBytes;
    private int monitorPlogNumberPeriod;
    private int monitorUnusedPlogPeriod;
    private int monitorDegradePlogPeriod;
    private int plogSealTaskQueueCapacity;
    private int createPlogNumPerTimes;
    private int usedTokenRatioMid;
    private int usedTokenRatioHigh;
    private int plogSealWorkerNumber;
    private int monitorPlogPoolCapacityPeriod;
    private int plogClientInitTimes;
    private int plogObjectListSize;
    private int plogObjectListSizeToDisk;
    private int plogObjectListSizePerDoc;
    private int plogReadMaxFailTime;
    private boolean isReadPerfDebugOpen;
    private int appendPlogMaxRetryCount;
    private double ssdUsageHighThreshold;
    private double ssdUsageLowThreshold;
    private double ssdUsedUpThreshold;
    private double ssdStorageAvailableThreshold;
    private double hddUsedUpThreshold;
    private double hddStorageAvailableThreshold;
    private double coldStorageAvailableThreshold;
    private double coldUsedUpThreshold;
    private boolean useAsyncMD5;
    private int asyncMD5ThreadNum;
    private int asyncMD5DataSize;
    private int asyncMD5Threshold;
    private int smallWriteWriteBackThreshold;
    private int plogKeyListSplitThreshold;
    private List<Integer> mirrorBackupNumber;

    public int getInitMirrorPlogNum() {
        return this.initMirrorPlogNum;
    }

    public int getMaxMirrorPlogNum() {
        return this.maxMirrorPlogNum;
    }

    public int getInitECPlogNum() {
        return this.initECPlogNum;
    }

    public int getColdInitECPlogNum() {
        return this.coldInitECPlogNum;
    }

    public int getMaxECPlogNum() {
        return this.maxECPlogNum;
    }

    public int getColdMaxECPlogNum() {
        return this.coldMaxECPlogNum;
    }

    public int getInitPartECPlogNum() {
        return this.initPartECPlogNum;
    }

    public int getInitDeltaECPlogNum() {
        return this.initDeltaECPlogNum;
    }

    public int getColdInitPartECPlogNum() {
        return this.coldInitPartECPlogNum;
    }

    public int getMaxPartECPlogNum() {
        return this.maxPartECPlogNum;
    }

    public int getMaxDeltaECPlogNum() {
        return this.maxDeltaECPlogNum;
    }

    public int getColdMaxPartECPlogNum() {
        return this.coldMaxPartECPlogNum;
    }

    public int getInitMirrorFDPlogNum() {
        return this.initMirrorFDPlogNum;
    }

    public int getMaxMirrorFDPlogNum() {
        return this.maxMirrorFDPlogNum;
    }

    public int getInitECFDPlogNum() {
        return this.initECFDPlogNum;
    }

    public int getMaxECFDPlogNum() {
        return this.maxECFDPlogNum;
    }

    public int getInitPartECFDPlogNum() {
        return this.initPartECFDPlogNum;
    }

    public int getMaxPartECFDPlogNum() {
        return this.maxPartECFDPlogNum;
    }

    public int getInitSmallECFDPlogNum() {
        return this.initSmallECFDPlogNum;
    }

    public int getMaxSmallECFDPlogNum() {
        return this.maxSmallECFDPlogNum;
    }

    public int getGcInitMirrorPlogNum() {
        return this.gcInitMirrorPlogNum;
    }

    public int getGcInitECPlogNum() {
        return this.gcInitECPlogNum;
    }

    public int getColdGcInitECPlogNum() {
        return this.coldGcInitECPlogNum;
    }

    public int getGcInitPartECPlogNum() {
        return this.gcInitPartECPlogNum;
    }

    public int getGcInitSmallECPlogNum() {
        return this.gcInitSmallECPlogNum;
    }

    public int getGcInitMirrorFDPlogNum() {
        return this.gcInitMirrorFDPlogNum;
    }

    public int getGcInitECFDPlogNum() {
        return this.gcInitECFDPlogNum;
    }

    public int getGcInitPartECFDPlogNum() {
        return this.gcInitPartECFDPlogNum;
    }

    public int getColdGcInitPartECPlogNum() {
        return this.coldGcInitPartECPlogNum;
    }

    public int getGcMaxMirrorPlogNum() {
        return this.gcMaxMirrorPlogNum;
    }

    public int getGcMaxECPlogNum() {
        return this.gcMaxECPlogNum;
    }

    public int getColdGcMaxECPlogNum() {
        return this.coldGcMaxECPlogNum;
    }

    public int getGcMaxPartECPlogNum() {
        return this.gcMaxPartECPlogNum;
    }

    public int getGcMaxMirrorFDPlogNum() {
        return this.gcMaxMirrorFDPlogNum;
    }

    public int getGcMaxECFDPlogNum() {
        return this.gcMaxECFDPlogNum;
    }

    public int getGcMaxPartECFDPlogNum() {
        return this.gcMaxPartECFDPlogNum;
    }

    public int getColdGcMaxPartECPlogNum() {
        return this.coldGcMaxPartECPlogNum;
    }

    public int getMirrorPlogUseRate() {
        return this.mirrorPlogUseRate;
    }

    public int getEcPlogUseRate() {
        return this.ecPlogUseRate;
    }

    public int getColdEcPlogUseRate() {
        return this.coldEcPlogUseRate;
    }

    public int getPartECPlogUseRate() {
        return this.partECPlogUseRate;
    }

    public int getDeltaECPlogUseRate() {
        return this.deltaECPlogUseRate;
    }

    public int getColdPartECPlogUseRate() {
        return this.coldPartECPlogUseRate;
    }

    public int getMirrorPlogCapacity() {
        return this.mirrorPlogCapacity;
    }

    public int getEcPlogCapacity() {
        return this.ecPlogCapacity;
    }

    public int getDeltaECPlogCapacity() {
        return this.deltaECPlogCapacity;
    }

    public int getColdEcPlogCapacity() {
        return this.coldEcPlogCapacity;
    }

    public int getSmallEcPlogCapacity() {
        return this.smallEcPlogCapacity;
    }

    public int getPlogHeaderMagicOffset() {
        return this.plogHeaderMagicOffset;
    }

    public int getPlogHeaderVersionOffset() {
        return this.plogHeaderVersionOffset;
    }

    public int getPlogHeaderBlocklenOffset() {
        return this.plogHeaderBlocklenOffset;
    }

    public int getPlogHeaderFlagOffset() {
        return this.plogHeaderFlagOffset;
    }

    public int getPlogHeaderHeaderlenOffset() {
        return this.plogHeaderHeaderlenOffset;
    }

    public int getPlogHeaderObjectKeylenOffset() {
        return this.plogHeaderObjectKeylenOffset;
    }

    public int getPlogHeaderMagicLength() {
        return this.plogHeaderMagicLength;
    }

    public int getPlogHeaderVersionLength() {
        return this.plogHeaderVersionLength;
    }

    public int getPlogHeaderBlocklenLength() {
        return this.plogHeaderBlocklenLength;
    }

    public int getPlogHeaderFlagLength() {
        return this.plogHeaderFlagLength;
    }

    public int getPlogHeaderHeaderlenLength() {
        return this.plogHeaderHeaderlenLength;
    }

    public int getPlogHeaderObjectKeylenLength() {
        return this.plogHeaderObjectKeylenLength;
    }

    public byte getPlogHeaderMagicValue() {
        return this.plogHeaderMagicValue;
    }

    public byte getPlogHeaderVersionValue() {
        return this.plogHeaderVersionValue;
    }

    public int getPlogHeaderAlignedBytes() {
        return this.plogHeaderAlignedBytes;
    }

    public int getMaxBorrowPlogWaitTime() {
        return this.maxBorrowPlogWaitTime;
    }

    public int getMonitorPlogNumberPeriod() {
        return this.monitorPlogNumberPeriod;
    }

    public int getMonitorUnusedPlogPeriod() {
        return this.monitorUnusedPlogPeriod;
    }

    public int getMonitorDegradePlogPeriod() {
        return this.monitorDegradePlogPeriod;
    }

    public int getMaxNoUsedTimeToSeal() {
        return this.maxNoUsedTimeToSeal;
    }

    public int getMaxNoUsedTimeToForceSeal() {
        return this.maxNoUsedTimeToForceSeal;
    }

    public int getMaxNoUsedTimeToNeedSeal() {
        return this.getConfig().getInt("max_no_used_time_to_need_seal", 86400);
    }

    public int getPlogClientInitTimes() {
        return this.plogClientInitTimes;
    }

    public int getPlogObjectListSize() {
        return this.plogObjectListSize;
    }

    public int getPlogObjectListSizePerDoc() {
        return this.plogObjectListSizePerDoc;
    }

    public int getPlogObjectListSizeToDisk() {
        return this.plogObjectListSizeToDisk;
    }

    public int getPlogUsageCacheThreshold() {
        return this.plogUsageCacheThreshold;
    }

    public int getPlogExpiredTime() {
        return this.plogExpiredTime;
    }

    public int getPlogCreatePriority() {
        return this.plogCreatePriority;
    }

    public int getPlogAppendPriority() {
        return this.plogAppendPriority;
    }

    public int getPlogReadPriority() {
        return this.plogReadPriority;
    }

    public int getMirrorPlogCutSize() {
        return this.mirrorPlogCutSize;
    }

    public void setMirrorPlogCutSize(int mirrorPlogCutSize) {
        this.mirrorPlogCutSize = mirrorPlogCutSize;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        byte[] content = new byte[]{};
        try (DigestInputStream dis = new DigestInputStream(new ByteArrayInputStream(content), MessageDigest.getInstance("MD5"));){
            dis.on(true);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("MD5 digest method can't load.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("close stream failed!!");
        }
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.loadUpDownloadConfig(this.getConfig());
        this.loadStorageClassConfig(this.getConfig());
        this.loadBufferPoolConfig(this.getConfig());
        this.loadResourcePoolConfig(this.getConfig());
        this.loadMirrorBackupConfig(this.getConfig());
        this.plogReadMaxFailTime = this.getConfig().getInt("plog_read_max_fail_time", 3);
        this.isReadPerfDebugOpen = this.getConfig().getBoolean("devReadPerfDebug", false);
        this.partECAggregationWaitTime = this.getConfig().getLong("partec_aggregation_wait_time", 4000L);
        this.partECAggregationWaitTime3AZ = this.getConfig().getLong("partec_aggregation_wait_time_3az", 8000L);
        this.mirrorAggregationWaitTime = this.getConfig().getLong("mirror_aggregation_wait_time", 0L);
        this.smallWriteAggregationWaitTime = this.getConfig().getLong("small_write_aggregation_wait_time", 0L);
        this.deltaECWriteAggregationWaitTime = this.getConfig().getLong("delta_write_aggregation_wait_time", 2000L);
        this.maxNoUsedTimeToSeal = this.getConfig().getInt("max_no_used_time_to_seal", 3600);
        this.maxNoUsedTimeToForceSeal = this.getConfig().getInt("max_no_used_time_to_force_seal", 2592000);
        this.plogUsageCacheThreshold = this.getConfig().getInt("plog_usage_cache_threshold", 10000);
        this.plogExpiredTime = this.getConfig().getInt("plog_expired_time", 43200);
        this.plogCreatePriority = this.getConfig().getInt("plog_create_priority", 0);
        this.plogAppendPriority = this.getConfig().getInt("plog_append_priority", 0);
        this.plogReadPriority = this.getConfig().getInt("plog_read_priority", 0);
        this.smallWriteWriteBackThreshold = this.getConfig().getInt("smallWriteWriteBackThreshold", 527360);
        this.useAsyncMD5 = this.getConfig().getBoolean("use_async_md5", true);
        this.asyncMD5ThreadNum = this.getConfig().getInt("async_md5_thread_num", 15);
        this.asyncMD5DataSize = this.getConfig().getInt("async_md5_data_size", 409600);
        this.plogKeyListSplitThreshold = this.getConfig().getInt("plogKeyListSplitThreshold", 819200);
        this.asyncMD5Threshold = this.getConfig().getInt("async_md5_threshold", 10);
        this.localMaxWeightScale = this.getConfig().getInt("local_max_weight_scale", 3);
        this.idleTime = this.getConfig().getInt("gc_master_idle_time", 180);
        this.storagePoolId = this.getConfig().getInt("storage_pool_id", 127);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    private void loadMirrorBackupConfig(PropertiesConfiguration config) {
        try {
            String[] mirrorBackupNumberArray = config.getString("mirror_backup_number", "3").split(";");
            ArrayList<Integer> mirrorBackupNumberTmp = new ArrayList<Integer>();
            for (String mirrorBackupNumberStr : mirrorBackupNumberArray) {
                mirrorBackupNumberTmp.add(Integer.valueOf(mirrorBackupNumberStr));
            }
            this.mirrorBackupNumber = mirrorBackupNumberTmp;
        }
        catch (Exception e) {
            LOGGER.error("the number of mirror backup config item is wrong", (Throwable)e);
        }
    }

    private void loadUpDownloadConfig(PropertiesConfiguration config) {
        this.uploadWaitTimeForComplete = config.getInt("osp_uploadWaitTimeForComplete", 200000);
        this.dataTransferSize = config.getInt("data_transfer_size", 8192);
        this.enablePreRead = config.getBoolean("pre_read_enable", false);
        this.preReadIOThreshold = config.getInt("pre_read_io_threshold", 131072);
        this.enablePreReadMemcache = config.getBoolean("pre_read_memcache_enable", false);
        this.preReadChunkSize = config.getInt("pre_read_chunk_size", 131072);
        this.preReadMemcacheOpTime = config.getInt("pre_read_memcache_optime", 5);
        this.stopPreReadPeriod = config.getInt("stop_pre_read_period", 60000);
        this.preReadHitRateThreshold = config.getInt("pre_read_hitrate_threshold", 30);
        this.preReadStatisticalPeriod = config.getInt("pre_read_statistical_period", 1000);
    }

    private void loadStorageClassConfig(PropertiesConfiguration config) {
        TreeMap<String, Properties> storageClassMap = new TreeMap<String, Properties>();
        for (String strclass : this.storageClass = config.getStringArray("StorageClass")) {
            storageClassMap.put(strclass, config.getProperties(strclass));
        }
    }

    private void loadResourcePoolConfig(PropertiesConfiguration config) {
        this.oscUploadExtendPoolCapacity = config.getInt("osc_upload_extend_pool_capacity", 1024);
        this.oscUploadExtendPoolMinIdle = config.getInt("osc_upload_extend_minIdle", 128);
        this.gcUploadReservedPoolCapacity = config.getInt("gc_upload_reserved_pool_capacity", 1024);
        this.oisUploadExtendPoolCapacity = config.getInt("ois_extend_pool_capacity", 2048);
        this.gcUploadExtendPoolCapacity = config.getInt("gc_upload_extend_pool_capacity", 1024);
        this.gcUploadExtendPoolMinIdle = config.getInt("gc_upload_extend_minIdle", 128);
        this.oisUploadExtendPoolMinIdle = config.getInt("ois_upload_extend_minIdle", 128);
        this.otmUploadExtendPoolCapacity = config.getInt("otm_upload_extend_pool_capacity", 2000);
        this.otmUploadExtendPoolMinIdle = config.getInt("otm_upload_extend_minIdle", 200);
        this.downloadRequestPoolTokenTimeoutMax = config.getLong("download_request_pool_token_timeout_max", 300000L);
        this.localTokenRetryTimes = config.getInt("local_token_retry_times", 300);
        this.localTokenTimeout = config.getInt("local_token_timeout", 100);
        this.bufferDirect = config.getBoolean("isDirect", true);
        this.commonBufferPoolLifo = config.getBoolean("lifo", true);
        this.commonBufferPoolMaxIdle = config.getInt("maxIdle", 256);
        this.commonBufferPoolMaxWait = config.getInt("maxWait", 10000);
        this.commonBufferPoolMinEvictableIdleTimeMillis = config.getLong("minEvictableIdleTimeMillis", 100000L);
        this.commonBufferPoolNumTestsPerEvictionRun = config.getInt("numTestsPerEvictionRun", 1);
        this.commonBufferPoolTestOnBorrow = config.getBoolean("testOnBorrow", false);
        this.commonBufferPoolTestOnReturn = config.getBoolean("testOnReturn", true);
        this.commonBufferPoolTestWhileIdle = config.getBoolean("testWhileIdle", true);
        this.commonBufferPoolTimeBetweenEvictionRunsMillis = config.getLong("timeBetweenEvictionRunsMillis", -1L);
        this.commonBufferPoolBlockWhenExhausted = config.getBoolean("blockWhenExhausted", true);
        this.maxBufferSizePerConn = config.getInt("OBS_MaxBufferSizePerConn", 75);
        this.deltaECUseMem = config.getBoolean("delta_ec_use_mem", true);
        this.fsBigIoLength = config.getInt("fs_big_io_lengh", 0);
        this.mirrorPlogCutSize = config.getInt("mirror_plog_cut_size", 512);
        this.appendPlogMaxRetryCount = config.getInt("plog_append_max_retry_count", 0);
        this.maxBorrowPlogWaitTime = config.getInt("max_borrow_plog_wait_time", 1000);
        String[] initPlogNum = config.getString("init_plog_num_ec_update", "100;200;100;100;100").split(";");
        this.initMirrorPlogNum = Integer.valueOf(initPlogNum[0]);
        this.initECPlogNum = Integer.valueOf(initPlogNum[1]);
        this.initPartECPlogNum = Integer.valueOf(initPlogNum[2]);
        this.initSmallECPlogNum = initPlogNum.length == 4 ? Integer.valueOf(initPlogNum[3]) : this.initPartECPlogNum;
        this.initDeltaECPlogNum = initPlogNum.length == 5 ? Integer.valueOf(initPlogNum[4]) : this.initPartECPlogNum;
        String[] initFDPlogNum = config.getString("init_fast_delete_plog_num_ec_update", "50;100;50;50").split(";");
        this.initMirrorFDPlogNum = Integer.valueOf(initFDPlogNum[0]);
        this.initECFDPlogNum = Integer.valueOf(initFDPlogNum[1]);
        this.initPartECFDPlogNum = Integer.valueOf(initFDPlogNum[2]);
        this.initSmallECFDPlogNum = Integer.valueOf(initFDPlogNum[3]);
        String[] coldInitPlogNum = config.getString("cold_init_plog_num_ec_update", "0;0").split(";");
        this.coldInitECPlogNum = Integer.valueOf(coldInitPlogNum[0]);
        this.coldInitPartECPlogNum = Integer.valueOf(coldInitPlogNum[1]);
        String[] maxPlogNum = config.getString("max_plog_num_ec_update", "2500;20000;2500;2500;1000").split(";");
        this.maxMirrorPlogNum = Integer.valueOf(maxPlogNum[0]);
        this.maxECPlogNum = Integer.valueOf(maxPlogNum[1]);
        this.maxPartECPlogNum = Integer.valueOf(maxPlogNum[2]);
        this.maxSmallECPlogNum = Integer.valueOf(maxPlogNum[3]);
        this.maxDeltaECPlogNum = Integer.valueOf(maxPlogNum[4]);
        String[] maxFDPlogNum = config.getString("max_fast_delete_plog_num_ec_update", "1250;10000;1250;1250").split(";");
        this.maxMirrorFDPlogNum = Integer.valueOf(maxFDPlogNum[0]);
        this.maxECFDPlogNum = Integer.valueOf(maxFDPlogNum[1]);
        this.maxPartECFDPlogNum = Integer.valueOf(maxFDPlogNum[2]);
        this.maxSmallECFDPlogNum = Integer.valueOf(maxFDPlogNum[3]);
        String[] coldMaxPlogNum = config.getString("cold_max_plog_num_ec_update", "25;25").split(";");
        this.coldMaxECPlogNum = Integer.valueOf(coldMaxPlogNum[0]);
        this.coldMaxPartECPlogNum = Integer.valueOf(coldMaxPlogNum[1]);
        String[] initFilePlogNum = config.getString("init_filegw_plog_num_ec_update", "100;200;100;100").split(";");
        this.initFileMirrorPlogNum = Integer.valueOf(initFilePlogNum[0]);
        this.initFileECPlogNum = Integer.valueOf(initFilePlogNum[1]);
        this.initFilePartECPlogNum = Integer.valueOf(initFilePlogNum[2]);
        this.initFileSmallECPlogNum = initPlogNum.length == 4 ? Integer.valueOf(initPlogNum[3]) : this.initPartECPlogNum;
        String[] minFilePlogNum = config.getString("min_filegw_plog_num_ec_update", "100;200;100;100").split(";");
        this.minFileMirrorPlogNum = Integer.valueOf(minFilePlogNum[0]);
        this.minFileECPlogNum = Integer.valueOf(minFilePlogNum[1]);
        this.minFilePartECPlogNum = Integer.valueOf(minFilePlogNum[2]);
        this.minFileSmallECPlogNum = Integer.valueOf(minFilePlogNum[3]);
        String[] maxFilePlogNum = config.getString("max_filegw_plog_num_ec_update", "2500;20000;2500;2500").split(";");
        this.maxFileMirrorPlogNum = Integer.valueOf(maxFilePlogNum[0]);
        this.maxFileECPlogNum = Integer.valueOf(maxFilePlogNum[1]);
        this.maxFilePartECPlogNum = Integer.valueOf(maxFilePlogNum[2]);
        this.maxFileSmallECPlogNum = Integer.valueOf(maxFilePlogNum[3]);
        String[] initColdInStandardPlogNum = config.getString("init_cold_in_standard_plog_num", "20;40;20;20").split(";");
        this.initColdInStandardMirrorPlogNum = Integer.valueOf(initColdInStandardPlogNum[0]);
        this.initColdInStandardECPlogNum = Integer.valueOf(initColdInStandardPlogNum[1]);
        this.initColdInStandardPartECPlogNum = Integer.valueOf(initColdInStandardPlogNum[2]);
        this.initColdInStandardSmallECPlogNum = Integer.valueOf(initColdInStandardPlogNum[3]);
        String[] maxColdInStandardPlogNum = config.getString("max_cold_in_standard_plog_num", "500;4000;500;500").split(";");
        this.maxColdInStandardMirrorPlogNum = Integer.valueOf(maxColdInStandardPlogNum[0]);
        this.maxColdInStandardECPlogNum = Integer.valueOf(maxColdInStandardPlogNum[1]);
        this.maxColdInStandardPartECPlogNum = Integer.valueOf(maxColdInStandardPlogNum[2]);
        this.maxColdInStandardSmallECPlogNum = Integer.valueOf(maxColdInStandardPlogNum[3]);
        this.coldPoolMemMaxLength = config.getLong("cold_pool_mem_max_length", 0xA00000L);
        String[] gcInitPlogNum = config.getString("gc_init_plog_num", "5;30;5").split(";");
        this.gcInitMirrorPlogNum = Integer.valueOf(gcInitPlogNum[0]);
        this.gcInitECPlogNum = Integer.valueOf(gcInitPlogNum[1]);
        this.gcInitPartECPlogNum = Integer.valueOf(gcInitPlogNum[2]);
        this.gcInitSmallECPlogNum = gcInitPlogNum.length == 4 ? Integer.valueOf(gcInitPlogNum[3]) : this.gcInitPartECPlogNum;
        String[] gcInitFDPlogNum = config.getString("gc_init_fast_delete_plog_num", "5;30;5").split(";");
        this.gcInitMirrorFDPlogNum = Integer.valueOf(gcInitFDPlogNum[0]);
        this.gcInitECFDPlogNum = Integer.valueOf(gcInitFDPlogNum[1]);
        this.gcInitPartECFDPlogNum = Integer.valueOf(gcInitFDPlogNum[2]);
        String[] coldGcInitPlogNum = config.getString("cold_gc_init_plog_num", "0;0").split(";");
        this.coldGcInitECPlogNum = Integer.valueOf(coldGcInitPlogNum[0]);
        this.coldGcInitPartECPlogNum = Integer.valueOf(coldGcInitPlogNum[1]);
        String[] gcMaxPlogNum = config.getString("gc_max_plog_num", "50;300;50").split(";");
        this.gcMaxMirrorPlogNum = Integer.valueOf(gcMaxPlogNum[0]);
        this.gcMaxECPlogNum = Integer.valueOf(gcMaxPlogNum[1]);
        this.gcMaxPartECPlogNum = Integer.valueOf(gcMaxPlogNum[2]);
        String[] gcMaxFDPlogNum = config.getString("gc_max_fast_delete_plog_num", "50;300;50").split(";");
        this.gcMaxMirrorFDPlogNum = Integer.valueOf(gcMaxFDPlogNum[0]);
        this.gcMaxECFDPlogNum = Integer.valueOf(gcMaxFDPlogNum[1]);
        this.gcMaxPartECFDPlogNum = Integer.valueOf(gcMaxFDPlogNum[2]);
        String[] coldGcMaxPlogNum = config.getString("cold_gc_max_plog_num", "25;25").split(";");
        this.coldGcMaxECPlogNum = Integer.valueOf(coldGcMaxPlogNum[0]);
        this.coldGcMaxPartECPlogNum = Integer.valueOf(coldGcMaxPlogNum[1]);
        String[] plogUseRate = config.getString("plog_use_rate", "95;95;95;95").split(";");
        this.mirrorPlogUseRate = Integer.valueOf(plogUseRate[0]);
        this.ecPlogUseRate = Integer.valueOf(plogUseRate[1]);
        this.partECPlogUseRate = Integer.valueOf(plogUseRate[2]);
        this.deltaECPlogUseRate = Integer.valueOf(plogUseRate[2]);
        String[] coldPlogUseRate = config.getString("cold_plog_use_rate", "95;95").split(";");
        this.coldEcPlogUseRate = Integer.valueOf(coldPlogUseRate[0]);
        this.coldPartECPlogUseRate = Integer.valueOf(coldPlogUseRate[1]);
        this.ecPlogCapacity = config.getInt("ec_plog_capacity", 4);
        this.deltaECPlogCapacity = config.getInt("delta_ec_plog_capacity", 4);
        this.coldEcPlogCapacity = config.getInt("cold_ec_plog_capacity", 6);
        this.smallEcPlogCapacity = config.getInt("small_ec_plog_capacity", 4);
        this.mirrorPlogCapacity = config.getInt("mirror_plog_capacity", 1);
        String[] plogHeaderOffset = config.getString("plog_header_offset", "0;1;2;6;9;11").split(";");
        this.plogHeaderMagicOffset = Integer.valueOf(plogHeaderOffset[0]);
        this.plogHeaderVersionOffset = Integer.valueOf(plogHeaderOffset[1]);
        this.plogHeaderBlocklenOffset = Integer.valueOf(plogHeaderOffset[2]);
        this.plogHeaderFlagOffset = Integer.valueOf(plogHeaderOffset[3]);
        this.plogHeaderHeaderlenOffset = Integer.valueOf(plogHeaderOffset[4]);
        this.plogHeaderObjectKeylenOffset = Integer.valueOf(plogHeaderOffset[5]);
        this.plogSealTaskQueueCapacity = config.getInt("plog_seal_task_queue_capacity", 20000);
        this.createPlogNumPerTimes = config.getInt("create_plog_number_per_times", 256);
        this.usedTokenRatioMid = config.getInt("used_token_ratio_mid", 40);
        this.usedTokenRatioHigh = config.getInt("used_token_ratio_high", 80);
        this.plogSealWorkerNumber = config.getInt("plog_seal_worker_number", 8);
        String[] plogHeaderLength = config.getString("plog_header_length", "1;1;4;3;2;2").split(";");
        this.plogHeaderMagicLength = Integer.valueOf(plogHeaderLength[0]);
        this.plogHeaderVersionLength = Integer.valueOf(plogHeaderLength[1]);
        this.plogHeaderBlocklenLength = Integer.valueOf(plogHeaderLength[2]);
        this.plogHeaderFlagLength = Integer.valueOf(plogHeaderLength[3]);
        this.plogHeaderHeaderlenLength = Integer.valueOf(plogHeaderLength[4]);
        this.plogHeaderObjectKeylenLength = Integer.valueOf(plogHeaderLength[5]);
        this.plogHeaderMagicValue = config.getByte("plog_header_magic_value", (byte)-18);
        this.plogHeaderVersionValue = config.getByte("plog_header_version_value", (byte)0);
        this.plogHeaderAlignedBytes = config.getInt("plog_header_aligned_bytes", 16);
        this.monitorPlogNumberPeriod = config.getInt("monitor_plog_number_period", 10);
        this.monitorUnusedPlogPeriod = config.getInt("monitor_unused_plog_period", 600);
        this.monitorDegradePlogPeriod = config.getInt("monitor_degrade_plog_period", 180);
        this.monitorPlogPoolCapacityPeriod = config.getInt("mongitor_plog_pool_capacity_period", 1);
        this.plogClientInitTimes = config.getInt("plog_client_init_times", 10000);
        this.plogObjectListSize = config.getInt("plog_object_list_size", 4000);
        this.plogObjectListSizePerDoc = config.getInt("plog_object_list_size_per_doc", 800);
        this.plogObjectListSizeToDisk = config.getInt("obs_plog_object_list_size_to_disk", 20);
        this.mirrorThreshold = config.getInt("mirror_threshold", 0);
        this.ssdUsageHighThreshold = config.getDouble("ssd_usage_high_threshold", 0.75);
        this.ssdUsageLowThreshold = config.getDouble("ssd_usage_low_threshold", 0.7);
        if (!(this.ssdUsageLowThreshold <= this.ssdUsageHighThreshold) || !(this.ssdUsageHighThreshold <= 1.0)) {
            LOGGER.warn("error configured: ssdUsageHighThreshold: {}, ssdUsageLowThreshold: {}", (Object)this.ssdUsageHighThreshold, (Object)this.ssdUsageLowThreshold);
            this.ssdUsageHighThreshold = 0.75;
            this.ssdUsageLowThreshold = 0.7;
        }
        this.ssdUsedUpThreshold = config.getDouble("ssd_use_up_threshold", 0.95);
        this.ssdStorageAvailableThreshold = config.getDouble("ssd_storage_available_threshold", 0.9);
        if (!(this.ssdStorageAvailableThreshold <= this.ssdUsedUpThreshold) || !(this.ssdUsedUpThreshold <= 1.0)) {
            LOGGER.warn("error configured: ssdStorageAvailableThreshold: {}, ssdUsedUpThreshold: {}", (Object)this.ssdStorageAvailableThreshold, (Object)this.ssdUsedUpThreshold);
            this.ssdStorageAvailableThreshold = 0.9;
            this.ssdUsedUpThreshold = 0.95;
        }
        this.hddUsedUpThreshold = config.getDouble("hdd_use_up_threshold", 1.0);
        this.hddStorageAvailableThreshold = config.getDouble("hdd_storage_available_threshold", 1.0);
        this.coldUsedUpThreshold = config.getDouble("cold_used_up_threshold", 0.95);
        this.coldStorageAvailableThreshold = config.getDouble("cold_storage_available_threshold", 0.95);
        if (!(this.hddStorageAvailableThreshold <= this.hddUsedUpThreshold) || !(this.hddUsedUpThreshold <= 1.0)) {
            LOGGER.warn("error configured: hddStorageAvailableThreshold: {}, hddUsedUpThreshold: {}", (Object)this.hddStorageAvailableThreshold, (Object)this.hddUsedUpThreshold);
            this.hddStorageAvailableThreshold = 1.0;
            this.hddUsedUpThreshold = 1.0;
        }
        this.oscDefaultDataPriority = config.getInt("default_priority_osc", 1);
        this.gcDefaultDataPriority = config.getInt("default_priority_gc", 2);
        this.gcWaitTime = config.getInt("wait_time_for_write_gc", 10);
        this.gcWritePercent = config.getInt("percent_for_write_gc", 90);
        this.maxWriteCountForOneWrite = config.getInt("max_buffer_count_for_one_write_osc", 5);
        this.writeBackPlogThreshold = config.getDouble("write_back_part_ec_threshold", 0.75);
        this.smallWriteECThreshold = config.getInt("smallWriteECThreshold", 0x200000);
        this.enterPriseEC = config.getBoolean("ec_enterprise", false);
        String[] lowCostInitPlogNum = config.getString("low_cost_init_plog_num", "0;200;100;100").split(";");
        this.lowCostInitMirrorPlogNum = Integer.valueOf(lowCostInitPlogNum[0]);
        this.lowCostInitECPlogNum = Integer.valueOf(lowCostInitPlogNum[1]);
        this.lowCostInitPartECPlogNum = Integer.valueOf(lowCostInitPlogNum[2]);
        this.lowCostInitSmallECPlogNum = Integer.valueOf(lowCostInitPlogNum[3]);
        String[] lowCostMaxPlogNum = config.getString("low_cost_max_plog_num", "0;20000;2500;2500").split(";");
        this.lowCostMaxMirrorPlogNum = Integer.valueOf(lowCostMaxPlogNum[0]);
        this.lowCostMaxECPlogNum = Integer.valueOf(lowCostMaxPlogNum[1]);
        this.lowCostMaxPartECPlogNum = Integer.valueOf(lowCostMaxPlogNum[2]);
        this.lowCostMaxSmallECPlogNum = Integer.valueOf(lowCostMaxPlogNum[3]);
        this.lowCostSmallWriteAggregationWaitTime = config.getInt("low_cost_small_write_aggregation_wait_time", 0);
        this.lowCostPartEcAggregationWaitTime = config.getInt("low_cost_part_ec_aggregation_wait_time", 500);
        String[] dedicatedInitPlogNum = config.getString("dedicated_init_plog_num", "0;0;0;0").split(";");
        this.dedicatedInitMirrorPlogNum = Integer.valueOf(dedicatedInitPlogNum[0]);
        this.dedicatedInitECPlogNum = Integer.valueOf(dedicatedInitPlogNum[1]);
        this.dedicatedInitPartECPlogNum = Integer.valueOf(dedicatedInitPlogNum[2]);
        this.dedicatedInitSmallECPlogNum = Integer.valueOf(dedicatedInitPlogNum[3]);
        String[] dedicatedMaxPlogNum = config.getString("dedicated_max_plog_num", "0;20000;2500;2500").split(";");
        this.dedicatedMaxMirrorPlogNum = Integer.valueOf(dedicatedMaxPlogNum[0]);
        this.dedicatedMaxECPlogNum = Integer.valueOf(dedicatedMaxPlogNum[1]);
        this.dedicatedMaxPartECPlogNum = Integer.valueOf(dedicatedMaxPlogNum[2]);
        this.dedicatedMaxSmallECPlogNum = Integer.valueOf(dedicatedMaxPlogNum[3]);
        this.dedicatedSmallWriteAggregationWaitTime = config.getInt("dedicated_small_write_aggregation_wait_time", 0);
        this.dedicatedPartEcAggregationWaitTime = config.getInt("dedicated_part_ec_aggregation_wait_time", 500);
        String[] lowCostGcInitPlogNum = config.getString("low_cost_gc_init_plog_num", "0;30;5").split(";");
        this.lowCostGcInitMirrorPlogNum = Integer.valueOf(gcInitPlogNum[0]);
        this.lowCostGcInitECPlogNum = Integer.valueOf(gcInitPlogNum[1]);
        this.lowCostGcInitPartECPlogNum = Integer.valueOf(gcInitPlogNum[2]);
        String[] lowCostGcMaxPlogNum = config.getString("low_cost_gc_max_plog_num", "0;300;50").split(";");
        this.lowCostGcMaxMirrorPlogNum = Integer.valueOf(lowCostGcMaxPlogNum[0]);
        this.lowCostGcMaxECPlogNum = Integer.valueOf(lowCostGcMaxPlogNum[1]);
        this.lowCostGcMaxPartECPlogNum = Integer.valueOf(lowCostGcMaxPlogNum[2]);
        String[] dedicatedGcInitPlogNum = config.getString("dedicated_gc_init_plog_num", "0;30;5").split(";");
        this.dedicatedGcInitMirrorPlogNum = Integer.valueOf(dedicatedGcInitPlogNum[0]);
        this.dedicatedGcInitECPlogNum = Integer.valueOf(dedicatedGcInitPlogNum[1]);
        this.dedicatedGcInitPartECPlogNum = Integer.valueOf(dedicatedGcInitPlogNum[2]);
        String[] dedicatedGcMaxPlogNum = config.getString("dedicated_gc_max_plog_num", "0;300;50").split(";");
        this.dedicatedGcMaxMirrorPlogNum = Integer.valueOf(dedicatedGcMaxPlogNum[0]);
        this.dedicatedGcMaxECPlogNum = Integer.valueOf(dedicatedGcMaxPlogNum[1]);
        this.dedicatedGcMaxPartECPlogNum = Integer.valueOf(dedicatedGcMaxPlogNum[2]);
    }

    private void loadBufferPoolConfig(PropertiesConfiguration config) {
        this.uploadPoolSize = config.getInt("upload_pool_size", 12);
        this.uploadMaxShrinkSize = config.getInt("upload_max_shrink_size", 10);
        this.uploadMaxExpandSize = config.getInt("upload_max_expend_size", 10);
        this.uploadShrinkThreshold = config.getInt("upload_advice_threshold", 3);
        this.uploadLowAdviceThreshold = config.getInt("upload_low_advice_threshold", 3);
        this.uploadExpandThreshold = config.getInt("upload_no_advice_threshold", 3);
        this.uploadResourceMonitorPeriod = config.getLong("upload_resource_monitor_period", 1000L);
        this.downloadPoolSize = config.getInt("download_pool_size", 30);
        this.downloadMaxShrinkSize = config.getInt("download_max_shrink_size", 10);
        this.downloadMaxExpandSize = config.getInt("download_max_expend_size", 5);
        this.downloadAdviceThreshold = config.getInt("download_advice_threshold", 3);
        this.downloadLowAdviceThreshold = config.getInt("download_low_advice_threshold", 3);
        this.downloadNoAdviceThreshold = config.getInt("download_no_advice_threshold", 3);
        this.downloadResourceMonitorPeriod = config.getLong("download_resource_monitor_period", 1000L);
        config.getInt("download_no_advice_threshold", 3);
        this.downloadResourceMonitorPeriod = config.getLong("download_resource_monitor_period", 1000L);
        this.localTokenRetryTime = config.getInt("localtoken_retry_time", 300);
        this.globalTokenLogInterval = config.getInt("global_token_log_interval", 30000);
    }

    public int getUploadWaitTimeForComplete() {
        return this.uploadWaitTimeForComplete;
    }

    public int getDataTransferSize() {
        return this.dataTransferSize;
    }

    public boolean isEnablePreRead() {
        return this.enablePreRead;
    }

    public int getPreReadIOThreshold() {
        return this.preReadIOThreshold;
    }

    public boolean isEnablePreReadMemcache() {
        return this.enablePreReadMemcache;
    }

    public int getPreReadChunkSize() {
        return this.preReadChunkSize;
    }

    public int getPreReadMemcacheOpTime() {
        return this.preReadMemcacheOpTime;
    }

    public int getStopPreReadPeriod() {
        return this.stopPreReadPeriod;
    }

    public int getPreReadHitRateThreshold() {
        return this.preReadHitRateThreshold;
    }

    public int getPreReadStatisticalPeriod() {
        return this.preReadStatisticalPeriod;
    }

    public String[] getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String[] storageClass) {
        this.storageClass = storageClass;
    }

    public boolean isBufferDirect() {
        return this.bufferDirect;
    }

    public int getOscUploadExtendPoolCapacity() {
        return this.oscUploadExtendPoolCapacity;
    }

    public int getOscUploadExtendPoolMinIdle() {
        return this.oscUploadExtendPoolMinIdle;
    }

    public int getGCUploadReservedPoolCapacity() {
        return this.gcUploadReservedPoolCapacity;
    }

    public int getOisUploadExtendPoolCapacity() {
        return this.oisUploadExtendPoolCapacity;
    }

    public int getGCUploadExtendPoolCapacity() {
        return this.gcUploadExtendPoolCapacity;
    }

    public int getOisUploadExtendPoolMinIdle() {
        return this.oisUploadExtendPoolMinIdle;
    }

    public int getGCUploadExtendPoolMinIdle() {
        return this.gcUploadExtendPoolMinIdle;
    }

    public int getOTMUploadExtendPoolCapacity() {
        return this.otmUploadExtendPoolCapacity;
    }

    public int getOTMUploadExtendPoolMinIdle() {
        return this.otmUploadExtendPoolMinIdle;
    }

    public boolean isCommonBufferPoolLifo() {
        return this.commonBufferPoolLifo;
    }

    public int getCommonBufferPoolMaxIdle() {
        return this.commonBufferPoolMaxIdle;
    }

    public int getCommonBufferPoolMaxWait() {
        return this.commonBufferPoolMaxWait;
    }

    public long getCommonBufferPoolMinEvictableIdleTimeMillis() {
        return this.commonBufferPoolMinEvictableIdleTimeMillis;
    }

    public int getCommonBufferPoolNumTestsPerEvictionRun() {
        return this.commonBufferPoolNumTestsPerEvictionRun;
    }

    public boolean isCommonBufferPoolTestOnBorrow() {
        return this.commonBufferPoolTestOnBorrow;
    }

    public boolean isCommonBufferPoolTestOnReturn() {
        return this.commonBufferPoolTestOnReturn;
    }

    public boolean isCommonBufferPoolTestWhileIdle() {
        return this.commonBufferPoolTestWhileIdle;
    }

    public long getCommonBufferPoolTimeBetweenEvictionRunsMillis() {
        return this.commonBufferPoolTimeBetweenEvictionRunsMillis;
    }

    public boolean getCommonBufferPoolBlockWhenExhausted() {
        return this.commonBufferPoolBlockWhenExhausted;
    }

    public int getMaxBufferSizePerConn() {
        return this.maxBufferSizePerConn;
    }

    public boolean isDeltaECUseMem() {
        return this.deltaECUseMem;
    }

    public int getUploadPoolSize() {
        return this.uploadPoolSize;
    }

    public int getUploadMaxShrinkSize() {
        return this.uploadMaxShrinkSize;
    }

    public int getUploadMaxExpandSize() {
        return this.uploadMaxExpandSize;
    }

    public int getUploadAdviceThreshold() {
        return this.uploadShrinkThreshold;
    }

    public int getUploadLowAdviceThreshold() {
        return this.uploadLowAdviceThreshold;
    }

    public int getUploadNoAdviceThreshold() {
        return this.uploadExpandThreshold;
    }

    public long getUploadResourceMonitorPeriod() {
        return this.uploadResourceMonitorPeriod;
    }

    public int getDownloadPoolSize() {
        return this.downloadPoolSize;
    }

    public int getDownloadMaxShrinkSize() {
        return this.downloadMaxShrinkSize;
    }

    public int getDownloadMaxExpandSize() {
        return this.downloadMaxExpandSize;
    }

    public int getDownloadAdviceThreshold() {
        return this.downloadAdviceThreshold;
    }

    public int getDownloadLowAdviceThreshold() {
        return this.downloadLowAdviceThreshold;
    }

    public int getDownloadNoAdviceThreshold() {
        return this.downloadNoAdviceThreshold;
    }

    public long getDownloadResourceMonitorPeriod() {
        return this.downloadResourceMonitorPeriod;
    }

    public int getGlobalTokenLogInterval() {
        return this.globalTokenLogInterval;
    }

    public long getDownloadRequestPoolTokenTimeoutMax() {
        return this.downloadRequestPoolTokenTimeoutMax;
    }

    public int getLocalTokenRetryTimes() {
        return this.localTokenRetryTimes;
    }

    public int getLocalTokenTimeout() {
        return this.localTokenTimeout;
    }

    public boolean getReadPerfDebug() {
        return this.isReadPerfDebugOpen;
    }

    public int getOscDefaultDataPriority() {
        return this.oscDefaultDataPriority;
    }

    public int getGCDefaultDataPriority() {
        return this.gcDefaultDataPriority;
    }

    public int getMirrorThreshold() {
        return this.mirrorThreshold;
    }

    public int getGCWaitTime() {
        return this.gcWaitTime;
    }

    public long getPartECAggregationWaitTime() {
        return this.partECAggregationWaitTime;
    }

    public long getPartECAggregationWaitTime3AZ() {
        return this.partECAggregationWaitTime3AZ;
    }

    public long getMirrorAggregationWaitTime() {
        return this.mirrorAggregationWaitTime;
    }

    public long getSmallWriteAggregationWaitTime() {
        return this.smallWriteAggregationWaitTime;
    }

    public long getDeltaECWriteAggregationWaitTime() {
        return this.deltaECWriteAggregationWaitTime;
    }

    public int getGCWritePercent() {
        return this.gcWritePercent;
    }

    public int getMaxWriteCountForOneWrite() {
        return this.maxWriteCountForOneWrite;
    }

    public int getPlogReadMaxFailTime() {
        return this.plogReadMaxFailTime;
    }

    public int getAppendPlogMaxRetryCount() {
        return this.appendPlogMaxRetryCount;
    }

    public double getWriteBackPlogThreshold() {
        return this.writeBackPlogThreshold;
    }

    public int getMonitorPlogPoolCapacityPeriod() {
        return this.monitorPlogPoolCapacityPeriod;
    }

    public double getSSDUsageHighThreshold() {
        return this.ssdUsageHighThreshold;
    }

    public double getSSDUsageLowThreshold() {
        return this.ssdUsageLowThreshold;
    }

    public double getSSDUsedUpThreshold() {
        return this.ssdUsedUpThreshold;
    }

    public double getSSDStorageAvailableThreshold() {
        return this.ssdStorageAvailableThreshold;
    }

    public double getHDDUsedUpThreshold() {
        return this.hddUsedUpThreshold;
    }

    public double getHDDStorageAvailableThreshold() {
        return this.hddStorageAvailableThreshold;
    }

    public double getColdUsedUpThreshold() {
        return this.coldUsedUpThreshold;
    }

    public double getColdStorageAvailableThreshold() {
        return this.coldStorageAvailableThreshold;
    }

    public int getPlogSealTaskQueueCapacity() {
        return this.plogSealTaskQueueCapacity;
    }

    public int getPlogSealWorkerNumber() {
        return this.plogSealWorkerNumber;
    }

    public int getSmallWriteECThreshold() {
        return this.smallWriteECThreshold;
    }

    public boolean isEnterPriseEC() {
        return this.enterPriseEC;
    }

    public int getInitSmallECPlogNum() {
        return this.initSmallECPlogNum;
    }

    public int getMaxSmallECPlogNum() {
        return this.maxSmallECPlogNum;
    }

    public int getSmallWriteWriteBackThreshold() {
        return this.smallWriteWriteBackThreshold;
    }

    public int getLowCostInitMirrorPlogNum() {
        return this.lowCostInitMirrorPlogNum;
    }

    public int getLowCostMaxMirrorPlogNum() {
        return this.lowCostMaxMirrorPlogNum;
    }

    public int getLowCostInitSmallECPlogNum() {
        return this.lowCostInitSmallECPlogNum;
    }

    public int getLowCostMaxSmallECPlogNum() {
        return this.lowCostMaxSmallECPlogNum;
    }

    public int getLowCostInitPartECPlogNum() {
        return this.lowCostInitPartECPlogNum;
    }

    public int getLowCostMaxPartECPlogNum() {
        return this.lowCostMaxPartECPlogNum;
    }

    public int getLowCostInitECPlogNum() {
        return this.lowCostInitECPlogNum;
    }

    public int getLowCostMaxECPlogNum() {
        return this.lowCostMaxECPlogNum;
    }

    public int getDedicatedInitMirrorPlogNum() {
        return this.dedicatedInitMirrorPlogNum;
    }

    public int getDedicatedMaxMirrorPlogNum() {
        return this.dedicatedMaxMirrorPlogNum;
    }

    public int getDedicatedInitSmallECPlogNum() {
        return this.dedicatedInitSmallECPlogNum;
    }

    public int getDedicatedMaxSmallECPlogNum() {
        return this.dedicatedMaxSmallECPlogNum;
    }

    public int getDedicatedInitPartECPlogNum() {
        return this.dedicatedInitPartECPlogNum;
    }

    public int getDedicatedMaxPartECPlogNum() {
        return this.dedicatedMaxPartECPlogNum;
    }

    public int getDedicatedInitECPlogNum() {
        return this.dedicatedInitECPlogNum;
    }

    public int getDedicatedMaxECPlogNum() {
        return this.dedicatedMaxECPlogNum;
    }

    public int getLowCostGcInitMirrorPlogNum() {
        return this.lowCostGcInitMirrorPlogNum;
    }

    public int getLowCostGcMaxMirrorPlogNum() {
        return this.lowCostGcMaxMirrorPlogNum;
    }

    public int getLowCostGcInitPartECPlogNum() {
        return this.lowCostGcInitPartECPlogNum;
    }

    public int getLowCostGcMaxPartECPlogNum() {
        return this.lowCostGcMaxPartECPlogNum;
    }

    public int getLowCostGcInitECPlogNum() {
        return this.lowCostGcInitECPlogNum;
    }

    public int getLowCostGcMaxECPlogNum() {
        return this.lowCostGcMaxECPlogNum;
    }

    public int getDedicatedGcInitMirrorPlogNum() {
        return this.dedicatedGcInitMirrorPlogNum;
    }

    public int getDedicatedGcMaxMirrorPlogNum() {
        return this.dedicatedGcMaxMirrorPlogNum;
    }

    public int getDedicatedGcInitPartECPlogNum() {
        return this.dedicatedGcInitPartECPlogNum;
    }

    public int getDedicatedGcMaxPartECPlogNum() {
        return this.dedicatedGcMaxPartECPlogNum;
    }

    public int getDedicatedGcInitECPlogNum() {
        return this.dedicatedGcInitECPlogNum;
    }

    public int getDedicatedGcMaxECPlogNum() {
        return this.dedicatedGcMaxECPlogNum;
    }

    public long getLowCostSmallWriteAggregationWaitTime() {
        return this.lowCostSmallWriteAggregationWaitTime;
    }

    public long getLowCostPartECAggregationWaitTime() {
        return this.lowCostPartEcAggregationWaitTime;
    }

    public long getDedicatedSmallWriteAggregationWaitTime() {
        return this.dedicatedSmallWriteAggregationWaitTime;
    }

    public long getDedicatedPartECAggregationWaitTime() {
        return this.dedicatedPartEcAggregationWaitTime;
    }

    public boolean useAsyncMD5() {
        return this.useAsyncMD5;
    }

    public int getAsyncMD5ThreadNum() {
        return this.asyncMD5ThreadNum;
    }

    public int getAsyncMD5DataSize() {
        return this.asyncMD5DataSize;
    }

    public int getAsyncMD5Threshold() {
        return this.asyncMD5Threshold;
    }

    public List<Integer> getMirrorBackupNumber() {
        return this.mirrorBackupNumber;
    }

    public int getPlogKeyListSplitThreshold() {
        return this.plogKeyListSplitThreshold;
    }

    public int getInitFileMirrorPlogNum() {
        return this.initFileMirrorPlogNum;
    }

    public int getMaxFileMirrorPlogNum() {
        return this.maxFileMirrorPlogNum;
    }

    public int getMinFileMirrorPlogNum() {
        return this.minFileMirrorPlogNum;
    }

    public int getInitFileECPlogNum() {
        return this.initFileECPlogNum;
    }

    public int getMaxFileECPlogNum() {
        return this.maxFileECPlogNum;
    }

    public int getMinFileECPlogNum() {
        return this.minFileECPlogNum;
    }

    public int getInitFilePartECPlogNum() {
        return this.initFilePartECPlogNum;
    }

    public int getMaxFilePartECPlogNum() {
        return this.maxFilePartECPlogNum;
    }

    public int getMinFilePartECPlogNum() {
        return this.minFilePartECPlogNum;
    }

    public int getInitFileSmallECPlogNum() {
        return this.initFileSmallECPlogNum;
    }

    public int getMaxFileSmallECPlogNum() {
        return this.maxFileSmallECPlogNum;
    }

    public int getMinFileSmallECPlogNum() {
        return this.minFileSmallECPlogNum;
    }

    public int getFsBigIoLength() {
        return this.fsBigIoLength;
    }

    public int getLocalMaxWeightScale() {
        return this.localMaxWeightScale;
    }

    public int getCreatePlogNumPerTimes() {
        return this.createPlogNumPerTimes;
    }

    public int getLocalTokenRetryTime() {
        return this.localTokenRetryTime;
    }

    public int getInitColdInStandardMirrorPlogNum() {
        return this.initColdInStandardMirrorPlogNum;
    }

    public int getInitColdInStandardECPlogNum() {
        return this.initColdInStandardECPlogNum;
    }

    public int getInitColdInStandardPartECPlogNum() {
        return this.initColdInStandardPartECPlogNum;
    }

    public int getInitColdInStandardSmallECPlogNum() {
        return this.initColdInStandardSmallECPlogNum;
    }

    public int getMaxColdInStandardMirrorPlogNum() {
        return this.maxColdInStandardMirrorPlogNum;
    }

    public int getMaxColdInStandardECPlogNum() {
        return this.maxColdInStandardECPlogNum;
    }

    public int getMaxColdInStandardPartECPlogNum() {
        return this.maxColdInStandardPartECPlogNum;
    }

    public int getMaxColdInStandardSmallECPlogNum() {
        return this.maxColdInStandardSmallECPlogNum;
    }

    public long getColdPoolMemMaxLength() {
        return this.coldPoolMemMaxLength;
    }

    public int getUsedTokenRatioMid() {
        return this.usedTokenRatioMid;
    }

    public int getUsedTokenRatioHigh() {
        return this.usedTokenRatioHigh;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public int getStoragePoolId() {
        return this.storagePoolId;
    }
}

