/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.otm;

import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.index.KVConfig;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public final class MigConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigConfig.class);
    private static final MigConfig INSTANCE = new MigConfig();
    private static final int FORMAT_NUM = 8;
    private static final int MAX_TAKEOVER_NUM = 24;
    private static final int NODE_MAYBE_FAULT_HBVALUE = 3;
    private String[] warmingFormatArray = new String[8];
    private int maxTransitionNum;
    private int migrateThreadSize;
    private int logScanIntervalMinute;
    private int migMaxListKeys;
    private int logProcessMaxRetryTimes;
    private String protocol;
    private long abortDayThreshold;
    private int abortRetryThreshold;
    private String glacierServiceConfigBucketName;
    private int glacierHeadBucketRetry;
    private int glacierSendAlarmPeriod;
    private int glacierBucketBatchCnt;
    private boolean lifeCycleDeltaScanEnable;
    private boolean lifeCycleS3ReqWithoutExecute;
    private boolean lifeCycleRecordProcessEnable;
    private boolean lifeCycleRecordTimeEnable;
    private int lifeCycleChunkPoolMaxSize;
    private int lifeCycleS3ReqPoolMaxSize;
    private int lifeCyclePrintObjInfoMaxSize;
    private int lifeCycleListChunkSizeOnePage;
    private int lifeCycleListObjectSizeOnePage;
    private long lifeCycleScanDeltaTime;
    private int lifeCycleMaxFrontThreadPoolNum;
    private int lifeCyclePoolNumPerReq;
    private int lifeCycleSubmitTaskTimeout;
    private boolean mockLifeCycleLanEndpointEnable;
    private String mockLifeCycleLanEndpointList;
    private String otmAzIpList;
    private String coldPoolAzId;
    private long otmMigrateQosLimitBps;
    private long otmMigrateQosLimitConcurrentreq;
    private long otmMigrateQosLimitTps;
    private long checkObjectLifeCycleBucketTaskTimeoutLastFail;
    private long checkLifecycleMaxFailCntOneDay;
    private double checkLifecycleMinSuccessRateOneDay;
    private long lifecycleMaxScanTimesPerDay;
    private int otmExecuteMigrateTaskMaxNum;
    private int otmRestoreTaskNum;
    private int otmRestoreInitialTaskNum;
    private int otmRestoreCachingTaskNum;
    private int otmRestoreCachedTaskNum;
    private int otmRestoreMigratedTaskNum;
    private int otmDeletionScanTaskNum;
    private String otmExeTimeSegment;
    private long migRestoreLockTimeout;
    private int coldQuotaCheckRatio;
    private int localAlarmAccountCapacity;
    private int localAlarmAccountCacheTimeout;

    private MigConfig() {
    }

    public static MigConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            return;
        }
        String tmpWarmingFormat = config.getString("warming_switch", "00000000");
        this.warmingFormatArray = this.convertWarmingFormatToArray(tmpWarmingFormat);
        this.maxTransitionNum = config.getInt("max_transition_num", 1000);
        this.migrateThreadSize = config.getInt("migrate_thread_size", 60);
        this.migrateThreadSize = Math.min(this.migrateThreadSize, 200);
        this.logScanIntervalMinute = this.getConfig().getInt("mig_log_scan_interval_minute", 5);
        this.migMaxListKeys = this.getConfig().getInt("mig_max_list_keys", 60);
        this.logProcessMaxRetryTimes = this.getConfig().getInt("log_process_max_retry_times", 3);
        this.protocol = config.getString("cold_service_protocol", "https");
        this.abortDayThreshold = config.getLong("abort_day_threshold", 172800000L);
        this.abortRetryThreshold = config.getInt("abort_retry_threshold", 200);
        this.glacierServiceConfigBucketName = config.getString("glacier_service_config_bucket_name", ".Ya89Soshla6S4Uma_glacierconfig");
        this.glacierHeadBucketRetry = config.getInt("glacier_service_head_bucket_retry", 3);
        this.glacierSendAlarmPeriod = config.getInt("glacier_service_alarm_period", 5);
        this.glacierBucketBatchCnt = config.getInt("glacier_create_bucket_batch_cnt", 50);
        this.otmAzIpList = config.getString("otm_az_ip_list", "");
        this.coldPoolAzId = config.getString("cold_pool_az_id", "");
        this.otmMigrateQosLimitBps = this.getConfig().getLong("otm_migrate_qos_limit_bps", 0L);
        this.otmMigrateQosLimitConcurrentreq = this.getConfig().getLong("otm_migrate_qos_limit_concurrentreq", 0L);
        this.otmMigrateQosLimitTps = this.getConfig().getLong("otm_migrate_qos_limit_tps", 0L);
        this.otmExecuteMigrateTaskMaxNum = config.getInt("otm_execute_migrate_task_max_num", 15);
        this.loadOtmConfig(config);
        this.loadLifeCycleConfig(config);
    }

    private void loadOtmConfig(PropertiesConfiguration config) {
        this.otmRestoreTaskNum = config.getInt("send_otm_restore_task_num", 5);
        this.otmRestoreInitialTaskNum = config.getInt("otm_restore_initial_task_num", 5);
        this.otmRestoreCachingTaskNum = config.getInt("otm_restore_caching_task_num", 5);
        this.otmRestoreCachedTaskNum = config.getInt("otm_restore_cached_task_num", 8);
        this.otmRestoreMigratedTaskNum = config.getInt("otm_restore_migrated_task_num", 5);
        this.otmDeletionScanTaskNum = config.getInt("otm_deletion_scan_task_num", 5);
        this.otmExeTimeSegment = config.getString("otm_execute_time_segment", "");
        this.coldQuotaCheckRatio = config.getInt("otm_cold_quota_check_ratio", 100);
        this.localAlarmAccountCapacity = config.getInt("otm_account_alarm_capacity", 10000);
        this.localAlarmAccountCacheTimeout = config.getInt("otm_account_alarm_cache_timeout", 86400000);
    }

    private void loadLifeCycleConfig(PropertiesConfiguration config) {
        this.lifeCycleDeltaScanEnable = config.getBoolean("lifecycle_delta_scan_enable", true);
        this.lifeCycleS3ReqWithoutExecute = config.getBoolean("lifecycle_task_not_execute", false);
        this.lifeCycleRecordProcessEnable = config.getBoolean("lifecycle_record_process_enable", true);
        this.lifeCycleRecordTimeEnable = config.getBoolean("lifecycle_record_time_enable", true);
        this.lifeCycleChunkPoolMaxSize = config.getInt("lifecycle_list_max_chunk_pool", 60);
        this.lifeCycleS3ReqPoolMaxSize = config.getInt("lifecycle_list_max_s3req_pool", 20);
        this.lifeCyclePrintObjInfoMaxSize = config.getInt("lifecycle_print_max_obj_info", 10);
        this.lifeCycleListChunkSizeOnePage = config.getInt("lifecycle_list_max_chunks", 6);
        this.lifeCycleListObjectSizeOnePage = config.getInt("lifecycle_list_max_keys", 500);
        this.lifeCycleScanDeltaTime = config.getLong("lifecycle_scan_delta_time", TimeUnit.DAYS.toHours(1L));
        this.lifeCycleMaxFrontThreadPoolNum = config.getInt("lifecycle_max_front_thread_pool_num", 100);
        this.lifeCyclePoolNumPerReq = config.getInt("lifecycle_thread_num_per_req", 5);
        this.mockLifeCycleLanEndpointEnable = config.getBoolean("mock_lifecycle_endpoint_enable", false);
        this.mockLifeCycleLanEndpointList = config.getString("mock_lifecycle_endpoint_list", "");
        this.lifeCycleSubmitTaskTimeout = config.getInt("lifecycle_submit_task_timeout", 14400);
        this.checkObjectLifeCycleBucketTaskTimeoutLastFail = config.getLong("check_object_lifecycle_bucket_task_timeout_last_fail", 3600L);
        this.checkLifecycleMaxFailCntOneDay = config.getLong("check_lifecycle_max_fail_cnt_one_day", 100L);
        this.checkLifecycleMinSuccessRateOneDay = config.getDouble("check_lifecycle_min_success_rate_one_day", 0.8);
        this.lifecycleMaxScanTimesPerDay = config.getLong("lifecycle_max_scan_times_per_day", 3L);
        this.migRestoreLockTimeout = config.getLong("otm_mig_restore_lock_timeout", 3600000L);
    }

    public int getMigLogDeletePeriod() {
        int logDeletePeriod = this.getConfig().getInt("warm_mig_log_delete_minute", 10080);
        if (logDeletePeriod <= 0) {
            LOGGER.debug("get warm_mig_log_delete_period <= 0, use default [{}].", (Object)10080);
            logDeletePeriod = 10080;
        }
        return logDeletePeriod;
    }

    public int getMigLogParallelNum() {
        int migLogParallelNum = this.getConfig().getInt("warm_mig_log_parallel_num", 64);
        if (migLogParallelNum <= 0 || migLogParallelNum > 512) {
            LOGGER.warn("WARMMIG:get mig_log_parallel_num <= 0 or > max [{}], use default [{}].", (Object)512, (Object)64);
            migLogParallelNum = 64;
        }
        return migLogParallelNum;
    }

    public void setMigLogParallelNum(int migLogParallelNum) {
        this.getConfig().setProperty("warm_mig_log_parallel_num", (Object)migLogParallelNum);
    }

    public int getMigLogParallelSecondHash() {
        int migLogParallelSecondHash = this.getConfig().getInt("warm_mig_log_parallel_second_hash", 1);
        if (migLogParallelSecondHash <= 0) {
            LOGGER.debug("WARMMIG:get warm_mig_log_parallel_second_hash <= 0, use default [{}].", (Object)1);
            migLogParallelSecondHash = 1;
        }
        return migLogParallelSecondHash;
    }

    public void setMigLogParallelSecondHash(int migLogParallelSecondHash) {
        this.getConfig().setProperty("warm_mig_log_parallel_second_hash", (Object)migLogParallelSecondHash);
    }

    public int getMigLogSpecialParallelNum() {
        int repMigSpecialParallelNum = this.getConfig().getInt("warm_mig_log_special_parallel_num", 13);
        if (repMigSpecialParallelNum <= 0 || repMigSpecialParallelNum > 13) {
            LOGGER.warn("WARMMIG:get warm_mig_log_special_parallel_num <= 0 or > max [{}], use default [{}].", (Object)13, (Object)13);
            repMigSpecialParallelNum = 13;
        }
        return repMigSpecialParallelNum;
    }

    public void setMigLogSpecialParallelNum(int migLogSpecialParallelNum) {
        this.getConfig().setProperty("warm_mig_log_special_parallel_num", (Object)migLogSpecialParallelNum);
    }

    public int getMigLogEntryMaxItem() {
        int migLogEntryMaxItem = this.getConfig().getInt("warm_mig_log_entry_max_item", 500);
        if (migLogEntryMaxItem <= 0 || migLogEntryMaxItem > 500) {
            LOGGER.debug("get warm_mig_log_entry_max_item is invalid.value:{}, use default [{}].", (Object)migLogEntryMaxItem, (Object)500);
            migLogEntryMaxItem = 500;
        }
        return migLogEntryMaxItem;
    }

    public void setMigLogEntryMaxItem(int migLogEntryMaxItem) {
        this.getConfig().setProperty("warm_mig_log_entry_max_item", (Object)migLogEntryMaxItem);
    }

    public int getMigLogSwitchTimeoutMinute() {
        int migLogSwitchTimeoutMinute = this.getConfig().getInt("warm_mig_log_switch_timeout_minute", 30);
        if (migLogSwitchTimeoutMinute <= 0) {
            LOGGER.debug("get warm_mig_log_switch_timeout_minute < 0, use default [{}].", (Object)30);
            migLogSwitchTimeoutMinute = 30;
        }
        return migLogSwitchTimeoutMinute;
    }

    public void setMigLogSwitchTimeoutMinute(int migLogSwitchTimeoutMinute) {
        this.getConfig().setProperty("warm_mig_log_switch_timeout_minute", (Object)migLogSwitchTimeoutMinute);
    }

    public int getMigLogStatusMaxItem() {
        int migLogStatusMaxItem = this.getConfig().getInt("warm_mig_log_status_max_item", 2048);
        if (migLogStatusMaxItem <= 0) {
            LOGGER.debug("get warm_mig_log_status_max_item <= 0, use default [{}].", (Object)2048);
            migLogStatusMaxItem = 2048;
        }
        return migLogStatusMaxItem;
    }

    public void setMigLogStatusMaxItem(int migLogStatusMaxItem) {
        this.getConfig().setProperty("warm_mig_log_status_max_item", (Object)migLogStatusMaxItem);
    }

    public int getMigLogHeaderMaxCacheNum() {
        int migLogHeaderMaxCacheNum = this.getConfig().getInt("warm_mig_log_header_max_cache_num", 400);
        if (migLogHeaderMaxCacheNum <= 0) {
            LOGGER.debug("get rep_log_header_max_cache_num <= 0, use default [{}].", (Object)400);
            migLogHeaderMaxCacheNum = 400;
        }
        return migLogHeaderMaxCacheNum;
    }

    public int getMigLogsStorageMaxNum() {
        int migLogsStorageMaxNum = this.getConfig().getInt("warm_mig_logs_storage_max_num", 20000);
        if (migLogsStorageMaxNum <= 0) {
            LOGGER.debug("get warm_mig_logs_storage_max_num <= 0, use default [{}].", (Object)20000);
            migLogsStorageMaxNum = 20000;
        }
        return migLogsStorageMaxNum;
    }

    public void setMigLogsStorageMaxNum(int migLogsStorageMaxNum) {
        this.getConfig().setProperty("warm_mig_logs_storage_max_num", (Object)migLogsStorageMaxNum);
    }

    public void setRepLogParallelNum(int repLogParallelNum) {
        this.getConfig().setProperty("warm_mig_log_parallel_num", (Object)repLogParallelNum);
    }

    public int getMigEntryStatusFlushThreshold() {
        int repEntryStatusFlushThreshold = this.getConfig().getInt("warm_mig_entry_status_flush_threshold", 125);
        if (repEntryStatusFlushThreshold <= 0) {
            LOGGER.debug("get rep_entry_status_flush_threshold <= 0, use default [{}].", (Object)125);
            repEntryStatusFlushThreshold = 125;
        }
        return repEntryStatusFlushThreshold;
    }

    public void setMigEntryStatusFlushThreshold(int repEntryStatusFlushThreshold) {
        this.getConfig().setProperty("warm_mig_entry_status_flush_threshold", (Object)repEntryStatusFlushThreshold);
    }

    public int getMigEntryStatusFlushTimeoutS() {
        int migEntryStatusFlushTimeoutS = this.getConfig().getInt("warm_mig_entry_status_flush_timeout_s", 60);
        if (migEntryStatusFlushTimeoutS < 0) {
            LOGGER.debug("get mig_entry_status_flush_timeout_s <= 0, use default [{}].", (Object)60);
            migEntryStatusFlushTimeoutS = 60;
        }
        return migEntryStatusFlushTimeoutS;
    }

    public void setMigEntryStatusFlushTimeoutS(int migEntryStatusFlushTimeoutS) {
        this.getConfig().setProperty("warm_mig_entry_status_flush_timeout_s", (Object)migEntryStatusFlushTimeoutS);
    }

    public int getMigLogTaskAddQueueWaitTimeS() {
        int migLogTaskAddQueueWaitTimeS = this.getConfig().getInt("mig_log_task_add_queue_wait_time_s", 30);
        if (migLogTaskAddQueueWaitTimeS < 0) {
            LOGGER.debug("get migLogTaskAddQueueWaitTimeS < 0, use default [{}].", (Object)30);
            migLogTaskAddQueueWaitTimeS = 30;
        }
        return migLogTaskAddQueueWaitTimeS;
    }

    public void setMigLogTaskAddQueueWaitTimeS(int migLogTaskAddQueueWaitTimeS) {
        this.getConfig().setProperty("mig_log_task_add_queue_wait_time_s", (Object)migLogTaskAddQueueWaitTimeS);
    }

    public String getWarmingFormatArray(int index) {
        return this.warmingFormatArray[index];
    }

    private String[] convertWarmingFormatToArray(String format) {
        if (format.length() != 8) {
            return this.convertString2Array("00000000");
        }
        return this.convertString2Array(format);
    }

    private String[] convertString2Array(String srcString) {
        String[] formatArray = new String[srcString.length()];
        for (int i = 0; i < srcString.length(); ++i) {
            formatArray[i] = srcString.charAt(i) + "";
        }
        return formatArray;
    }

    public void setRepairMigObjectByConsistenceTask(int repairSwitch) {
        this.getConfig().setProperty("repair_mig_object_by_consistence_task", (Object)repairSwitch);
    }

    public boolean getRepairMigObjectByConsistenceTask() {
        int repairSwitch = this.getConfig().getInt("repair_mig_object_by_consistence_task", 0);
        if (repairSwitch < 0) {
            LOGGER.debug("get repair_mig_object_by_consistence_task illegal value:{}, use default [{}].", (Object)repairSwitch, (Object)0);
            repairSwitch = 0;
        }
        return repairSwitch != 0;
    }

    public void setMigHeartbeatMaxLostCount(int maxLostCount) {
        this.getConfig().setProperty("warm_mig_heartbeat_max_lost_count", (Object)maxLostCount);
    }

    public int getMigHeartbeatMaxLostCount() {
        int maxLostCount = this.getConfig().getInt("warm_mig_heartbeat_max_lost_count", 30);
        if (maxLostCount <= 3) {
            LOGGER.warn("get heartbeat_max_lost_count illegal, use default [{}].", (Object)30);
            maxLostCount = 30;
        }
        return maxLostCount;
    }

    public void setMigMasternodeMaxLostCount(int maxLostCount) {
        this.getConfig().setProperty("warm_mig_masternode_max_lost_count", (Object)maxLostCount);
    }

    public int getMigMasternodeMaxLostCount() {
        int maxLostCount = this.getConfig().getInt("warm_mig_masternode_max_lost_count", 10);
        if (maxLostCount <= 0) {
            LOGGER.debug("get masternode_max_lost_count illegal, use default [{}].", (Object)10);
            maxLostCount = 10;
        }
        return maxLostCount;
    }

    public void setMigMaxTakeoverNum(int maxNum) {
        this.getConfig().setProperty("mig_max_takeover_num", (Object)maxNum);
    }

    public int getMigMaxTakeoverNum() {
        int maxNum = this.getConfig().getInt("mig_max_takeover_num", 8);
        if (maxNum <= 0 || maxNum > 24) {
            LOGGER.debug("get mig_max_takeover_num illegal value:{}, use default [{}].", (Object)maxNum, (Object)8);
            maxNum = 8;
        }
        return maxNum;
    }

    public int getMigLogScanIntervalMinute() {
        return this.logScanIntervalMinute;
    }

    public void setMigLogScanIntervalMinute(int minute) {
        this.logScanIntervalMinute = minute;
    }

    public int getDataTaskQueueCapacity() {
        int dataTaskQueueCapacity = this.getConfig().getInt("log_data_task_queue_capacity", 1000);
        if (dataTaskQueueCapacity <= 0) {
            LOGGER.debug("get log_data_recover_task_queue_capacity <= 0, use default [{}].", (Object)1000);
            dataTaskQueueCapacity = 1000;
        }
        return dataTaskQueueCapacity;
    }

    public int getLogAddTaskFailMaxTryNum() {
        int logAddTaskFailMaxTryNum = this.getConfig().getInt("log_add_task_fail_max_try_num", 3);
        if (logAddTaskFailMaxTryNum <= 0) {
            LOGGER.debug("get log_add_task_fail_max_try_num <= 0, use default [{}].", (Object)"log_add_task_fail_max_try_num");
            logAddTaskFailMaxTryNum = 3;
        }
        return logAddTaskFailMaxTryNum;
    }

    public int getLogAddTaskFailSleepTimeMs() {
        int logAddTaskFailSleepTimeMs = this.getConfig().getInt("log_add_task_fail_sleep_time_ms", 100);
        if (logAddTaskFailSleepTimeMs <= 0) {
            LOGGER.debug("get log_add_task_fail_sleep_time_ms <= 0, use default [{}].", (Object)"log_add_task_fail_sleep_time_ms");
            logAddTaskFailSleepTimeMs = 100;
        }
        return logAddTaskFailSleepTimeMs;
    }

    public int getLogProcessDefaultThreadSize() {
        int logProcessDefaultThreadSize = this.getConfig().getInt("log_process_default_thread_size", 50);
        if (logProcessDefaultThreadSize <= 0) {
            LOGGER.debug("getLogProcessDefaultThreadSize <= 0, use default [{}].", (Object)"log_process_default_thread_size");
            logProcessDefaultThreadSize = 50;
        }
        return logProcessDefaultThreadSize;
    }

    public int getLogProcessThreadPollWQCapacity() {
        int logProcessThreadPollWQCapacity = this.getConfig().getInt("log_process_thread_pool_WQ_capacity", 1000);
        if (logProcessThreadPollWQCapacity <= 0) {
            LOGGER.debug("get logProcessThreadPollWQCapacity <= 0, use default [{}].", (Object)"log_process_thread_pool_WQ_capacity");
            logProcessThreadPollWQCapacity = 1000;
        }
        return logProcessThreadPollWQCapacity;
    }

    public int getLogStatusMaxCacheNum() {
        int logStatusMaxCacheNum = this.getConfig().getInt("log_status_max_cache_num", 100);
        if (logStatusMaxCacheNum <= 0) {
            LOGGER.debug("get log_status_max_cache_num <= 0, use default [{}].", (Object)100);
            logStatusMaxCacheNum = 100;
        }
        return logStatusMaxCacheNum;
    }

    public boolean isMigHttps() {
        return !this.protocol.equalsIgnoreCase("http");
    }

    public int getLogFailedThreshold() {
        int logFailedThreshold = this.getConfig().getInt("log_failed_threshold", 200);
        if (logFailedThreshold <= 0) {
            LOGGER.debug("get log_failed_threshold <= 0, use default [{}].", (Object)200);
            logFailedThreshold = 200;
        }
        return logFailedThreshold;
    }

    public int getLogMoveStatusCursorInterval() {
        int interval = this.getConfig().getInt("log_move_status_cursor_interval", 100);
        if (interval <= 0) {
            return Integer.MAX_VALUE;
        }
        return interval;
    }

    public int getLogMinRetryIntervalMs() {
        int minTime = this.getConfig().getInt("log_min_retry_interval_ms", 20000);
        if (minTime < 0) {
            LOGGER.debug("getLogMinRetryIntervalMs value:{}, use default [{}].", (Object)minTime, (Object)20000);
            minTime = 20000;
        }
        return minTime;
    }

    public int getLogProcessMaxRetryTimes() {
        if (this.logProcessMaxRetryTimes < 0) {
            LOGGER.debug("getLogProcessMaxRetryTimes illegal value:{}, use default [{}].", (Object)this.logProcessMaxRetryTimes, (Object)"log_process_max_retry_times");
            this.logProcessMaxRetryTimes = 3;
        }
        return this.logProcessMaxRetryTimes;
    }

    public int getLifeCycleMaxFrontThreadPoolNum() {
        return this.lifeCycleMaxFrontThreadPoolNum;
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getMaxTransitionNum() {
        return this.maxTransitionNum;
    }

    public int getMigrateThreadSize() {
        return this.migrateThreadSize;
    }

    public int getMigMaxListKeys() {
        return this.migMaxListKeys;
    }

    public int getFailedPartsNum() {
        return this.getConfig().getInt("failed_parts_num", 0);
    }

    public long getAbortDayThreshold() {
        return this.abortDayThreshold;
    }

    public int getAbortRetryThreshold() {
        return this.abortRetryThreshold;
    }

    public String getGlacierServiceConfigBucketName() {
        return this.glacierServiceConfigBucketName;
    }

    public int getGlacierHeadBucketRetry() {
        return this.glacierHeadBucketRetry;
    }

    public int getGlacierServiceAlarmPeriod() {
        return this.glacierSendAlarmPeriod;
    }

    public int getGlacierBucketBatchCnt() {
        return this.glacierBucketBatchCnt;
    }

    public boolean isLifeCycleDeltaScanEnable() {
        return this.lifeCycleDeltaScanEnable;
    }

    public boolean isLifeCycleS3ReqWithoutExecute() {
        return this.lifeCycleS3ReqWithoutExecute;
    }

    public int getLifeCycleChunkPoolMaxSize() {
        return this.lifeCycleChunkPoolMaxSize;
    }

    public int getLifeCycleS3ReqPoolMaxSize() {
        return this.lifeCycleS3ReqPoolMaxSize;
    }

    public int getLifeCyclePrintObjInfoMaxSize() {
        return this.lifeCyclePrintObjInfoMaxSize;
    }

    public int getLifeCycleListChunkSizeOnePage() {
        return this.lifeCycleListChunkSizeOnePage;
    }

    public int getLifeCycleListObjectSizeOnePage() {
        return this.lifeCycleListObjectSizeOnePage;
    }

    public long getLifeCycleScanDeltaTime() {
        return this.lifeCycleScanDeltaTime;
    }

    public boolean isLifeCycleRecordProcessEnable() {
        return this.lifeCycleRecordProcessEnable;
    }

    public boolean isLifeCycleRecordTimeEnable() {
        return this.lifeCycleRecordTimeEnable;
    }

    public int getLifeCycleThreadNumPerReq() {
        return this.lifeCyclePoolNumPerReq;
    }

    public boolean isMockLifeCycleLanEndpointEnable() {
        return this.mockLifeCycleLanEndpointEnable;
    }

    public String getMockLifeCycleLanEndpointList() {
        return this.mockLifeCycleLanEndpointList;
    }

    public int getLifeCycleSubmitTaskTimeout() {
        return this.lifeCycleSubmitTaskTimeout;
    }

    public String getOtmAzIpList() {
        return this.otmAzIpList;
    }

    public String getColdPoolAzId() {
        return this.coldPoolAzId;
    }

    public long getOtmMigrateQosLimitBps() {
        return this.otmMigrateQosLimitBps;
    }

    public long getOtmMigrateQosLimitConcurrentreq() {
        return this.otmMigrateQosLimitConcurrentreq;
    }

    public long getOtmMigrateQosLimitTps() {
        return this.otmMigrateQosLimitTps;
    }

    public long getMigrateTaskMaxSize() {
        return KVConfig.INSTANCE.getLongValue("otm_migrate_task_max_size", 0x140000000L);
    }

    public long getMigrateTaskMaxCount() {
        return KVConfig.INSTANCE.getLongValue("otm_migrate_task_max_count", 1000000L);
    }

    public long getMigrateLogMaxCount() {
        return KVConfig.INSTANCE.getLongValue("otm_migrate_log_max_count", 1000L);
    }

    public int getMigrateMaxBsonSize() {
        return this.getConfig().getInt("otm_migrate_log_bson_max_size", 986112);
    }

    public long getCheckObjectLifeCycleBucketTaskTimeoutLastFail() {
        return this.checkObjectLifeCycleBucketTaskTimeoutLastFail;
    }

    public long getCheckLifeCycleMaxFailCntOneDay() {
        return this.checkLifecycleMaxFailCntOneDay;
    }

    public double getCheckLifecycleMinSuccessRateOneDay() {
        return this.checkLifecycleMinSuccessRateOneDay;
    }

    public long getLifecycleMaxScanTimesPerDay() {
        return this.lifecycleMaxScanTimesPerDay;
    }

    public int getOtmExecuteMigrateTaskMaxNum() {
        return this.otmExecuteMigrateTaskMaxNum;
    }

    public int getOTMRestoreTaskNum() {
        return this.otmRestoreTaskNum;
    }

    public int getOTMRestoreInitialTaskNum() {
        return this.otmRestoreInitialTaskNum;
    }

    public int getOTMRestoreCachingTaskNum() {
        return this.otmRestoreCachingTaskNum;
    }

    public int getOTMRestoreCachedTaskNum() {
        return this.otmRestoreCachedTaskNum;
    }

    public int getOTMRestoreMigratedTaskNum() {
        return this.otmRestoreMigratedTaskNum;
    }

    public int getOtmDeletionScanTaskNum() {
        return this.otmDeletionScanTaskNum;
    }

    public String getOtmExeTimeSegment() {
        return this.otmExeTimeSegment;
    }

    public long getMigRestoreLockTimeout() {
        return this.migRestoreLockTimeout;
    }

    public void setMigRestoreLockTimeout(long migRestoreLockTimeout) {
        this.migRestoreLockTimeout = migRestoreLockTimeout;
    }

    public boolean isMockBluRay() {
        return KVConfig.INSTANCE.getBoolValue("switch_mock_blue_ray", false);
    }

    public int getColdQuotaCheckRatio() {
        if (this.coldQuotaCheckRatio < 1 || this.coldQuotaCheckRatio > 100) {
            return 100;
        }
        return this.coldQuotaCheckRatio;
    }

    public int getLocalAlarmAccountCapacity() {
        if (this.localAlarmAccountCapacity < 1) {
            return 10000;
        }
        return this.localAlarmAccountCapacity;
    }

    public long getLocalAlarmAccountCacheTimeout() {
        return this.localAlarmAccountCacheTimeout;
    }
}

