/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.poeop;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class PoeOpConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoeOpConfig.class);
    private int period;
    private int coreSize;
    private int maxSize;
    private int queueSzie;
    private int duration;
    private int idletime;
    private int maxKeyPairCount;
    private boolean mobileUser;
    private long maxTenantCount;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            return;
        }
        this.period = config.getInt("scannerPeriod", 900);
        this.coreSize = config.getInt("scannerCoreSize", 50);
        this.maxSize = config.getInt("scannerMaxSize", 50);
        this.queueSzie = config.getInt("scannerQueueSize", 1000);
        this.duration = config.getInt("scannerDuration", 1800000);
        this.idletime = config.getInt("poemasterIdleTime", 180);
        this.maxKeyPairCount = config.getInt("maxKeypairCount", 3);
        this.mobileUser = config.getBoolean("mobileUser", false);
        this.maxTenantCount = config.getLong("maxTenantCount", 50000L);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getQueueSzie() {
        return this.queueSzie;
    }

    public void setQueueSzie(int queueSzie) {
        this.queueSzie = queueSzie;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getIdletime() {
        return this.idletime;
    }

    public void setIdletime(int idletime) {
        this.idletime = idletime;
    }

    public int getMaxKeyPairCount() {
        return this.maxKeyPairCount;
    }

    public void setMaxKeyPairCount(int maxKeyPairCount) {
        this.maxKeyPairCount = maxKeyPairCount;
    }

    public boolean isMobileUser() {
        return this.mobileUser;
    }

    public long getMaxTenantCount() {
        return this.maxTenantCount;
    }

    public void setMaxTenantCount(long maxTenantCount) {
        this.maxTenantCount = maxTenantCount;
    }
}

