/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.pulsarathenz;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class PulsarAthenzConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarAthenzConfig.class);
    private boolean isPulsarSwitchOpen;
    private String pulsarAddress;
    private String tenantDomain;
    private String tenantService;
    private String providerDomain;
    private String privateKey;
    private String keyId;
    private String pulsarCacertPath;
    private String athenzConfPath;
    private String principalHeader;
    private String roleHeader;
    private String ztsUrl;
    private String tlsCertFile;
    private String tlsKeyFile;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.isPulsarSwitchOpen = this.getConfig().getBoolean("pulsar_connection", false);
        this.pulsarAddress = this.getConfig().getString("pulsar_address", "");
        this.tenantDomain = this.getConfig().getString("pulsar_auth_tenant_domain", "");
        this.tenantService = this.getConfig().getString("pulsar_auth_tenant_service", "");
        this.providerDomain = this.getConfig().getString("pulsar_auth_provider_domain", "");
        this.keyId = this.getConfig().getString("pulsar_auth_key_id", "");
        this.pulsarCacertPath = this.getConfig().getString("pulsar_cacert_path", "");
        this.privateKey = this.getConfig().getString("pulsar_auth_private_key", "");
        this.athenzConfPath = this.getConfig().getString("pulsar_auth_athenz_conf_path", "");
        this.principalHeader = this.getConfig().getString("pulsar_auth_principal_header", "");
        this.roleHeader = this.getConfig().getString("pulsar_auth_role_header", "");
        this.ztsUrl = this.getConfig().getString("pulsar_auth_zts_url", "");
        this.tlsCertFile = this.getConfig().getString("pulsar_tlsCertFile", "");
        this.tlsKeyFile = this.getConfig().getString("pulsar_tlsKeyFile", "");
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public boolean isPulsarSwitchOpen() {
        return this.isPulsarSwitchOpen;
    }

    public String getPulsarAddress() {
        return this.pulsarAddress;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public String getTenantService() {
        return this.tenantService;
    }

    public String getProviderDomain() {
        return this.providerDomain;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getAthenzConfPath() {
        return this.athenzConfPath;
    }

    public String getPrincipalHeader() {
        return this.principalHeader;
    }

    public String getRoleHeader() {
        return this.roleHeader;
    }

    public String getZtsUrl() {
        return this.ztsUrl;
    }

    public String getTlsCertFile() {
        return this.tlsCertFile;
    }

    public String getTlsKeyFile() {
        return this.tlsKeyFile;
    }

    public String getPulsarCacertPath() {
        return this.pulsarCacertPath;
    }
}

