/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.qosclient;

import java.util.Properties;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class QosConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(QosConfig.class);
    private long defaultBucketTpsGet;
    private long defaultBucketTpsPutDel;
    private long defaultBucketTpsGetPutDel;
    private long defaultBucketTpsList;
    private long defaultBucketBpsGet;
    private long defaultBucketBpsPut;
    private long defaultBucketBpsGetPut;
    private long defaultBucketConcurrentreq;
    private int defaultBucketPriority;
    private boolean defaultBucketQosSwitch;
    private long ipRangeBpsPut;
    private long ipRangeTpsGet;
    private long ipRangeTpsList;
    private long ipRangeBpsGet;
    private long ipRangeTpsPut;
    private long ipRangeConcurrentReq;
    private String ipRangeName;
    private long defaultAccountTpsGet;
    private long defaultAccountTpsPutDel;
    private long defaultAccountTpsGetPutDel;
    private long defaultAccountTpsList;
    private long defaultAccountBpsGet;
    private long defaultAccountBpsPut;
    private long defaultAccountBpsGetPut;
    private long defaultAccountConcurrentreq;
    private boolean defaultAccountQosSwitch;
    private long qosStatisticsPeriod;
    private boolean loadNativeQosLibrary;
    private boolean qosInitEnable;
    private boolean oneTrunkToWrite;
    private boolean overloadControlSwitch;
    private boolean overloadchunkControlSwitch;
    private int frontTaskPriority;
    private long crrQosLimitBpsGet;
    private long crrQosLimitConcurrentreq;
    private long crrQosLimitBpsPut;
    private long crrQosLimitTpsPutDel;
    private long otmQosLimitBpsGet;
    private long otmQosLimitConcurrentreq;
    private long smcQosLimitBpsPut;
    private long smcQosLimitConcurrentreq;
    private long smcQosLimitTpsPut;
    private Properties priorityClassList;
    private long qosPerConnectBps;
    private int tierQos;

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.ipRangeName = this.getConfig().getString("ip_range_name", "");
        this.ipRangeTpsGet = this.getConfig().getLong("ip_range_limit_tps_get", 0L);
        this.ipRangeTpsPut = this.getConfig().getLong("ip_range_limit_tps_put", 0L);
        this.ipRangeTpsList = this.getConfig().getLong("ip_range_limit_tps_list", 0L);
        this.ipRangeBpsGet = this.getConfig().getLong("ip_range_limit_bps_get", 0L);
        this.ipRangeBpsPut = this.getConfig().getLong("ip_range_limit_bps_put", 0L);
        this.ipRangeConcurrentReq = this.getConfig().getLong("ip_range_limit_concurrentreq", 0L);
        this.qosStatisticsPeriod = this.getConfig().getLong("qos_statistics_period", 60000L);
        this.defaultBucketTpsGet = this.getConfig().getLong("defaultBucketQosLimit_Tps_Get", 200L);
        this.defaultBucketTpsPutDel = this.getConfig().getLong("defaultBucketQosLimit_Tps_PutDel", 200L);
        this.defaultBucketTpsGetPutDel = this.getConfig().getLong("defaultBucketQosLimit_Tps_GetPutDel", 0L);
        this.defaultBucketTpsList = this.getConfig().getLong("defaultBucketQosLimit_Tps_List", 50L);
        this.defaultBucketBpsGet = this.getConfig().getLong("defaultBucketQosLimit_Bps_Get", 102400L);
        this.defaultBucketBpsPut = this.getConfig().getLong("defaultBucketQosLimit_Bps_Put", 102400L);
        this.defaultBucketBpsGetPut = this.getConfig().getLong("defaultBucketQosLimit_Bps_GetPut", 0L);
        this.defaultBucketConcurrentreq = this.getConfig().getLong("defaultBucketQosLimit_Concurrentreq", 100L);
        this.defaultBucketPriority = this.getConfig().getInt("defaultBucketQosLimit_Priority", 3);
        this.defaultBucketQosSwitch = this.getConfig().getBoolean("defaultBucketQos_Open", false);
        this.defaultAccountTpsGet = this.getConfig().getLong("defaultAccountQosLimit_Tps_Get", 0L);
        this.defaultAccountTpsPutDel = this.getConfig().getLong("defaultAccountQosLimit_Tps_PutDel", 0L);
        this.defaultAccountTpsGetPutDel = this.getConfig().getLong("defaultAccountQosLimit_Tps_GetPutDel", 0L);
        this.defaultAccountTpsList = this.getConfig().getLong("defaultAccountQosLimit_Tps_List", 0L);
        this.defaultAccountBpsGet = this.getConfig().getLong("defaultAccountQosLimit_Bps_Get", 0L);
        this.defaultAccountBpsPut = this.getConfig().getLong("defaultAccountQosLimit_Bps_Put", 0L);
        this.loadOthers();
    }

    private void loadOthers() {
        this.defaultAccountBpsGetPut = this.getConfig().getLong("defaultAccountQosLimit_Bps_GetPut", 0L);
        this.defaultAccountConcurrentreq = this.getConfig().getLong("defaultAccountQosLimit_Concurrentreq", 0L);
        this.defaultAccountQosSwitch = this.getConfig().getBoolean("defaultAccountQos_Open", false);
        this.overloadControlSwitch = this.getConfig().getBoolean("overload_control_switch", false);
        this.overloadchunkControlSwitch = this.getConfig().getBoolean("overload_chunk_control_switch", true);
        boolean interworking = this.getConfig().getBoolean("is_support_interworking", false);
        this.loadNativeQosLibrary = !interworking ? this.getConfig().getBoolean("load_native_qos_library", true) : false;
        this.qosInitEnable = this.getConfig().getBoolean("qos_init_enable", true);
        this.oneTrunkToWrite = this.getConfig().getBoolean("one_trunk_to_write", false);
        this.frontTaskPriority = this.getConfig().getInt("front_task_priority", 2);
        this.crrQosLimitBpsGet = this.getConfig().getLong("crrQosLimit_Bps_Get", 0L);
        this.crrQosLimitConcurrentreq = this.getConfig().getLong("crrQosLimit_Concurrentreq", 0L);
        this.crrQosLimitBpsPut = this.getConfig().getLong("crrQosLimit_Bps_Put", 0L);
        this.crrQosLimitTpsPutDel = this.getConfig().getLong("crrQosLimit_Tps_PutDel", 0L);
        this.otmQosLimitBpsGet = this.getConfig().getLong("otm_qos_limit_bps_get", 0L);
        this.otmQosLimitConcurrentreq = this.getConfig().getLong("otm_qos_limit_concurrentreq", 0L);
        this.smcQosLimitBpsPut = this.getConfig().getLong("smcQosLimit_Bps_Put", 0L);
        this.smcQosLimitConcurrentreq = this.getConfig().getLong("smcQosLimit_Concurrentreq", 0L);
        this.smcQosLimitTpsPut = this.getConfig().getLong("smcQosLimit_Tps_Put", 0L);
        this.priorityClassList = this.getConfig().getProperties("priorityClassList");
        this.qosPerConnectBps = this.getConfig().getLong("qos_per_connect_bps", 0L);
        this.tierQos = this.getConfig().getInt("tier_qos", 0);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public long getIpRangeBpsPut() {
        return this.ipRangeBpsPut;
    }

    public long getDefaultBucketTpsGet() {
        return this.defaultBucketTpsGet;
    }

    public long getDefaultBucketTpsPutDel() {
        return this.defaultBucketTpsPutDel;
    }

    public long getDefaultBucketTpsGetPutDel() {
        return this.defaultBucketTpsGetPutDel;
    }

    public long getDefaultBucketTpsList() {
        return this.defaultBucketTpsList;
    }

    public long getDefaultBucketBpsGet() {
        return this.defaultBucketBpsGet;
    }

    public long getDefaultBucketBpsPut() {
        return this.defaultBucketBpsPut;
    }

    public long getDefaultBucketBpsGetPut() {
        return this.defaultBucketBpsGetPut;
    }

    public boolean isDefaultBucketQosSwitch() {
        return this.defaultBucketQosSwitch;
    }

    public boolean isOverloadControlSwitch() {
        return this.overloadControlSwitch;
    }

    public boolean isOverloadchunkControlSwitch() {
        return this.overloadchunkControlSwitch;
    }

    public long getIpRangeTpsGet() {
        return this.ipRangeTpsGet;
    }

    public long getIpRangeTpsList() {
        return this.ipRangeTpsList;
    }

    public long getIpRangeBpsGet() {
        return this.ipRangeBpsGet;
    }

    public long getIpRangeTpsPut() {
        return this.ipRangeTpsPut;
    }

    public long getIpRangeConcurrentReq() {
        return this.ipRangeConcurrentReq;
    }

    public String getIpRangeName() {
        return this.ipRangeName;
    }

    public long getQosStatisticsPeriod() {
        return this.qosStatisticsPeriod;
    }

    public long getDefaultBucketConcurrentreq() {
        return this.defaultBucketConcurrentreq;
    }

    public int getDefaultBucketPriority() {
        return this.defaultBucketPriority;
    }

    public boolean isLoadNativeQosLibrary() {
        return this.loadNativeQosLibrary;
    }

    public boolean isQosInitEnable(boolean isInterWorking) {
        if (isInterWorking) {
            return this.qosInitEnable;
        }
        return this.qosInitEnable && this.loadNativeQosLibrary;
    }

    public boolean isOneTrunkToWrite() {
        return this.oneTrunkToWrite;
    }

    public int getFrontTaskPriority() {
        return this.frontTaskPriority;
    }

    public long getDefaultAccountTpsGet() {
        return this.defaultAccountTpsGet;
    }

    public long getDefaultAccountTpsPutDel() {
        return this.defaultAccountTpsPutDel;
    }

    public long getDefaultAccountTpsGetPutDel() {
        return this.defaultAccountTpsGetPutDel;
    }

    public long getDefaultAccountTpsList() {
        return this.defaultAccountTpsList;
    }

    public long getDefaultAccountBpsGet() {
        return this.defaultAccountBpsGet;
    }

    public long getDefaultAccountBpsPut() {
        return this.defaultAccountBpsPut;
    }

    public long getDefaultAccountBpsGetPut() {
        return this.defaultAccountBpsGetPut;
    }

    public long getDefaultAccountConcurrentreq() {
        return this.defaultAccountConcurrentreq;
    }

    public boolean isDefaultAccountQosSwitch() {
        return this.defaultAccountQosSwitch;
    }

    public long getCrrQosLimitBpsGet() {
        return this.crrQosLimitBpsGet;
    }

    public long getCrrQosLimitConcurrentreq() {
        return this.crrQosLimitConcurrentreq;
    }

    public long getCrrQosLimitBpsPut() {
        return this.crrQosLimitBpsPut;
    }

    public long getCrrQosLimitTpsPutDel() {
        return this.crrQosLimitTpsPutDel;
    }

    public long getOTMQosLimitBpsGet() {
        return this.otmQosLimitBpsGet;
    }

    public long getOTMQosLimitConcurrentreq() {
        return this.otmQosLimitConcurrentreq;
    }

    public long getSMCQosLimitBpsPut() {
        return this.smcQosLimitBpsPut;
    }

    public long getSMCQosLimitConcurrentreq() {
        return this.smcQosLimitConcurrentreq;
    }

    public Properties getPriorityClassList() {
        return this.priorityClassList;
    }

    public long getQosPerConnectBps() {
        return this.qosPerConnectBps;
    }

    public long getSMCQosLimitTpsPut() {
        return this.smcQosLimitTpsPut;
    }

    public int getTierQos() {
        return this.tierQos;
    }
}

