/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.rep;

import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public final class RepConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepConfig.class);
    private static final RepConfig INSTANCE = new RepConfig();
    private static final int MAX_TAKEOVER_NUM = 24;
    private static final int NODE_MAYBE_FAULT_HBVALUE = 3;
    private int repMode;
    private int repHighAvailabilityNrwR;
    private int repHighAvailabilityNrwW;
    private int repHighReliabilityNrwR;
    private int repHighReliabilityNrwW;
    private int repLogRecordSwitch;
    private int repLogParallelNum;
    private int repLogSystemParallelNum;
    private int repLogSpecialParallelNum;
    private int repLogRepSwitchParallelNum;
    private int repLogParallelSecondHash;
    private int repEntrySize;
    private int repLogStatusMaxItem;
    private int repLogEntryMaxItem;
    private int repLogSwitchTimeoutMinute;
    private int repLogSwitchSysRepFailedMinute;
    private int repEntryMegreWriteTimeoutMs;
    private int repEntryMegreWriteQueueSize;
    private int repEntryStatusFlushThreshold;
    private int repEntryStatusFlushTimeoutS;
    private int repLogDeleteScanPeriodMinute;
    private int repSyncRepWorkQueueCapacity;
    private int repDataRecoverDefaultThreadNum;
    private int repDataRecoverMaxThreadNum;
    private int repDataRecoverWorkQueueCapacity;
    private int repDataRecoverTaskQueueCapacity;
    private int repMsgProcessDefaultThreadNum;
    private int repMsgProcessMaxThreadNum;
    private int repMsgProcessWorkQueueCapacity;
    private int repAddTaskFailMaxTryNum;
    private int repAddTaskFailSleepTimeMs;
    private int repLogStatusMaxCacheNum;
    private int repLogHeaderMaxCacheNum;
    private int repSegmentLogHeaderMaxCacheNum;
    private int repDataRecoverScanPeriodS;
    private int repDataRecoverAddQueueRetryIntervalS;
    private int repDataRecoverDispatchPeriodS;
    private int repDataRecoverScanMode;
    private int repEntryReadWriteMaxNum;
    private int repLogDeletePeriod;
    private int repLogsStorageMaxNum;
    private int highCPUUsagePercent;
    private int lowCPUUsagePercent;
    private int repCPUUsageMode;
    private int enableStatus;
    private int masternodeMaxLostCount;
    private int heartbeatMaxLostCount;
    private int interval;
    private int repAlarmScanPeriodS;
    private int repRecoverFailedThreshold;
    private int repRecoverReportAlarmThreshold;
    private int retrytime;
    private int repKeyMetadataBackupPeriod;
    private int maxNum;
    private int counterSwitch;
    private int retryTimes;
    private int repMinRetryIntervalMs;
    private int delEntryLogTimeoutMin;
    private boolean isRepBgTaskEnabled;

    private RepConfig() {
    }

    public static RepConfig getInstance() {
        return INSTANCE;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.repMode = this.getConfig().getInt("rep_mode", 0);
        this.repHighAvailabilityNrwR = this.getConfig().getInt("rep_high_availability_nrw_r", 1);
        this.repHighAvailabilityNrwW = this.getConfig().getInt("rep_high_availability_nrw_w", 1);
        this.repHighReliabilityNrwR = this.getConfig().getInt("rep_high_reliability_nrw_r", 1);
        this.repHighReliabilityNrwW = this.getConfig().getInt("rep_high_reliability_nrw_w", 2);
        this.repLogRecordSwitch = this.getConfig().getInt("rep_log_record_switch", 1);
        this.repLogParallelNum = this.getConfig().getInt("rep_log_parallel_num", 50);
        this.repLogSystemParallelNum = this.getConfig().getInt("rep_log_system_parallel_num", 576);
        this.repLogSpecialParallelNum = this.getConfig().getInt("rep_log_special_parallel_num", 64);
        this.repLogRepSwitchParallelNum = this.getConfig().getInt("rep_log_rep_switch_parallel_num", 50);
        this.repLogParallelSecondHash = this.getConfig().getInt("rep_log_parallel_second_hash", 10);
        this.repEntrySize = this.getConfig().getInt("rep_entry_size", 1500);
        this.repLogStatusMaxItem = this.getConfig().getInt("rep_log_status_max_item", 2048);
        this.repLogEntryMaxItem = this.getConfig().getInt("rep_log_entry_max_item", 2000);
        this.repLogSwitchTimeoutMinute = this.getConfig().getInt("rep_log_switch_timeout_minute", 30);
        this.repLogSwitchSysRepFailedMinute = this.getConfig().getInt("rep_log_switch_sys_rep_failed_minute", 10);
        this.repEntryMegreWriteTimeoutMs = this.getConfig().getInt("rep_entry_megre_write_timeout_ms", 2);
        this.repEntryMegreWriteQueueSize = this.getConfig().getInt("rep_entry_megre_write_queue_size", 100);
        this.repEntryStatusFlushThreshold = this.getConfig().getInt("rep_entry_status_flush_threshold", 500);
        this.repEntryStatusFlushTimeoutS = this.getConfig().getInt("rep_entry_status_flush_timeout_s", 60);
        this.repLogDeleteScanPeriodMinute = this.getConfig().getInt("rep_log_delete_scan_period_minute", 30);
        this.repSyncRepWorkQueueCapacity = this.getConfig().getInt("rep_sync_rep_work_queue_capacity", 10);
        this.repDataRecoverDefaultThreadNum = this.getConfig().getInt("rep_data_recover_default_thread_num", 20);
        this.repDataRecoverMaxThreadNum = this.getConfig().getInt("rep_data_recover_max_thread_num", 100);
        this.repDataRecoverWorkQueueCapacity = this.getConfig().getInt("rep_data_recover_work_queue_capacity", 1);
        this.repDataRecoverTaskQueueCapacity = this.getConfig().getInt("rep_data_recover_task_queue_capacity", 1000);
        this.repMsgProcessDefaultThreadNum = this.getConfig().getInt("rep_msg_process_default_thread_num", 5);
        this.repMsgProcessMaxThreadNum = this.getConfig().getInt("rep_msg_process_max_thread_num", 20);
        this.repMsgProcessWorkQueueCapacity = this.getConfig().getInt("rep_msg_process_work_queue_capacity", 100);
        this.repAddTaskFailMaxTryNum = this.getConfig().getInt("rep_add_task_fail_max_try_num", 3);
        this.repAddTaskFailSleepTimeMs = this.getConfig().getInt("rep_add_task_fail_sleep_time_ms", 100);
        this.repLogStatusMaxCacheNum = this.getConfig().getInt("rep_log_status_max_cache_num", 100);
        this.repLogHeaderMaxCacheNum = this.getConfig().getInt("rep_log_header_max_cache_num", 400);
        this.repSegmentLogHeaderMaxCacheNum = this.getConfig().getInt("rep_segment_log_header_max_cache_num", 6000);
        this.repDataRecoverScanPeriodS = this.getConfig().getInt("rep_data_recover_scan_period_s", 60);
        this.repDataRecoverAddQueueRetryIntervalS = this.getConfig().getInt("rep_data_recover_add_queue_retry_s", 10);
        this.repDataRecoverDispatchPeriodS = this.getConfig().getInt("rep_data_recover_dispatch_period_s", 10);
        this.repDataRecoverScanMode = this.getConfig().getInt("rep_data_recover_scan_mode", 0);
        this.repEntryReadWriteMaxNum = this.getConfig().getInt("rep_entry_read_write_max_num", 400);
        this.repLogDeletePeriod = this.getConfig().getInt("rep_log_delete_period", 2160);
        this.repLogsStorageMaxNum = this.getConfig().getInt("rep_logs_storage_max_num", 20000);
        this.highCPUUsagePercent = this.getConfig().getInt("high_cpu_usage_percent", 60);
        this.lowCPUUsagePercent = this.getConfig().getInt("low_cpu_usage_percent", 30);
        this.repCPUUsageMode = this.getConfig().getInt("rep_cpu_usage_mode", 0);
        this.enableStatus = this.getConfig().getInt("enable_mml_compile", 1);
        this.masternodeMaxLostCount = this.getConfig().getInt("masternode_max_lost_count", 10);
        this.heartbeatMaxLostCount = this.getConfig().getInt("heartbeat_max_lost_count", 30);
        this.interval = this.getConfig().getInt("rep_move_status_cursor_interval", 100);
        this.repAlarmScanPeriodS = this.getConfig().getInt("rep_alarm_scan_period_s", 60);
        this.repRecoverFailedThreshold = this.getConfig().getInt("rep_recover_failed_threshold", 60);
        this.repRecoverReportAlarmThreshold = this.getConfig().getInt("rep_recover_report_alarm_threshold_min", 240);
        this.retrytime = this.getConfig().getInt("rep_send_msg_retrytime", 0);
        this.repKeyMetadataBackupPeriod = this.getConfig().getInt("rep_key_metadata_backup_period_h", 12);
        this.maxNum = this.getConfig().getInt("rep_max_takeover_num", 8);
        this.counterSwitch = this.getConfig().getInt("rep_recover_counter_switch", 1);
        this.retryTimes = this.getConfig().getInt("rep_state_max_retry_times", 3);
        this.repMinRetryIntervalMs = this.getConfig().getInt("rep_min_retry_interval_ms", 20000);
        this.delEntryLogTimeoutMin = this.getConfig().getInt("rep_del_entry_log_task_timeout_min", 10);
        try {
            this.isRepBgTaskEnabled = this.getConfig().getBoolean("rep_bgtask_enable", true);
        }
        catch (Exception e) {
            LOGGER.warn("config.getBoolean(ConfPropsRep.REP_BGTASK_SWITCH) failed", (Throwable)e);
            this.isRepBgTaskEnabled = true;
        }
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getRepMode() {
        if (this.repMode != 0 && this.repMode != 1) {
            LOGGER.debug("get rep_mode illegal, use default [{}].", (Object)0);
            this.repMode = 0;
        }
        return this.repMode;
    }

    public void setRepMode(int repMode) {
        this.getConfig().setProperty("rep_mode", (Object)repMode);
        this.repMode = repMode;
    }

    public int getRepHighAvailabilityNrwR() {
        if (this.repHighAvailabilityNrwR != 1) {
            LOGGER.debug("get rep_high_availability_nrw_r illegal, use default [{}].", (Object)1);
            this.repHighAvailabilityNrwR = 1;
        }
        return this.repHighAvailabilityNrwR;
    }

    public void setRepHighAvailabilityNrwR(int repHighAvailabilityNrwR) {
        this.getConfig().setProperty("rep_high_availability_nrw_r", (Object)repHighAvailabilityNrwR);
        this.repHighAvailabilityNrwR = repHighAvailabilityNrwR;
    }

    public int getRepHighAvailabilityNrwW() {
        if (this.repHighAvailabilityNrwW != 1) {
            LOGGER.debug("get rep_high_availability_nrw_w illegal, use default [{}].", (Object)1);
            this.repHighAvailabilityNrwW = 1;
        }
        return this.repHighAvailabilityNrwW;
    }

    public void setRepHighAvailabilityNrwW(int repHighAvailabilityNrwW) {
        this.getConfig().setProperty("rep_high_availability_nrw_w", (Object)repHighAvailabilityNrwW);
        this.repHighAvailabilityNrwW = repHighAvailabilityNrwW;
    }

    public int getRepHighReliabilityNrwR() {
        if (this.repHighReliabilityNrwR != 1) {
            LOGGER.debug("get rep_high_reliability_nrw_r illegal, use default [{}].", (Object)1);
            this.repHighReliabilityNrwR = 1;
        }
        return this.repHighReliabilityNrwR;
    }

    public void setRepHighReliabilityNrwR(int repHighReliabilityNrwR) {
        this.getConfig().setProperty("rep_high_reliability_nrw_r", (Object)repHighReliabilityNrwR);
        this.repHighReliabilityNrwR = repHighReliabilityNrwR;
    }

    public int getRepHighReliabilityNrwW() {
        if (this.repHighReliabilityNrwW != 2) {
            LOGGER.debug("get rep_high_reliability_nrw_w illegal, use default [{}].", (Object)2);
            this.repHighReliabilityNrwW = 2;
        }
        return this.repHighReliabilityNrwW;
    }

    public void setRepHighReliabilityNrwW(int repHighReliabilityNrwW) {
        this.getConfig().setProperty("rep_high_reliability_nrw_w", (Object)repHighReliabilityNrwW);
        this.repHighReliabilityNrwW = repHighReliabilityNrwW;
    }

    public int getRepLogRecordSwitch() {
        if (this.repLogRecordSwitch != 0 && this.repLogRecordSwitch != 1) {
            LOGGER.debug("get rep_log_record_switch illegal, use default [{}].", (Object)1);
            this.repLogRecordSwitch = 1;
        }
        return this.repLogRecordSwitch;
    }

    public void setRepLogRecordSwitch(int repLogRecordSwitch) {
        this.getConfig().setProperty("rep_log_record_switch", (Object)repLogRecordSwitch);
        this.repLogRecordSwitch = repLogRecordSwitch;
    }

    public int getRepLogParallelNum() {
        if (this.repLogParallelNum <= 0 || this.repLogParallelNum > 512) {
            LOGGER.warn("REP:get rep_log_parallel_num <= 0 or > max [{}], use default [{}].", (Object)512, (Object)50);
            this.repLogParallelNum = 50;
        }
        return this.repLogParallelNum;
    }

    public void setRepLogParallelNum(int repLogParallelNum) {
        this.getConfig().setProperty("rep_log_parallel_num", (Object)repLogParallelNum);
        this.repLogParallelNum = repLogParallelNum;
    }

    public int getRepLogSystemParallelNum() {
        if (this.repLogSystemParallelNum <= 0 || this.repLogSystemParallelNum > 576) {
            LOGGER.warn("REP:get rep_log_system_parallel_num <= 0 or > max [{}], use default [{}].", (Object)576, (Object)50);
            this.repLogSystemParallelNum = 576;
        }
        return this.repLogSystemParallelNum;
    }

    public int getRepLogSpecialParallelNum() {
        if (this.repLogSpecialParallelNum <= 0 || this.repLogSpecialParallelNum > 64) {
            LOGGER.warn("REP:get rep_log_special_parallel_num <= 0 or > max [{}], use default [{}].", (Object)64, (Object)64);
            this.repLogSpecialParallelNum = 64;
        }
        return this.repLogSpecialParallelNum;
    }

    public int getRepLogRepSwitchParallelNum() {
        if (this.repLogRepSwitchParallelNum <= 0 || this.repLogRepSwitchParallelNum > 50) {
            LOGGER.warn("REP:get rep_log_special_parallel_num <= 0 or > max [{}], use default [{}].", (Object)50, (Object)50);
            this.repLogRepSwitchParallelNum = 50;
        }
        return this.repLogRepSwitchParallelNum;
    }

    public void setRepLogRepSwitchParallelNum(int repLogRepSwitchParallelNum) {
        this.getConfig().setProperty("rep_log_rep_switch_parallel_num", (Object)repLogRepSwitchParallelNum);
        this.repLogRepSwitchParallelNum = repLogRepSwitchParallelNum;
    }

    public int getRepLogParallelSecondHash() {
        if (this.repLogParallelSecondHash <= 0) {
            LOGGER.debug("get rep_log_parallel_second_hash <= 0, use default [{}].", (Object)10);
            this.repLogParallelSecondHash = 10;
        }
        return this.repLogParallelSecondHash;
    }

    public void setRepLogParallelSecondHash(int repLogParallelSecondHash) {
        this.getConfig().setProperty("rep_log_parallel_second_hash", (Object)repLogParallelSecondHash);
        this.repLogParallelSecondHash = repLogParallelSecondHash;
    }

    public int getRepEntrySize() {
        if (this.repEntrySize <= 0) {
            LOGGER.debug("get rep_entry_size <= 0, use default [{}].", (Object)1500);
            this.repEntrySize = 1500;
        }
        return this.repEntrySize;
    }

    public void setRepEntrySize(int repEntrySize) {
        this.getConfig().setProperty("rep_entry_size", (Object)repEntrySize);
        this.repEntrySize = repEntrySize;
    }

    public int getRepLogStatusMaxItem() {
        if (this.repLogStatusMaxItem <= 0) {
            LOGGER.debug("get rep_log_status_max_item <= 0, use default [{}].", (Object)2048);
            this.repLogStatusMaxItem = 2048;
        }
        return this.repLogStatusMaxItem;
    }

    public void setRepLogStatusMaxItem(int repLogStatusMaxItem) {
        this.getConfig().setProperty("rep_log_status_max_item", (Object)repLogStatusMaxItem);
        this.repLogStatusMaxItem = repLogStatusMaxItem;
    }

    public int getRepLogEntryMaxItem() {
        if (this.repLogEntryMaxItem <= 0 || this.repLogEntryMaxItem > 2000) {
            LOGGER.debug("get rep_log_entry_max_item is invalid.value:{}, use default [{}].", (Object)this.repLogEntryMaxItem, (Object)2000);
            this.repLogEntryMaxItem = 2000;
        }
        return this.repLogEntryMaxItem;
    }

    public void setRepLogEntryMaxItem(int repLogEntryMaxItem) {
        this.getConfig().setProperty("rep_log_entry_max_item", (Object)repLogEntryMaxItem);
        this.repLogEntryMaxItem = repLogEntryMaxItem;
    }

    public int getRepLogSwitchTimeoutMinute() {
        if (this.repLogSwitchTimeoutMinute <= 0) {
            LOGGER.debug("get rep_log_switch_timeout_minute <= 0, use default [{}].", (Object)30);
            this.repLogSwitchTimeoutMinute = 30;
        }
        return this.repLogSwitchTimeoutMinute;
    }

    public void setRepLogSwitchTimeoutMinute(int repLogSwitchTimeoutMinute) {
        this.getConfig().setProperty("rep_log_switch_timeout_minute", (Object)repLogSwitchTimeoutMinute);
        this.repLogSwitchTimeoutMinute = repLogSwitchTimeoutMinute;
    }

    public int getRepLogSwitchSysRepFailedMinute() {
        if (this.repLogSwitchSysRepFailedMinute <= 0) {
            LOGGER.debug("get rep_log_switch_sys_rep_failed_miunte <=0, use default [{}].", (Object)10);
            this.repLogSwitchSysRepFailedMinute = 10;
        }
        return this.repLogSwitchSysRepFailedMinute;
    }

    public void setRepLogSwitchSysRepFailedMinute(int repLogSwitchSysRepFailedMinute) {
        this.getConfig().setProperty("rep_log_switch_sys_rep_failed_minute", (Object)repLogSwitchSysRepFailedMinute);
        this.repLogSwitchSysRepFailedMinute = repLogSwitchSysRepFailedMinute;
    }

    public int getRepEntryMegreWriteTimeoutMs() {
        if (this.repEntryMegreWriteTimeoutMs <= 0) {
            LOGGER.debug("get rep_entry_megre_write_timeout_ms <= 0, use default [{}].", (Object)2);
            this.repEntryMegreWriteTimeoutMs = 2;
        }
        return this.repEntryMegreWriteTimeoutMs;
    }

    public void setRepEntryMegreWriteTimeoutMs(int repEntryMegreWriteTimeoutMs) {
        this.getConfig().setProperty("rep_entry_megre_write_timeout_ms", (Object)repEntryMegreWriteTimeoutMs);
        this.repEntryMegreWriteTimeoutMs = repEntryMegreWriteTimeoutMs;
    }

    public int getRepEntryMegreWriteQueueSize() {
        if (this.repEntryMegreWriteQueueSize <= 0) {
            LOGGER.debug("get rep_entry_megre_write_queue_size <= 0, use default [{}].", (Object)100);
            this.repEntryMegreWriteQueueSize = 100;
        }
        return this.repEntryMegreWriteQueueSize;
    }

    public void setRepEntryMegreWriteQueueSize(int repEntryMegreWriteQueueSize) {
        this.getConfig().setProperty("rep_entry_megre_write_queue_size", (Object)repEntryMegreWriteQueueSize);
        this.repEntryMegreWriteQueueSize = repEntryMegreWriteQueueSize;
    }

    public int getRepEntryStatusFlushThreshold() {
        if (this.repEntryStatusFlushThreshold <= 0) {
            LOGGER.debug("get rep_entry_status_flush_threshold <= 0, use default [{}].", (Object)500);
            this.repEntryStatusFlushThreshold = 500;
        }
        return this.repEntryStatusFlushThreshold;
    }

    public void setRepEntryStatusFlushThreshold(int repEntryStatusFlushThreshold) {
        this.getConfig().setProperty("rep_entry_status_flush_threshold", (Object)repEntryStatusFlushThreshold);
        this.repEntryStatusFlushThreshold = repEntryStatusFlushThreshold;
    }

    public int getRepEntryStatusFlushTimeoutS() {
        if (this.repEntryStatusFlushTimeoutS <= 0) {
            LOGGER.debug("get rep_entry_status_flush_timeout_s <= 0, use default [{}].", (Object)60);
            this.repEntryStatusFlushTimeoutS = 60;
        }
        return this.repEntryStatusFlushTimeoutS;
    }

    public void setRepEntryStatusFlushTimeoutS(int repEntryStatusFlushTimeoutS) {
        this.getConfig().setProperty("rep_entry_status_flush_timeout_s", (Object)repEntryStatusFlushTimeoutS);
        this.repEntryStatusFlushTimeoutS = repEntryStatusFlushTimeoutS;
    }

    public int getRepLogDeleteScanPeriodMinute() {
        if (this.repLogDeleteScanPeriodMinute <= 0) {
            LOGGER.debug("get rep_log_delete_scan_period_minute <= 0, use default [{}].", (Object)30);
            this.repLogDeleteScanPeriodMinute = 30;
        }
        return this.repLogDeleteScanPeriodMinute;
    }

    public void setRepLogDeleteScanPeriodMinute(int repLogDeleteScanPeriodMinute) {
        this.getConfig().setProperty("rep_log_delete_scan_period_minute", (Object)repLogDeleteScanPeriodMinute);
        this.repLogDeleteScanPeriodMinute = repLogDeleteScanPeriodMinute;
    }

    public int getRepSyncRepWorkQueueCapacity() {
        if (this.repSyncRepWorkQueueCapacity <= 0) {
            LOGGER.debug("get rep_sync_rep_work_queue_capacity <= 0, use default [{}].", (Object)10);
            this.repSyncRepWorkQueueCapacity = 10;
        }
        return this.repSyncRepWorkQueueCapacity;
    }

    public void setRepSyncRepWorkQueueCapacity(int repSyncRepWorkQueueCapacity) {
        this.getConfig().setProperty("rep_sync_rep_work_queue_capacity", (Object)repSyncRepWorkQueueCapacity);
        this.repSyncRepWorkQueueCapacity = repSyncRepWorkQueueCapacity;
    }

    public int getRepDataRecoverDefaultThreadNum() {
        if (this.repDataRecoverDefaultThreadNum <= 0) {
            LOGGER.debug("get rep_data_recover_default_thread_num <= 0, use default [{}].", (Object)20);
            this.repDataRecoverDefaultThreadNum = 20;
        }
        return this.repDataRecoverDefaultThreadNum;
    }

    public void setRepDataRecoverDefaultThreadNum(int repDataRecoverDefaultThreadNum) {
        this.getConfig().setProperty("rep_data_recover_default_thread_num", (Object)repDataRecoverDefaultThreadNum);
        this.repDataRecoverDefaultThreadNum = repDataRecoverDefaultThreadNum;
    }

    public int getRepDataRecoverMaxThreadNum() {
        if (this.repDataRecoverMaxThreadNum <= 0) {
            LOGGER.debug("get rep_data_recover_max_thread_num <= 0, use default [{}].", (Object)100);
            this.repDataRecoverMaxThreadNum = 100;
        }
        return this.repDataRecoverMaxThreadNum;
    }

    public void setRepDataRecoverMaxThreadNum(int repDataRecoverMaxThreadNum) {
        this.getConfig().setProperty("rep_data_recover_max_thread_num", (Object)repDataRecoverMaxThreadNum);
        this.repDataRecoverMaxThreadNum = repDataRecoverMaxThreadNum;
    }

    public int getRepDataRecoverWorkQueueCapacity() {
        if (this.repDataRecoverWorkQueueCapacity <= 0) {
            LOGGER.debug("get rep_data_recover_work_queue_capacity <= 0, use default [{}].", (Object)1);
            this.repDataRecoverWorkQueueCapacity = 1;
        }
        return this.repDataRecoverWorkQueueCapacity;
    }

    public void setRepDataRecoverWorkQueueCapacity(int repDataRecoverWorkQueueCapacity) {
        this.getConfig().setProperty("rep_data_recover_work_queue_capacity", (Object)repDataRecoverWorkQueueCapacity);
        this.repDataRecoverWorkQueueCapacity = repDataRecoverWorkQueueCapacity;
    }

    public int getRepDataRecoverTaskQueueCapacity() {
        if (this.repDataRecoverTaskQueueCapacity <= 0) {
            LOGGER.debug("get rep_data_recover_task_queue_capacity <= 0, use default [{}].", (Object)1000);
            this.repDataRecoverTaskQueueCapacity = 1000;
        }
        return this.repDataRecoverTaskQueueCapacity;
    }

    public void setRepDataRecoverTaskQueueCapacity(int repDataRecoverTaskQueueCapacity) {
        this.getConfig().setProperty("rep_data_recover_task_queue_capacity", (Object)repDataRecoverTaskQueueCapacity);
        this.repDataRecoverTaskQueueCapacity = repDataRecoverTaskQueueCapacity;
    }

    public int getRepMsgProcessDefaultThreadNum() {
        if (this.repMsgProcessDefaultThreadNum <= 0) {
            LOGGER.debug("get rep_msg_process_default_thread_num <= 0, use default [{}].", (Object)5);
            this.repMsgProcessDefaultThreadNum = 5;
        }
        return this.repMsgProcessDefaultThreadNum;
    }

    public void setRepMsgProcessDefaultThreadNum(int repMsgProcessDefaultThreadNum) {
        this.getConfig().setProperty("rep_msg_process_default_thread_num", (Object)repMsgProcessDefaultThreadNum);
        this.repMsgProcessDefaultThreadNum = repMsgProcessDefaultThreadNum;
    }

    public int getRepMsgProcessMaxThreadNum() {
        if (this.repMsgProcessMaxThreadNum <= 0) {
            LOGGER.debug("get rep_msg_process_max_thread_num <= 0, use default [{}].", (Object)20);
            this.repMsgProcessMaxThreadNum = 20;
        }
        return this.repMsgProcessMaxThreadNum;
    }

    public void setRepMsgProcessMaxThreadNum(int repMsgProcessMaxThreadNum) {
        this.getConfig().setProperty("rep_msg_process_max_thread_num", (Object)repMsgProcessMaxThreadNum);
        this.repMsgProcessMaxThreadNum = repMsgProcessMaxThreadNum;
    }

    public int getRepMsgProcessWorkQueueCapacity() {
        if (this.repMsgProcessWorkQueueCapacity <= 0) {
            LOGGER.debug("get rep_msg_process_work_queue_capacity <= 0, use default [{}].", (Object)100);
            this.repMsgProcessWorkQueueCapacity = 100;
        }
        return this.repMsgProcessWorkQueueCapacity;
    }

    public void setRepMsgProcessWorkQueueCapacity(int repMsgProcessWorkQueueCapacity) {
        this.getConfig().setProperty("rep_msg_process_work_queue_capacity", (Object)repMsgProcessWorkQueueCapacity);
        this.repMsgProcessWorkQueueCapacity = repMsgProcessWorkQueueCapacity;
    }

    public int getRepAddTaskFailMaxTryNum() {
        if (this.repAddTaskFailMaxTryNum <= 0) {
            LOGGER.debug("get rep_add_task_fail_max_try_num <= 0, use default [{}].", (Object)3);
            this.repAddTaskFailMaxTryNum = 3;
        }
        return this.repAddTaskFailMaxTryNum;
    }

    public void setRepAddTaskFailMaxTryNum(int repAddTaskFailMaxTryNum) {
        this.getConfig().setProperty("rep_add_task_fail_max_try_num", (Object)repAddTaskFailMaxTryNum);
        this.repAddTaskFailMaxTryNum = repAddTaskFailMaxTryNum;
    }

    public int getRepAddTaskFailSleepTimeMs() {
        if (this.repAddTaskFailSleepTimeMs <= 0) {
            LOGGER.debug("get rep_add_task_fail_sleep_time_ms <= 0, use default [{}].", (Object)100);
            this.repAddTaskFailSleepTimeMs = 100;
        }
        return this.repAddTaskFailSleepTimeMs;
    }

    public void setRepAddTaskFailSleepTimeMs(int repAddTaskFailSleepTimeMs) {
        this.getConfig().setProperty("rep_add_task_fail_sleep_time_ms", (Object)repAddTaskFailSleepTimeMs);
        this.repAddTaskFailSleepTimeMs = repAddTaskFailSleepTimeMs;
    }

    public int getRepLogStatusMaxCacheNum() {
        if (this.repLogStatusMaxCacheNum <= 0) {
            LOGGER.debug("get rep_log_status_max_cache_num <= 0, use default [{}].", (Object)100);
            this.repLogStatusMaxCacheNum = 100;
        }
        return this.repLogStatusMaxCacheNum;
    }

    public void setRepLogStatusMaxCacheNum(int repLogStatusMaxCacheNum) {
        this.getConfig().setProperty("rep_log_status_max_cache_num", (Object)repLogStatusMaxCacheNum);
        this.repLogStatusMaxCacheNum = repLogStatusMaxCacheNum;
    }

    public int getRepLogHeaderMaxCacheNum() {
        if (this.repLogHeaderMaxCacheNum <= 0) {
            LOGGER.debug("get rep_log_header_max_cache_num <= 0, use default [{}].", (Object)400);
            this.repLogHeaderMaxCacheNum = 400;
        }
        return this.repLogHeaderMaxCacheNum;
    }

    public void setRepLogHeaderMaxCacheNum(int repLogHeaderMaxCacheNum) {
        this.getConfig().setProperty("rep_log_header_max_cache_num", (Object)repLogHeaderMaxCacheNum);
        this.repLogHeaderMaxCacheNum = repLogHeaderMaxCacheNum;
    }

    public int getRepSegmentLogHeaderMaxCacheNum() {
        if (this.repSegmentLogHeaderMaxCacheNum <= 0) {
            LOGGER.debug("get rep_segment_log_header_max_cache_num <= 0, use default [{}].", (Object)6000);
            this.repSegmentLogHeaderMaxCacheNum = 6000;
        }
        return this.repSegmentLogHeaderMaxCacheNum;
    }

    public void setRepSegmentLogHeaderMaxCacheNum(int repSegmentLogHeaderMaxCacheNum) {
        this.getConfig().setProperty("rep_segment_log_header_max_cache_num", (Object)repSegmentLogHeaderMaxCacheNum);
        this.repSegmentLogHeaderMaxCacheNum = repSegmentLogHeaderMaxCacheNum;
    }

    public int getRepDataRecoverScanPeriodS() {
        if (this.repDataRecoverScanPeriodS <= 0) {
            LOGGER.debug("get rep_data_recover_scan_period_s <= 0, use default [{}].", (Object)60);
            this.repDataRecoverScanPeriodS = 60;
        }
        return this.repDataRecoverScanPeriodS;
    }

    public void setRepDataRecoverScanPeriodS(int repDataRecoverScanPeriodS) {
        this.getConfig().setProperty("rep_data_recover_scan_period_s", (Object)repDataRecoverScanPeriodS);
        this.repDataRecoverScanPeriodS = repDataRecoverScanPeriodS;
    }

    public int getRepDataRecoverAddQueueRetryIntervalS() {
        if (this.repDataRecoverAddQueueRetryIntervalS <= 0) {
            LOGGER.debug("get rep_data_recover_add_queue_retry_interval_s <= 0, use default [{}].", (Object)10);
            this.repDataRecoverAddQueueRetryIntervalS = 10;
        }
        return this.repDataRecoverAddQueueRetryIntervalS;
    }

    public void setRepDataRecoverAddQueueRetryIntervalS(int repDataRecoverAddQueueRetryIntervalS) {
        this.getConfig().setProperty("rep_data_recover_add_queue_retry_s", (Object)repDataRecoverAddQueueRetryIntervalS);
        this.repDataRecoverAddQueueRetryIntervalS = repDataRecoverAddQueueRetryIntervalS;
    }

    public int getRepDataRecoverDispatchPeriodS() {
        if (this.repDataRecoverDispatchPeriodS <= 0) {
            LOGGER.debug("get rep_data_recover_dispatch_period_s <= 0, use default [{}].", (Object)10);
            this.repDataRecoverDispatchPeriodS = 10;
        }
        return this.repDataRecoverDispatchPeriodS;
    }

    public void setRepDataRecoverDispatchPeriodS(int repDataRecoverDispatchPeriodS) {
        this.getConfig().setProperty("rep_data_recover_dispatch_period_s", (Object)repDataRecoverDispatchPeriodS);
        this.repDataRecoverDispatchPeriodS = repDataRecoverDispatchPeriodS;
    }

    public int getRepDataRecoverScanMode() {
        if (this.repDataRecoverScanMode != 0 && this.repDataRecoverScanMode != 1 && this.repDataRecoverScanMode != 2) {
            LOGGER.debug("get rep_data_recover_dispatch_mode illegal, use default [{}].", (Object)0);
            this.repDataRecoverScanMode = 0;
        }
        return this.repDataRecoverScanMode;
    }

    public void setRepDataRecoverScanMode(int repDataRecoverScanMode) {
        this.getConfig().setProperty("rep_data_recover_scan_mode", (Object)repDataRecoverScanMode);
        this.repDataRecoverScanMode = repDataRecoverScanMode;
    }

    public int getRepEntryReadWriteNumOneTime() {
        if (this.repEntryReadWriteMaxNum <= 0) {
            LOGGER.debug("get rep_data_recover_scan_period_s <= 0, use default [{}].", (Object)400);
            this.repEntryReadWriteMaxNum = 400;
        }
        return this.repEntryReadWriteMaxNum;
    }

    public void setHighCPUUsagePercent(int highCPUUsagePercent) {
        this.getConfig().setProperty("high_cpu_usage_percent", (Object)highCPUUsagePercent);
        this.highCPUUsagePercent = highCPUUsagePercent;
    }

    public int getRepLogDeletePeriod() {
        if (this.repLogDeletePeriod <= 0) {
            LOGGER.debug("get rep_log_delete_period <= 0, use default [{}].", (Object)2160);
            this.repLogDeletePeriod = 2160;
        }
        return this.repLogDeletePeriod;
    }

    public void setRepLogDeletePeriod(int repLogDeletePeriod) {
        this.getConfig().setProperty("rep_log_delete_period", (Object)repLogDeletePeriod);
        this.repLogDeletePeriod = repLogDeletePeriod;
    }

    public int getRepLogsStorageMaxNum() {
        if (this.repLogsStorageMaxNum <= 0) {
            LOGGER.debug("get rep_logs_storage_max_num <= 0, use default [{}].", (Object)20000);
            this.repLogsStorageMaxNum = 20000;
        }
        return this.repLogsStorageMaxNum;
    }

    public void setRepLogsStorageMaxNum(int repLogsStorageMaxNum) {
        this.getConfig().setProperty("rep_logs_storage_max_num", (Object)repLogsStorageMaxNum);
        this.repLogsStorageMaxNum = repLogsStorageMaxNum;
    }

    public int getHighCPUUsagePercent() {
        if (this.highCPUUsagePercent < 0 || this.highCPUUsagePercent > 100) {
            LOGGER.debug("get high cpu usage percent illegal, use default [{}].", (Object)60);
            this.highCPUUsagePercent = 60;
        }
        return this.highCPUUsagePercent;
    }

    public void setLowCPUUsagePercent(int lowCPUUsagePercent) {
        this.getConfig().setProperty("low_cpu_usage_percent", (Object)lowCPUUsagePercent);
        this.lowCPUUsagePercent = lowCPUUsagePercent;
    }

    public int getLowCPUUsagePercent() {
        if (this.lowCPUUsagePercent < 0 || this.lowCPUUsagePercent > 100) {
            LOGGER.debug("get low cpu usage percent illegal, use default [{}].", (Object)30);
            this.lowCPUUsagePercent = 30;
        }
        return this.lowCPUUsagePercent;
    }

    public int getRepCPUUsageMode() {
        if (this.repCPUUsageMode < 0 || this.repCPUUsageMode > 1) {
            LOGGER.debug("get rep cpu usage mode illegal, use default [{}].", (Object)0);
            this.repCPUUsageMode = 0;
        }
        return this.repCPUUsageMode;
    }

    public void setRepCPUUsageMode(int repCPUUsageMode) {
        this.getConfig().setProperty("rep_cpu_usage_mode", (Object)repCPUUsageMode);
        this.repCPUUsageMode = repCPUUsageMode;
    }

    public int getEnableMmlCompile() {
        if (this.enableStatus != 0 && this.enableStatus != 1) {
            LOGGER.debug("get enable_mml_compile illegal, use default [{}].", (Object)1);
            this.enableStatus = 1;
        }
        return this.enableStatus;
    }

    public void setMasternodeMaxLostCount(int maxLostCount) {
        this.getConfig().setProperty("masternode_max_lost_count", (Object)maxLostCount);
        this.masternodeMaxLostCount = maxLostCount;
    }

    public int getMasternodeMaxLostCount() {
        if (this.masternodeMaxLostCount <= 0) {
            LOGGER.debug("get masternode_max_lost_count illegal, use default [{}].", (Object)10);
            this.masternodeMaxLostCount = 10;
        }
        return this.masternodeMaxLostCount;
    }

    public void setHeartbeatMaxLostCount(int maxLostCount) {
        this.getConfig().setProperty("heartbeat_max_lost_count", (Object)maxLostCount);
        this.heartbeatMaxLostCount = maxLostCount;
    }

    public int getHeartbeatMaxLostCount() {
        if (this.heartbeatMaxLostCount <= 3) {
            LOGGER.warn("get heartbeat_max_lost_count illegal, use default [{}].", (Object)30);
            this.heartbeatMaxLostCount = 30;
        }
        return this.heartbeatMaxLostCount;
    }

    public int getRepMoveStatusCursorInterval() {
        if (this.interval <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.interval;
    }

    public int getRepAlarmScanPeriodS() {
        if (this.repAlarmScanPeriodS <= 0) {
            LOGGER.debug("get rep_replica_mode_scan_period_s <= 0, use default [{}].", (Object)60);
            this.repAlarmScanPeriodS = 60;
        }
        return this.repAlarmScanPeriodS;
    }

    public void setRepAlarmScanPeriodS(int repAlarmScanPeriodS) {
        this.getConfig().setProperty("rep_alarm_scan_period_s", (Object)repAlarmScanPeriodS);
        this.repAlarmScanPeriodS = repAlarmScanPeriodS;
    }

    public int getRepRecoverFailedThreshold() {
        if (this.repRecoverFailedThreshold <= 0) {
            LOGGER.debug("get rep_recover_failed_threshold <= 0, use default [{}].", (Object)60);
            this.repRecoverFailedThreshold = 60;
        }
        return this.repRecoverFailedThreshold;
    }

    public void setRepRecoverFailedThreshold(int repRecoverFailedThreshold) {
        this.getConfig().setProperty("rep_recover_failed_threshold", (Object)repRecoverFailedThreshold);
        this.repRecoverFailedThreshold = repRecoverFailedThreshold;
    }

    public int getRepRecoverReportAlarmThreshold() {
        if (this.repRecoverReportAlarmThreshold <= 0) {
            LOGGER.debug("get rep_recover_report_alarm_threshold_min <= 0, use default [{}].", (Object)240);
            this.repRecoverReportAlarmThreshold = 240;
        }
        return this.repRecoverReportAlarmThreshold;
    }

    public void setRepRecoverReportAlarmThreshold(int repRecoverReportAlarmThreshold) {
        this.getConfig().setProperty("rep_recover_report_alarm_threshold_min", (Object)repRecoverReportAlarmThreshold);
        this.repRecoverReportAlarmThreshold = repRecoverReportAlarmThreshold;
    }

    public void setRepSendMsgRetrytime(int retrytime) {
        this.getConfig().setProperty("rep_send_msg_retrytime", (Object)retrytime);
        this.retrytime = retrytime;
    }

    public int getRepSendMsgRetrytime() {
        if (this.retrytime < 0) {
            LOGGER.debug("get rep_send_msg_retrytime illegal, use default [{}].", (Object)0);
            this.retrytime = 0;
        }
        return this.retrytime;
    }

    public int getRepKeyMetadataBackupPeriod() {
        if (this.repKeyMetadataBackupPeriod <= 0) {
            LOGGER.debug("get rep_key_metadata_backup_period_h <= 0, use default [{}].", (Object)12);
            this.repKeyMetadataBackupPeriod = 12;
        }
        return this.repKeyMetadataBackupPeriod;
    }

    public void setRepKeyMetadataBackupPeriod(int repKeyMetadataBackupPeriod) {
        this.getConfig().setProperty("rep_add_task_fail_max_try_num", (Object)repKeyMetadataBackupPeriod);
        this.repKeyMetadataBackupPeriod = repKeyMetadataBackupPeriod;
    }

    public void setRepMaxTakeoverNum(int maxNum) {
        this.getConfig().setProperty("rep_max_takeover_num", (Object)maxNum);
        this.maxNum = maxNum;
    }

    public int getRepMaxTakeoverNum() {
        if (this.maxNum <= 0 || this.maxNum > 24) {
            LOGGER.debug("get rep_max_takeover_num illegal value:{}, use default [{}].", (Object)this.maxNum, (Object)8);
            this.maxNum = 8;
        }
        return this.maxNum;
    }

    public int getRepRecoverCounterSwitch() {
        if (this.counterSwitch != 0 && this.counterSwitch != 1) {
            LOGGER.debug("get rep_recover_counter_switch illegal value:{}, use default [{}].", (Object)this.counterSwitch, (Object)1);
            this.counterSwitch = 1;
        }
        return this.counterSwitch;
    }

    public void setRepStateMaxRetryTimes(int retryTimes) {
        this.getConfig().setProperty("rep_state_max_retry_times", (Object)retryTimes);
        this.retryTimes = retryTimes;
    }

    public int getRepStateMaxRetryTimes() {
        if (this.retryTimes < 0) {
            LOGGER.debug("get rep_state_max_retry_times illegal value:{}, use default [{}].", (Object)this.retryTimes, (Object)3);
            this.retryTimes = 3;
        }
        return this.retryTimes;
    }

    public void setRepMinRetryIntervalMs(int minTime) {
        this.getConfig().setProperty("rep_min_retry_interval_ms", (Object)minTime);
        this.repMinRetryIntervalMs = minTime;
    }

    public int getRepMinRetryIntervalMs() {
        if (this.repMinRetryIntervalMs < 0) {
            LOGGER.debug("get rep_min_retry_interval_ms illegal value:{}, use default [{}].", (Object)this.repMinRetryIntervalMs, (Object)20000);
            this.repMinRetryIntervalMs = 20000;
        }
        return this.repMinRetryIntervalMs;
    }

    public int getDelEntryLogTimeoutMin() {
        if (this.delEntryLogTimeoutMin < 0) {
            LOGGER.debug("get rep_del_entry_log_timeout_ms illegal value:{}, use default [{}].", (Object)this.delEntryLogTimeoutMin, (Object)10);
            this.delEntryLogTimeoutMin = 10;
        }
        return this.delEntryLogTimeoutMin;
    }

    public boolean isRepBgTaskEnabled() {
        return this.isRepBgTaskEnabled;
    }

    public void setRepBgTaskEnabled(boolean status) {
        this.getConfig().setProperty("rep_bgtask_enable", (Object)status);
        this.isRepBgTaskEnabled = status;
    }
}

