/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.role;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.role.RolesContainer;

public class RoleConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoleConfig.class);
    private RolesContainer roles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String filename) {
        File file = new File(filename);
        FileReader fr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String content;
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            while (null != (content = br.readLine())) {
                sb.append(content);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception occur when parse file!", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    LOGGER.error("Exception occur when Close BufferedReader!", (Throwable)e);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Exception e) {
                    LOGGER.error("Exception occur when Close FileReader!", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    public RolesContainer loadRolePolicy(String file) throws ConfigurationException {
        String content = this.readFile(file);
        if (StringUtils.isBlank((CharSequence)content)) {
            LOGGER.error("Load configuration failed.");
            throw new ConfigurationException("Load policy.json configuration failed.");
        }
        this.roles = new RolesContainer();
        this.roles.initRoles(content);
        LOGGER.debug("Load \"policy.json\" file end.");
        return this.roles;
    }

    public RolesContainer getRolesPolicy() {
        return this.roles;
    }
}

