/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.role;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolesContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolesContainer.class);
    private static final String ALLOW_FILEDS = "Allow";
    private static final String DENY_FILEDS = "Deny";
    private static final String ARREARS_FILEDS = "Arrears";
    private Map<String, List<String>> actionAllowedRoles = new HashMap<String, List<String>>();
    private Map<String, List<String>> actionDeniedRoles = new HashMap<String, List<String>>();
    private Map<String, List<String>> actionArrearsRoles = new HashMap<String, List<String>>();

    public void initRoles(String configString) throws ConfigurationException {
        JSONObject jo = this.parseConfiguration(configString);
        if (jo == null) {
            LOGGER.error("Parse configuration failed.");
            throw new ConfigurationException("Parse configuration to json object failed.");
        }
        this.initActionRolesContainer(jo);
    }

    private JSONObject parseConfiguration(String configString) {
        String noBlank = configString.replaceAll("\\s*", "");
        JSONObject joPolicy = null;
        try {
            joPolicy = JSON.parseObject((String)noBlank);
        }
        catch (Exception e) {
            LOGGER.error("Exception occur when parse json!", (Throwable)e);
            return null;
        }
        return joPolicy;
    }

    private void initActionRolesContainer(JSONObject joPolicy) {
        int j;
        ArrayList<String> valueRoles;
        JSONArray jaRoles;
        JSONObject allowedJo = joPolicy.getJSONObject(ALLOW_FILEDS);
        JSONObject deniedJo = joPolicy.getJSONObject(DENY_FILEDS);
        JSONObject arrearsJo = joPolicy.getJSONObject(ARREARS_FILEDS);
        Set keyActionNames = allowedJo.keySet();
        for (String keyActionName : keyActionNames) {
            jaRoles = allowedJo.getJSONArray(keyActionName);
            valueRoles = new ArrayList<String>();
            for (j = 0; j < jaRoles.size(); ++j) {
                valueRoles.add(jaRoles.getString(j));
            }
            this.actionAllowedRoles.put(keyActionName, valueRoles);
        }
        keyActionNames = deniedJo.keySet();
        for (String keyActionName : keyActionNames) {
            jaRoles = deniedJo.getJSONArray(keyActionName);
            valueRoles = new ArrayList();
            for (j = 0; j < jaRoles.size(); ++j) {
                valueRoles.add(jaRoles.getString(j));
            }
            this.actionDeniedRoles.put(keyActionName, valueRoles);
        }
        keyActionNames = arrearsJo.keySet();
        for (String keyActionName : keyActionNames) {
            jaRoles = arrearsJo.getJSONArray(keyActionName);
            valueRoles = new ArrayList();
            for (j = 0; j < jaRoles.size(); ++j) {
                valueRoles.add(jaRoles.getString(j));
            }
            this.actionArrearsRoles.put(keyActionName, valueRoles);
        }
    }

    public Map<String, List<String>> getActionAllowedRoles() {
        return this.actionAllowedRoles;
    }

    public Map<String, List<String>> getActionDeniedRoles() {
        return this.actionDeniedRoles;
    }

    public Map<String, List<String>> getActionArrearsRoles() {
        return this.actionArrearsRoles;
    }
}

