/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.smc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.index.KVConfig;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class MigratingConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(MigratingConfig.class);
    private static MigratingConfig instance = new MigratingConfig();
    private long smcOscMonitorCycle;
    private long smcNodeAsyncMonitorCycle;
    private int smcMigratingCreateTimeout;
    private int smcMaxObjectNum;
    private int smcMigratingUpdateTimeout;
    private boolean smcMockForward;
    private boolean smcMockAllForward;
    private boolean smcMockDeleteFailed;
    private boolean smcMockChkFailed;
    private boolean smcMockIO;
    private long ioHangTime;
    private boolean routeSwitch;
    private int migrateBucketTaskNum;
    private int migrateObjectTaskNum;
    private boolean qos;
    private int corePoolSize;
    private int maxPoolSize;
    private long keepAliveTime;
    private int queueSize;
    private int getObjectPoolSize;
    private int getObjectQueueSize;
    private int flushRepairTaskCorePoolSize;
    private int flushRepairTaskMaxPoolSize;
    private int smcMigratePoolSize;
    private int smcMigrateQueueSize;
    private int smcMockMigrateFailType;
    private boolean silenceMigrateEnable;
    private boolean specifyFieldsByRawApi;
    private boolean tryReadRemote;
    private boolean mockForceReadRemote;
    private long listTimeOut;
    private int smcDecryptionPoolSize;
    private int smcDecryptionMaxPoolSize;
    private int smcReadDataPoolSize;
    private int smcReadDataMaxPoolSize;
    private int smcReadPartDataPoolSize;
    private int smcReadPartDataMaxPoolSize;
    private boolean smcAsyncDecryptData;
    private int maxListCount;
    private boolean smclifecycleCheck;
    private boolean checkOSCHealth;

    private MigratingConfig() {
    }

    public boolean isSmclifecycleCheck() {
        return this.smclifecycleCheck;
    }

    public boolean isCheckOSCHealth() {
        return this.checkOSCHealth;
    }

    public static MigratingConfig getInstance() {
        return instance;
    }

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.smcOscMonitorCycle = this.getConfig().getLong("smc_osc_monitor_cycle", 15L);
        this.smcNodeAsyncMonitorCycle = this.getConfig().getLong("smc_node_async_monitor_cycle", 3L);
        this.smcMigratingCreateTimeout = this.getConfig().getInt("smc_migrating_create_timeout", 2);
        this.smcMigratingUpdateTimeout = this.getConfig().getInt("smc_migrating_update_timeout", 60000);
        this.smcMaxObjectNum = this.getConfig().getInt("smc_max_object_num", 300);
        this.smcMockForward = this.getConfig().getBoolean("smc_mock_forward", false);
        this.smcMockAllForward = this.getConfig().getBoolean("smc_mock_all_forward", false);
        this.smcMockDeleteFailed = this.getConfig().getBoolean("smc_mock_delete_failed", false);
        this.smcMockChkFailed = this.getConfig().getBoolean("smc_mock_chk_failed", false);
        this.smcMockIO = this.getConfig().getBoolean("smc_mock_io", false);
        this.ioHangTime = this.getConfig().getLong("smc_mock_io_hang_time", 0L);
        this.routeSwitch = this.getConfig().getBoolean("route_switch", false);
        this.migrateBucketTaskNum = this.getConfig().getInt("smc_max_bucket_task_num", 20);
        this.migrateObjectTaskNum = this.getConfig().getInt("smc_max_object_task_num", 100);
        this.corePoolSize = this.getConfig().getInt("smc_core_thread_size", 10);
        this.maxPoolSize = this.getConfig().getInt("smc_max_thread_size", 30);
        this.keepAliveTime = this.getConfig().getLong("smc_keey_alive_time", 1000L);
        this.queueSize = this.getConfig().getInt("smc_queue_size", 100);
        this.getObjectPoolSize = this.getConfig().getInt("smc_get_object_pool_size", 100);
        this.getObjectQueueSize = this.getConfig().getInt("smc_get_object_queue_size", 10000);
        this.flushRepairTaskCorePoolSize = this.getConfig().getInt("smc_flush_repair_task_pool_size", 3);
        this.flushRepairTaskMaxPoolSize = this.getConfig().getInt("smc_flush_repair_task_max_pool_size", 20);
        this.smcMigratePoolSize = this.getConfig().getInt("smc_migrate_pool_size", 200);
        this.smcMigrateQueueSize = this.getConfig().getInt("smc_migrate_queue_size", 10);
        this.smcMockMigrateFailType = this.getConfig().getInt("smc_mock_migrate_time_out", 0);
        this.specifyFieldsByRawApi = this.getConfig().getBoolean("specify_fields_by_raw_api", true);
        this.mockForceReadRemote = this.getConfig().getBoolean("smc_mock_force_read_remote", false);
        this.silenceMigrateEnable = this.getConfig().getBoolean("smc_enable", true);
        this.tryReadRemote = this.getConfig().getBoolean("smc_try_read_remote", false);
        this.listTimeOut = this.getConfig().getLong("smc_list_time_out", 1800000L);
        this.maxListCount = this.getConfig().getInt("smc_list_count", 20);
        this.smcDecryptionPoolSize = this.getConfig().getInt("smc_decryption_pool_size", 10);
        this.smcDecryptionMaxPoolSize = this.getConfig().getInt("smc_decryption_max_pool_size", 100);
        this.smcReadDataPoolSize = this.getConfig().getInt("smc_read_data_pool_size", 50);
        this.smcReadDataMaxPoolSize = this.getConfig().getInt("smc_read_data_max_pool_size", 100);
        this.smcReadPartDataPoolSize = this.getConfig().getInt("smc_read_part_data_pool_size", 50);
        this.smcReadPartDataMaxPoolSize = this.getConfig().getInt("smc_read_part_data_max_pool_size", 100);
        this.smcAsyncDecryptData = this.getConfig().getBoolean("smc_async_decrypt_data", false);
        this.qos = this.getConfig().getBoolean("smc_check_qos", true);
        this.smclifecycleCheck = this.getConfig().getBoolean("smc_lifecycle_check", false);
        this.checkOSCHealth = this.getConfig().getBoolean("smc_check_osc_healthy", true);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public long getSmcOscMonitorCycle() {
        return this.smcOscMonitorCycle;
    }

    public long getSmcNodeAsyncMonitorCycle() {
        return this.smcNodeAsyncMonitorCycle;
    }

    public int getSmcMigratingCreateTimeout() {
        return this.smcMigratingCreateTimeout;
    }

    public int getSmcMigratingUpdateTimeout() {
        return this.smcMigratingUpdateTimeout;
    }

    public int getSmcMaxObjectNum() {
        return this.smcMaxObjectNum;
    }

    public boolean isSmcMockForward() {
        return this.smcMockForward;
    }

    public boolean isSmcMockAllForward() {
        return this.smcMockAllForward;
    }

    public boolean isSmcMockDeleteFailed() {
        return this.smcMockDeleteFailed;
    }

    public boolean isSmcMockChkFailed() {
        return this.smcMockChkFailed;
    }

    public boolean isSmcMockIO() {
        return this.smcMockIO;
    }

    public long getIOHangTime() {
        return this.ioHangTime;
    }

    public boolean isRouteSwitch() {
        return this.routeSwitch;
    }

    public int getMigrateBucketTaskNum() {
        return this.migrateBucketTaskNum;
    }

    public int getMigrateObjectTaskNum() {
        return this.migrateObjectTaskNum;
    }

    public boolean checkQos() {
        return this.qos;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getSmcGetObjectPoolSize() {
        return this.getObjectPoolSize;
    }

    public int getSmcGetObjectQueueSize() {
        return this.getObjectQueueSize;
    }

    public int getFlushRepairTaskCorePoolSize() {
        return this.flushRepairTaskCorePoolSize;
    }

    public int getFlushRepairTaskMaxPoolSize() {
        return this.flushRepairTaskMaxPoolSize;
    }

    public int getSmcMigratePoolSize() {
        return this.smcMigratePoolSize;
    }

    public int getSmcMigrateQueueSize() {
        return this.smcMigrateQueueSize;
    }

    public int getSmcMockMigrateFailType() {
        return this.smcMockMigrateFailType;
    }

    public boolean isSilenceMigrateEnable() {
        return this.silenceMigrateEnable;
    }

    public boolean isTryReadRemote() {
        return this.tryReadRemote;
    }

    public boolean isSpecifyFieldsByRawApi() {
        return this.specifyFieldsByRawApi;
    }

    public boolean isMockForceReadRemote() {
        return this.mockForceReadRemote;
    }

    public long getListTimeOut() {
        return this.listTimeOut;
    }

    public int getMaxListCount() {
        return this.maxListCount;
    }

    public boolean shouldUseHttp() {
        return KVConfig.INSTANCE.getBoolValue("smc_use_http", true);
    }

    public int getDecryptionPoolSize() {
        return this.smcDecryptionPoolSize;
    }

    public int getDecryptionMaxPoolSize() {
        return this.smcDecryptionMaxPoolSize;
    }

    public int getReadDataPoolSize() {
        return this.smcReadDataPoolSize;
    }

    public int getReadDataMaxPoolSize() {
        return this.smcReadDataMaxPoolSize;
    }

    public int getReadPartDataPoolSize() {
        return this.smcReadPartDataPoolSize;
    }

    public int getReadPartDataMaxPoolSize() {
        return this.smcReadPartDataMaxPoolSize;
    }

    public boolean isAsyncDecryptData() {
        return this.smcAsyncDecryptData;
    }
}

