/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.snasini;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;
import uds.common.config.sysconf.SystemFilePath;

public class SnasConfig {
    private static final Logger logger = LoggerFactory.getLogger(SnasConfig.class);
    private static final String POE_BUSINESS_FLOAT_IP = "poe_business_float_ip";
    private static final String POE_BUSINESS_FLOAT_IP_V6 = "poe_business_float_ip_v6";
    private static SnasConfig instance = new SnasConfig();
    private PropertiesConfigBuilder configBuilder;
    private boolean isInit = false;

    public static synchronized SnasConfig getInstance() {
        instance.init();
        return instance;
    }

    public void init() {
        if (this.isInit) {
            return;
        }
        this.configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(SystemFilePath.CONFIG_FILE_NAME, null);
        this.isInit = true;
    }

    public String getPoeBusinessFloatIP() {
        try {
            return this.configBuilder.getConfiguration().getString(POE_BUSINESS_FLOAT_IP, "");
        }
        catch (Exception e) {
            logger.error("Get poe business float ip of v4 failed [{}]", (Throwable)e);
            return "";
        }
    }

    public String getPoeBusinessFloatIPWithV6() {
        try {
            return this.configBuilder.getConfiguration().getString(POE_BUSINESS_FLOAT_IP_V6, "");
        }
        catch (Exception e) {
            logger.error("Get poe business float ip of v6 failed [{}]", (Throwable)e);
            return "";
        }
    }
}

