/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.sodclient;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.sysconf.SystemFilePath;

public class SodClientConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(SodClientConfig.class);
    private static final String SOD_MOCK = SystemFilePath.ROOT_DIR + File.separator + "sod.mock";
    private boolean useSodMock;
    private String sodMockRootPath;
    private int buffersPerWrite;
    private int sodSocketTimeout;
    private int sodRoutingTimeout;
    private int sodConnectionTimeout;
    private int sodSocketBufferSize;
    private String sodRequestFormat;
    private int sodApplicationBufferSize;
    private int sodNettyBufferSize;
    private Map<String, Properties> sodStoreMap;
    private int storeReadOnlyLevel;
    private int storDiskpoolCapCacheTime;
    private int storFirstReadSize;
    private boolean isSodPerfOpenPa;
    private int storeRetryBaseTime;
    private int storeRetryCount;
    private long storeMaxRetryWait;
    private int storeECRetryCount;
    private int oscSodRequestMaxRetryLimit;
    private int oscSodRequestRetryIntervalMs;
    private int oscSodClient322Port;
    private int oscSodClient111Port;
    private int oscSodNettyMaxBufferCount;
    private int oscSodNettyWriteBufferLowWater;
    private int oscSodNettyWriteBufferHighWater;
    private int oscSodNettySendBufferSize;
    private int oscSodNettyReceiveBufferSize;
    private int oisSodRequestMaxRetryLimit;
    private int oisSodRequestRetryIntervalMs;
    private int oisSodClient322Port;
    private int oisSodClient111Port;
    private int oisSodNettyMaxBufferCount;
    private int oisSodNettyWriteBufferLowWater;
    private int oisSodNettyWriteBufferHighWater;
    private int oisSodNettySendBufferSize;
    private int oisSodNettyReceiveBufferSize;

    public void loadConfig(PropertiesConfigBuilder configBuilder) {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        if (this.getConfig() == null) {
            return;
        }
        this.loadSodClientMockConfig(this.getConfig());
        this.loadSodClientBasicConfig(this.getConfig());
        this.loadSodClientRetryConfig(this.getConfig());
        this.loadOscSodConfig(this.getConfig());
        this.loadOisSodConfig(this.getConfig());
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    private void loadSodClientMockConfig(PropertiesConfiguration config) {
        this.useSodMock = config.getBoolean("use.sod.mock", false);
        this.sodMockRootPath = config.getString("sod.mock.root.path", SOD_MOCK);
    }

    private void loadSodClientBasicConfig(PropertiesConfiguration config) {
        String[] sodStoreType;
        this.buffersPerWrite = config.getInt("osp_uploadChunkingBuffersPerWrite", 2);
        this.sodSocketTimeout = config.getInt("sod_socket_timeout", 10000);
        this.sodRoutingTimeout = config.getInt("sod_routing_timeout", 15000);
        this.sodConnectionTimeout = config.getInt("sod_connection_timeout", 5000);
        this.sodSocketBufferSize = config.getInt("sod_socket_buffer_size", 65535);
        this.sodRequestFormat = config.getString("sod_request_format", "pb0");
        this.sodApplicationBufferSize = config.getInt("sod_application_buffer_size", 0x102000);
        this.sodNettyBufferSize = config.getInt("sod_netty_buffer_size", 65536);
        this.sodStoreMap = new TreeMap<String, Properties>();
        for (String type : sodStoreType = config.getStringArray("SoD_Store")) {
            Properties store = config.getProperties(type);
            this.sodStoreMap.put(type, store);
            logger.debug("type: {} ,store: {}", (Object)type, (Object)store);
        }
    }

    private void loadSodClientRetryConfig(PropertiesConfiguration config) {
        this.storeRetryBaseTime = config.getInt("store_retryBaseTime", 10);
        this.storeRetryCount = config.getInt("store_retryCount", 5);
        this.storeECRetryCount = config.getInt("store_ecRetryCount", 10);
        this.storeMaxRetryWait = config.getLong("store_maxRetryWait", 10000L);
        this.storeReadOnlyLevel = config.getInt("store_readonlyLevel", 100);
        this.storDiskpoolCapCacheTime = config.getInt("store_diskpoolCapCacheTime", 60000);
        this.storFirstReadSize = config.getInt("sodFirstReadSize", 32768);
        this.isSodPerfOpenPa = config.getBoolean("isSodPerfOpen", false);
    }

    private void loadOscSodConfig(PropertiesConfiguration config) {
        this.oscSodRequestMaxRetryLimit = config.getInt("osc_sod_request_max_retry_limit", 3);
        this.oscSodRequestRetryIntervalMs = config.getInt("osc_sod_request_retry_interval_ms", 1000);
        this.oscSodClient322Port = config.getInt("osc_sod_client322_port", 6071);
        this.oscSodClient111Port = config.getInt("osc_sod_client111_port", 6072);
        this.oscSodNettyMaxBufferCount = config.getInt("osc_sod_netty_max_buffer_count", 32000);
        this.oscSodNettyWriteBufferLowWater = config.getInt("osc_sod_netty_write_buffer_lowwater", 0x500000);
        this.oscSodNettyWriteBufferHighWater = config.getInt("osc_sod_netty_write_buffer_highwater", 0xA00000);
        this.oscSodNettySendBufferSize = config.getInt("osc_sod_netty_send_buffer_size", 262144);
        this.oscSodNettyReceiveBufferSize = config.getInt("osc_sod_netty_receive_buffer_size", 65536);
    }

    private void loadOisSodConfig(PropertiesConfiguration config) {
        this.oisSodRequestMaxRetryLimit = config.getInt("ois_sod_request_max_retry_limit", 3);
        this.oisSodRequestRetryIntervalMs = config.getInt("ois_sod_request_retry_interval_ms", 1000);
        this.oisSodClient322Port = config.getInt("ois_sod_client322_port", 6081);
        this.oisSodClient111Port = config.getInt("ois_sod_client111_port", 6082);
        this.oisSodNettyMaxBufferCount = config.getInt("ois_sod_netty_max_buffer_count", 100);
        this.oisSodNettyWriteBufferLowWater = config.getInt("ois_sod_netty_write_buffer_lowwater", 0x500000);
        this.oisSodNettyWriteBufferHighWater = config.getInt("ois_sod_netty_write_buffer_highwater", 0xA00000);
        this.oisSodNettySendBufferSize = config.getInt("ois_sod_netty_send_buffer_size", 262144);
        this.oisSodNettyReceiveBufferSize = config.getInt("ois_sod_netty_receive_buffer_size", 65536);
    }

    public boolean isUseSodMock() {
        return this.useSodMock;
    }

    public void setUseSodMock(boolean useSodMock) {
        this.useSodMock = useSodMock;
    }

    public String getSodMockRootPath() {
        return this.sodMockRootPath;
    }

    public void setSodMockRootPath(String sodMockRootPath) {
        this.sodMockRootPath = sodMockRootPath;
    }

    public int getBuffersPerWrite() {
        return this.buffersPerWrite;
    }

    public void setBuffersPerWrite(int buffersPerWrite) {
        this.buffersPerWrite = buffersPerWrite;
    }

    public int getSodSocketTimeout() {
        return this.sodSocketTimeout;
    }

    public void setSodSocketTimeout(int sodSocketTimeout) {
        this.sodSocketTimeout = sodSocketTimeout;
    }

    public int getSodRoutingTimeout() {
        return this.sodRoutingTimeout;
    }

    public void setSodRoutingTimeout(int sodRoutingTimeout) {
        this.sodRoutingTimeout = sodRoutingTimeout;
    }

    public int getSodConnectionTimeout() {
        return this.sodConnectionTimeout;
    }

    public void setSodConnectionTimeout(int sodConnectionTimeout) {
        this.sodConnectionTimeout = sodConnectionTimeout;
    }

    public int getSodSocketBufferSize() {
        return this.sodSocketBufferSize;
    }

    public void setSodSocketBufferSize(int sodSocketBufferSize) {
        this.sodSocketBufferSize = sodSocketBufferSize;
    }

    public String getSodRequestFormat() {
        return this.sodRequestFormat;
    }

    public void setSodRequestFormat(String sodRequestFormat) {
        this.sodRequestFormat = sodRequestFormat;
    }

    public int getSodApplicationBufferSize() {
        return this.sodApplicationBufferSize;
    }

    public void setSodApplicationBufferSize(int sodApplicationBufferSize) {
        this.sodApplicationBufferSize = sodApplicationBufferSize;
    }

    public Map<String, Properties> getSodStoreMap() {
        return this.sodStoreMap;
    }

    public void setSodStoreMap(Map<String, Properties> sodStoreMap) {
        this.sodStoreMap = sodStoreMap;
    }

    public int getStoreRetryBaseTime() {
        return this.storeRetryBaseTime;
    }

    public void setStoreRetryBaseTime(int storeRetryBaseTime) {
        this.storeRetryBaseTime = storeRetryBaseTime;
    }

    public int getStoreRetryCount() {
        return this.storeRetryCount;
    }

    public void setStoreRetryCount(int storeRetryCount) {
        this.storeRetryCount = storeRetryCount;
    }

    public int getStoreECRetryCount() {
        return this.storeECRetryCount;
    }

    public void setStoreECRetryCount(int storeECRetryCount) {
        this.storeECRetryCount = storeECRetryCount;
    }

    public long getStoreMaxRetryWait() {
        return this.storeMaxRetryWait;
    }

    public void setStoreMaxRetryWait(long storeMaxRetryWait) {
        this.storeMaxRetryWait = storeMaxRetryWait;
    }

    public int getStoreReadOnlyLevel() {
        return this.storeReadOnlyLevel;
    }

    public void setStoreReadOnlyLevel(int storeReadOnlyLevel) {
        this.storeReadOnlyLevel = storeReadOnlyLevel;
    }

    public int getDiskpoolCapCacheTime() {
        return this.storDiskpoolCapCacheTime;
    }

    public void setDiskpoolCapCacheTime(int cacheTime) {
        this.storDiskpoolCapCacheTime = cacheTime;
    }

    public int getSodFirstReadSize() {
        return this.storFirstReadSize;
    }

    public void setSodFirstReadSize(int firstReadSize) {
        this.storFirstReadSize = firstReadSize;
    }

    public boolean isSodPerfOpen() {
        return this.isSodPerfOpenPa;
    }

    public void setSodPerfOpen(boolean flag) {
        this.isSodPerfOpenPa = flag;
    }

    public int getSodNettyBufferSize() {
        return this.sodNettyBufferSize;
    }

    public void setSodNettyBufferSize(int sodNettyBufferSize) {
        this.sodNettyBufferSize = sodNettyBufferSize;
    }

    public int getOscSodRequestMaxRetryLimit() {
        return this.oscSodRequestMaxRetryLimit;
    }

    public void setOscSodRequestMaxRetryLimit(int oscSodRequestMaxRetryLimit) {
        this.oscSodRequestMaxRetryLimit = oscSodRequestMaxRetryLimit;
    }

    public int getOscSodRequestRetryIntervalMs() {
        return this.oscSodRequestRetryIntervalMs;
    }

    public void setOscSodRequestRetryIntervalMs(int oscSodRequestRetryIntervalMs) {
        this.oscSodRequestRetryIntervalMs = oscSodRequestRetryIntervalMs;
    }

    public int getOscSodClient322Port() {
        return this.oscSodClient322Port;
    }

    public void setOscSodClient322Port(int oscSodClient322Port) {
        this.oscSodClient322Port = oscSodClient322Port;
    }

    public int getOscSodClient111Port() {
        return this.oscSodClient111Port;
    }

    public void setOscSodClient111Port(int oscSodClient111Port) {
        this.oscSodClient111Port = oscSodClient111Port;
    }

    public int getOscSodNettyMaxBufferCount() {
        return this.oscSodNettyMaxBufferCount;
    }

    public void setOscSodNettyMaxBufferCount(int oscSodNettyMaxBufferCount) {
        this.oscSodNettyMaxBufferCount = oscSodNettyMaxBufferCount;
    }

    public int getOscSodNettyWriteBufferLowWater() {
        return this.oscSodNettyWriteBufferLowWater;
    }

    public void setOscSodNettyWriteBufferLowWater(int oscSodNettyWriteBufferLowWater) {
        this.oscSodNettyWriteBufferLowWater = oscSodNettyWriteBufferLowWater;
    }

    public int getOscSodNettyWriteBufferHighWater() {
        return this.oscSodNettyWriteBufferHighWater;
    }

    public void setOscSodNettyWriteBufferHighWater(int oscSodNettyWriteBufferHighWater) {
        this.oscSodNettyWriteBufferHighWater = oscSodNettyWriteBufferHighWater;
    }

    public int getOscSodNettySendBufferSize() {
        return this.oscSodNettySendBufferSize;
    }

    public void setOscSodNettySendBufferSize(int oscSodNettySendBufferSize) {
        this.oscSodNettySendBufferSize = oscSodNettySendBufferSize;
    }

    public int getOscSodNettyReceiveBufferSize() {
        return this.oscSodNettyReceiveBufferSize;
    }

    public void setOscSodNettyReceiveBufferSize(int oscSodNettyReceiveBufferSize) {
        this.oscSodNettyReceiveBufferSize = oscSodNettyReceiveBufferSize;
    }

    public int getOisSodRequestMaxRetryLimit() {
        return this.oisSodRequestMaxRetryLimit;
    }

    public void setOisSodRequestMaxRetryLimit(int oisSodRequestMaxRetryLimit) {
        this.oisSodRequestMaxRetryLimit = oisSodRequestMaxRetryLimit;
    }

    public int getOisSodRequestRetryIntervalMs() {
        return this.oisSodRequestRetryIntervalMs;
    }

    public void setOisSodRequestRetryIntervalMs(int oisSodRequestRetryIntervalMs) {
        this.oisSodRequestRetryIntervalMs = oisSodRequestRetryIntervalMs;
    }

    public int getOisSodClient322Port() {
        return this.oisSodClient322Port;
    }

    public void setOisSodClient322Port(int oisSodClient322Port) {
        this.oisSodClient322Port = oisSodClient322Port;
    }

    public int getOisSodClient111Port() {
        return this.oisSodClient111Port;
    }

    public void setOisSodClient111Port(int oisSodClient111Port) {
        this.oisSodClient111Port = oisSodClient111Port;
    }

    public int getOisSodNettyMaxBufferCount() {
        return this.oisSodNettyMaxBufferCount;
    }

    public void setOisSodNettyMaxBufferCount(int oisSodNettyMaxBufferCount) {
        this.oisSodNettyMaxBufferCount = oisSodNettyMaxBufferCount;
    }

    public int getOisSodNettyWriteBufferLowWater() {
        return this.oisSodNettyWriteBufferLowWater;
    }

    public void setOisSodNettyWriteBufferLowWater(int oisSodNettyWriteBufferLowWater) {
        this.oisSodNettyWriteBufferLowWater = oisSodNettyWriteBufferLowWater;
    }

    public int getOisSodNettyWriteBufferHighWater() {
        return this.oisSodNettyWriteBufferHighWater;
    }

    public void setOisSodNettyWriteBufferHighWater(int oisSodNettyWriteBufferHighWater) {
        this.oisSodNettyWriteBufferHighWater = oisSodNettyWriteBufferHighWater;
    }

    public int getOisSodNettySendBufferSize() {
        return this.oisSodNettySendBufferSize;
    }

    public void setOisSodNettySendBufferSize(int oisSodNettySendBufferSize) {
        this.oisSodNettySendBufferSize = oisSodNettySendBufferSize;
    }

    public int getOisSodNettyReceiveBufferSize() {
        return this.oisSodNettyReceiveBufferSize;
    }

    public void setOisSodNettyReceiveBufferSize(int oisSodNettyReceiveBufferSize) {
        this.oisSodNettyReceiveBufferSize = oisSodNettyReceiveBufferSize;
    }
}

