/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.sysconf;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetWorkInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetWorkInformation.class);
    public static final int MAX_MAC_LEN = 8;
    private List<NetWorkCard> networkCards = NetWorkInformation.generateNetworkInformation();

    private NetWorkInformation() {
    }

    public static NetWorkInformation getInstance() {
        return NetWorkInformationHolder.INSTANCE;
    }

    public List<NetWorkCard> getNetWorkCardsInfo() {
        return Collections.unmodifiableList(this.networkCards);
    }

    private static List<NetWorkCard> generateNetworkInformation() {
        ArrayList<NetWorkCard> netWorkCardList = new ArrayList<NetWorkCard>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface ni = interfaces.nextElement();
                    if (ni.isLoopback()) continue;
                    String name = ni.getName();
                    byte[] macAddress = ni.getHardwareAddress();
                    List<byte[]> ipAddresses = NetWorkInformation.getAllIPv4Addresses(ni.getInetAddresses());
                    if (name == null || macAddress == null) continue;
                    netWorkCardList.add(new NetWorkCard(name, macAddress, ipAddresses));
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("NetWorkInformation.generateNetworkInformation, SocketException:", (Throwable)e);
        }
        return netWorkCardList;
    }

    private static List<byte[]> getAllIPv4Addresses(Enumeration<InetAddress> addresses) {
        ArrayList<byte[]> ipAddresses = new ArrayList<byte[]>();
        while (addresses.hasMoreElements()) {
            InetAddress addr = addresses.nextElement();
            if (!(addr instanceof Inet4Address)) continue;
            ipAddresses.add(addr.getAddress());
        }
        return ipAddresses;
    }

    public String getMac() {
        StringBuilder mac = new StringBuilder(DigestUtils.md5Hex((byte[])NetWorkInformation.getInstance().getNetWorkCardsInfo().get(0).getMacAddress()));
        if (mac.length() > 8) {
            return mac.substring(0, 8);
        }
        if (mac.length() < 8) {
            for (int i = 8 - mac.length(); i > 0; --i) {
                mac.insert(0, "0");
            }
        }
        return mac.toString();
    }

    private static class NetWorkInformationHolder {
        private static final NetWorkInformation INSTANCE = new NetWorkInformation();

        private NetWorkInformationHolder() {
        }
    }

    public static class NetWorkCard {
        private String name;
        private byte[] macAddress;
        private List<byte[]> ipAddresses;

        public NetWorkCard(String name, byte[] macAddress, List<byte[]> ipAddresses) {
            this.name = name;
            this.macAddress = macAddress;
            this.ipAddresses = ipAddresses;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getMacAddress() {
            return this.macAddress;
        }

        public List<byte[]> getIpAddresses() {
            return Collections.unmodifiableList(this.ipAddresses);
        }

        public String toString() {
            StringBuilder strBuf = new StringBuilder();
            strBuf.append("name: " + this.name + "\n");
            strBuf.append("mac : ");
            for (byte index : this.macAddress) {
                strBuf.append(String.format(Locale.ROOT, "%02X", index) + ":");
            }
            strBuf.append("\n");
            strBuf.append("ip addresses :\n");
            Object object = this.ipAddresses.iterator();
            while (object.hasNext()) {
                byte[] bytes = (byte[])object.next();
                strBuf.append("\t");
                for (int n : bytes) {
                    int value = n >= 0 ? n : n - -128 - -128;
                    strBuf.append(value);
                    strBuf.append(".");
                }
                strBuf.append("\n");
            }
            return strBuf.toString();
        }
    }
}

