/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.sysconf;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import uds.common.config.interf.OBSConfig;

public final class UUIDGenerator {
    public static final int BASE_UUID_FIX_LENGTH = 32;
    public static final int UPLOAD_ID_LEN = 32;
    public static final int UUID_LENGTH = 32;
    public static final int META_INFO_TOTAL_LENGTH_WIDTH = 6;
    private static AtomicInteger increment = new AtomicInteger(0);
    private static ThreadLocalRandom randGen = ThreadLocalRandom.current();
    private static ThreadLocalRandom shortRandGen = ThreadLocalRandom.current();

    private UUIDGenerator() {
    }

    private static int getRamdomInt() {
        return randGen.nextInt();
    }

    public static String getUUID() {
        short nodeId = (short)OBSConfig.getInstance().getNodeId();
        short myValue = (short)increment.incrementAndGet();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(System.currentTimeMillis());
        buffer.putShort(nodeId);
        buffer.putShort(myValue);
        buffer.putInt(UUIDGenerator.getRamdomInt());
        return Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static String getUUIDByTime(long time) {
        short nodeId = (short)OBSConfig.getInstance().getNodeId();
        short myValue = (short)increment.incrementAndGet();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(time);
        buffer.putShort(nodeId);
        buffer.putShort(myValue);
        buffer.putInt(UUIDGenerator.getRamdomInt());
        return Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static String getKVUUID() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putShort((short)randGen.nextInt());
        buffer.putShort((short)System.currentTimeMillis());
        return Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static String generatorUUID() {
        short nodeId = (short)OBSConfig.getInstance().getNodeId();
        short myValue = (short)increment.incrementAndGet();
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putInt(shortRandGen.nextInt(1, 100));
        buffer.putLong(System.currentTimeMillis());
        buffer.putShort(nodeId);
        buffer.putShort(myValue);
        return Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static Long getTimeStampFromUUID(String uuid) {
        if (uuid == null || uuid.length() != 32) {
            return null;
        }
        return Long.parseLong(uuid.substring(0, 16), 16);
    }

    public static String getRequestUUID() {
        return UUIDGenerator.getUUID();
    }

    public static String getMongoIdPrefix(long logicTime, short nodeId, long sliceId) {
        int prefixLen = sliceId == -1L ? 2 : 10;
        ByteBuffer buffer = ByteBuffer.allocate(prefixLen);
        buffer.putShort(nodeId);
        if (prefixLen == 10) {
            buffer.putLong(sliceId);
        }
        return UUIDGenerator.generateLogicTimePrefix(logicTime) + Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static String generateLogicTimePrefix(long logicTime) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(logicTime);
        return Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
    }

    public static String getMongoId(long logicTime, short nodeId) {
        return UUIDGenerator.getMongoIdPrefix(logicTime, nodeId, -1L) + UUIDGenerator.getUUID();
    }

    public static String getBaseUUID(String uuid) {
        if (uuid == null || uuid.length() <= 32) {
            return uuid;
        }
        return uuid.substring(uuid.length() - 32);
    }

    public static String getUUID(String bucketName, String objectName) {
        return UUIDGenerator.getUUID(bucketName, "null", objectName);
    }

    public static String getUUID(String bucketName, String objectVersionId, String objectName) {
        return UUIDGenerator.genMetaPrefix(bucketName, objectVersionId, objectName) + UUIDGenerator.getUUID();
    }

    public static String genMetaPrefix(String bucketName, String objectVersionId, String objectName) {
        if (StringUtils.isEmpty((CharSequence)bucketName) || StringUtils.isEmpty((CharSequence)objectVersionId) || StringUtils.isEmpty((CharSequence)objectName)) {
            throw new IllegalArgumentException("bucketName, objectVersionId and objectName can not be null");
        }
        String temp = String.format(Locale.ROOT, "%04d%s%04d%s%s", bucketName.length(), bucketName, objectVersionId.length(), objectVersionId, objectName);
        return String.format(Locale.ROOT, "#%06d", temp.length() + 6 + 1) + temp;
    }

    public static String getJobID(int status) {
        short myValue = (short)increment.incrementAndGet();
        ByteBuffer buffer = ByteBuffer.allocate(14);
        buffer.putLong(System.currentTimeMillis());
        buffer.putShort(myValue);
        buffer.putInt(UUIDGenerator.getRamdomInt());
        String id = Hex.encodeHexString((byte[])buffer.array()).toUpperCase(Locale.US);
        return "OBS" + status + id;
    }

    public static String getPlogDeleteKeyLSN(long logicTime) {
        return UUIDGenerator.generateLogicTimePrefix(logicTime) + UUIDGenerator.getUUID().toUpperCase(Locale.US);
    }
}

