/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.system;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.DefaultConf;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.sysconf.SystemFilePath;
import uds.common.config.system.DefaultConfSystem;
import uds.core.util.BucketType;
import uds.core.util.DiskPoolInfo;

public class SystemConfig
extends AbstractConfigPraser {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfig.class);
    private int chunkSize;
    private int maxSize4SmallIoRead;
    private int coldChunkSize;
    private int partECGroupTime;
    private int sodDataVersion;
    private int instanceId;
    private String messageQueueIp;
    private String proxyServiceIps;
    private String omdNodeId;
    private String omdNodeIP;
    private String poeFloatIP;
    private boolean checkPoeFloatIP;
    private String oscBussinessIp;
    private List<String> fsOscIpList;
    private long fsServerCacheMemMB;
    private long fsClientMetaCacheMemMB;
    private long fsMaxTruncLenGB;
    private long fsMaxCacheSeconds;
    private long fsMaxReadSize;
    private long fsDelayPrintThreshold;
    private long fsStatPrintInterval;
    private long fsStatCountPrintThreshold;
    private String oamUNodeIP;
    private int ecAlgorithm;
    private boolean trafficCtontrolOpen;
    private int maxCpuUsage;
    private int cpuLow;
    private int maxSleepTime;
    private int maxUploadMbps;
    private int maxSleepStepBase;
    private int balanceSleepTimeWrite;
    private int balanceSleepTimeRead;
    private String oscAuthVersion;
    private boolean needCalcPlainText;
    private boolean needCheckDownloadMd5;
    private boolean accessLsByHttps = true;
    private int clusterBucketThreads;
    private int listS3ReqPoolMaxSize;
    private int listMaxSize4LsAndPoe;
    private int clusterPerThreadHandleUsers;
    private long clusterCacheExpireTime;
    private int clusterPerUserTime;
    private String[] billList;
    private int kmcAlgorithmId;
    private int kmcCryptoDomainId;
    private boolean adldapUserPolicyEnable;
    private int logicClockClientUpdateValue;
    private String zookeeperHostPort;
    private String kmcPrimaryKeyPath;
    private String kmcStandbyKeyPath;
    private String kmcLogPath;
    private int clusterAbility;
    private String clusterId;
    private boolean isOptionsJudged;
    private long monitorStatisticInterval;
    private boolean isMdcHTTPS;
    private boolean isOscPassiveWriteOpen;
    private boolean isForceCreateOpen;
    private boolean isInternalPort;
    private String objchkInspectTimeunit;
    private long objchkInspectInterval;
    private long objectWalkingCycleTime;
    private String objectWalkingCycleTimeUnit;
    private long afterOneCycleObjectWalkerSleepInSeconds;
    private long objectWalkerMonitorReadStatusIntervalInSeconds;
    private long deletedUserDataCleanTaskDelayTime;
    private long deleteBucketDataTaskDelayTime;
    private boolean isOisTaskEnable;
    private long thresholdTimeForDelete;
    private long thresholdTimeForNotifyDelete;
    private boolean notifyBSSByBucket;
    private boolean isCheckAuthTimeOpen;
    private boolean isSwitchOfPerfStat;
    private boolean isRemoteReplication;
    private boolean isRepSwitchSlaveDeleteUpload;
    private boolean isRepSwitchSlaveDeleteObject;
    private boolean isRepSwitchSlaveCopyObject;
    private int oisObjectCheckerPoolSize;
    private int oisOCCPoolSize;
    private boolean isSlaveDcTakeOverSwitchOpen;
    private long checkObjectLifeCycleTaskPeriod;
    private long checkObjectLifeCycleTimeout;
    private long repairClusterDgFlagTaskPeriod;
    private long repairBucketIndexTaskPeriod;
    private long cleanBucketIndexTaskPeriod;
    private int scanIndexRecordDelayLogicTime;
    private long repSwitchNormalKeepTime;
    private long repairDegradeReadyBucketTaskPeriod;
    private int repairDegradeReadyBucketRunningNum;
    private int buildBucketLocationTaskPeriod;
    private long buildBucketLocationTaskExpried;
    private int buildBucketLocationThreadNum;
    private int repairOldObjRepLogTaskPeriod;
    private long repairOldObjRepLogTaskExpried;
    private int repairOldObjRepLogThreadNum;
    private long repairOldObjRepLogTaskExpriedCreaten;
    private int repairBucketOldObjRepLogThreadNum;
    private long repairBucketOldObjRepLogTaskToleranceTime;
    private int obsQueueRegionManageTaskNum;
    private long checkObjectLifeCycleBucketTaskTimeout;
    private long checkAllObjectLifeCycleBucketTaskInternal;
    private long localCacheLsExpireTime;
    private long controlIOSizeBandwidth;
    private boolean isCrossDomianEnable;
    private boolean isSwiftSwitch;
    private long lastChunkSkipTimeout;
    private int parallelFactor;
    private int scanBucket2DeleteTaskPriority;
    private int bucketDeleteTaskPriority;
    private long scanBucket2DelPeriod;
    private long alarmCheckerPeriod;
    private String poeServiceEndpoint;
    private boolean isAllowDeleteWhenUserInactive;
    private int monitorLogicClockZkConfPeriod;
    private int monitorLogicClockStatusPeriod;
    private int loggicClockUpdatePeriodThreshold;
    private int zkMsBetweenRetry;
    private long fixMetaClock;
    private boolean bucketUsageCacheSwitch;
    private boolean fsBucketUsageSwitch;
    private int fsBucketUsageBatchFlushCount;
    private int fsBucketUsagePreStopOscWaitCount;
    private boolean isFsBucketUsageValidCheck;
    private int fsSwitchCacheThreadPeriod;
    private int fsDeleteObjChunkThreadNum;
    private int fsDeleteObjChunkQueCapacity;
    private int getFsDeleteObjChunkIntervalClock;
    private int fsDeleteObjChunkPeriod;
    private int fsDeleteObjChunkAllowOverTime;
    private boolean isFsBUDeltaCheckEnable;
    private double fsBUDeltaValidRatio;
    private int requestTimedTaskPeriodS;
    private int requestTimeoutS;
    private int requestInfoRemoveTimeS;
    private long calRegionStatisTaskPeriod;
    private long monitorAzQosTaskPeriod;
    private String supportAPI;
    private String defaultAPI;
    private boolean obsPathSwitch;
    private List<String> obsLVSIPList;
    private List<String> obsWhiteList;
    private boolean cloudMonitorSwitch;
    private long statisticsLogCollectInterval;
    private long checkObjectExpirationTaskPeriod;
    private long checkObjectExpirationTaskTimeout;
    private String dyeTrack;
    private String shortConnectionsBuckets;
    private String shortConnectionsUsers;
    private boolean isCloseLongConnection;
    private int asyncBucketUsageUpdateThread;
    private int enterpriseUsageMode;
    private boolean buSummaryList;
    private int kVConfigScanInterval;
    private int kVConfigScanInitDelay;
    private int smnMaxSleepTime;
    private int tenantStoreCacheInterval;
    private int tenantStoreCacheDelay;
    private boolean isInternationalAccessGlobalOpen;
    private boolean isMainlandAccessGlobalOpen;
    private boolean dedupswitch;
    private boolean enterpriseVersionIdUpgrade;
    private int importDataMaxThreadCount;
    private int importDataCountPerThread;
    private boolean enterpriseMode;
    private boolean readWriteThreadPoolIsolationSwitch;
    private int plogPerfType;
    private String swiftResellerPrefix;
    private String swiftServiceType;
    private String swiftTempURLMethods;
    private String swiftIncomingRemoveHeaders;
    private String swiftIncomingAllowHeaders;
    private boolean isListObjectV2;
    private boolean enterpriseOccCheck;
    private boolean enterpriseAlarmSwitch;
    private boolean listMultiPartTaskWithMultiIndex;
    private boolean enterprise3azOpen;
    private int dataplusForwardConnectionTimeOut;
    private int dataplusForwardSocketTimeOut;
    private int dataplusAccessMethodMaxLength;
    private boolean needAuthProxyByOSC;
    private int cacheLowCapacity;
    private int cacheHighCapacity;
    private int partEcScanThreadNum;
    private boolean multiversionSupport;
    private boolean isRestrictedStatusClose;
    private boolean repair330benable;
    private int repairAndMarkMultiPartPeriod;
    private int multiPartThreadNumber;
    private int secretKeyScannerThreadNumber;
    private int multiPartQueueNumber;
    private boolean realNameAuthMasterSwitch;
    private boolean realNameAuthStagetwoSwitch;
    private boolean realNameAuthStageoneSwitch;
    private int buIdleTime;
    private int oisIdleTime;
    private String internalIp;
    private String ccdbLocalIp;
    private long loadCMViewInterval;
    private long loadDHTViewInterval;
    private long fsHeartBeatInterval;
    private boolean mockZkLoadDHTViewFailed;
    private boolean mockSupportFs;
    private boolean enableMonitorPlogOperate;
    private boolean isReadObjectCacheOpen;
    private boolean isTrimSlashOpen;
    private boolean isHttpClientNormalizeSwitchOpen;
    private boolean isPathTransferVirtualHost;
    private boolean isAllowDirReceive1ByteData;
    private boolean isAddMD5PrefixToObjectName;
    private String serviceType;
    private boolean dataPilotServiceOpen;
    private int fsDefragmentMaxTreemapMoveLimit;
    private boolean fsDefragmentEnable;
    private boolean getFsDefragmentMd5CheckEnable;
    private boolean fsDefragmentConflictCountClear;
    private boolean fsDefragmentMd5CheckStatisticsClear;
    private boolean fsDefragmentEcCutLocationStatisticsClear;
    private boolean fsDefragmentCutPlogTypeStatisticsClear;
    private long fsDefragmentMaxLayoutPerRangeThreshold;
    private double fsDefragmentDatasizePerRangeThreshold;
    private double fsDefragmentPieceLevel;
    private long fsDefragmentRangesize;
    private long fsDefragmentCacheMemThreshold;
    private long fsDefragmentCacheAverMem;
    private double fsDefragmentSysPriorityThreshold;
    private int fsDefragmentMaptoqCycle;
    private boolean fsDefragmentObjectLayout;
    private long fsDefragmentMaxLayoutPerLogicClock;
    private int fsMultiPartMovedThreadNumber;
    private int fsCleanTaskRecordPeriod;
    private boolean fsChunkMarkDelEnable;
    private boolean fsMultipartMoveStatisticsClear;
    private int wormClockClientUpdatePeriod;
    private int wormClockServerUpdatePeriod;
    private int wormClockClientExpiredThreshold;
    private int wormClockClientUpdateThreshold;
    private long wormPolicyConfirmMaxTime;
    private long blockKeyUpdateInterval;
    private long blockKeyLifetime;
    private long blockKeyScanInterval;
    private long delegationKeyUpdateInterval;
    private long tokenMaxLifetime;
    private long tokenRenewInterval;
    private long syncDataTimeoutInMicros;
    private boolean internalReqAddFTDSDelay;
    private boolean obsSupportFtdsBelowHigh;
    private boolean sealDowngradePlogOpen;
    private long scheduleTotalAccountUsageInterval;
    private long auScanCacheMonitorInterval;
    private long buUpdateStorageInterval;
    private long auScanMaxAddInterval;
    private boolean bucketUsageCheckSwitch;
    private String gcDynamicScanMetaDelLogicTime;
    private String gcDynamicHddPlogDelaySinceLastModifyTime;
    private String gcDynamicHddPlogTaskDelayTimeParams;
    private String gcDynamicPlogUsage;
    private int gcDynamicCPUBusyCore;
    private int gcDynamicPlogTime;
    private String gcDynamicGcQosTPS;
    private String gcDynamicRatioThreshold;
    private boolean gcDynamicSwitch;
    private String gcDynamicGcQosBPS;
    private String oamsIpList;
    private String oamiIpList;
    private String oampIpList;
    private String oamuIpList;
    private String oamgsIpList;
    private boolean dns3azSwitchOpen;
    private boolean supportBucketUnderLine;
    private boolean supportBucketNameWithNas;
    private String kmsIpList;
    private String clusterSn;
    private String ctrlIp;
    private String localIp;
    private long secretKeyUpdateInterval;
    private boolean softEncryptOn;
    private long poeLsid;
    private long lsid;
    private long cmrCmLsid;
    private int cmrCmPort;
    private long ebsServerLsid;
    private int ebsServerPort;
    private String nsGlobalIpList;
    private Boolean oldDataInMongo;
    private long ccdbLsid;
    private long mrfsTestRpcLinkFlag;
    private int mrfsRouterHandlerDirectBufferSize;
    private int asyECDelayHour;
    private long repRetryTime;
    private int repRetryCount;
    private int maxFullPathLength;
    private int maxKeyLengthInPath;
    private boolean interworking;
    private boolean supportPartition;
    private int sysPartitionNum;
    private String bucketName;
    private String bucketID;
    private String canonicalID;
    private String diskPoolInfo;
    private Map<Integer, DiskPoolInfo> diskPoolMap;
    private long partMetaRepairSpan;
    private boolean supportOrigBucket;
    private boolean metaSearchSwitch;
    private int maxMetaIndexKeyNumber;
    private String poolType;
    private boolean objectEnable;
    private boolean hdfsEnable;
    private boolean accountCheckVersionEnable;
    private boolean nasEnable;
    private String defaultBucketType;
    private boolean md5Enable;
    private boolean needImportAccounts;
    private int edsFlushSize;
    private String contentTypeDefaultValue;
    private boolean isDeleteAccountAsync;
    private boolean mobileSwitch;
    private String mobileInnerClientIpList;
    private long mobileStatisticInterval;
    private long maxInitializingTime4Repair;
    private long maxInitializedTime4Repair;
    private long checkInitUploadIdInterval;
    private long delEmptyObjDirInterval4Repair;
    private String zkAuthUserName;
    private String zkAuthPassWord;
    private int maxMultiPartObjFullPathLength;
    private long checkUploadFailedInterval;
    private boolean isNeedForwardSwitch;
    private boolean isClusterAutoSwitch;
    private int clusterAutoSwitchTime;
    private int flowControl;
    private boolean isSupportCircularDeleteDir;
    private boolean isForceDeleteDir;
    private boolean isCheckCompressMetadataSize;
    private volatile boolean isOscHttpSwitch;
    private String rbfNodeList;
    private String memAlarmThreshold;
    private String tierStorageClass;
    private int maxRegionNumber;
    private int tierVendor;
    private int pocLevel;
    private boolean isFtdsStatOn = true;
    private int tierMaxSegSize;
    private long cpuMonitorPeriod;
    private boolean isRangerPolicySaveToLocalFile;
    private long rangerPolicyTotalSize;

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() throws ConfigurationException {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            logger.warn("config is null.");
            return;
        }
        this.sodDataVersion = config.getInt("sod_dataVersion", 1);
        this.instanceId = config.getInt("obs_instanceId", 1);
        this.chunkSize = config.getInt("objectdata_chunkSize", 524288);
        this.maxSize4SmallIoRead = config.getInt("max_size_4_small_io_read", 131072);
        this.coldChunkSize = config.getInt("objectdata_cold_chunkSize", 524288);
        this.partECGroupTime = config.getInt("gc_partec_group_time", 60);
        this.clusterBucketThreads = config.getInt("cluster_calculate_thread_num", 20);
        this.listS3ReqPoolMaxSize = config.getInt("list_thread_num", 50);
        this.listMaxSize4LsAndPoe = config.getInt("list_thread_num_ls_poe", 10);
        this.supportBucketNameWithNas = config.getBoolean("supportBucketWithNas", true);
        this.kmsIpList = config.getString("kms_ip_list", "");
        this.clusterSn = config.getString("g_cluster_sn", "");
        this.ctrlIp = config.getString("ctrl_ip");
        this.localIp = config.getString("local_ip");
        this.secretKeyUpdateInterval = config.getLong("secretKeyUpdateInterval", 86400000L);
        this.softEncryptOn = config.getBoolean("soft_encrypt_switch", false);
        this.clusterPerThreadHandleUsers = config.getInt("cluster_per_thread_handle_user_num", 1000);
        this.clusterCacheExpireTime = config.getLong("cluster_cache_expire_time", 3600000L);
        this.clusterPerUserTime = config.getInt("cluster_per_user_time", 50);
        this.kmcAlgorithmId = config.getInt("kmc_algorithm_id", 5);
        this.kmcCryptoDomainId = config.getInt("kmc_crypto_domain_id", 101);
        this.logicClockClientUpdateValue = config.getInt("logic_clock_client_update_value", 6);
        this.zookeeperHostPort = config.getString("zookeeper_host_port", "127.0.0.1:2181");
        this.kmcPrimaryKeyPath = config.getString("kmc_primary_key_path", DefaultConfSystem.DEFAULT_KMC_PRIMARY_KEY_PATH);
        this.kmcStandbyKeyPath = config.getString("kmc_standby_key_path", DefaultConfSystem.DEFAULT_KMC_STANDBY_KEY_PATH);
        this.kmcLogPath = config.getString("kmc_log_path", "/var/log/s3/servicelog/%s/obs.%s.kmc.log");
        if (this.kmcLogPath.contains("%s")) {
            this.kmcLogPath = this.kmcLogPath.replace("%s", this.getModuleName(SystemFilePath.ROOT_DIR));
        }
        this.supportAPI = config.getString("support_API", "S3");
        this.defaultAPI = this.supportAPI.contains("S3") ? "S3" : "OBS";
        this.obsPathSwitch = config.getBoolean("OBS_path_switch", false);
        String obsLVSIP = config.getString("lvsip", "");
        this.obsLVSIPList = new ArrayList<String>(Arrays.asList(obsLVSIP.split(",")));
        this.cloudMonitorSwitch = config.getBoolean("cloud_monitor_switch", false);
        this.statisticsLogCollectInterval = config.getLong("statistics_collect_interval", 60L);
        String obsWhiteListString = config.getString("OBS_white_list", "");
        this.obsWhiteList = new ArrayList<String>(Arrays.asList(obsWhiteListString.split(",")));
        String fsOscIpListString = config.getString("fs_osc_ip_list", "");
        if (!fsOscIpListString.isEmpty()) {
            this.fsOscIpList = new ArrayList<String>(Arrays.asList(fsOscIpListString.split(",")));
        }
        this.internalIp = config.getString("fs_local_internal_ip", "");
        this.ccdbLocalIp = config.getString("ccdb_local_ip", "");
        this.loadCMViewInterval = config.getLong("fs_load_cm_view_interval", 10L);
        this.loadDHTViewInterval = config.getLong("fs_load_dht_view_interval", 10L);
        this.fsHeartBeatInterval = config.getLong("fs_heart_beat_interval", 1L);
        this.mockZkLoadDHTViewFailed = config.getBoolean("fs_mock_load_dht_view_failed", false);
        this.mockSupportFs = config.getBoolean("fs_mock_support_fs", false);
        this.enableMonitorPlogOperate = config.getBoolean("fs_enable_plog_operate_count", true);
        this.fsMultiPartMovedThreadNumber = config.getInt("fs_multi_part_moved_thread_number", 20);
        this.fsCleanTaskRecordPeriod = config.getInt("fs_clean_task_record_period", 3600);
        this.fsServerCacheMemMB = config.getLong("fs_server_cache_mem_mb", 800L);
        this.fsMaxTruncLenGB = config.getLong("fs_max_trunc_len_gb", 150L);
        this.fsMaxReadSize = config.getLong("fs_max_read_size", 0x8000000L);
        this.fsDelayPrintThreshold = config.getLong("fs_delay_print_threshold", 1000L);
        this.fsStatPrintInterval = config.getLong("fs_stat_print_interval", 180L);
        this.fsStatCountPrintThreshold = config.getLong("fs_stat_count_print_threshold", 10000L);
        this.fsClientMetaCacheMemMB = config.getLong("fs_clientmeta_cache_mem_mb", 200L);
        this.fsMaxCacheSeconds = config.getLong("fs_max_cache_seconds", 28800L);
        this.fsChunkMarkDelEnable = config.getBoolean("fs_chunk_mark_del_enable", true);
        this.fsDefragmentMaxTreemapMoveLimit = config.getInt("fs_defragment_max_tree_map_move_limit", 200);
        this.fsDefragmentEnable = config.getBoolean("fs_defragment_enable", false);
        this.getFsDefragmentMd5CheckEnable = config.getBoolean("fs_defragment_md5_check_enable", true);
        this.fsDefragmentConflictCountClear = config.getBoolean("fs_defragment_conflict_count_clear", true);
        this.fsDefragmentMd5CheckStatisticsClear = config.getBoolean("fs_defragment_md5_check_statistics_clear", true);
        this.fsDefragmentEcCutLocationStatisticsClear = config.getBoolean("fs_defragment_ec_cut_location_statistics_clear", true);
        this.fsDefragmentCutPlogTypeStatisticsClear = config.getBoolean("fs_defragment_cut_plogtype_statistics_clear", true);
        this.fsDefragmentMaxLayoutPerRangeThreshold = config.getLong("fs_defragment_max_layout_per_range_threshold", 15L);
        this.fsDefragmentDatasizePerRangeThreshold = config.getDouble("fs_defragment_datasize_per_range_threshold", 2.5);
        this.fsDefragmentPieceLevel = config.getDouble("fs_defragment_piece_level", 2.0);
        this.fsDefragmentRangesize = config.getLong("fs_defragment_rangesize", 0x600000L);
        this.fsDefragmentCacheMemThreshold = config.getLong("fs_defragment_cache_mem_threshold", 0x19000000L);
        this.fsDefragmentCacheAverMem = config.getLong("fs_defragment_cache_average_mem", 200L);
        this.fsDefragmentMaxLayoutPerLogicClock = config.getLong("fs_defragment_max_layout_per_logic_clock", 1000L);
        this.fsDefragmentSysPriorityThreshold = config.getDouble("fs_defragment_sys_priority_threshold", 20.0);
        this.fsDefragmentMaptoqCycle = config.getInt("fs_defragment_maptoq_cycle", 200);
        this.fsDefragmentObjectLayout = config.getBoolean("fs_defragment_object_layout", false);
        this.fsMultipartMoveStatisticsClear = config.getBoolean("fs_multipart_move_statistics_clear", true);
        this.dyeTrack = config.getString("dye_track", "");
        this.clusterAbility = config.getInt("cluster_ability", 0);
        this.clusterId = config.getString("cluster_id", "");
        this.bucketUsageCacheSwitch = config.getBoolean("bucket_usage_cache_switch", false);
        this.fsBucketUsageSwitch = config.getBoolean("fs_bucket_usage_switch", true);
        this.fsBucketUsageBatchFlushCount = config.getInt("fs_bucket_usage_batch_flush_count", 800);
        this.fsBucketUsagePreStopOscWaitCount = config.getInt("fs_bucket_usage_prestop_osc_wait_count", 10);
        this.isFsBucketUsageValidCheck = config.getBoolean("fs_bucket_usage_valid_check", true);
        this.fsSwitchCacheThreadPeriod = config.getInt("fs_switch_cache_thread_period", 3);
        this.fsDeleteObjChunkThreadNum = config.getInt("fs_delete_obj_chunk_thread_num", 20);
        this.fsDeleteObjChunkQueCapacity = config.getInt("fs_delete_obj_chunk_que_capacity", 10000);
        this.getFsDeleteObjChunkIntervalClock = config.getInt("fs_delete_obj_chunk_interval_clock", 2);
        this.isFsBUDeltaCheckEnable = config.getBoolean("is_fs_budelta_check_enalbe", true);
        this.fsBUDeltaValidRatio = config.getDouble("fs_budelta_valid_ratio", 0.8);
        this.requestTimedTaskPeriodS = config.getInt("request_timed_task_period_s", 60);
        this.requestTimeoutS = config.getInt("request_timeout_s", 240);
        this.requestInfoRemoveTimeS = config.getInt("request_info_remove_time_s", 3600);
        String omsStorageFloatIP = config.getString("oms_storage_float_ip", "");
        if (omsStorageFloatIP.isEmpty()) {
            logger.error("Configuration error,oms_storage_float_ip is empty");
            throw new ConfigurationException("oms_storage_float_ip is empty");
        }
        this.messageQueueIp = config.getString("message_queue_ip", "");
        if (this.messageQueueIp.isEmpty()) {
            logger.error("Configuration error,message_queue_ip is empty");
            throw new ConfigurationException("message_queue_ipp is empty");
        }
        this.needCalcPlainText = config.getBoolean("need_calc_plaintext_md5", false);
        this.needCheckDownloadMd5 = config.getBoolean("need_check_download_md5", false);
        this.loadNodeInfoConfig(config);
        this.loadTrafficConfig(config);
        this.accessLsByHttps = config.getBoolean("access_ls_use_https", true);
        this.trafficCtontrolOpen = config.getBoolean("trafficControlOpen", true);
        try {
            this.oscAuthVersion = config.getString("osc_auth_version", "v4");
        }
        catch (Exception e) {
            logger.error("load PoeAuthVersion faild!", (Throwable)e);
        }
        String tmpStr = config.getString("domain_name_nobilling", null);
        if (!StringUtils.isBlank((CharSequence)tmpStr)) {
            if (tmpStr.startsWith("domainname:")) {
                tmpStr = tmpStr.split("domainname:")[1];
            }
            this.billList = tmpStr.split(",");
        } else {
            this.billList = null;
        }
        this.isOscPassiveWriteOpen = config.getBoolean("osc_passive_write_switch", true);
        this.isForceCreateOpen = config.getBoolean("osc_force_create_switch", false);
        this.isOptionsJudged = config.getBoolean("judge_options", true);
        this.monitorStatisticInterval = config.getLong("monitor_statistic_interval", 30L);
        this.isMdcHTTPS = config.getBoolean("MDC_HTTPS", true);
        this.isInternalPort = config.getBoolean("check_internal_port_on_maintain_interf", true);
        this.objchkInspectTimeunit = config.getString("object_inspect_time_unit", DefaultConf.OBJCHK_INSPECT_TIME_UNIT.name());
        this.objchkInspectInterval = config.getLong("object_inspect_time_value", 90L);
        this.objectWalkingCycleTime = config.getLong("object_walking_cycle_time", 7L);
        this.objectWalkingCycleTimeUnit = config.getString("object_walking_cycle_time_unit", DefaultConf.OBJECT_WALKING_CYCLE_TIME_UNIT.name());
        this.afterOneCycleObjectWalkerSleepInSeconds = config.getLong("after_one_cycle_objectwalker_sleep_in_seconds", 600L);
        this.objectWalkerMonitorReadStatusIntervalInSeconds = config.getLong("objectwalker_monitor_read_status_interval_in_seconds", 3600L);
        this.deletedUserDataCleanTaskDelayTime = config.getLong("deleted_user_data_clean_task_delay_time", 1800000L);
        this.deleteBucketDataTaskDelayTime = config.getLong("deleted_bucket_data_task_delay_time", 3600000L);
        this.isOisTaskEnable = config.getBoolean("ois_task_enable", true);
        this.thresholdTimeForDelete = config.getLong("threshold_time_for_delete", 0L);
        this.notifyBSSByBucket = config.getBoolean("notify_bss_by_bucket", false);
        this.thresholdTimeForNotifyDelete = config.getLong("threshold_time_for_notify_delete", 0L);
        this.isCheckAuthTimeOpen = config.getBoolean("checkAuthTimeOpen", true);
        this.isSwitchOfPerfStat = config.getBoolean("perfstat_switch", true);
        this.isRemoteReplication = config.getBoolean("replicationPolicy", false);
        this.isRepSwitchSlaveDeleteUpload = config.getBoolean("is_rep_switch_slave_delete_upload", true);
        this.isRepSwitchSlaveDeleteObject = config.getBoolean("is_rep_switch_slave_delete_object", true);
        this.isRepSwitchSlaveCopyObject = config.getBoolean("is_rep_switch_slave_copy_object", true);
        this.oisObjectCheckerPoolSize = config.getInt("ois_object_checker_pool_size", 30);
        this.oisOCCPoolSize = config.getInt("ois_occ_pool_size", 5);
        this.isSlaveDcTakeOverSwitchOpen = config.getBoolean("slave_dc_takeover_switch", false);
        this.checkObjectLifeCycleTaskPeriod = config.getLong("check_object_lifecycle_task_period", 3600L);
        this.checkObjectLifeCycleTimeout = config.getLong("check_object_lifecycle_timeout", 21600L);
        this.repairClusterDgFlagTaskPeriod = config.getLong("repair_cluster_dgflag_task_period", 3600L);
        this.repairBucketIndexTaskPeriod = config.getLong("repair_bucket_index_task_period", 60L);
        this.cleanBucketIndexTaskPeriod = config.getLong("clean_bucket_index_task_period", 14400L);
        this.scanIndexRecordDelayLogicTime = config.getInt("scan_index_record_delay_logic_time", 3);
        this.repSwitchNormalKeepTime = config.getLong("rep_switch_normal_keep_time", 86400000L);
        this.monitorLogicClockZkConfPeriod = config.getInt("monitor_logic_clock_zk_conf_period", 300);
        this.monitorLogicClockStatusPeriod = config.getInt("monitor_logic_clock_status_period", 5);
        this.loggicClockUpdatePeriodThreshold = config.getInt("logicclock_update_period_threshold", 15);
        this.zkMsBetweenRetry = config.getInt("zk_ms_between_retry", 60000);
        this.isAllowDeleteWhenUserInactive = config.getBoolean("allow_delete_when_user_inactive", true);
        this.poeServiceEndpoint = config.getString("POEServiceEndpoint", "");
        this.bucketDeleteTaskPriority = config.getInt("bukDelTaskPriority", 4);
        this.scanBucket2DelPeriod = config.getInt("bukDelScanPeriod", 720);
        this.alarmCheckerPeriod = config.getInt("alarmCheckerPeriod", 300);
        this.scanBucket2DeleteTaskPriority = config.getInt("scanBukDelPriority", 4);
        this.parallelFactor = config.getInt("parallel_factor", 1);
        this.lastChunkSkipTimeout = config.getLong("lastChunkSkipTimeout", 1000L);
        this.isCrossDomianEnable = config.getBoolean("crossdomain_enable", false);
        this.isNeedForwardSwitch = config.getBoolean("forward_switch", true);
        this.isSwiftSwitch = config.getBoolean("swift_switch", false);
        this.controlIOSizeBandwidth = config.getLong("flowcontrol_io_size_bandwidth", 102400L);
        this.localCacheLsExpireTime = config.getLong("local_cache_ls_expire_time", 3600L);
        this.checkObjectLifeCycleBucketTaskTimeout = config.getLong("check_object_lifecycle_bucket_task_timeout", 86400L);
        this.checkAllObjectLifeCycleBucketTaskInternal = config.getLong("check_all_object_lifecycle_bucket_task_Interval", 604800L);
        this.obsQueueRegionManageTaskNum = config.getInt("obs_queue_region_manage_task_num", 20);
        this.repairBucketOldObjRepLogTaskToleranceTime = config.getLong("repair_bucket_old_obj_replog_task_tolerance_time", 172800000L);
        this.repairBucketOldObjRepLogThreadNum = config.getInt("repair_bucket_old_obj_replog_thread_num", 20);
        this.repairOldObjRepLogTaskExpriedCreaten = config.getLong("repair_old_obj_replog_task_expried_create", 86400000L);
        this.repairOldObjRepLogThreadNum = config.getInt("repair_old_obj_replog_thread_num", 10);
        this.repairOldObjRepLogTaskExpried = config.getLong("repair_old_obj_task_expried", 0x6DDD00L);
        this.repairOldObjRepLogTaskPeriod = config.getInt("repair_old_obj_replog_task_period", 3600);
        this.buildBucketLocationThreadNum = config.getInt("build_bucket_location_thread_num", 30);
        this.buildBucketLocationTaskExpried = config.getLong("build_bucket_location_task_expried", 1800000L);
        this.buildBucketLocationTaskPeriod = config.getInt("build_bucket_location_task_period", 10);
        this.repairDegradeReadyBucketTaskPeriod = config.getLong("repair_degradeready_bucket_task_period", 300000L);
        this.repairDegradeReadyBucketRunningNum = config.getInt("repair_degradeready_bucket_running_num", 3);
        this.fixMetaClock = config.getLong("metaclock_when_disk_isnull", 1000L);
        this.calRegionStatisTaskPeriod = config.getLong("cal_region_statistics_task_period", 1800L);
        this.monitorAzQosTaskPeriod = config.getLong("monitor_az_qos_task_period", 5L);
        this.checkObjectExpirationTaskPeriod = config.getLong("check_object_expiration_task_period", 3600L);
        this.checkObjectExpirationTaskTimeout = config.getLong("check_object_expiration_task_timeout", 43200L);
        this.shortConnectionsBuckets = config.getString("short_connection_buckets", "");
        this.shortConnectionsUsers = config.getString("short_connection_users", "");
        this.isCloseLongConnection = config.getBoolean("close_all_connection", false);
        this.asyncBucketUsageUpdateThread = config.getInt("async_bucket_usage_front_update_thread", 100);
        this.enterpriseUsageMode = config.getInt("enterprise_usage_mode", 0);
        this.buSummaryList = config.getBoolean("bu_summary_list", false);
        this.buIdleTime = config.getInt("bucket_usage_idle_time", 180);
        this.oisIdleTime = config.getInt("ois_idle_time", 180);
        this.kVConfigScanInterval = config.getInt("cli_kvconfig_scan_interval", 30);
        this.kVConfigScanInitDelay = config.getInt("cli_kvconfig_scan_init_delay", 3);
        this.tenantStoreCacheInterval = config.getInt("tenant_store_cache_interval", 30);
        this.tenantStoreCacheDelay = config.getInt("tenant_store_cache_delay", 30);
        this.isInternationalAccessGlobalOpen = config.getBoolean("real_name_auth_international_access_global_switch", Boolean.FALSE);
        this.isMainlandAccessGlobalOpen = config.getBoolean("real_name_auth_mainland_access_global_switch", Boolean.FALSE);
        this.dedupswitch = config.getBoolean("dedup_switch", false);
        this.enterpriseVersionIdUpgrade = config.getBoolean("enterprise_version_id_upgrade", false);
        this.swiftResellerPrefix = config.getString("swift_reseller_prefix", "AUTH");
        this.enterpriseMode = config.getBoolean("enterprise_mode", false);
        this.readWriteThreadPoolIsolationSwitch = config.getBoolean("read_write_threadpool_isolation_switch", true);
        this.plogPerfType = config.getInt("plog_perf_type", 0);
        this.gcDynamicSwitch = config.getBoolean("gc_dynamic_gc_switch", true);
        this.gcDynamicRatioThreshold = config.getString("gc_dynamic_ratio_threshold", "80;90");
        this.gcDynamicScanMetaDelLogicTime = config.getString("gc_dynamic_scan_meta_del_logictime", "24;24;12");
        this.gcDynamicHddPlogDelaySinceLastModifyTime = config.getString("gc_dynamic_hddplog_delay_since_last_modifytime", "24;24;24");
        this.gcDynamicHddPlogTaskDelayTimeParams = config.getString("gc_dynamic_hdd_plogtask_delay_time_params", "192;96;96");
        this.gcDynamicPlogUsage = config.getString("gc_dynamic_plog_usage", "40;100");
        this.gcDynamicGcQosTPS = config.getString("gc_dynamic_gc_qos_tps", "30;250;0");
        this.gcDynamicCPUBusyCore = config.getInt("gc_dynamic_gc_cpu_busy_core", 3);
        this.gcDynamicPlogTime = config.getInt("gc_dynamic_gc_plog_time", 35);
        this.gcDynamicGcQosBPS = config.getString("gc_dynamic_gc_qos_bps", "26214400;319430400;0");
        this.swiftServiceType = config.getString("rest_service_type", "s3");
        this.swiftTempURLMethods = config.getString("swift_temp_url_methods", "");
        this.swiftIncomingRemoveHeaders = config.getString("swift_incoming_remove_headers", "");
        this.swiftIncomingAllowHeaders = config.getString("swift_incoming_allow_headers", "");
        this.isListObjectV2 = config.getBoolean("list_object_v2", false);
        this.enterpriseOccCheck = config.getBoolean("enterprise_occ_check", true);
        this.enterpriseAlarmSwitch = config.getBoolean("enterprise_alarm_switch", false);
        this.listMultiPartTaskWithMultiIndex = config.getBoolean("list_MultiPartTask_With_MultiIndex", true);
        this.enterprise3azOpen = config.getBoolean("enterprise_three_az_open", false);
        this.needAuthProxyByOSC = config.getBoolean("need_auth_proxy_by_osc", false);
        this.cacheLowCapacity = config.getInt("cache_low_capacity", 30000);
        this.cacheHighCapacity = config.getInt("cache_high_capacity", 60000);
        this.partEcScanThreadNum = config.getInt("part_ec_scan_thread_num", 10);
        this.multiversionSupport = config.getBoolean("multiversion_support", true);
        this.isRestrictedStatusClose = config.getBoolean("is_restricted_status_close", false);
        this.isReadObjectCacheOpen = config.getBoolean("read_object_cache_switch", false);
        this.isTrimSlashOpen = config.getBoolean("trim_slash_switch", false);
        this.isHttpClientNormalizeSwitchOpen = config.getBoolean("http_client_normalize_switch", false);
        this.isPathTransferVirtualHost = config.getBoolean("is_path_transfer_virtual_host", false);
        this.isAllowDirReceive1ByteData = config.getBoolean("allow_dir_receive_1byte_data", true);
        this.dataPilotServiceOpen = config.getBoolean("data_pilot_service_open", false);
        this.isAddMD5PrefixToObjectName = config.getBoolean("lexi_order_object_optimize_switch", false);
        this.isRestrictedStatusClose = config.getBoolean("is_restricted_status_close", false);
        this.isRestrictedStatusClose = config.getBoolean("is_restricted_status_close", false);
        this.repair330benable = config.getBoolean("repair330benable", true);
        this.repairAndMarkMultiPartPeriod = config.getInt("repairAndMarkMultiPartPeriod", 300);
        this.multiPartThreadNumber = config.getInt("multi_part_thread_number", 100);
        this.secretKeyScannerThreadNumber = config.getInt("secret_key_scanner_thread_number", 10);
        this.multiPartQueueNumber = config.getInt("multi_part_queue_number", 1000);
        this.realNameAuthMasterSwitch = config.getBoolean("real_name_auth_master_switch", false);
        this.realNameAuthStagetwoSwitch = config.getBoolean("real_name_auth_stagetwo_switch", false);
        this.realNameAuthStageoneSwitch = config.getBoolean("real_name_auth_stageone_switch", false);
        config.getBoolean("enterprise_three_az_open", false);
        this.proxyServiceIps = config.getString("obs-proxy_service_ip_list");
        this.realNameAuthStageoneSwitch = config.getBoolean("real_name_auth_stageone_switch", false);
        config.getBoolean("enterprise_three_az_open", false);
        this.realNameAuthStageoneSwitch = config.getBoolean("real_name_auth_stageone_switch", false);
        config.getBoolean("enterprise_three_az_open", false);
        this.dataplusForwardConnectionTimeOut = config.getInt("data_plus_connection_timeout", 10000);
        this.dataplusForwardSocketTimeOut = config.getInt("data_plus_socket_timeout", 120000);
        this.dataplusForwardSocketTimeOut = config.getInt("data_plus_socket_timeout", 120000);
        this.wormClockClientUpdatePeriod = config.getInt("worm_clock_client_update_period", 30);
        this.wormClockServerUpdatePeriod = config.getInt("worm_clock_server_update_period", 60);
        this.wormClockClientExpiredThreshold = config.getInt("worm_clock_client_expired_threshold", 120);
        this.serviceType = config.getString("service_type", "s3");
        this.dataplusAccessMethodMaxLength = config.getInt("data_plus_access_method_max_length", 20);
        this.smnMaxSleepTime = config.getInt("smnMaxSleepTime", 1000);
        this.wormClockClientUpdateThreshold = config.getInt("worm_clock_client_update_threshold", 15);
        this.wormPolicyConfirmMaxTime = config.getLong("worm_policy_confirm_max_time", 86400000L);
        this.blockKeyUpdateInterval = config.getLong("block_key_update_interval", 3600000L);
        this.blockKeyLifetime = config.getLong("block_key_lifetime", 36000000L);
        this.blockKeyScanInterval = config.getLong("block_key_scan_interval", 60000L);
        this.delegationKeyUpdateInterval = config.getLong("delegation_update_interval", 86400000L);
        this.tokenMaxLifetime = config.getLong("delegation_max_lifetime", 604800000L);
        this.tokenRenewInterval = config.getLong("delegation_renew_interval", 86400000L);
        this.internalReqAddFTDSDelay = config.getBoolean("internal_req_add_ftds_delay", true);
        this.obsSupportFtdsBelowHigh = config.getBoolean("obs_support_ftds_below_high", true);
        this.sealDowngradePlogOpen = config.getBoolean("seal_downgrade_plog_open", false);
        this.fsDeleteObjChunkPeriod = config.getInt("fs_delete_object_chunk_period", 60);
        this.fsDeleteObjChunkAllowOverTime = config.getInt("fs_delete_obj_chunk_allow_over_time", 3600000);
        this.auScanCacheMonitorInterval = config.getLong("au_scan_cache_monitor_interval", 1000L);
        this.buUpdateStorageInterval = config.getLong("bu_update_storage_interval", 2000L);
        this.auScanMaxAddInterval = config.getLong("au_scan_max_add_interval", 4000L);
        this.bucketUsageCheckSwitch = config.getBoolean("bucket_usage_check_switch", true);
        this.scheduleTotalAccountUsageInterval = config.getLong("schedule_total_account_usage_interval", 600L);
        this.asyECDelayHour = config.getInt("async_ec_delay_hour", 0);
        this.supportBucketUnderLine = this.getBoolean("supportBucketUnderLine", false);
        this.interworking = config.getBoolean("is_support_interworking", false);
        this.maxFullPathLength = config.getInt("max_full_path_length", 4095);
        this.maxKeyLengthInPath = config.getInt("max_key_length_in_path", 1023);
        this.supportPartition = config.getBoolean("is_support_partition", false);
        this.sysPartitionNum = config.getInt("sys_partition_num", 127);
        try {
            this.poeLsid = config.getLong("poe_lsid", -1L);
            this.lsid = config.getLong("ls_id", -1L);
            this.cmrCmLsid = config.getLong("cmr_cm_lsid", -1L);
            this.cmrCmPort = config.getInt("cmr_cm_port", -1);
            this.ebsServerLsid = config.getLong("ebs_server_lsid", -1L);
            this.ebsServerPort = config.getInt("ebs_server_port", -1);
            this.nsGlobalIpList = config.getString("ns_global_ip_list", "");
            this.oldDataInMongo = config.getBoolean("has_old_data_in_mongo", false);
            this.ccdbLsid = config.getLong("ccdb_lsid", -1L);
            this.bucketName = config.getString("bucket_name", "test");
            this.bucketID = config.getString("bucket_id", "test001");
            this.canonicalID = config.getString("canonical_id", "12345678");
            this.needImportAccounts = config.getBoolean("need_import_accounts", false);
        }
        catch (Exception e) {
            logger.warn("some module does not care about these config, ignore error.", (Throwable)e);
        }
        this.repRetryCount = config.getInt("rep_Retry_Count", 3);
        this.repRetryTime = config.getLong("rep_Retry_Time", 180L);
        this.diskPoolInfo = config.getString("disk_pool_info", "");
        this.partMetaRepairSpan = config.getLong("part_meta_repair_span", 4320L);
        this.supportOrigBucket = config.getBoolean("support_orig_bucket", true);
        this.metaSearchSwitch = config.getBoolean("metasearch_switch", false);
        this.maxMetaIndexKeyNumber = config.getInt("max_meta_index_key_number", 30);
        this.poolType = config.getString("business_service_type", "OTHER");
        this.objectEnable = config.getBoolean("object_service_type", false);
        this.hdfsEnable = config.getBoolean("hdfs_service_type", false);
        this.accountCheckVersionEnable = config.getBoolean("account_version_check_enable", true);
        this.nasEnable = config.getBoolean("file_service_type", false);
        this.defaultBucketType = config.getString("default_bucket_type", BucketType.INTERWORKING.lowercaseName());
        this.md5Enable = config.getBoolean("default_md5_type", true);
        this.initDiskPoolMap();
        this.loadOamxIpInfoConfig(config);
        this.edsFlushSize = config.getInt("eds_flush_size", 1);
        this.contentTypeDefaultValue = config.getString("content_type_default_value_config", "application/octet-stream");
        this.isDeleteAccountAsync = config.getBoolean("isDeleteAccountAsync", false);
        this.mobileSwitch = config.getBoolean("mobile_switch", false);
        this.mobileInnerClientIpList = config.getString("mobile_inner_client_ip_list", "");
        this.mobileStatisticInterval = config.getLong("mobile_statistic_interval", 300L);
        this.maxInitializingTime4Repair = config.getLong("max_initializing_time_4_repair", 3600000L);
        this.maxInitializedTime4Repair = config.getLong("max_initialized_time_4_repair", 604800000L);
        this.checkInitUploadIdInterval = config.getLong("check_init_uploadid_interval", 10800000L);
        this.delEmptyObjDirInterval4Repair = config.getLong("del_empty_obj_dir_interval_4_Repair", 10800000L);
        this.zkAuthUserName = config.getString("zk_auth_user_name", "zk_user");
        this.zkAuthPassWord = config.getString("zk_auth_password", "");
        this.maxMultiPartObjFullPathLength = config.getInt("max_multipart_obj_full_path_length", 1024);
        this.checkUploadFailedInterval = config.getLong("check_init_uploadid_failed_interval", 86400000L);
        this.adldapUserPolicyEnable = config.getBoolean("adldap_user_policy_enable", true);
        this.isClusterAutoSwitch = config.getBoolean("cluster_status_auto_switch", true);
        this.clusterAutoSwitchTime = config.getInt("cluster_status_auto_switch_time", 300);
        this.flowControl = config.getInt("flow_control_config", 300);
        this.isSupportCircularDeleteDir = config.getBoolean("circular_delete_dir", true);
        this.isForceDeleteDir = config.getBoolean("force_delete_dir", false);
        this.isCheckCompressMetadataSize = config.getBoolean("check_compress_metadata_size", true);
        boolean isOscHttpOn = this.isOscHttpSwitch;
        this.isOscHttpSwitch = config.getBoolean("osc_http_switch", false);
        if (isOscHttpOn != this.isOscHttpSwitch) {
            logger.warn("osc http switch change to:{}", (Object)this.isOscHttpSwitch);
        }
        this.rbfNodeList = config.getString("rbf_node_list", "");
        this.memAlarmThreshold = config.getString("mem_alarm_threshold", "0:90;1:90;2:90;3:90;4:90");
        this.pocLevel = config.getInt("osc_poc_switch", 0);
        this.isFtdsStatOn = config.getBoolean("ftds_switch", true);
        this.tierStorageClass = config.getString("tier_storageclass", "");
        this.maxRegionNumber = config.getInt("max_region_number", 32);
        this.tierVendor = config.getInt("tier_vendor", 0);
        this.tierMaxSegSize = config.getInt("tier_max_seg_size", 5120);
        this.cpuMonitorPeriod = config.getLong("cpu_monitor_period", 300L);
        this.isRangerPolicySaveToLocalFile = config.getBoolean("is_ranger_policy_save_to_local_file", false);
        this.rangerPolicyTotalSize = config.getLong("ranger_policy_total_size", 20L);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            try {
                this.loadConfig();
            }
            catch (ConfigurationException e) {
                logger.warn(String.format(Locale.ROOT, "Failed to refresh configurations due to error: [%1$s]", e.getLocalizedMessage()));
            }
        }
    }

    private void loadAuthConfig(PropertiesConfiguration config) throws ConfigurationException {
        this.oscAuthVersion = config.getString("osc_auth_version", "v2v4");
    }

    private void loadNodeInfoConfig(PropertiesConfiguration config) throws ConfigurationException {
        this.omdNodeId = config.getString("omd_node_id", "");
        if (this.omdNodeId.isEmpty()) {
            logger.error("systemconfig error,omd_node_id is empty");
            throw new ConfigurationException("omd_node_id is empty");
        }
        this.omdNodeIP = config.getString("omd_storage_ip", "");
        if (this.omdNodeIP.isEmpty()) {
            logger.error("systemconfig error,omd_storage_ip is empty");
            throw new ConfigurationException("omd_storage_ip is empty");
        }
        this.oscBussinessIp = config.getString("osc_node_bussiness_ip", "");
        if (this.oscBussinessIp.isEmpty()) {
            logger.error("systemconfig error,osc_node_bussiness_ip is empty");
            throw new ConfigurationException("osc_node_bussiness_ip is empty");
        }
        this.oamUNodeIP = config.getString("oam_u_ip", "127.0.0.1");
        this.poeFloatIP = config.getString("poe_float_ip", "127.0.0.1");
        this.checkPoeFloatIP = config.getBoolean("check_poe_float_ip", true);
        String zookeeperGateway = config.getString("zookeeper_gateway", "");
        if (zookeeperGateway.isEmpty()) {
            logger.error("systemconfig error,zookeeper_gateway is empty");
            throw new ConfigurationException("zookeeper_gateway is empty");
        }
    }

    private void loadTrafficConfig(PropertiesConfiguration config) {
        this.trafficCtontrolOpen = config.getBoolean("trafficControlOpen", true);
        this.maxCpuUsage = config.getInt("maxCpuUsage", 99);
        this.cpuLow = config.getInt("cpuLow", 95);
        this.maxSleepTime = config.getInt("maxSleepTime", 1000);
        if (this.maxCpuUsage < this.cpuLow || this.cpuLow < 0) {
            this.maxCpuUsage = 99;
            this.cpuLow = 95;
            logger.warn("maxCpuUsage or cpuLow not correct configured .Use default value.");
        }
        this.maxUploadMbps = config.getInt("maxUploadMbps", 550);
        this.maxSleepStepBase = config.getInt("maxSleepStepBase", 60);
        this.balanceSleepTimeWrite = config.getInt("balanceSleepTimeUpload", 250);
        this.balanceSleepTimeRead = config.getInt("balanceSleepTimeDownload", 750);
    }

    private void loadOamxIpInfoConfig(PropertiesConfiguration config) {
        this.dns3azSwitchOpen = config.getBoolean("dns_3az_switch", false);
        this.oamsIpList = config.getString("oams_ip_info", "");
        this.oamiIpList = config.getString("oami_ip_info", "");
        this.oampIpList = config.getString("oamp_ip_info", "");
        this.oamuIpList = config.getString("oamu_ip_info", "");
        this.oamgsIpList = config.getString("oamgs_ip_info", "");
    }

    private String getModuleName(String rootDir) {
        if (StringUtils.isBlank((CharSequence)rootDir)) {
            return "";
        }
        String[] temp = rootDir.split("/");
        if (temp.length >= 1) {
            return temp[temp.length - 1];
        }
        return "";
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getMaxSize4SmallIoRead() {
        return this.maxSize4SmallIoRead;
    }

    public int getColdChunkSize() {
        return this.coldChunkSize;
    }

    public int getPartECGroupTime() {
        return this.partECGroupTime;
    }

    public int getSodDataVersion() {
        return this.sodDataVersion;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public String getOmdNodeId() {
        return this.omdNodeId;
    }

    public String getOmdNodeIP() {
        return this.omdNodeIP;
    }

    public String getOamUNodeIP() {
        return this.oamUNodeIP;
    }

    public String getPOEFloatIP() {
        return this.poeFloatIP;
    }

    public boolean isCheckPoeFloatIP() {
        return this.checkPoeFloatIP;
    }

    public String getOscBussinessIp() {
        return this.oscBussinessIp;
    }

    public List<String> getFsOscIpList() {
        return this.fsOscIpList;
    }

    public String getZookeeperHostPort() {
        return this.zookeeperHostPort;
    }

    public int getLogicClockClientUpdateInterval() {
        return this.logicClockClientUpdateValue;
    }

    public void setEcAlgorithm(int ecAlgorithm) {
        this.ecAlgorithm = ecAlgorithm;
    }

    public int getEcAlgorithm() {
        return this.ecAlgorithm;
    }

    public boolean isTrafficCtontrolOpen() {
        return this.trafficCtontrolOpen;
    }

    public int getMaxCpuUsage() {
        return this.maxCpuUsage;
    }

    public void setMaxCpuUsage(int maxCpuUsage) {
        this.maxCpuUsage = maxCpuUsage;
    }

    public int getCpuLow() {
        return this.cpuLow;
    }

    public void setCpuLow(int cpuLow) {
        this.cpuLow = cpuLow;
    }

    public int getMaxSleepTime() {
        return this.maxSleepTime;
    }

    public int getSmnMaxSleepTime() {
        return this.smnMaxSleepTime;
    }

    public void setMaxSleepTime(int maxSleepTime) {
        this.maxSleepTime = maxSleepTime;
    }

    public int getMaxUploadMbps() {
        return this.maxUploadMbps;
    }

    public void setMaxUploadMbps(int maxUploadMbps) {
        this.maxUploadMbps = maxUploadMbps;
    }

    public int getMaxSleepStepBase() {
        return this.maxSleepStepBase;
    }

    public void setMaxSleepStepBase(int maxSleepStepBase) {
        this.maxSleepStepBase = maxSleepStepBase;
    }

    public int getBalanceSleepTimeWrite() {
        return this.balanceSleepTimeWrite;
    }

    public int getBalanceSleepTimeRead() {
        return this.balanceSleepTimeRead;
    }

    public String getMessageQueueIp() {
        return this.messageQueueIp;
    }

    public String getOscAuthVersion() {
        return this.oscAuthVersion;
    }

    public boolean isNeedCalcPlainText() {
        return this.needCalcPlainText;
    }

    public boolean isNeedCheckDownloadMd5() {
        return this.needCheckDownloadMd5;
    }

    public boolean isAccessLsByHttps() {
        return this.accessLsByHttps;
    }

    public int getClusterBucketThreads() {
        return this.clusterBucketThreads;
    }

    public int getListS3ReqPoolMaxSize() {
        return this.listS3ReqPoolMaxSize;
    }

    public int getListMaxSize4LsAndPoe() {
        return this.listMaxSize4LsAndPoe;
    }

    public int getClusterPerThreadHandleUsers() {
        return this.clusterPerThreadHandleUsers;
    }

    public long getClusterCacheExpireTime() {
        return this.clusterCacheExpireTime;
    }

    public int getClusterPerUserTime() {
        return this.clusterPerUserTime;
    }

    public int getKmcCryptoDomainId() {
        return this.kmcCryptoDomainId;
    }

    public int getKmcAlgorithmId() {
        return this.kmcAlgorithmId;
    }

    public String getLicenceCCertPassword() {
        return this.getConfig().getString("license_client_cert_password");
    }

    public boolean getIfNeedSupportSSL() {
        return this.getConfig().getBoolean("license_need_support_ssl", false);
    }

    public String getSSECustomerHmacKey() {
        return this.getConfig().getString("sse_customer_hmac_key");
    }

    public String getMaintainSCertPassowrd() {
        return this.getConfig().getString("maintain_s_cert_password");
    }

    public String[] getMaintainProtocol() {
        String maintainProtocol = this.getConfig().getString("maintain_protocol", "TLSv1.2");
        return maintainProtocol.split(",");
    }

    public String getKmcPrimaryKeyPath() {
        return this.kmcPrimaryKeyPath;
    }

    public String getKmcStandbyKeyPath() {
        return this.kmcStandbyKeyPath;
    }

    public String getKmcLogPath() {
        return this.kmcLogPath;
    }

    public int getClusterAbility() {
        return this.clusterAbility;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public long getRepSwitchNormalKeepTime() {
        return this.repSwitchNormalKeepTime;
    }

    public long getRepairClusterDgFlagTaskPeriod() {
        return this.repairClusterDgFlagTaskPeriod;
    }

    public long getRepairBucketIndexTaskPeriod() {
        return this.repairBucketIndexTaskPeriod;
    }

    public long getCleanBucketIndexTaskPeriod() {
        return this.cleanBucketIndexTaskPeriod;
    }

    public int getScanIndexRecordDelayLogicTime() {
        return this.scanIndexRecordDelayLogicTime;
    }

    public long getCheckObjectLifeCycleTimeout() {
        return this.checkObjectLifeCycleTimeout;
    }

    public long getCheckObjectLifeCycleTaskPeriod() {
        return this.checkObjectLifeCycleTaskPeriod;
    }

    public boolean isSlaveDcTakeOverSwitchOpen() {
        return this.isSlaveDcTakeOverSwitchOpen;
    }

    public int getOisObjectCheckerPoolSize() {
        return this.oisObjectCheckerPoolSize;
    }

    public boolean isRepSwitchSlaveCopyObject() {
        return this.isRepSwitchSlaveCopyObject;
    }

    public boolean isRepSwitchSlaveDeleteObject() {
        return this.isRepSwitchSlaveDeleteObject;
    }

    public boolean isRepSwitchSlaveDeleteUpload() {
        return this.isRepSwitchSlaveDeleteUpload;
    }

    public boolean isRemoteReplication() {
        return this.isRemoteReplication;
    }

    public boolean isSwitchOfPerfStat() {
        return this.isSwitchOfPerfStat;
    }

    public boolean isCheckAuthTimeOpen() {
        return this.isCheckAuthTimeOpen;
    }

    public long getThresholdTimeForDelete() {
        return this.thresholdTimeForDelete;
    }

    public long getThresholdTimeForNotifyDelete() {
        return this.thresholdTimeForNotifyDelete;
    }

    public boolean isNotifyBSSByBucket() {
        return this.notifyBSSByBucket;
    }

    public boolean isOisTaskEnable() {
        return this.isOisTaskEnable;
    }

    public long getDeletedUserDataCleanTaskDelayTime() {
        return this.deletedUserDataCleanTaskDelayTime;
    }

    public long getDeleteBucketDataTaskDelayTime() {
        return this.deleteBucketDataTaskDelayTime;
    }

    public long getObjectWalkerMonitorReadStatusIntervalInSeconds() {
        return this.objectWalkerMonitorReadStatusIntervalInSeconds;
    }

    public long getAfterOneCycleObjectWalkerSleepInSeconds() {
        return this.afterOneCycleObjectWalkerSleepInSeconds;
    }

    public String getObjectWalkingCycleTimeUnit() {
        return this.objectWalkingCycleTimeUnit;
    }

    public long getObjectWalkingCycleTime() {
        return this.objectWalkingCycleTime;
    }

    public long getObjchkInspectInterval() {
        return this.objchkInspectInterval;
    }

    public String getObjchkInspectTimeunit() {
        return this.objchkInspectTimeunit;
    }

    public boolean isInternalPort() {
        return this.isInternalPort;
    }

    public boolean isMdcHTTPS() {
        return this.isMdcHTTPS;
    }

    public long getMonitorStatisticInterval() {
        return this.monitorStatisticInterval;
    }

    public boolean isOptionsJudged() {
        return this.isOptionsJudged;
    }

    public String[] getBillList() {
        return this.billList;
    }

    public int getZkMsBetweenRetry() {
        return this.zkMsBetweenRetry;
    }

    public boolean isOscPassiveWriteOpen() {
        return this.isOscPassiveWriteOpen;
    }

    public boolean isForceCreateOpen() {
        return this.isForceCreateOpen;
    }

    public int getLoggicClockUpdatePeriodThreshold() {
        return this.loggicClockUpdatePeriodThreshold;
    }

    public int getMonitorLogicClockStatusPeriod() {
        return this.monitorLogicClockStatusPeriod;
    }

    public int getMonitorLogicClockZkConfPeriod() {
        return this.monitorLogicClockZkConfPeriod;
    }

    public boolean getAllowDeleteWhenUserInactive() {
        return this.isAllowDeleteWhenUserInactive;
    }

    public String getPOEServiceEndpoint() {
        return this.poeServiceEndpoint;
    }

    public long getAlarmCheckerPeriod() {
        return this.alarmCheckerPeriod;
    }

    public long getScanBucket2DelPeriod() {
        return this.scanBucket2DelPeriod;
    }

    public int getBucketDeleteTaskPriority() {
        return this.bucketDeleteTaskPriority;
    }

    public int getScanBucket2DeleteTaskPriority() {
        return this.scanBucket2DeleteTaskPriority;
    }

    public int getParallelFactor() {
        return this.parallelFactor;
    }

    public void setParallelFactor(int parallelFactor) {
        this.parallelFactor = parallelFactor;
    }

    public long getLastChunkSkipTimeout() {
        return this.lastChunkSkipTimeout;
    }

    public boolean isCrossDomianEnable() {
        return this.isCrossDomianEnable;
    }

    public boolean isSwiftSwitch() {
        return this.isSwiftSwitch;
    }

    public long getControlIOSizeBandwidth() {
        return this.controlIOSizeBandwidth;
    }

    public long getLocalCacheLsExpireTime() {
        return this.localCacheLsExpireTime;
    }

    public long getCheckObjectLifeCycleBucketTaskTimeout() {
        return this.checkObjectLifeCycleBucketTaskTimeout;
    }

    public long getCheckAllObjectLifeCycleBucketTaskInternal() {
        return this.checkAllObjectLifeCycleBucketTaskInternal;
    }

    public int getObsQueueRegionManageTaskNum() {
        return this.obsQueueRegionManageTaskNum;
    }

    public long getRepairBucketOldObjRepLogTaskToleranceTime() {
        return this.repairBucketOldObjRepLogTaskToleranceTime;
    }

    public int getRepairBucketOldObjRepLogThreadNum() {
        return this.repairBucketOldObjRepLogThreadNum;
    }

    public long getRepairOldObjRepLogTaskExpriedCreate() {
        return this.repairOldObjRepLogTaskExpriedCreaten;
    }

    public int getRepairOldObjRepLogThreadNum() {
        return this.repairOldObjRepLogThreadNum;
    }

    public long getRepairOldObjRepLogTaskExpried() {
        return this.repairOldObjRepLogTaskExpried;
    }

    public int getRepairOldObjRepLogTaskPeriod() {
        return this.repairOldObjRepLogTaskPeriod;
    }

    public int getBuildBucketLocationThreadNum() {
        return this.buildBucketLocationThreadNum;
    }

    public long getBuildBucketLocationTaskExpried() {
        return this.buildBucketLocationTaskExpried;
    }

    public int getBuildBucketLocationTaskPeriod() {
        return this.buildBucketLocationTaskPeriod;
    }

    public int getRepairDegradeReadyBucketRunningNum() {
        return this.repairDegradeReadyBucketRunningNum;
    }

    public long getRepairDegradeReadyBucketTaskPeriod() {
        return this.repairDegradeReadyBucketTaskPeriod;
    }

    public long getFixMetaClock() {
        return this.fixMetaClock;
    }

    public boolean getBucketUsageCacheSwitch() {
        return this.bucketUsageCacheSwitch;
    }

    public boolean getFsBucketUsageSwitch() {
        return this.fsBucketUsageSwitch;
    }

    public int getFsBucketUsageBatchFlushCount() {
        return this.fsBucketUsageBatchFlushCount;
    }

    public int getFsBucketUsagePreStopOscWaitCount() {
        return this.fsBucketUsagePreStopOscWaitCount;
    }

    public boolean isFsBUDeltaCheckEnable() {
        return this.isFsBUDeltaCheckEnable;
    }

    public double getFsBUDeltaValidRatio() {
        return this.fsBUDeltaValidRatio;
    }

    public boolean getFsBucketUsageValidCheck() {
        return this.isFsBucketUsageValidCheck;
    }

    public int getFsSwitchCacheThreadPeriod() {
        return this.fsSwitchCacheThreadPeriod;
    }

    public int getFsDeleteObjChunkThreadNum() {
        return this.fsDeleteObjChunkThreadNum;
    }

    public int getFsDeleteObjChunkQueCapacity() {
        return this.fsDeleteObjChunkQueCapacity;
    }

    public int getFsDeleteObjChunkIntervalClock() {
        return this.getFsDeleteObjChunkIntervalClock;
    }

    public int getRquestTimedTaskPeriodS() {
        return this.requestTimedTaskPeriodS;
    }

    public int getRequestTimeoutS() {
        return this.requestTimeoutS;
    }

    public int getRequestInfoRemoveTimeS() {
        return this.requestInfoRemoveTimeS;
    }

    public long getCalRegionStatisTaskPeriod() {
        return this.calRegionStatisTaskPeriod;
    }

    public long getMonitorAzQosTaskPeriod() {
        return this.monitorAzQosTaskPeriod;
    }

    public String getSupportAPI() {
        return this.supportAPI;
    }

    public String getDefaultAPI() {
        return this.defaultAPI;
    }

    public boolean isObsPathSwitch() {
        return this.obsPathSwitch;
    }

    public boolean isOBSWhiteListAccount(String accountID) {
        logger.debug("accountID={}", (Object)accountID);
        return this.obsWhiteList.contains(accountID);
    }

    public boolean isCloudMonitorSwitch() {
        return this.cloudMonitorSwitch;
    }

    public long getStatisticsLogCollectInterval() {
        return this.statisticsLogCollectInterval;
    }

    public long getCheckObjectExpirationTaskPeriod() {
        return this.checkObjectExpirationTaskPeriod;
    }

    public long getCheckObjectExpirationTaskTimeout() {
        return this.checkObjectExpirationTaskTimeout;
    }

    public String getDyeTrack() {
        return this.dyeTrack;
    }

    public String getShortConnectionsBuckets() {
        return this.shortConnectionsBuckets;
    }

    public String getShortConnectionsUsers() {
        return this.shortConnectionsUsers;
    }

    public boolean isCloseLongConnection() {
        return this.isCloseLongConnection;
    }

    public int getAsyncBucketUsageUpdateThread() {
        return this.asyncBucketUsageUpdateThread;
    }

    public int getEnterpriseUsageMode() {
        return this.enterpriseUsageMode;
    }

    public boolean isBuSummaryList() {
        return this.buSummaryList;
    }

    public int getKVConfigScanInterval() {
        return this.getConfig().getInt("cli_kvconfig_scan_interval", 30);
    }

    public int getKVConfigScanInitDelay() {
        return this.kVConfigScanInitDelay;
    }

    public int getTenantStoreCacheInterval() {
        return this.tenantStoreCacheInterval;
    }

    public int getTenantStoreCacheDelay() {
        return this.tenantStoreCacheDelay;
    }

    public boolean isRealNameAuthInternationalAccessGlobalSwitchOpen() {
        return this.isInternationalAccessGlobalOpen;
    }

    public boolean isRealNameAuthMainlandAccessGlobalSwitchOpen() {
        return this.isMainlandAccessGlobalOpen;
    }

    public boolean isDedupswitch() {
        return this.dedupswitch;
    }

    public boolean isEnterpriseVersionIdUpgrade() {
        return this.enterpriseVersionIdUpgrade;
    }

    public boolean isEnterpriseMode() {
        return this.enterpriseMode;
    }

    public boolean isReadWriteThreadPoolIsolationSwitch() {
        return this.readWriteThreadPoolIsolationSwitch;
    }

    public int getPlogPerfType() {
        return this.plogPerfType;
    }

    public String getSwiftResellerPrefix() {
        return this.swiftResellerPrefix;
    }

    public String getSwiftServiceType() {
        return this.swiftServiceType;
    }

    public String getSwiftTempURLMethods() {
        return this.swiftTempURLMethods;
    }

    public String getSwiftIncomingRemoveHeaders() {
        return this.swiftIncomingRemoveHeaders;
    }

    public String getSwiftIncomingAllowHeaders() {
        return this.swiftIncomingAllowHeaders;
    }

    public boolean isListObjectV2() {
        return this.isListObjectV2;
    }

    public boolean isEnterpriseOccCheck() {
        return this.enterpriseOccCheck;
    }

    public boolean getEnterpriseAlarmSwitch() {
        return this.enterpriseAlarmSwitch;
    }

    public boolean isListMultiPartTaskWithMultiIndex() {
        return this.listMultiPartTaskWithMultiIndex;
    }

    public boolean isEnterprise3AZOpen() {
        return this.enterprise3azOpen;
    }

    public void setDedupswitch(boolean dedupswitch) {
        this.dedupswitch = dedupswitch;
    }

    public long getFsServerCacheMemMB() {
        return this.fsServerCacheMemMB;
    }

    public long getFsMaxTruncLenGB() {
        return this.fsMaxTruncLenGB;
    }

    public long getFsClientMetaCacheMemMB() {
        return this.fsClientMetaCacheMemMB;
    }

    public String getInternalIp() {
        return this.internalIp;
    }

    public String getCcdbLocalIp() {
        return this.ccdbLocalIp;
    }

    public boolean isNeedAuthProxyByOSC() {
        return this.needAuthProxyByOSC;
    }

    public int getCacheLowCapacity() {
        return this.cacheLowCapacity;
    }

    public int getCacheHighCapacity() {
        return this.cacheHighCapacity;
    }

    public int getPartECScanThreadNum() {
        return this.partEcScanThreadNum;
    }

    public boolean isMultiversionSupport() {
        return this.multiversionSupport;
    }

    public boolean isRestrictedStatusClosed() {
        return this.isRestrictedStatusClose;
    }

    public boolean isRepair330BEnable() {
        return this.repair330benable;
    }

    public int getRepairAndMarkMultiPartPeriod() {
        return this.repairAndMarkMultiPartPeriod;
    }

    public int getMultiPartThreadNumber() {
        return this.multiPartThreadNumber;
    }

    public int getSecretKeyScannerThreadNumber() {
        return this.secretKeyScannerThreadNumber;
    }

    public int getFsMultiPartMovedThreadNumber() {
        return this.fsMultiPartMovedThreadNumber;
    }

    public int getMultiPartQueueNumber() {
        return this.multiPartQueueNumber;
    }

    public boolean isRealNameAuthMasterSwitchOpen() {
        return this.realNameAuthMasterSwitch;
    }

    public boolean isRealNameAuthStageTwoSwitchOpen() {
        return this.realNameAuthStagetwoSwitch;
    }

    public boolean isRealNameAuthStageOneSwitchOpen() {
        return this.realNameAuthStageoneSwitch;
    }

    public int getDataplusForwardConnectionTimeOut() {
        return this.dataplusForwardConnectionTimeOut;
    }

    public int getDataplusForwardSocketTimeOut() {
        return this.dataplusForwardSocketTimeOut;
    }

    public int getDataplusAccessMethodMaxLength() {
        return this.dataplusAccessMethodMaxLength;
    }

    public int getImportDataMaxThreadCount() {
        return this.importDataMaxThreadCount;
    }

    public int getImportDataCountPerThread() {
        return this.importDataCountPerThread;
    }

    public String getProxyServiceIps() {
        return this.proxyServiceIps;
    }

    public long getLoadCMViewInterval() {
        return this.loadCMViewInterval;
    }

    public long getLoadDHTViewInterval() {
        return this.loadDHTViewInterval;
    }

    public long getFsHeartBeatInterval() {
        return this.fsHeartBeatInterval;
    }

    public long getFsMaxReadSize() {
        return this.fsMaxReadSize;
    }

    public long getFsDelayPrintThreshold() {
        return this.fsDelayPrintThreshold;
    }

    public long getFsStatPrintInterval() {
        return this.fsStatPrintInterval;
    }

    public long getFsStatPrintCountThreshold() {
        return this.fsStatCountPrintThreshold;
    }

    public boolean isMockZkLoadDHTViewFailed() {
        return this.mockZkLoadDHTViewFailed;
    }

    public boolean isMockSupportFs() {
        return this.mockSupportFs;
    }

    public boolean isEnableMonitorPlogOperate() {
        return this.enableMonitorPlogOperate;
    }

    public long getFsMaxCacheSeconds() {
        return this.fsMaxCacheSeconds;
    }

    public List<String> getObsLVSIPList() {
        return this.obsLVSIPList;
    }

    public int getFsDefragmentMaxTreemapMoveLimit() {
        return this.fsDefragmentMaxTreemapMoveLimit;
    }

    public boolean getFsDefragmentEnable() {
        return this.fsDefragmentEnable;
    }

    public boolean getfsChunkMarkDelEnable() {
        return this.fsChunkMarkDelEnable;
    }

    public boolean getFsDefragmentMd5CheckEnable() {
        return this.getFsDefragmentMd5CheckEnable;
    }

    public boolean getfsDefragmentConflictCountClear() {
        return this.fsDefragmentConflictCountClear;
    }

    public boolean getFsDefragmentMd5CheckStatisticsClear() {
        return this.fsDefragmentMd5CheckStatisticsClear;
    }

    public boolean getFsDefragmentEcCutLocationStatisticsClear() {
        return this.fsDefragmentEcCutLocationStatisticsClear;
    }

    public boolean getFsDefragmentCutPlogTypeStatisticsClear() {
        return this.fsDefragmentCutPlogTypeStatisticsClear;
    }

    public long getfsDefragmentMaxLayoutPerRangeThreshold() {
        return this.fsDefragmentMaxLayoutPerRangeThreshold;
    }

    public double getfsDefragmentDatasizePerRangeThreshold() {
        return this.fsDefragmentDatasizePerRangeThreshold;
    }

    public double getfsDefragmentPieceLevel() {
        return this.fsDefragmentPieceLevel;
    }

    public long getfsDefragmentRangesize() {
        return this.fsDefragmentRangesize;
    }

    public long getfsDefragmentCacheMemThreshold() {
        return this.fsDefragmentCacheMemThreshold;
    }

    public long getfsDefragmentCacheAverMemThreshold() {
        return this.fsDefragmentCacheAverMem;
    }

    public double getfsDefragmentSysPriorityThreshold() {
        return this.fsDefragmentSysPriorityThreshold;
    }

    public int getfsDefragmentMaptoqCycle() {
        return this.fsDefragmentMaptoqCycle;
    }

    public boolean isFsDefragmentObjectLayout() {
        return this.fsDefragmentObjectLayout;
    }

    public long getFsDefragmentMaxLayoutPerLogicClock() {
        return this.fsDefragmentMaxLayoutPerLogicClock;
    }

    public int getFsCleanTaskRecordPeriod() {
        return this.fsCleanTaskRecordPeriod;
    }

    public boolean getfsMultipartMoveStatisticsClear() {
        return this.fsMultipartMoveStatisticsClear;
    }

    public int getBUIdleTime() {
        return this.buIdleTime;
    }

    public int getOISIdleTime() {
        return this.oisIdleTime;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public boolean isReadObjectCacheOpen() {
        return this.isReadObjectCacheOpen;
    }

    public boolean isTrimSlashOpen() {
        return this.isTrimSlashOpen;
    }

    public boolean isAllowDirReceive1ByteData() {
        return this.isAllowDirReceive1ByteData;
    }

    public boolean isDataPilotServiceOpen() {
        return this.dataPilotServiceOpen;
    }

    public boolean isAddMD5PrefixToObjectName() {
        return this.isAddMD5PrefixToObjectName;
    }

    public void setAddMD5PrefixToObjectName(boolean addMD5PrefixToObjectName) {
        this.isAddMD5PrefixToObjectName = addMD5PrefixToObjectName;
    }

    public int getWormClockClientUpdatePeriod() {
        return this.wormClockClientUpdatePeriod;
    }

    public int getWormClockServerUpdatePeriod() {
        return this.wormClockServerUpdatePeriod;
    }

    public int getWormClockClientExpiredThreshold() {
        return this.wormClockClientExpiredThreshold;
    }

    public int getWormClockClientUpdateThreshold() {
        return this.wormClockClientUpdateThreshold;
    }

    public long getWormPolicyConfirmMaxTime() {
        return this.wormPolicyConfirmMaxTime;
    }

    public long getBlockKeyUpdateInterval() {
        return this.blockKeyUpdateInterval;
    }

    public long getBlockKeyLifetime() {
        return this.blockKeyLifetime;
    }

    public long getBlockKeyScanInterval() {
        return this.blockKeyScanInterval;
    }

    public long getDelegationKeyUpdateInterval() {
        return this.delegationKeyUpdateInterval;
    }

    public long getTokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long getTokenRenewInterval() {
        return this.tokenRenewInterval;
    }

    public long getSyncDataTimeoutInMicros() {
        return this.syncDataTimeoutInMicros;
    }

    public boolean isInternalReqAddFTDSDelay() {
        return this.internalReqAddFTDSDelay;
    }

    public boolean isObsSupportFtdsBelowHigh() {
        return this.obsSupportFtdsBelowHigh;
    }

    public boolean isSealDowngradePlogOpen() {
        return this.sealDowngradePlogOpen;
    }

    public int getFsDeleteObjChunkPeriod() {
        return this.fsDeleteObjChunkPeriod;
    }

    public int getFsDeleteObjChunkAllowOverTime() {
        return this.fsDeleteObjChunkAllowOverTime;
    }

    public int getOisOCCPoolSize() {
        return this.oisOCCPoolSize;
    }

    public long getAuScanCacheMonitorInterval() {
        return this.auScanCacheMonitorInterval;
    }

    public long getBuUpdateStorageInterval() {
        return this.buUpdateStorageInterval;
    }

    public String getGCDynamicRatioThreshold() {
        return this.gcDynamicRatioThreshold;
    }

    public String getGCDynamicScanMetaDelLogicTime() {
        return this.gcDynamicScanMetaDelLogicTime;
    }

    public String getGCDynamicHddPlogDelaySinceLastModifyTime() {
        return this.gcDynamicHddPlogDelaySinceLastModifyTime;
    }

    public String getGCDynamicHddPlogTaskDelayTimeParams() {
        return this.gcDynamicHddPlogTaskDelayTimeParams;
    }

    public String getGCDynamicGcQosBPS() {
        return this.gcDynamicGcQosBPS;
    }

    public boolean isGcDynamicSwitch() {
        return this.gcDynamicSwitch;
    }

    public String getGCDynamicGcQosTPS() {
        return this.gcDynamicGcQosTPS;
    }

    public String getGCDynamicPlogUsage() {
        return this.gcDynamicPlogUsage;
    }

    public int getGCDynamicCPUBusyCore() {
        return this.gcDynamicCPUBusyCore;
    }

    public int getGCDynamicPlogTime() {
        return this.gcDynamicPlogTime;
    }

    public long getAuScanMaxAddInterval() {
        return this.auScanMaxAddInterval;
    }

    public boolean isBucketUsageCheckSwitch() {
        return this.bucketUsageCheckSwitch;
    }

    public long getScheduleTotalAccountUsageInterval() {
        return this.scheduleTotalAccountUsageInterval;
    }

    public String getOAMSIpList() {
        return this.oamsIpList;
    }

    public String getOAMIIpList() {
        return this.oamiIpList;
    }

    public String getOAMPIpList() {
        return this.oampIpList;
    }

    public String getOAMUIpList() {
        return this.oamuIpList;
    }

    public String getOamgsIpList() {
        return this.oamgsIpList;
    }

    public boolean isDns3AzSwitchOpen() {
        return this.dns3azSwitchOpen;
    }

    public boolean isSupportBucketUnderLine() {
        return this.supportBucketUnderLine;
    }

    public boolean isSupportBucketNameWithNas() {
        return this.supportBucketNameWithNas;
    }

    public String getKmsIpList() {
        return this.kmsIpList;
    }

    public String getClusterSn() {
        return this.clusterSn;
    }

    public String getCtrlIp() {
        return this.ctrlIp;
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public long getSecretKeyUpdateInterval() {
        return this.secretKeyUpdateInterval;
    }

    public boolean isSoftEncryptOn() {
        return this.softEncryptOn;
    }

    public long getLsid() {
        return this.lsid;
    }

    public long getPoeLsid() {
        return this.poeLsid;
    }

    public long getCmrCmLsid() {
        return this.cmrCmLsid;
    }

    public int getCmrCmPort() {
        return this.cmrCmPort;
    }

    public long getEbsServerLsid() {
        return this.ebsServerLsid;
    }

    public int getEbsServerPort() {
        return this.ebsServerPort;
    }

    public long getCcdbLsid() {
        return this.ccdbLsid;
    }

    public String getNsGlobalIpList() {
        return this.nsGlobalIpList;
    }

    public Boolean hasOldDataInMongo() {
        return this.oldDataInMongo;
    }

    public int getAsyECDelayHour() {
        return this.asyECDelayHour;
    }

    public long getRepRetryTime() {
        return this.repRetryTime;
    }

    public int getRepRetryCount() {
        return this.repRetryCount;
    }

    public int getMaxFullPathLength() {
        return this.maxFullPathLength;
    }

    public int getMaxKeyLengthInPath() {
        return this.maxKeyLengthInPath;
    }

    public boolean isInterworking() {
        return this.interworking;
    }

    public boolean isSupportPartition() {
        return this.supportPartition;
    }

    public int getSysPartitionNum() {
        return this.sysPartitionNum;
    }

    public String getDiskPoolInfo() {
        return this.diskPoolInfo;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getBucketID() {
        return this.bucketID;
    }

    public String getCanonicalID() {
        return this.canonicalID;
    }

    public void initDiskPoolMap() {
        List diskPoolList = JSONArray.parseArray((String)this.getDiskPoolInfo(), Map.class);
        if (CollectionUtils.isEmpty((Collection)diskPoolList)) {
            return;
        }
        this.diskPoolMap = new HashMap<Integer, DiskPoolInfo>();
        for (Map diskPool : diskPoolList) {
            String mediaType = null;
            if (diskPool.get("mediaType") instanceof String) {
                mediaType = (String)diskPool.get("mediaType");
            }
            int diskPoolId = (Integer)diskPool.get("diskPoolId");
            int storagePoolId = (Integer)diskPool.get("storagePoolId");
            JSONObject duObject = (JSONObject)diskPool.get("durabilityDetailed");
            int mValue = (Integer)duObject.get((Object)"m");
            int nValue = (Integer)duObject.get((Object)"n");
            DiskPoolInfo diskPoolInfoObj = new DiskPoolInfo(diskPoolId, nValue, mValue, mediaType, storagePoolId);
            this.diskPoolMap.put(diskPoolId, diskPoolInfoObj);
        }
    }

    public void setDiskPoolMap(Map<Integer, DiskPoolInfo> diskPoolMap) {
        this.diskPoolMap = diskPoolMap;
    }

    public Map<Integer, DiskPoolInfo> getDiskPoolMap() {
        return this.diskPoolMap;
    }

    public long getPartMetaRepairSpan() {
        return this.partMetaRepairSpan;
    }

    public boolean isSupportOrigBucket() {
        return this.supportOrigBucket;
    }

    public boolean getMetaSearchSwitch() {
        return this.metaSearchSwitch;
    }

    public int getMaxMetaIndexKeyNumber() {
        return this.maxMetaIndexKeyNumber;
    }

    public String getPoolType() {
        return this.poolType;
    }

    public boolean isObjectEnable() {
        return this.objectEnable;
    }

    public boolean isHDFSEnable() {
        return this.hdfsEnable;
    }

    public boolean isAccountVersionCheckEnable() {
        return this.accountCheckVersionEnable;
    }

    public boolean isNASEnable() {
        return this.nasEnable;
    }

    public boolean isNeedForwardSwitch() {
        return this.isNeedForwardSwitch;
    }

    public String getDefaultBucketType() {
        return this.defaultBucketType;
    }

    public boolean isMD5Enable() {
        return this.md5Enable;
    }

    public int getEdsFlushSize() {
        return this.edsFlushSize;
    }

    public boolean isNeedImportAccounts() {
        return this.needImportAccounts;
    }

    public String getContentTypeDefaultValue() {
        return this.contentTypeDefaultValue;
    }

    public boolean getMobileSwitch() {
        return this.mobileSwitch;
    }

    public String getMobileInnerClientIpList() {
        return this.mobileInnerClientIpList;
    }

    public long getMobileStatisticInterval() {
        return this.mobileStatisticInterval;
    }

    public boolean isDeleteAccountAsync() {
        return this.isDeleteAccountAsync;
    }

    public long getMaxInitializingTime4Repair() {
        return this.maxInitializingTime4Repair;
    }

    public long getMaxInitializedTime4Repair() {
        return this.maxInitializedTime4Repair;
    }

    public long getCheckInitUploadIdInterval() {
        return this.checkInitUploadIdInterval;
    }

    public long getCheckInitUploadIdFailedInterval() {
        return this.checkUploadFailedInterval;
    }

    public long getDelEmptyObjDirInterval4Repair() {
        return this.delEmptyObjDirInterval4Repair;
    }

    public String getZkAuthUserName() {
        return this.zkAuthUserName;
    }

    public String getZkAuthPassWord() {
        return this.zkAuthPassWord;
    }

    public int getMaxMultiPartObjFullPathLength() {
        return this.maxMultiPartObjFullPathLength;
    }

    public boolean isAdldapUserPolicyEnable() {
        return this.adldapUserPolicyEnable;
    }

    public boolean isClusterAutoSwitch() {
        return this.isClusterAutoSwitch;
    }

    public int getClusterAutoSwitchTime() {
        return this.clusterAutoSwitchTime;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    public boolean isSupportCircularDeleteDir() {
        return this.isSupportCircularDeleteDir;
    }

    public boolean isCheckCompressMetadataSize() {
        return this.isCheckCompressMetadataSize;
    }

    public boolean isOscHttpSwitch() {
        return this.isOscHttpSwitch;
    }

    public int getPocLevel() {
        return this.pocLevel;
    }

    public boolean isFtdsStatOn() {
        return this.isFtdsStatOn;
    }

    public String getRbfNodeList() {
        return this.rbfNodeList;
    }

    public boolean isHttpClientNormalizeSwitchOpen() {
        return this.isHttpClientNormalizeSwitchOpen;
    }

    public boolean isPathTransferVirtualHost() {
        return this.isPathTransferVirtualHost;
    }

    public boolean isRangerPolicySaveToLocalFile() {
        return this.isRangerPolicySaveToLocalFile;
    }

    public long getRangerPolicyTotalSize() {
        return this.rangerPolicyTotalSize;
    }

    public boolean isForceDeleteDir() {
        return this.isForceDeleteDir;
    }

    public String getMemAlarmThreshold() {
        return this.memAlarmThreshold;
    }

    public String getTierStorageClass() {
        return this.tierStorageClass;
    }

    public int getMaxRegionNumber() {
        return this.maxRegionNumber;
    }

    public int getTierVendor() {
        return this.tierVendor;
    }

    public int getTierMaxSegSize() {
        return this.tierMaxSegSize;
    }

    public long getCpuMonitorPeriod() {
        return this.cpuMonitorPeriod;
    }
}

