/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.system;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;
import uds.common.config.interf.PropertiesConfigBuilderManager;

public class UpgradeStatusConfig
extends AbstractConfigPraser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeStatusConfig.class);
    private boolean isInUpgradeOrRollback = false;

    public synchronized void loadConfigFile(String propertyfile) throws ConfigurationException {
        PropertiesConfigBuilder configBuilder = PropertiesConfigBuilderManager.getInstance().getPropertiesConfigBuilder(propertyfile, Character.valueOf('|'));
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration upgradeStatusProperties = this.getConfig();
        this.isInUpgradeOrRollback = upgradeStatusProperties.getBoolean("in_upgrade_or_rollback", false);
    }

    public boolean isInUpgrade() {
        if (this.getConfig() == null) {
            return false;
        }
        return this.isInUpgradeOrRollback;
    }

    @Override
    public void reloadConfig() {
        if (this.getConfigBuilder() != null) {
            this.loadConfig();
        }
    }
}

