/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.task;

import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import uds.common.config.interf.AbstractConfigPraser;
import uds.common.config.interf.PropertiesConfigBuilder;

public class TaskConfig
extends AbstractConfigPraser {
    private int checkObjPriority;
    private int putObjRemotePriority;
    private int putObjAclRemotePriority;
    private int delObjRemotePriority;
    private int delUserDataPriority;
    private int repSwitchLib2DPriority;
    private int delUploadPartDataPriority;
    private int putMultipartObjRemotePriority;
    private int repairGroupPriority;
    private int dedupObjPriority;
    private int scanUserPriority;
    private int scanBucketPriority;
    private int checkBucketStatusPriority;
    private int maxLteCountForLtc;
    private int validateBucketObjectsTask;
    private int createHighperformanceBucketPriority;
    private int mdcPutBktSubResPriority;
    private int mdcScanBucketTaskPriority;
    private int notificationPublishTaskPriority;
    private int logicClockUpPeriod;
    private int logicClockSaveInterval;
    private int logicClockUpInterval;
    private int gcScanCloePlogInterval;
    private int scanDeletedObjectTaskPeriod;
    private int scanDeletedObjectTaskThread;
    private int deleteObjectTaskSize;
    private int logicClockRepeatInterval;
    private int gcUpdScanAbnormalPlogInterval;
    private int gcMaxPlogScanCount;
    private int gcMaxCreateLogicTime;
    private boolean isTestRepSwitchAction;
    private long testReplicationFinishTime;
    private long repSwitchBucketTaskRetryTime;
    private long clusterUserRepSwitchTaskRetryTime;
    private boolean checkObjectWithReplicationFinishTimeSwitch;
    private boolean isCheckObjectEtagSwitchOpen;
    private boolean isCheckObjectCreatetimeSwitchOpen;
    private boolean isCheckObjectDataSwitchOpen;
    private boolean isLifeCycleMidnightForTestOpen;
    private boolean isLifeCycleForTestSwitchOpen;
    private boolean isObjectCheckStatusRecordSwitchOpen;
    private String mdcReplicTaskPriority;
    private int scanLifecycleBucketTaskNum;
    private int scanObjectExpirationTaskNum;
    private int maxDedupMasterIdleTime;

    public void loadConfig(PropertiesConfigBuilder configBuilder) throws ConfigurationException {
        this.setConfigBuilder(configBuilder);
        configBuilder.registerForReloading(this);
        this.loadConfig();
    }

    private void loadConfig() {
        PropertiesConfiguration config = this.getConfig();
        if (config == null) {
            return;
        }
        this.checkObjPriority = config.getInt("check_object_priority", 4);
        this.putObjRemotePriority = config.getInt("put_obj_remote_dc_priortiy", 7);
        this.putObjAclRemotePriority = config.getInt("put_obj_acl_remote_dc_priority", 4);
        this.delObjRemotePriority = config.getInt("del_obj_remote_dc_priority", 4);
        this.delUserDataPriority = config.getInt("del_user_data_priority", 4);
        this.repSwitchLib2DPriority = config.getInt("rep_switch_lib2d_priority", 4);
        this.delUploadPartDataPriority = config.getInt("del_upload_part_priority", 4);
        this.putMultipartObjRemotePriority = config.getInt("put_multipart_obj_remote_priority", 7);
        this.dedupObjPriority = config.getInt("dedup_obj_priority", 4);
        this.scanUserPriority = config.getInt("scan_user_priority", 4);
        this.scanBucketPriority = config.getInt("scan_bucket_priority", 4);
        this.checkBucketStatusPriority = config.getInt("check_bucket_status_priority", 7);
        this.maxLteCountForLtc = config.getInt("max_lte_count_for_ltc", 500);
        this.validateBucketObjectsTask = config.getInt("validate_bucket_objects_priority", 4);
        this.createHighperformanceBucketPriority = config.getInt("create_highperformance_bucket_priority", 7);
        this.mdcPutBktSubResPriority = config.getInt("mdc_put_bkt_sub_res_priority", 7);
        this.mdcScanBucketTaskPriority = config.getInt("mdc_scan_bucket_task_priority", 7);
        this.notificationPublishTaskPriority = config.getInt("notification_publish_priority", 7);
        this.logicClockUpPeriod = config.getInt("logicclock_up_period", 5);
        this.logicClockRepeatInterval = config.getInt("logicclock_up_interval", 30);
        this.logicClockSaveInterval = config.getInt("logicclock_save_interval", 1);
        this.gcUpdScanAbnormalPlogInterval = config.getInt("scan_abnormalplog_interval", 60);
        this.gcMaxPlogScanCount = config.getInt("max_scanplogcount_interval", 10000);
        this.gcMaxCreateLogicTime = config.getInt("max_createlogictime_interval", 8640);
        this.gcScanCloePlogInterval = config.getInt("gc_scan_closeplog_interval", 1);
        this.isObjectCheckStatusRecordSwitchOpen = config.getBoolean("object_check_status_record_switch_open", false);
        this.scanDeletedObjectTaskPeriod = config.getInt("scan_deleted_object_task_period", 10);
        this.scanDeletedObjectTaskThread = config.getInt("scan_deleted_object_task_thread", 5);
        this.deleteObjectTaskSize = config.getInt("delete_object_task_size", 50);
        this.isLifeCycleForTestSwitchOpen = config.getBoolean("lifecycle_for_test_switch", false);
        this.isLifeCycleMidnightForTestOpen = config.getBoolean("lifecycle_midnight_for_test_switch", false);
        this.mdcReplicTaskPriority = config.getString("data_flow_control_level", "dynamic");
        this.isCheckObjectDataSwitchOpen = config.getBoolean("check_object_data_switch", true);
        this.isCheckObjectCreatetimeSwitchOpen = config.getBoolean("check_object_createtime_switch", true);
        this.isCheckObjectEtagSwitchOpen = config.getBoolean("check_object_etag_switch", true);
        this.checkObjectWithReplicationFinishTimeSwitch = config.getBoolean("check_object_with_replication_time_switch", true);
        this.clusterUserRepSwitchTaskRetryTime = config.getLong("repswitch_cluster_user_task_retry_time", 2400000L);
        this.repSwitchBucketTaskRetryTime = config.getLong("repswitch_bucket_task_retry_time", 600000L);
        this.testReplicationFinishTime = config.getLong("test_replication_finish_time", -1L);
        this.isTestRepSwitchAction = config.getBoolean("log_repswitch_action", true);
        this.scanLifecycleBucketTaskNum = config.getInt("scan_lifecycle_bucket_task_num", 10);
        this.scanObjectExpirationTaskNum = config.getInt("scan_object_expiration_task_num", 10);
        this.maxDedupMasterIdleTime = config.getInt("max_dedup_master_idle_time", 180);
    }

    @Override
    public void reloadConfig() {
        if (this.getConfig() != null) {
            this.loadConfig();
        }
    }

    public int getLogicClockUpPeriod() {
        return this.logicClockUpPeriod;
    }

    public int getUsgaeScanAbnormalPlogInterval() {
        return this.gcUpdScanAbnormalPlogInterval;
    }

    public int getGcMaxPlogScanCount() {
        return this.gcMaxPlogScanCount;
    }

    public int getGcMaxCreateLogicTime() {
        return this.gcMaxCreateLogicTime;
    }

    public int getLogicClockSaveInterval() {
        return this.logicClockSaveInterval;
    }

    public int getLogicClockUpInterval() {
        return this.logicClockUpInterval;
    }

    public int getGCScanInterval() {
        return this.gcScanCloePlogInterval;
    }

    public int getScanDeleteObjectPeriod() {
        return this.scanDeletedObjectTaskPeriod;
    }

    public int getScanDeleteObjectThread() {
        return this.scanDeletedObjectTaskThread;
    }

    public int getDeleteObjectTaskSize() {
        return this.deleteObjectTaskSize;
    }

    public int getCheckObjPriority() {
        return this.checkObjPriority;
    }

    public int getPutObjRemotePriority() {
        return this.putObjRemotePriority;
    }

    public void setPutObjRemotePriority(int putObjRemotePriority) {
        this.putObjRemotePriority = putObjRemotePriority;
    }

    public int getPutObjAclRemotePriority() {
        return this.putObjAclRemotePriority;
    }

    public void setPutObjAclRemotePriority(int putObjAclRemotePriority) {
        this.putObjAclRemotePriority = putObjAclRemotePriority;
    }

    public int getDelObjRemotePriority() {
        return this.delObjRemotePriority;
    }

    public void setDelObjRemotePriority(int delObjRemotePriority) {
        this.delObjRemotePriority = delObjRemotePriority;
    }

    public int getDelUserDataPriority() {
        return this.delUserDataPriority;
    }

    public void setDelUserDataPriority(int delUserDataPriority) {
        this.delUserDataPriority = delUserDataPriority;
    }

    public int getDelUploadPartDataPriority() {
        return this.delUploadPartDataPriority;
    }

    public void setDelUploadPartDataPriority(int delUploadPartDataPriority) {
        this.delUploadPartDataPriority = delUploadPartDataPriority;
    }

    public int getPutMultipartObjRemotePriority() {
        return this.putMultipartObjRemotePriority;
    }

    public void setPutMultipartObjRemotePriority(int putMultipartObjRemotePriority) {
        this.putMultipartObjRemotePriority = putMultipartObjRemotePriority;
    }

    public int getRepairGroupPriority() {
        return this.repairGroupPriority;
    }

    public void setRepairGroupPriority(int repairGroupPriority) {
        this.repairGroupPriority = repairGroupPriority;
    }

    public int getDedupObjPriority() {
        return this.dedupObjPriority;
    }

    public void setDedupObjPriority(int dedupObjPriority) {
        this.dedupObjPriority = dedupObjPriority;
    }

    public int getScanUserPriority() {
        return this.scanUserPriority;
    }

    public void setScanUserPriority(int scanUserPriority) {
        this.scanUserPriority = scanUserPriority;
    }

    public int getScanBucketPriority() {
        return this.scanBucketPriority;
    }

    public void setScanBucketPriority(int scanBucketPriority) {
        this.scanBucketPriority = scanBucketPriority;
    }

    public int getCheckBucketStatusPriority() {
        return this.checkBucketStatusPriority;
    }

    public void setCheckBucketStatusPriority(int checkBucketStatusPriority) {
        this.checkBucketStatusPriority = checkBucketStatusPriority;
    }

    public int getValidateBucketObjectsTask() {
        return this.validateBucketObjectsTask;
    }

    public void setValidateBucketObjectsTask(int validateBucketObjectsTask) {
        this.validateBucketObjectsTask = validateBucketObjectsTask;
    }

    public int getMaxLteCountForLtc() {
        return this.maxLteCountForLtc;
    }

    public String getJobIdByEntryType(String entryType) {
        return this.getString(entryType + "_litetask_jobid", entryType);
    }

    public int getJobPriorityByEntryType(String entryType) {
        return this.getInt(entryType + "_litetask_jobpriority", 0);
    }

    public int getJobJobtypeByEntryType(String entryType) {
        return this.getInt(entryType + "_litetask_jobtype", 0);
    }

    public int getJobRetryByEntryType(String entryType) {
        return this.getInt(entryType + "_litetask_jobretry", 0);
    }

    public int getJobTimeOutByEntryType(String entryType) {
        return this.getInt(entryType + "_litetask_jobtimeout", 0);
    }

    public int getMdcPutBktSubResPriority() {
        return this.mdcPutBktSubResPriority;
    }

    public void setMdcPutBktSubResPriority(int mdcPutBktSubResPriority) {
        this.mdcPutBktSubResPriority = mdcPutBktSubResPriority;
    }

    public boolean isObjectCheckStatusRecordSwitchOpen() {
        return this.isObjectCheckStatusRecordSwitchOpen;
    }

    public boolean isLifeCycleForTestSwitchOpen() {
        return this.isLifeCycleForTestSwitchOpen;
    }

    public boolean isLifeCycleMidnightForTestOpen() {
        return this.isLifeCycleMidnightForTestOpen;
    }

    public int getCreateHighperformanceBucketPriority() {
        return this.createHighperformanceBucketPriority;
    }

    public void setCreateHighperformanceBucketPriority(int createHighperformanceBucketPriority) {
        this.createHighperformanceBucketPriority = createHighperformanceBucketPriority;
    }

    public int getMdcScanBucketTaskPriority() {
        return this.mdcScanBucketTaskPriority;
    }

    public void setMdcScanBucketTaskPriority(int mdcScanBucketTaskPriority) {
        this.mdcScanBucketTaskPriority = mdcScanBucketTaskPriority;
    }

    public String getMdcReplicTaskPriority() {
        return this.mdcReplicTaskPriority;
    }

    public int getNotificationPublishTaskPriority() {
        return this.notificationPublishTaskPriority;
    }

    public void setNotificationPublishTaskPriority(int notificationPublishTaskPriority) {
        this.notificationPublishTaskPriority = notificationPublishTaskPriority;
    }

    public boolean isCheckObjectDataSwitchOpen() {
        return this.isCheckObjectDataSwitchOpen;
    }

    public boolean isCheckObjectCreatetimeSwitchOpen() {
        return this.isCheckObjectCreatetimeSwitchOpen;
    }

    public boolean isCheckObjectEtagSwitchOpen() {
        return this.isCheckObjectEtagSwitchOpen;
    }

    public boolean checkObjectWithReplicationFinishTimeSwitch() {
        return this.checkObjectWithReplicationFinishTimeSwitch;
    }

    public void setCheckObjectWithReplicationFinishTimeSwitch(PropertiesConfiguration config, boolean set) {
        config.setProperty("check_object_with_replication_time_switch", (Object)set);
    }

    public void setClusterUserRepSwitchTaskRetryTime(PropertiesConfiguration config, long time) {
        config.setProperty("repswitch_cluster_user_task_retry_time", (Object)time);
    }

    public long getClusterUserRepSwitchTaskRetryTime() {
        return this.clusterUserRepSwitchTaskRetryTime;
    }

    public void setRepSwitchBucketTaskRetryTime(PropertiesConfiguration config, long time) {
        config.setProperty("repswitch_bucket_task_retry_time", (Object)time);
    }

    public long getRepSwitchBucketTaskRetryTime() {
        return this.repSwitchBucketTaskRetryTime;
    }

    public long getTestReplicationFinishTime() {
        return this.testReplicationFinishTime;
    }

    public boolean getTestRepSwitchAction() {
        return this.isTestRepSwitchAction;
    }

    public void setTestReplicationFinishTime(PropertiesConfiguration config, long set) {
        config.setProperty("test_replication_finish_time", (Object)set);
    }

    public int getRepSwitchLib2DPriority() {
        return this.repSwitchLib2DPriority;
    }

    public void setRepSwitchLib2DPriority(int repSwitchLib2DPriority) {
        this.repSwitchLib2DPriority = repSwitchLib2DPriority;
    }

    public int getScanLifecycleBucketTaskNum() {
        return this.scanLifecycleBucketTaskNum;
    }

    public int getScanObjectExpirationTaskNum() {
        return this.scanObjectExpirationTaskNum;
    }

    public int getMaxDedupMasterIdleTime() {
        return this.maxDedupMasterIdleTime;
    }

    public int getLogicClockRepeatInterval() {
        return this.logicClockRepeatInterval;
    }
}

