/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String DOMAIN_REGEX_PRE = "^(https?://)([^/]+)\\.(";
    private static final String DOMAIN_REGEX_POST = "(?::\\d+)?)/?(.*)$";

    public static void sleepQuiet(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static String toAbsolutePath(String filePath, ClassLoader classLoader) {
        if (filePath == null || StringUtils.isEmpty((CharSequence)filePath.trim())) {
            return null;
        }
        return filePath;
    }

    public static List<Pattern> buildRegexPattern(List<String> allDomain) {
        ArrayList<Pattern> allPattern = new ArrayList<Pattern>();
        if (allDomain == null || allDomain.isEmpty()) {
            return allPattern;
        }
        for (String domain : allDomain) {
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(DOMAIN_REGEX_PRE);
            regexBuilder.append(StringUtils.replace((String)domain, (String)".", (String)"\\."));
            regexBuilder.append(DOMAIN_REGEX_POST);
            allPattern.add(Pattern.compile(regexBuilder.toString(), 2));
        }
        return allPattern;
    }
}

