/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainUtils.class);
    public static final String MULTI_DOMAIN_SPLIT_SIGN = ";";

    public static final List<String> getAllDomain(String domain) {
        List<String> allDomain = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            String[] domainArr = domain.split(MULTI_DOMAIN_SPLIT_SIGN);
            allDomain = Arrays.asList(domainArr);
        }
        LOGGER.debug("domain list is[{}]", allDomain);
        return allDomain;
    }

    public static final Matcher matchDomain(String domain, List<Pattern> patterns) {
        Matcher matcher = null;
        if (patterns == null || patterns.isEmpty()) {
            LOGGER.warn("patterns{} is null", patterns);
            return matcher;
        }
        for (Pattern pattern : patterns) {
            matcher = pattern.matcher(domain);
            if (!matcher.matches()) continue;
            LOGGER.debug("is match.[{}/{}]", (Object)domain, (Object)pattern);
            return matcher;
        }
        LOGGER.debug("not match[{}/{}]", (Object)domain, patterns);
        return null;
    }
}

