/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OBSThreadPoolFactory {
    private static final int DEFAULT_KEEP_ALIVE_TIME = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(OBSThreadPoolFactory.class);

    public static ScheduledExecutorService createThreadPool(int poolSize, final String poolName) {
        return new ScheduledThreadPoolExecutor(poolSize, new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, poolName + "-" + this.threadNumber.getAndIncrement());
                thread.setUncaughtExceptionHandler((t, exception) -> LOGGER.warn(String.format("Thread %s occur exception: ", t.getName()), exception));
                return thread;
            }
        });
    }

    public static ThreadPoolExecutor createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, final String namePrefix) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new ThreadFactory(){
            private AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                String tName = namePrefix + "-" + this.index.incrementAndGet();
                return new Thread(runnable, tName);
            }
        });
    }

    public static ThreadPoolExecutor createThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, final String namePrefix, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new ThreadFactory(){
            private AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                String tName = namePrefix + "-" + this.index.incrementAndGet();
                return new Thread(runnable, tName);
            }
        }, handler);
    }

    public static ThreadPoolExecutor createThreadPool(int poolSize, int queueSize, String namePrefix) {
        return OBSThreadPoolFactory.createThreadPool(poolSize, poolSize, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), namePrefix);
    }

    public static ThreadPoolExecutor createAutoExtendThreadPool(int poolSize, int maxSize, int queueSize, String namePrefix) {
        return OBSThreadPoolFactory.createThreadPool(poolSize, maxSize, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), namePrefix);
    }
}

