/*
 * Decompiled with CFR 0.152.
 */
package uds.common.config.util;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.ConfigLoadPredicate;
import uds.common.config.interf.AbstractReloadHandler;
import uds.common.config.util.ConfigUtil;

public class ReloadFileManager
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadFileManager.class);
    private static final long SLEEP_TIME = 2000L;
    private final List<AbstractReloadHandler> registeredLoader;
    private ConfigLoadPredicate configLoadPredicate = ConfigLoadPredicate.DEFAULT;

    public ReloadFileManager(List<AbstractReloadHandler> loader) {
        this.registeredLoader = loader;
    }

    @Override
    public void run() {
        boolean hasSleep = false;
        try {
            if (this.registeredLoader == null || this.registeredLoader.isEmpty()) {
                LOGGER.debug("No registered file");
                return;
            }
            if (!this.configLoadPredicate.loadNow()) {
                return;
            }
            for (AbstractReloadHandler handler : this.registeredLoader) {
                if (!handler.isFileModified()) continue;
                if (!hasSleep) {
                    ConfigUtil.sleepQuiet(2000L);
                    hasSleep = true;
                }
                this.notifyFileHandle(handler);
                File file = new File(handler.getFilename());
                LOGGER.warn("File is changed." + file.getName() + " class name: " + handler.getClass());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("reload handler error!", e);
        }
    }

    private void notifyFileHandle(AbstractReloadHandler handler) {
        try {
            handler.handle();
        }
        catch (Throwable e) {
            LOGGER.warn("Handle file failed.", e);
        }
    }

    public void setConfigLoadPredicate(ConfigLoadPredicate configLoadPredicate) {
        this.configLoadPredicate = configLoadPredicate;
    }
}

