/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl;

public interface AclConstants {
    public static final String KERBEROS_MODE = "kerberos";
    public static final String SIMPLE_MODE = "simple";
    public static final String NAMESPACE_ID = "plugin.hdfs.namespace.id";
    public static final String CONFIG_WATCH_DIR = "/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl";
    public static final String CONFIG_EXTENSION_NAME = "xml";

    public static enum ObsTaskConfig {
        THIRD_ACL_POLICY_PERIOD("set_ranger_policies_task_delay", 500L),
        CHECK_CONFIG_WATCH_DIR_TASK_DELAY("check_config_watch_dir_task_delay", 5L);

        private final String configKey;
        private final Object defaultValue;

        public long getDefaultValueLong() throws NumberFormatException {
            if (this.defaultValue instanceof Long) {
                return (Long)this.defaultValue;
            }
            return Long.parseLong(this.defaultValue.toString());
        }

        private ObsTaskConfig(String configKey, Object defaultValue) {
            this.configKey = configKey;
            this.defaultValue = defaultValue;
        }

        public String getConfigKey() {
            return this.configKey;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    public static enum FileData {
        DIRECTORY_PATH("/opt/dfv/obs_service_layer/objectwebservice/osc/plugin/policycache"),
        ACL_DATA_SUFFIX("acl"),
        ACL_TEMP_DATA_SUFFIX("temp");

        private final String value;

        private FileData(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface Ranger {
        public static final String RANGER_PLUGIN_SERVICE_NAME = "ranger.plugin.hdfs.service.name";
        public static final String RANGER_PLUGIN_HDFS_RESE_URL = "ranger.plugin.hdfs.policy.rest.url";
        public static final String RANGER_PLUGIN_HDFS_TIMEZONE = "ranger.plugin.hdfs.timezone";
        public static final String DEFAULT_APP_ID = "hdfs";
        public static final String PROPERTY_PREFIX = "ranger.plugin.hdfs";
        public static final String POLL_INTERVAL_MS = "plugin.hdfs.policy.pollIntervalMs";
        public static final String DISABLE_CACHE_IF_SERVICE_NOT_FOUND = "ranger.plugin.hdfs.disable.cache.if.servicenotfound";
        public static final String SECURITY_MODE = "ranger.hdfs.service.security.mode";
        public static final String RANGER_SERVER_PRINCIPAL = "ranger.hdfs.service.server.principal";
        public static final String RANGER_KERBEROS_KEYTAB = "ranger.hdfs.service.server.keytab";

        public static interface Validator {
            public static final String MAX_POLICY_PER_NAMESPACE = "ranger_policy_max_number_of_namespace";
            public static final int MAX_POLICY_PER_NAMESPACE_DEFAULT = 100;
            public static final String MAX_PATH_PER_POLICY = "ranger_policy_max_path_number_of_policy";
            public static final int MAX_PATH_PER_POLICY_DEFAULT = 10;
            public static final String MAX_VALIDITY_SCHEDULE_PER_POLICY = "ranger_policy_max_effective_period_number_of_policy";
            public static final int MAX_VALIDITY_SCHEDULE_PER_POLICY_DEFAULT = 10;
            public static final String MAX_ITEM_PER_POLICY = "ranger_policy_max_item_number_of_policy";
            public static final int MAX_ITEM_PER_POLICY_DEFAULT = 20;
            public static final String MAX_USER_GROUP_PER_POLICY_ITEM = "ranger_policy_max_user_number_of_policy_item";
            public static final int MAX_USER_GROUP_PER_POLICY_ITEM_DEFAULT = 10;
        }
    }

    public static interface Sentry {
        public static final String SERVER_RPC_PORT = "sentry.hdfs.service.client.server.rpc-port";
        public static final int SERVER_RPC_PORT_DEFAULT = 8038;
        public static final String SERVER_RPC_ADDRESS = "sentry.hdfs.service.client.server.rpc-addresses";
        public static final int DEFAULT_SINGLE_POOL_SIZE = 10;
        public static final String SECURITY_MODE = "sentry.hdfs.service.security.mode";
        public static final String SECURITY_USE_UGI_TRANSPORT = "sentry.hdfs.service.security.use.ugi";
        public static final String SENTRY_RPC_RETRY_TOTAL = "sentry.service.client.rpc.retry-total";
        public static final int SENTRY_RPC_RETRY_TOTAL_DEFAULT = 2;
        public static final String SERVER_RPC_CONN_RETRY_DELAY_MS = "sentry.service.client.rpc.retry.interval.msec";
        public static final long SERVER_RPC_CONN_RETRY_DELAY_MS_DEFAULT = 500L;
        public static final String SENTRY_SERVER_PRINCIPAL = "sentry.hdfs.service.server.principal";
        public static final String SENTRY_KERBEROS_KEYTAB = "sentry.hdfs.service.server.keytab";
        public static final String SERVER_RPC_CONN_TIMEOUT = "sentry.hdfs.service.client.server.rpc-connection-timeout";
        public static final int SERVER_RPC_CONN_TIMEOUT_DEFAULT = 1200000;
        public static final String SENTRY_POOL_MAX_TOTAL = "sentry.hdfs.service.client.connection.pool.max-total";
        public static final int SENTRY_POOL_MAX_TOTAL_DEFAULT = 16;
        public static final String SENTRY_POOL_MIN_EVICTION_TIME_SEC = "sentry.hdfs.service.client.connection.pool.eviction.mintime.sec";
        public static final long SENTRY_POOL_MIN_EVICTION_TIME_SEC_DEFAULT = 0L;
        public static final String SENTRY_POOL_EVICTION_INTERVAL_SEC = "sentry.hdfs.service.client.connection.pool.eviction.interval.sec";
        public static final long SENTRY_POOL_EVICTION_INTERVAL_SEC_DEFAULT = -1L;
        public static final String SENTRY_CLIENT_LOAD_BALANCING = "sentry.service.client.connection.loadbalance";
        public static final boolean IS_SENTRY_CLIENT_LOAD_BALANCING_DEFAULT = true;
        public static final String SENTRY_POOL_ENABLE = "sentry.hdfs.service.client.connection.pool.enable";
        public static final boolean IS_SENTRY_POOL_ENABLE_DEFAULT = false;
        public static final String SENTRY_USE_COMPACT_TRANSPORT = "sentry.hdfs.service.client.compact.transport";
        public static final boolean CAN_SENTRY_USE_COMPACT_TRANSPORT_DEFAULT = false;
        public static final String SENTRY_HDFS_THRIFT_MAX_MESSAGE_SIZE = "sentry.hdfs.thrift.max.message.size";
        public static final long SENTRY_HDFS_THRIFT_MAX_MESSAGE_SIZE_DEFAULT = 0x6400000L;
        public static final long UNUSED_PATH_UPDATE_IMG_NUM = -1L;
        public static final String SENTRY_USE_OLD_SENTRY_SERVER = "sentry.hdfs.service.client.old.server";
        public static final boolean IS_SENTRY_USE_OLD_SENTRY_SERVER_DEFAULT = false;

        public static interface Validator {
            public static final String MAX_PATH_COUNT_PER_NAMESPACE = "sentry_policy_max_number_of_namespace";
            public static final int MAX_PATH_COUNT_PER_NAMESPACE_DEFAULT = 200;
            public static final String MAX_ROLE_PER_PATH = "sentry_policy_max_role_count_of_path";
            public static final int MAX_ROLE_PER_PATH_DEFAULT = 10;
            public static final String MAX_UG_COUNT_PER_PATH = "sentry_policy_max_ug_count_of_path";
            public static final int MAX_UG_COUNT_PER_PATH_DEFAULT = 10;
        }
    }

    public static interface Alarm {
        public static final String ALARM_FAIL_COUNT_THRESHOLD_CONFIG = "ranger_alarm_failed_count_threshold";
        public static final int ALARM_FAIL_COUNT_THRESHOLD_DEFAULT = 10;
    }

    public static interface Common {
        public static final String VERSION_INNER_SPLIT_CHAR = "#";
        public static final String VERSION_INTRA_SPLIT_CHAR = ";";
        public static final char PRETTY_TAB_CHAR = '\t';
        public static final String PLUGIN_NAMESPACE_ID = "plugin.hdfs.namespace.id";
    }

    public static interface Type {
        public static final String PLUGIN_TYPE_RANGER = "ranger";
        public static final String PLUGIN_TYPE_SENTRY = "sentry";
    }
}

