/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.alarm;

import com.huawei.osc.acl.AclInfoAdapter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.alarm.AlarmReporterImpl;
import uds.common.alarm.enumeration.AlarmLevel;
import uds.common.alarm.enumeration.AlarmType;
import uds.common.alarm.exception.SendAlarmFailedException;
import uds.common.config.interf.OBSConfig;
import uds.common.config.util.OBSThreadPoolFactory;

public class ThirdAclServerStatusMonitor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAclServerStatusMonitor.class);
    private static final ThirdAclServerStatusMonitor INSTANCE = new ThirdAclServerStatusMonitor();
    private static final long TASK_PERIOD = 5L;
    private final Set<String> alarmedHost = new HashSet<String>();
    private final Set<String> resumedHost = new HashSet<String>();
    private final Set<AclInfoAdapter> samples = new HashSet<AclInfoAdapter>();
    private volatile ScheduledExecutorService executor;
    private long alarmThreshold;

    private ThirdAclServerStatusMonitor() {
    }

    public static ThirdAclServerStatusMonitor getInstance() {
        return INSTANCE;
    }

    public synchronized void register(AclInfoAdapter aclInfoAdapter) {
        this.samples.add(aclInfoAdapter);
    }

    public synchronized void unregister(AclInfoAdapter aclInfoAdapter) {
        this.samples.remove(aclInfoAdapter);
        try {
            this.doResume(ThirdAclServerStatusMonitor.buildAlarmInfo(aclInfoAdapter));
        }
        catch (SendAlarmFailedException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "resume acl alarm failed, info=%s", ThirdAclServerStatusMonitor.buildAlarmInfo(aclInfoAdapter)), (Throwable)e);
        }
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = OBSThreadPoolFactory.createThreadPool((int)1, (String)"third-acl-plugin-monitor-task");
            this.executor.scheduleWithFixedDelay(INSTANCE, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void run() {
        try {
            this.alarmThreshold = OBSConfig.getInstance().getInt("ranger_alarm_failed_count_threshold", 10);
            this.doAlarmOrResume();
        }
        catch (SendAlarmFailedException e) {
            LOGGER.error("send or resume alarm failed!", (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("send or resume alarm error!!!", t);
        }
    }

    private synchronized void doAlarmOrResume() throws SendAlarmFailedException {
        for (AclInfoAdapter aclInfoAdapter : this.samples) {
            String alarmInfo = ThirdAclServerStatusMonitor.buildAlarmInfo(aclInfoAdapter);
            if (aclInfoAdapter.getContinuousFailedNums() > this.alarmThreshold && !this.alarmedHost.contains(alarmInfo)) {
                this.doAlarm(alarmInfo);
            }
            if (aclInfoAdapter.getContinuousFailedNums() != 0L || this.resumedHost.contains(alarmInfo)) continue;
            this.doResume(alarmInfo);
        }
    }

    private void doResume(String alarmInfo) throws SendAlarmFailedException {
        AlarmReporterImpl.getInstance().sendAlarm(68356931592L, AlarmType.RESUME_ALARM, AlarmLevel.MAJOR_ALARM, OBSConfig.getInstance().getCurrentComponent(), alarmInfo, null, false);
        this.resumedHost.add(alarmInfo);
        this.alarmedHost.remove(alarmInfo);
    }

    private void doAlarm(String alarmInfo) throws SendAlarmFailedException {
        AlarmReporterImpl.getInstance().sendAlarm(68356931592L, AlarmType.REPORT_ALARM, AlarmLevel.MAJOR_ALARM, OBSConfig.getInstance().getCurrentComponent(), alarmInfo, null, false);
        this.alarmedHost.add(alarmInfo);
        this.resumedHost.remove(alarmInfo);
    }

    private static String buildAlarmInfo(AclInfoAdapter acl) {
        return String.format(Locale.ROOT, "[%s] namespaceId[%d]", acl.getHost(), acl.getNamespaceId());
    }
}

