/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.auth;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosUtil {
    private static final Logger log = LoggerFactory.getLogger(KerberosUtil.class);
    private static final String COM_L = "RULE:[2:$1@$0](.*@%s$)s/@%s//L";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";

    public static UserGroupInformation configKerberos(Configuration pluginConfig) {
        String serviceType = pluginConfig.get("plugin.hdfs.servicetype");
        String keytab = "";
        String principal = "";
        if (StringUtils.equals((CharSequence)serviceType, (CharSequence)"ranger")) {
            keytab = pluginConfig.get("ranger.hdfs.service.server.keytab");
            principal = pluginConfig.get("ranger.hdfs.service.server.principal");
        } else if (StringUtils.equals((CharSequence)serviceType, (CharSequence)"sentry")) {
            keytab = pluginConfig.get("sentry.hdfs.service.server.keytab");
            principal = pluginConfig.get("sentry.hdfs.service.server.principal");
        } else {
            log.debug("unexpected servicetype: {} ", (Object)serviceType);
        }
        if (StringUtils.isEmpty((CharSequence)keytab)) {
            log.error("Empty keytab file");
            throw new IllegalArgumentException("Empty keytab file");
        }
        File file = new File(keytab);
        if (!file.exists()) {
            log.error("Keytab file {} doesn't exist", (Object)keytab);
            throw new IllegalArgumentException("Keytab file " + keytab + " doesn't exist");
        }
        try {
            Keytab kt = Keytab.loadKeytab((File)file);
            List principals = kt.getPrincipals();
            if (principals.size() == 0) {
                throw new IllegalArgumentException("Keytab file " + keytab + " with empty principal.");
            }
            return KerberosUtil.loginFromPrincipalAndKeytab(serviceType, keytab, principal, principals);
        }
        catch (IOException exception) {
            log.error("Kerberos login failed, ", (Throwable)exception);
            throw new IllegalArgumentException("Kerberos login failed, ", exception);
        }
    }

    private static UserGroupInformation loginFromPrincipalAndKeytab(String serviceType, String keytab, String principal, List<PrincipalName> principals) throws IOException {
        Configuration conf = new Configuration();
        String[] principalParts = SaslRpcServer.splitKerberosName((String)principal);
        if (principalParts.length != 3) {
            throw new IOException("Principal of kerberos not match 3 parts: " + principal);
        }
        conf.set("hadoop.security.authentication", "Kerberos");
        conf.set("hadoop.security.auth_to_local", String.format(Locale.ENGLISH, COM_L, principalParts[2], principalParts[2]));
        UserGroupInformation.setConfiguration((Configuration)conf);
        String name = "";
        if (StringUtils.equals((CharSequence)serviceType, (CharSequence)"ranger")) {
            name = principal;
        } else if (StringUtils.equals((CharSequence)serviceType, (CharSequence)"sentry")) {
            name = principals.get(0).getName();
        } else {
            log.debug("unexpected servicetype: {} ", (Object)serviceType);
        }
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)name, (String)keytab);
        log.info("Auth sync with kerberos, name: {}, keytab: {}", (Object)name, (Object)keytab);
        return ugi;
    }

    public static String getFinalUrl(String url) throws UnknownHostException {
        String ipOrFQDN;
        String finalUrl = "";
        if (url.startsWith(HTTP_PROTOCOL)) {
            finalUrl = finalUrl + HTTP_PROTOCOL;
            ipOrFQDN = url.substring(HTTP_PROTOCOL.length());
        } else {
            finalUrl = finalUrl + HTTPS_PROTOCOL;
            ipOrFQDN = url.substring(HTTPS_PROTOCOL.length());
        }
        String port = "";
        if (ipOrFQDN.contains(":")) {
            int portStart = ipOrFQDN.indexOf(":");
            port = ipOrFQDN.substring(portStart);
            ipOrFQDN = ipOrFQDN.substring(0, portStart);
        }
        InetAddress in = InetAddress.getByName(ipOrFQDN);
        ipOrFQDN = in.getHostName();
        finalUrl = finalUrl + ipOrFQDN + port;
        return finalUrl;
    }
}

