/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.common;

import com.huawei.osc.acl.common.JsonSerializeUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.memcache.impl.TODistributedCacheClient;
import uds.common.memcache.interf.DistributedCacheError;
import uds.common.memcache.interf.entity.CacheResult;

public enum CommonMemCacheUtil {
    INSTANCE;

    private static final Logger log;
    private TODistributedCacheClient cacheClient = new TODistributedCacheClient();

    public <T> Optional<T> get(String key, Class<T> valueType) {
        Optional result = Optional.empty();
        try {
            Object value = this.cacheClient.get(key);
            result = JsonSerializeUtils.deserialize(value, valueType);
            log.debug("get key[{}] from memCache success", (Object)key);
        }
        catch (DistributedCacheError distributedCacheError) {
            log.warn("get key[{}] from memCache failed", (Object)key);
        }
        return result;
    }

    public <T> Optional<T> getWithException(String key, Class<T> valueType) throws DistributedCacheError {
        Object value = this.cacheClient.get(key);
        return JsonSerializeUtils.deserialize(value, valueType);
    }

    public <T> boolean put(String key, T data) {
        return this.put(key, data, OBSConfig.memcache().getDataExpireTime());
    }

    public <T> boolean put(String key, T data, long memCacheExpireTime) {
        try {
            log.info("put key:[{}] to memCache", (Object)key);
            String serializedData = JsonSerializeUtils.serialize(data);
            CacheResult cacheResult = this.cacheClient.set(key, memCacheExpireTime, (Object)serializedData);
            if (!CacheResult.MEMSTORE.equals((Object)cacheResult)) {
                log.warn("Put Key[{}] to memCache failed.", (Object)key);
                return false;
            }
            log.info("Put key:[{}] to memCache, memCacheCacheExpireTime:[{}]", (Object)key, (Object)memCacheExpireTime);
            return true;
        }
        catch (DistributedCacheError e) {
            log.warn("Put Key:[{}] to memCache failed.", (Object)key, (Object)e);
            return false;
        }
    }

    public <T> boolean putPermanentData(String key, T data) {
        return this.put(key, data, 0L);
    }

    public boolean delete(String key) {
        try {
            log.info("==>delete key:[{}] from memCache", (Object)key);
            CacheResult cacheResult = this.cacheClient.delete(key);
            if (!CacheResult.MEMSTORE.equals((Object)cacheResult)) {
                log.error("delete Key[{}] from memCache failed.", (Object)key);
                return false;
            }
            log.info("<==delete key:[{}] from memCache", (Object)key);
            return true;
        }
        catch (DistributedCacheError e) {
            log.error("delete Key:[" + key + "] from memCache failed.", (Throwable)e);
            return false;
        }
    }

    static {
        log = LoggerFactory.getLogger(CommonMemCacheUtil.class);
    }
}

