/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.common;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class GeneralThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean isDaemon = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory defaultThreadFactory = null;

    public GeneralThreadFactoryBuilder setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
        return this;
    }

    public GeneralThreadFactoryBuilder setDaemon(Boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public GeneralThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public GeneralThreadFactoryBuilder setDefaultThreadFactory(ThreadFactory defaultThreadFactory) {
        this.defaultThreadFactory = defaultThreadFactory;
        return this;
    }

    public ThreadFactory build() {
        return GeneralThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(GeneralThreadFactoryBuilder builder) {
        ThreadFactory threadFactory = builder.defaultThreadFactory != null ? builder.defaultThreadFactory : Executors.defaultThreadFactory();
        return runnable -> {
            Thread thread = threadFactory.newThread(runnable);
            if (builder.nameFormat != null) {
                thread.setName(builder.nameFormat);
            }
            if (builder.isDaemon != null) {
                thread.setDaemon(builder.isDaemon);
            }
            if (builder.uncaughtExceptionHandler != null) {
                thread.setUncaughtExceptionHandler(builder.uncaughtExceptionHandler);
            }
            return thread;
        };
    }
}

