/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.common;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HostInfo {
    private final Scheme scheme;
    private final String host;
    private final int port;

    public HostInfo(Scheme scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public HostInfo(String host, int port) {
        this(null, host, port);
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static HostInfo fromString(Scheme scheme, String hostInfo, int defaultPort) {
        int idx = hostInfo.indexOf(":");
        if (idx > 0) {
            return new HostInfo(scheme, hostInfo.substring(0, idx), Integer.parseInt(hostInfo.substring(idx + 1)));
        }
        return new HostInfo(scheme, hostInfo, defaultPort);
    }

    public String toString() {
        return "HostInfo{scheme=" + (Object)((Object)this.scheme) + ", host='" + this.host + '\'' + ", port=" + this.port + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj instanceof Scheme) {
            return false;
        }
        if (!(obj instanceof HostInfo)) {
            return false;
        }
        HostInfo hostInfo = (HostInfo)obj;
        return new EqualsBuilder().append(this.port, hostInfo.port).append((Object)this.scheme, (Object)hostInfo.scheme).append((Object)this.host, (Object)hostInfo.host).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.scheme).append((Object)this.host).append(this.port).toHashCode();
    }

    public static enum Scheme {
        HTTP,
        HTTPS,
        THRIFT;

    }
}

