/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSerializeUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonSerializeUtils() {
    }

    public static <T> String serialize(T rawMeta) {
        if (rawMeta == null) {
            return "";
        }
        byte[] content = new byte[]{};
        try {
            content = OBJECT_MAPPER.writeValueAsBytes(rawMeta);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("serialize failed.", (Throwable)e);
        }
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64URLSafe((byte[])content));
    }

    public static <T, I> Optional<T> deserialize(I object, Class<T> valueType) {
        Object integerProfile;
        if (object == null) {
            return Optional.empty();
        }
        byte[] content = JsonSerializeUtils.objectToByte(object);
        try {
            integerProfile = OBJECT_MAPPER.readValue(content, valueType);
        }
        catch (IOException e) {
            LOGGER.warn("Deserialize failed.", (Throwable)e);
            integerProfile = null;
        }
        return Optional.ofNullable(integerProfile);
    }

    private static <T> byte[] objectToByte(T object) {
        String str = "";
        if (object instanceof String) {
            str = (String)object;
        } else {
            LOGGER.warn("The obj which need deserialize is not String : {}", object);
        }
        return Base64.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8));
    }
}

