/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.common;

import com.huawei.osc.acl.AclInfoAdapter;
import com.huawei.osc.acl.common.ConfigurationWrapper;
import com.huawei.osc.acl.ranger.OceanStorRangerHdfsPlugin;
import com.huawei.osc.acl.sentry.SentryAuthorizationInfoAdapter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.eds.client.ThirdAclPolicy;

public class ThirdAclUtils {
    private static final Logger log = LoggerFactory.getLogger(ThirdAclUtils.class);
    private static Map<String, String> alarmInfoMap = new HashMap<String, String>();

    public static Map<String, String> getAlarmInfoMap() {
        return alarmInfoMap;
    }

    public static int getNamespaceIdByConfigName(String config) {
        try {
            return Integer.parseInt(config.split("-")[2]);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static AclInfoAdapter buildAclInfoAdapterByConfig(String configFileName) {
        String[] parts = configFileName.split("-");
        if (!configFileName.endsWith("xml") || parts.length != 4 || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)parts[2])) {
            log.error("invalid file format skip... config={}", (Object)configFileName);
            return null;
        }
        String type = parts[0];
        int namespaceId = NumberUtils.toInt((String)parts[2], (int)-1);
        if (namespaceId <= 0) {
            log.warn("unsupported namespaceId[{}], skip..., config={}", (Object)namespaceId, (Object)configFileName);
            return null;
        }
        File file = new File("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl/" + configFileName);
        try {
            ConfigurationWrapper configurationWrapper = new ConfigurationWrapper(file.toURI().toURL());
            AclInfoAdapter plugin = null;
            if (StringUtils.equals((String)type, (String)"ranger")) {
                plugin = new OceanStorRangerHdfsPlugin(configurationWrapper);
            } else if (StringUtils.equals((String)type, (String)"sentry")) {
                plugin = new SentryAuthorizationInfoAdapter(configurationWrapper);
            } else {
                log.warn("unsupported third acl type, skip..., config={}", (Object)configFileName);
            }
            return plugin;
        }
        catch (Exception e) {
            log.error(String.format(Locale.ENGLISH, "load config failed, config=%s", configFileName), (Throwable)e);
            return null;
        }
    }

    public static ThirdAclPolicy buildDisablePolicy(int namespaceId) {
        return ThirdAclPolicy.builder().namespaceId(namespaceId).type(0).policies(Collections.emptyList()).build();
    }

    public static int getNamespaceIdByVersionValue(String version) {
        String[] parts = version.split("#");
        return NumberUtils.toInt((String)parts[1], (int)0);
    }

    public static Map<Integer, String> buildVersionMap(String versions) {
        if (StringUtils.isEmpty((String)versions)) {
            return new HashMap<Integer, String>();
        }
        return Arrays.stream(versions.split(";")).collect(Collectors.toMap(ThirdAclUtils::getNamespaceIdByVersionValue, Function.identity()));
    }

    public static String updateVersions(String versions, String newVersion) {
        Map<Integer, String> versionMap = ThirdAclUtils.buildVersionMap(versions);
        int newNamespaceId = ThirdAclUtils.getNamespaceIdByVersionValue(newVersion);
        versionMap.put(newNamespaceId, newVersion);
        return versionMap.values().stream().sorted().collect(Collectors.joining(";"));
    }

    public static String deleteVersions(String versions, int namespaceId) {
        Map<Integer, String> versionMap = ThirdAclUtils.buildVersionMap(versions);
        versionMap.remove(namespaceId);
        return versionMap.values().stream().sorted().collect(Collectors.joining(";"));
    }

    public static boolean isNeedUpdate(String newVerString, String oldVerString) {
        int pos = newVerString.lastIndexOf("#");
        if (pos == -1) {
            return false;
        }
        String newVer = newVerString.substring(pos);
        pos = oldVerString.lastIndexOf("#");
        if (pos == -1) {
            return false;
        }
        String oldVer = oldVerString.substring(pos);
        return newVer.compareTo(oldVer) > 0;
    }

    public static String buildPolicyId(int namespaceId) {
        return String.format(Locale.ENGLISH, "%d_%d", OBSConfig.getInstance().getOspStoragePoolId(), namespaceId);
    }

    public static String buildPolicyId(String namespaceId) {
        return String.format(Locale.ENGLISH, "%d_%s", OBSConfig.getInstance().getOspStoragePoolId(), namespaceId);
    }
}

