/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.dao;

import com.google.common.collect.Lists;
import com.huawei.osc.acl.common.ThirdAclUtils;
import com.huawei.osc.acl.dao.ThirdAclPolicyCondition;
import com.huawei.osc.acl.dao.ThirdAclPolicyDao;
import com.huawei.osc.acl.dao.ThirdAclPolicyInfo;
import com.huawei.osc.acl.dao.ThirdAclPolicyVersionCondition;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import uds.ccdb.adapter.CcdbAdapter;
import uds.ccdb.client.CcdbClient;
import uds.ccdb.condition.AbstractCCDBCondition;
import uds.ccdb.entity.CcdbCallback;
import uds.ccdb.entity.CcdbLogicOperator;
import uds.ccdb.entity.CcdbQueryCondition;
import uds.ccdb.entity.CcdbQueryEntity;
import uds.ccdb.task.CcdbMonitor;
import uds.common.config.interf.OBSConfig;
import uds.common.storage.exception.StorEngineException;
import uds.eds.client.ThirdAclPolicy;

public class ThirdAclPolicyDaoSpi
implements ThirdAclPolicyDao {
    private static final ThirdAclPolicyDaoSpi INSTANCE = new ThirdAclPolicyDaoSpi();

    public static ThirdAclPolicyDaoSpi getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeAclPolicy(ThirdAclPolicy policy) throws StorEngineException {
        if (policy == null) {
            throw new IllegalArgumentException("policy not be null.");
        }
        ThirdAclPolicy readPolicy = this.getAclPolicyByNamespaceId(policy.getNamespaceId());
        if (readPolicy == null) {
            CcdbAdapter.getInstance().insertData((List)Lists.newArrayList((Object[])new AbstractCCDBCondition[]{new ThirdAclPolicyCondition(policy)}));
        } else {
            CcdbAdapter.getInstance().updateData((List)Lists.newArrayList((Object[])new AbstractCCDBCondition[]{new ThirdAclPolicyCondition(policy)}));
        }
    }

    @Override
    public ThirdAclPolicy getAclPolicyByNamespaceId(int namespaceId) throws StorEngineException {
        if (namespaceId <= 0) {
            throw new IllegalArgumentException("invalid namspace id.");
        }
        ThirdAclPolicyCondition condition = new ThirdAclPolicyCondition();
        condition.addMapFilter("policyId", new CcdbQueryEntity("policyId", (Object)ThirdAclUtils.buildPolicyId(namespaceId), CcdbLogicOperator.CCDB_LOGIC_EQ, CcdbQueryCondition.AND));
        List policies = CcdbAdapter.getInstance().queryData((AbstractCCDBCondition)condition);
        if (CollectionUtils.isNotEmpty((Collection)policies)) {
            return (ThirdAclPolicy)policies.get(0);
        }
        return null;
    }

    @Override
    public List<ThirdAclPolicyInfo> getAllPolicyVersionInfo() throws StorEngineException {
        ThirdAclPolicyVersionCondition cond = new ThirdAclPolicyVersionCondition();
        cond.addMapFilter("storagePoolId", new CcdbQueryEntity("storagePoolId", (Object)OBSConfig.getInstance().getOspStoragePoolId(), CcdbLogicOperator.CCDB_LOGIC_EQ, CcdbQueryCondition.AND));
        return CcdbAdapter.getInstance().queryData((AbstractCCDBCondition)cond);
    }

    @Override
    public void deleteAclPolicyByNamespaceId(int namespaceId) throws StorEngineException {
        String policyId = ThirdAclUtils.buildPolicyId(namespaceId);
        if (namespaceId <= 0) {
            throw new IllegalArgumentException("invalid namespaceId.");
        }
        ThirdAclPolicyCondition condition = new ThirdAclPolicyCondition();
        condition.setPolicyId(policyId);
        CcdbAdapter.getInstance().deleteData((List)Lists.newArrayList((Object[])new AbstractCCDBCondition[]{condition}));
    }

    @Override
    public int subAclPolicyNotify(CcdbCallback callback) throws StorEngineException {
        return CcdbClient.INSTANCE.subDBNotifySync(CcdbMonitor.INSTANCE.getDbId(), "hdfs_third_acl_policy", callback);
    }
}

