/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.osc.acl.AclInfoAdapter;
import com.huawei.osc.acl.alarm.ThirdAclServerStatusMonitor;
import com.huawei.osc.acl.auth.KerberosUtil;
import com.huawei.osc.acl.common.ConfigurationWrapper;
import com.huawei.osc.acl.common.ValidationFailure;
import com.huawei.osc.acl.ranger.PolicyRefresher;
import com.huawei.osc.acl.ranger.RangerAdminRESTClient;
import com.huawei.osc.acl.ranger.RangerPolicyValidator;
import com.huawei.osc.acl.ranger.RangerUtils;
import com.huawei.osc.acl.task.MemcacheAction;
import com.huawei.osc.acl.task.MemcacheActionProcessor;
import com.huawei.osc.acl.task.MemcacheActionType;
import com.huawei.osc.acl.task.entity.AclCacheData;
import com.huawei.osc.acl.task.entity.AclMemCacheVersion;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.ServicePolicies;
import uds.common.alarm.AlarmReporterImpl;
import uds.common.alarm.enumeration.AlarmLevel;
import uds.common.alarm.enumeration.AlarmType;
import uds.common.alarm.exception.SendAlarmFailedException;
import uds.common.config.interf.OBSConfig;
import uds.eds.client.ThirdAclPolicy;

public class OceanStorRangerHdfsPlugin
implements AclInfoAdapter {
    public static final String VERSION_PREFIX = "ranger";
    private static final Logger LOG = LogManager.getLogger(RangerBasePlugin.class);
    private static final String DISABLE_SERVICE_NAME = "";
    private static final long DISABLE_VERSION = -1L;
    private ConfigurationWrapper configWrapper;
    private Configuration pluginConfig;
    private PolicyRefresher refresher;
    private final int namespaceId;
    private final String timezone;
    private final AtomicLong failedCount = new AtomicLong(1L);
    private final String host;
    private final String serviceName;

    public OceanStorRangerHdfsPlugin(ConfigurationWrapper configWrapper) {
        this.configWrapper = configWrapper;
        this.pluginConfig = configWrapper.getConfiguration();
        this.namespaceId = this.pluginConfig.getInt("plugin.hdfs.namespace.id", -1);
        this.host = this.pluginConfig.get("ranger.plugin.hdfs.policy.rest.url");
        this.serviceName = this.pluginConfig.get("ranger.plugin.hdfs.service.name");
        this.timezone = this.pluginConfig.get("ranger.plugin.hdfs.timezone");
    }

    public static RangerAdminRESTClient createAdminClient(ConfigurationWrapper configWrapper) {
        Configuration configuration = configWrapper.getConfiguration();
        String securityMode = configuration.get("ranger.hdfs.service.security.mode", "simple").trim();
        if ("kerberos".equals(securityMode)) {
            UserGroupInformation ugi = KerberosUtil.configKerberos(configuration);
            configWrapper.setUgi(ugi);
        }
        RangerAdminRESTClient ret = new RangerAdminRESTClient();
        try {
            ret.init(configWrapper.getConfiguration().get("ranger.plugin.hdfs.service.name"), "hdfs", "ranger.plugin.hdfs", configWrapper);
        }
        catch (UnknownHostException e) {
            LOG.error("UnknownHostException, start res_init, thread[{}]", (Object)Thread.currentThread().getName(), (Object)e);
        }
        return ret;
    }

    @Override
    public void start() {
        this.stop();
        this.refresher = new PolicyRefresher(this);
        LOG.info("Created PolicyRefresher Thread({})", (Object)this.refresher.getName());
        this.refresher.setDaemon(true);
        this.refresher.startRefresher();
        ThirdAclServerStatusMonitor.getInstance().register(this);
    }

    @Override
    public void stop() {
        UserGroupInformation ugi = this.configWrapper.getUgi();
        if (ugi != null) {
            try {
                ugi.logoutUserFromKeytab();
            }
            catch (IOException e) {
                LOG.error("Ugi logout failed.", (Throwable)e);
            }
        }
        ThirdAclServerStatusMonitor.getInstance().unregister(this);
        PolicyRefresher refresher1 = this.refresher;
        this.refresher = null;
        if (refresher1 != null) {
            refresher1.stopRefresher();
        }
        try {
            String alarmInfo = String.format(Locale.ROOT, "[%s] namespaceId[%d]", this.getHost(), this.getNamespaceId());
            AlarmReporterImpl.getInstance().sendAlarm(68356931592L, AlarmType.RESUME_ALARM, AlarmLevel.MAJOR_ALARM, OBSConfig.getInstance().getCurrentComponent(), alarmInfo, null, false);
        }
        catch (SendAlarmFailedException e) {
            LOG.error("send or resume alarm failed!", (Throwable)e);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getNamespaceId() {
        return this.namespaceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public long getContinuousFailedNums() {
        return this.failedCount.get();
    }

    @Override
    public Configuration getConfig() {
        return this.pluginConfig;
    }

    public boolean setPolicies(ServicePolicies policies) {
        if (policies == null) {
            return true;
        }
        ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>();
        RangerPolicyValidator.validateArgs(policies, failures);
        if (failures.size() > 0) {
            LOG.error("policy validation failed, ignore... " + ValidationFailure.serializeFailures(failures));
            this.onLoadPolicyFailed();
            return false;
        }
        ThirdAclPolicy rangerPolicy = ThirdAclPolicy.builder().type(1).namespaceId(this.namespaceId).build();
        if (policies.getPolicies() == null) {
            rangerPolicy.setPolicies(Collections.emptyList());
        } else {
            rangerPolicy.setPolicies(policies.getPolicies().stream().filter(RangerBaseModelObject::getIsEnabled).map(this::fillTimeZone).map(RangerUtils::convertPolicyToInner).collect(Collectors.toList()));
        }
        rangerPolicy.setVersion(this.buildVersionValue());
        long maxPolicySize = OBSConfig.getInstance().getRangerPolicyTotalSize() * 1024L * 1024L;
        long policySize = this.getPolicySize(rangerPolicy);
        if (policySize == -1L || policySize > maxPolicySize) {
            LOG.error("namespace {} policySize {} is greater than maxPolicySize {}", (Object)this.namespaceId, (Object)policySize, (Object)maxPolicySize);
            this.onLoadPolicyFailed();
            return false;
        }
        MemcacheActionProcessor.getInstance().put(this.namespaceId, MemcacheAction.builder().type(MemcacheActionType.UPDATE).policy(rangerPolicy).build());
        return true;
    }

    private long getPolicySize(ThirdAclPolicy rangerPolicy) {
        long policySize = -1L;
        String fileValue = DISABLE_SERVICE_NAME;
        AclMemCacheVersion aclMemCacheVersion = new AclMemCacheVersion(String.valueOf(rangerPolicy.getNamespaceId()), VERSION_PREFIX, rangerPolicy.getVersion().split("#")[2]);
        AclCacheData newAclCacheData = new AclCacheData().setThirdAclPolicy(rangerPolicy).setFiledWithOutFile(aclMemCacheVersion);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            fileValue = objectMapper.writeValueAsString((Object)newAclCacheData);
            policySize = fileValue.length();
            LOG.debug("current  policy size is :{}, namespaceId is {}", (Object)policySize, (Object)rangerPolicy.getNamespaceId());
        }
        catch (JsonProcessingException e) {
            LOG.error("writeValueAsString meet JsonProcessingException ,can not change RangerPolicy : [{}}] to String, exception is {}", (Object)aclMemCacheVersion, (Object)e);
        }
        return policySize;
    }

    public RangerPolicy fillTimeZone(RangerPolicy rangerPolicy) {
        rangerPolicy.getValiditySchedules().forEach(schedule -> schedule.setTimeZone(StringUtils.isNotBlank((String)schedule.getTimeZone()) ? schedule.getTimeZone() : this.timezone));
        return rangerPolicy;
    }

    public void onLoadPolicySucceeded() {
        this.failedCount.set(0L);
    }

    public void onCacheDisabled() {
        this.failedCount.set(Integer.MAX_VALUE);
        LOG.warn("onCacheDisabled, namespaceId={}, url={}, serviceName={}, failedCount={}", (Object)this.namespaceId, (Object)this.host, (Object)this.serviceName, (Object)this.failedCount);
        MemcacheActionProcessor.getInstance().put(this.namespaceId, MemcacheAction.builder().type(MemcacheActionType.DELETE).build());
    }

    public void onLoadPolicyFailed() {
        this.failedCount.incrementAndGet();
        LOG.warn("onLoadPolicyFailed, namespaceId={}, url={}, serviceName={}, failedCount={}", (Object)this.namespaceId, (Object)this.host, (Object)this.serviceName, (Object)this.failedCount);
    }

    public void onKerberosAuthFailed(String alarmInfo) {
        LOG.warn("onKerberosAuthFailed, namespaceId={}, servicetype={}, principal={}, keytab={}, failedCount={}", (Object)this.namespaceId, (Object)this.pluginConfig.get("plugin.hdfs.servicetype"), (Object)this.pluginConfig.get("ranger.hdfs.service.server.principal"), (Object)this.pluginConfig.get("ranger.hdfs.service.server.keytab"), (Object)this.failedCount);
        try {
            AlarmReporterImpl.getInstance().sendAlarm(68356931592L, AlarmType.REPORT_ALARM, AlarmLevel.MAJOR_ALARM, OBSConfig.getInstance().getCurrentComponent(), alarmInfo, null, false);
        }
        catch (SendAlarmFailedException e) {
            LOG.error("send or resume alarm failed!", (Throwable)e);
        }
    }

    private String buildVersionValue() {
        return String.format(Locale.ENGLISH, "%s#%d#%d", VERSION_PREFIX, this.namespaceId, System.currentTimeMillis());
    }

    public long getFailedCount() {
        return this.failedCount.get();
    }

    public ConfigurationWrapper getConfigWrapper() {
        return this.configWrapper;
    }
}

