/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class OceanStorRangerPluginConfig
extends RangerConfiguration {
    private static final Logger LOG = LogManager.getLogger(RangerBasePlugin.class);
    private final String serviceName;
    private final int namespaceId;
    private final String propertyPrefix;

    public OceanStorRangerPluginConfig(int namespaceId) {
        this.namespaceId = namespaceId;
        this.propertyPrefix = "ranger.plugin.hdfs";
        this.addResourcesForNamespaceId(namespaceId);
        this.serviceName = this.get("ranger.plugin.hdfs.service.name");
    }

    private void addResourcesForNamespaceId(int nameSpaceId) {
        String serviceSecurityCfg = "ranger-hdfs-" + nameSpaceId + "-security.xml";
        this.addFileResourceIfReadable("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl/" + serviceSecurityCfg);
    }

    private boolean addFileResourceIfReadable(String fileName) {
        boolean isDone = false;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                URL fileUrl = file.toURI().toURL();
                this.addResource(fileUrl);
                isDone = true;
            }
            catch (MalformedURLException var5) {
                LOG.error("Unable to load the resource name [" + fileName + "]. Ignoring the resource:" + file.getPath());
            }
        } else {
            LOG.debug("Conf file path {} does not exists", (Object)fileName);
        }
        return isDone;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getNamespaceId() {
        return this.namespaceId;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public String getAppId() {
        return "hdfs";
    }
}

