/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import com.huawei.osc.acl.ranger.OceanStorRangerHdfsPlugin;
import com.huawei.osc.acl.ranger.RangerAdminRESTClient;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRefresher
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(PolicyRefresher.class);
    private final OceanStorRangerHdfsPlugin plugIn;
    private final String serviceName;
    private final RangerAdminRESTClient rangerAdmin;
    private final long pollingIntervalMs;
    private final boolean isDisableCacheIfServiceNAFound;
    private long lastKnownVersion = -1L;
    private long lastActivationTimeInMillis;
    private boolean isPoliciesSetInPlugin;
    private boolean isServiceDefSetInPlugin;

    public PolicyRefresher(OceanStorRangerHdfsPlugin plugIn) {
        super.setName("PolicyRefresher");
        log.debug("==> PolicyRefresher(serviceName={}).PolicyRefresher()", (Object)plugIn.getServiceName());
        Configuration pluginConfig = plugIn.getConfig();
        this.plugIn = plugIn;
        this.serviceName = plugIn.getServiceName();
        this.isDisableCacheIfServiceNAFound = pluginConfig.getBoolean("ranger.plugin.hdfs.disable.cache.if.servicenotfound", true);
        String alarmInfo = "";
        try {
            alarmInfo = String.format(Locale.ROOT, "[%s] namespaceId[%d]", plugIn.getHost(), plugIn.getNamespaceId());
            this.rangerAdmin = OceanStorRangerHdfsPlugin.createAdminClient(plugIn.getConfigWrapper());
        }
        catch (IllegalArgumentException illegalE) {
            if (this.isDisableCacheIfServiceNAFound) {
                plugIn.onCacheDisabled();
                plugIn.setPolicies(null);
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
                this.isServiceDefSetInPlugin = true;
            }
            plugIn.onKerberosAuthFailed(alarmInfo);
            throw new IllegalArgumentException("Kerberos login failed", illegalE);
        }
        this.pollingIntervalMs = pluginConfig.getLong("plugin.hdfs.policy.pollIntervalMs", 30000L);
        this.setName("PolicyRefresher(serviceName=" + this.serviceName + ")-" + this.getId());
        log.debug("<== PolicyRefresher(serviceName={}).PolicyRefresher()", (Object)this.serviceName);
    }

    public OceanStorRangerHdfsPlugin getPlugin() {
        return this.plugIn;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerAdminRESTClient getRangerAdminClient() {
        return this.rangerAdmin;
    }

    public void startRefresher() {
        this.loadPolicy();
        super.start();
    }

    public void stopRefresher() {
        if (super.isAlive()) {
            super.interrupt();
            boolean hasSetInterrupted = false;
            boolean isJoined = false;
            while (!isJoined) {
                try {
                    super.join();
                    isJoined = true;
                }
                catch (InterruptedException excp) {
                    log.warn("PolicyRefresher(serviceName=" + this.serviceName + "): error while waiting for thread to exit", (Throwable)excp);
                    log.warn("Retrying Thread.join(). Current thread will be marked as 'interrupted' after Thread.join() returns");
                    hasSetInterrupted = true;
                }
            }
            if (hasSetInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        log.debug("==> PolicyRefresher(serviceName=" + this.serviceName + ").run()");
        while (true) {
            this.loadPolicy();
            try {
                Thread.sleep(this.pollingIntervalMs);
            }
            catch (InterruptedException excp) {
                log.info("PolicyRefresher(serviceName=" + this.serviceName + ").run(): interrupted! Exiting thread", (Throwable)excp);
                log.debug("<== PolicyRefresher(serviceName=" + this.serviceName + ").run()");
                return;
            }
        }
    }

    private void loadPolicy() {
        log.debug("==> PolicyRefresher(serviceName={}).loadPolicy()", (Object)this.serviceName);
        try {
            ServicePolicies svcPolicies = this.loadPolicyfromPolicyAdmin();
            if (svcPolicies != null) {
                boolean result = this.plugIn.setPolicies(svcPolicies);
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                if (result) {
                    this.isPoliciesSetInPlugin = true;
                    this.lastKnownVersion = svcPolicies.getPolicyVersion() != null ? svcPolicies.getPolicyVersion() : -1L;
                    this.plugIn.onLoadPolicySucceeded();
                } else {
                    this.lastKnownVersion = -1L;
                }
            } else {
                if (!this.isPoliciesSetInPlugin && !this.isServiceDefSetInPlugin) {
                    this.plugIn.setPolicies(null);
                    this.isServiceDefSetInPlugin = true;
                }
                this.plugIn.onLoadPolicySucceeded();
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (this.isDisableCacheIfServiceNAFound) {
                this.plugIn.onCacheDisabled();
                this.plugIn.setPolicies(null);
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownVersion = -1L;
                this.isServiceDefSetInPlugin = true;
            } else {
                this.plugIn.onLoadPolicyFailed();
            }
        }
        catch (Exception excp) {
            log.error("Encountered unexpected exception, ignoring..", (Throwable)excp);
            this.plugIn.onLoadPolicyFailed();
        }
        log.debug("<== PolicyRefresher(serviceName={}).loadPolicy()", (Object)this.serviceName);
    }

    private ServicePolicies loadPolicyfromPolicyAdmin() throws Exception {
        log.debug("==> PolicyRefresher(serviceName={}).loadPolicyfromPolicyAdmin()", (Object)this.serviceName);
        ServicePolicies svcPolicies = null;
        RangerPerfTracer perf = null;
        try {
            boolean isUpdated;
            svcPolicies = this.rangerAdmin.getPoliciesIfUpdated(this.lastKnownVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = svcPolicies != null;
            if (isUpdated) {
                long newVersion;
                long l = newVersion = svcPolicies.getPolicyVersion() == null ? -1L : svcPolicies.getPolicyVersion();
                if (!StringUtils.equals((String)this.serviceName, (String)svcPolicies.getServiceName())) {
                    log.warn("PolicyRefresher(serviceName=" + this.serviceName + "): ignoring unexpected serviceName '" + svcPolicies.getServiceName() + "' in service-store");
                    svcPolicies.setServiceName(this.serviceName);
                }
                log.info("PolicyRefresher(serviceName=" + this.serviceName + "): found updated version. lastKnownVersion=" + this.lastKnownVersion + "; newVersion=" + newVersion);
            } else {
                log.debug("PolicyRefresher(serviceName={}).run(): no update found. lastKnownVersion={}", (Object)this.serviceName, (Object)this.lastKnownVersion);
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            log.error("PolicyRefresher(serviceName=" + this.serviceName + "): failed to find service. Will clean up local cache of policies (" + this.lastKnownVersion + ")", (Throwable)snfe);
            throw snfe;
        }
        catch (Exception excp) {
            log.error("PolicyRefresher(serviceName=" + this.serviceName + "): failed to refresh policies. Will continue to use last known version of policies (" + this.lastKnownVersion + ")", (Throwable)excp);
            throw excp;
        }
        RangerPerfTracer.log(perf);
        log.debug("<== PolicyRefresher(serviceName={}).loadPolicyfromPolicyAdmin()", (Object)this.serviceName);
        return svcPolicies;
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }
}

