/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import com.huawei.osc.acl.auth.KerberosUtil;
import com.huawei.osc.acl.common.ConfigurationWrapper;
import com.huawei.osc.acl.ranger.RangerServiceException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.URLEncoderUtil;

public class RangerAdminRESTClient
extends AbstractRangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminRESTClient.class);
    private static final String POLICY_REST_URL = ".policy.rest.url";
    private static final String POLICY_REST_SSL_CONFIG_FILE = ".policy.rest.ssl.config.file";
    private static final String ACCESS_CLUSTER_NAME = ".access.cluster.name";
    private static final String AMBARI_CLUSTER_NAME = ".ambari.cluster.name";
    private static final String CLIENT_CONNECTION_TIMEOUT_MS = ".policy.rest.client.connection.timeoutMs";
    private static final String CLIENT_READ_TIMEOUT_MS = ".policy.rest.client.read.timeoutMs";
    private static final String SUPPORTS_POLICY_DELTAS = ".policy.rest.supports.policy.deltas";
    private static final String SUPPORTS_TAG_DELTAS = ".tag.rest.supports.tag.deltas";
    private static final String REST_PARAM_LAST_KNOWN_POLICY_VERSION = "lastKnownVersion";
    private static final String REST_PARAM_LAST_ACTIVATION_TIME = "lastActivationTime";
    private static final String REST_PARAM_PLUGIN_ID = "pluginId";
    private static final String REST_PARAM_CLUSTER_NAME = "clusterName";
    private static final String REST_PARAM_SUPPORTS_POLICY_DELTAS = "supportsPolicyDeltas";
    private static final String REST_PARAM_CAPABILITIES = "pluginCapabilities";
    private static final String REST_URL_POLICY_GET_FOR_SERVICE_IF_UPDATED = "/service/plugins/policies/download/";
    private static final String REST_URL_POLICY_GET_FOR_SECURE_SERVICE_IF_UPDATED = "/service/plugins/secure/policies/download/";
    private RangerRESTUtils restUtils = new RangerRESTUtils();
    private String supportsPolicyDeltas;
    private String supportsTagDeltas;
    private String serviceName;
    private String serviceNameUrlParam;
    private String pluginId;
    private String clusterName;
    private RangerRESTClient restClient;
    private UserGroupInformation ugi;
    private boolean isSecureMode;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());

    public void init(String serviceName, String appId, String propertyPrefix, ConfigurationWrapper configWrapper) throws UnknownHostException {
        Configuration config = configWrapper.getConfiguration();
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        this.clusterName = config.get(propertyPrefix + ACCESS_CLUSTER_NAME, "");
        if (StringUtil.isEmpty((String)this.clusterName)) {
            this.clusterName = config.get(propertyPrefix + AMBARI_CLUSTER_NAME, "");
            if (StringUtil.isEmpty((String)this.clusterName) && config instanceof RangerPluginConfig) {
                this.clusterName = ((RangerPluginConfig)config).getClusterName();
            }
        }
        this.supportsPolicyDeltas = config.get(propertyPrefix + SUPPORTS_POLICY_DELTAS, "false");
        this.supportsTagDeltas = config.get(propertyPrefix + SUPPORTS_TAG_DELTAS, "false");
        String targetUrl = "";
        String tmpUrl = config.get(propertyPrefix + POLICY_REST_URL);
        if (!StringUtil.isEmpty((String)tmpUrl)) {
            targetUrl = tmpUrl.trim();
        }
        if (targetUrl.endsWith("/")) {
            targetUrl = targetUrl.substring(0, targetUrl.length() - 1);
        }
        if (!"true".equalsIgnoreCase(this.supportsPolicyDeltas)) {
            this.supportsPolicyDeltas = "false";
        }
        if (!"true".equalsIgnoreCase(this.supportsTagDeltas)) {
            this.supportsTagDeltas = "false";
        }
        int restClientConnTimeOutMs = config.getInt(propertyPrefix + CLIENT_CONNECTION_TIMEOUT_MS, 120000);
        int restClientReadTimeOutMs = config.getInt(propertyPrefix + CLIENT_READ_TIMEOUT_MS, 30000);
        String sslConfigFileName = config.get(propertyPrefix + POLICY_REST_SSL_CONFIG_FILE);
        this.init(targetUrl, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs, configWrapper);
        try {
            this.serviceNameUrlParam = URLEncoderUtil.encodeURIParam((String)serviceName);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)("Unsupported encoding, serviceName=" + serviceName));
            this.serviceNameUrlParam = serviceName;
        }
    }

    public ServicePolicies getPoliciesIfUpdated(long lastVersion, long lastActTimeInMs) throws Exception {
        ServicePolicies ret;
        RESTResponse resp;
        ClientResponse response;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastVersion + ", " + lastActTimeInMs + ")"));
        }
        this.isSecureMode = this.ugi != null && UserGroupInformation.isSecurityEnabled();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        this.setQueryParams(lastVersion, lastActTimeInMs, queryParams);
        if (this.isSecureMode) {
            response = this.getResponseWithSecureMode(queryParams);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            String relativeURL = REST_URL_POLICY_GET_FOR_SERVICE_IF_UPDATED + this.serviceNameUrlParam;
            response = this.restClient.get(relativeURL, queryParams);
        }
        if (response == null || response.getStatus() == 304) {
            if (response == null) {
                LOG.error((Object)("Error getting policies; Received NULL response!!. secureMode=" + this.isSecureMode + ", ugi=" + this.ugi + ", serviceName=" + this.serviceName));
                throw new RangerServiceNotFoundException(this.serviceName);
            }
            resp = RESTResponse.fromClientResponse((ClientResponse)response);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No change in policies. secureMode=" + this.isSecureMode + ", ugi=" + this.ugi + ", response=" + resp + ", serviceName=" + this.serviceName));
            }
            ret = null;
        } else if (response.getStatus() == 200) {
            ret = (ServicePolicies)response.getEntity(ServicePolicies.class);
        } else if (response.getStatus() == 404) {
            ret = this.scNotFound(lastVersion, lastActTimeInMs, response, this.isSecureMode);
        } else {
            resp = RESTResponse.fromClientResponse((ClientResponse)response);
            LOG.warn((Object)("Error getting policies. secureMode=" + this.isSecureMode + ", ugi=" + this.ugi + ", response=" + resp + ", serviceName=" + this.serviceName));
            throw new RangerServiceException(this.serviceName, resp.getStatusCode());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastVersion + ", " + lastActTimeInMs + "): "));
        }
        return ret;
    }

    private void setQueryParams(long lastVersion, long lastActTimeInMs, Map<String, String> queryParams) {
        queryParams.put(REST_PARAM_LAST_KNOWN_POLICY_VERSION, Long.toString(lastVersion));
        queryParams.put(REST_PARAM_LAST_ACTIVATION_TIME, Long.toString(lastActTimeInMs));
        queryParams.put(REST_PARAM_PLUGIN_ID, this.pluginId);
        queryParams.put(REST_PARAM_CLUSTER_NAME, this.clusterName);
        queryParams.put(REST_PARAM_SUPPORTS_POLICY_DELTAS, this.supportsPolicyDeltas);
        queryParams.put(REST_PARAM_CAPABILITIES, this.pluginCapabilities);
    }

    private ServicePolicies scNotFound(long lastVersion, long lastActTimeInMs, ClientResponse response, boolean isSecureMode) throws RangerServiceNotFoundException {
        LOG.error((Object)("Error getting policies; service not found. secureMode=" + isSecureMode + ", ugi=" + this.ugi + ", response=" + response.getStatus() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastVersion + ", lastActivationTimeInMillis=" + lastActTimeInMs));
        String exceptionMsg = response.hasEntity() ? (String)response.getEntity(String.class) : null;
        RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this.serviceName, (String)exceptionMsg);
        LOG.warn((Object)("Received 404 error code with body:[" + exceptionMsg + "]"));
        throw new RangerServiceNotFoundException(this.serviceName);
    }

    private ClientResponse getResponseWithSecureMode(Map<String, String> queryParams) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking Service policy if updated as user : " + this.ugi));
        }
        PrivilegedAction<ClientResponse> action = () -> {
            ClientResponse clientResponse = null;
            String relativeURL = REST_URL_POLICY_GET_FOR_SECURE_SERVICE_IF_UPDATED + this.serviceNameUrlParam;
            try {
                clientResponse = this.restClient.get(relativeURL, queryParams);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to get response, Error is : " + ex.getMessage()), (Throwable)ex);
            }
            return clientResponse;
        };
        try {
            this.ugi.checkTGTAndReloginFromKeytab();
        }
        catch (IOException e) {
            LOG.error((Object)"Error renewing TGT and relogin. Ignoring Exception, and continuing with the old TGT", (Throwable)e);
        }
        ClientResponse response = (ClientResponse)this.ugi.doAs(action);
        return response;
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs, ConfigurationWrapper configWrapper) throws UnknownHostException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
        String finalUrl = url;
        this.ugi = configWrapper.getUgi();
        boolean bl = this.isSecureMode = this.ugi != null && UserGroupInformation.isSecurityEnabled();
        if (this.isSecureMode) {
            finalUrl = KerberosUtil.getFinalUrl(url);
        }
        this.restClient = new RangerRESTClient(finalUrl, sslConfigFileName, configWrapper.getConfiguration()){

            public TrustManager[] getTrustManagers(String trustStoreFile, String trustStoreFilePwd) {
                return new TrustManager[]{RangerAdminRESTClient.this.getX509ExtendedTrustManager()};
            }
        };
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.init(" + finalUrl + ", " + sslConfigFileName + ")"));
        }
    }

    private X509ExtendedTrustManager getX509ExtendedTrustManager() {
        return new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    public RangerRESTClient getRestClient() {
        return this.restClient;
    }
}

