/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import com.huawei.osc.acl.common.ValidationFailure;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.util.ServicePolicies;
import uds.common.config.interf.OBSConfig;

public class RangerPolicyValidator {
    private static final String SERVICE_DEF_NAME = "hdfs";

    public static void validateArgs(ServicePolicies policies, List<ValidationFailure> failures) {
        if (!StringUtils.equals((String)policies.getServiceDef().getName(), (String)SERVICE_DEF_NAME)) {
            failures.add(ValidationFailure.builder().field("serviceDef type").msg("type should be hdfs, but is " + policies.getServiceDef().getName()).build());
            return;
        }
        int maxPolicyPerNamespace = OBSConfig.getInstance().getInt("ranger_policy_max_number_of_namespace", 100);
        List rangerPolicies = policies.getPolicies();
        if (rangerPolicies == null) {
            return;
        }
        if (rangerPolicies.size() > maxPolicyPerNamespace) {
            failures.add(ValidationFailure.builder().field("policy size").msg("exceeds the limit " + maxPolicyPerNamespace).build());
        }
        RangerPolicyValidator.validPolicies(rangerPolicies, failures);
    }

    private static void validPolicies(List<RangerPolicy> rangerPolicies, List<ValidationFailure> failures) {
        int maxPathPerPolicy = OBSConfig.getInstance().getInt("ranger_policy_max_path_number_of_policy", 10);
        int maxValiditySchedulePerPolicy = OBSConfig.getInstance().getInt("ranger_policy_max_effective_period_number_of_policy", 10);
        int maxItemPerPolicy = OBSConfig.getInstance().getInt("ranger_policy_max_item_number_of_policy", 20);
        int maxUserGroupCountPerItem = OBSConfig.getInstance().getInt("ranger_policy_max_user_number_of_policy_item", 10);
        for (RangerPolicy rangerPolicy : rangerPolicies) {
            String id = rangerPolicy.getId().toString();
            if (((RangerPolicy.RangerPolicyResource)rangerPolicy.getResources().get("path")).getValues().size() > maxPathPerPolicy) {
                failures.add(ValidationFailure.builder().id(id).field("path size").msg("exceeds the limit " + maxPathPerPolicy).build());
            }
            if (rangerPolicy.getValiditySchedules().size() > maxValiditySchedulePerPolicy) {
                failures.add(ValidationFailure.builder().id(id).field("validity schedule size").msg("exceeds the limit " + maxValiditySchedulePerPolicy).build());
            }
            if (rangerPolicy.getPolicyItems().size() + rangerPolicy.getDenyPolicyItems().size() + rangerPolicy.getAllowExceptions().size() + rangerPolicy.getDenyExceptions().size() > maxItemPerPolicy) {
                failures.add(ValidationFailure.builder().id(id).field("policy item size").msg("exceeds the limit " + maxItemPerPolicy).build());
            }
            RangerPolicyValidator.validateUserAndGroup(rangerPolicy.getPolicyItems(), failures, id, "PolicyItem", maxUserGroupCountPerItem);
            RangerPolicyValidator.validateUserAndGroup(rangerPolicy.getAllowExceptions(), failures, id, "AllowExceptions", maxUserGroupCountPerItem);
            RangerPolicyValidator.validateUserAndGroup(rangerPolicy.getDenyPolicyItems(), failures, id, "DenyPolicyItems", maxUserGroupCountPerItem);
            RangerPolicyValidator.validateUserAndGroup(rangerPolicy.getDenyExceptions(), failures, id, "DenyExceptions", maxUserGroupCountPerItem);
        }
    }

    private static void validateUserAndGroup(List<RangerPolicy.RangerPolicyItem> policyItems, List<ValidationFailure> failures, String id, String policyType, int maxUserNumOfSinglePolicyItem) {
        for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
            if (policyItem.getUsers().size() + policyItem.getGroups().size() <= maxUserNumOfSinglePolicyItem) continue;
            failures.add(ValidationFailure.builder().id(id).field(policyType + ": policy item user+group size").msg("exceeds the limit " + maxUserNumOfSinglePolicyItem).build());
        }
    }
}

