/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.ranger;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import uds.eds.client.Policy;
import uds.eds.client.PolicyEntry;
import uds.eds.client.ValiditySchedule;

public class RangerUtils {
    private static final Logger LOG = LogManager.getLogger(RangerBasePlugin.class);
    private static final DateTimeFormatter SCHEDULE_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final Map<String, Integer> PERMISSION_BIT_MAP = new HashMap<String, Integer>();

    public static int buildPermission(List<RangerPolicy.RangerPolicyItemAccess> accessList) {
        Integer permissions = 0;
        for (RangerPolicy.RangerPolicyItemAccess access : accessList) {
            if (!access.getIsAllowed().booleanValue()) continue;
            permissions = permissions + PERMISSION_BIT_MAP.getOrDefault(access.getType(), 0);
        }
        return permissions;
    }

    public static PolicyEntry convertPolicyItemToInner(RangerPolicy.RangerPolicyItem item) {
        return PolicyEntry.builder().groupIds(item.getGroups()).userIds(item.getUsers()).permissions(RangerUtils.buildPermission(item.getAccesses())).build();
    }

    public static ValiditySchedule convertValidityScheduleToInner(RangerValiditySchedule rangerSchedule) {
        String startTimeStr = rangerSchedule.getStartTime();
        String endTimeStr = rangerSchedule.getEndTime();
        String timeZone = rangerSchedule.getTimeZone();
        long startTime = 0L;
        long endTime = 0L;
        if (StringUtils.isNotEmpty((String)startTimeStr)) {
            startTime = RangerUtils.convertToEpochMilli(startTimeStr, timeZone);
        }
        if (StringUtils.isNotEmpty((String)endTimeStr)) {
            endTime = RangerUtils.convertToEpochMilli(endTimeStr, timeZone);
        }
        return new ValiditySchedule(startTime, endTime);
    }

    public static long convertToEpochMilli(String timeStr, String timezone) {
        ZoneId zoneId = ZoneId.systemDefault();
        try {
            zoneId = ZoneId.of(timezone);
        }
        catch (DateTimeException e) {
            LOG.error("invalid timeZoneId" + timezone + ", use: " + zoneId);
        }
        LocalDateTime localDateTime = LocalDateTime.parse(timeStr, SCHEDULE_DATE_FORMATTER);
        ZonedDateTime zoneDateTime = ZonedDateTime.of(localDateTime, zoneId);
        return zoneDateTime.toInstant().toEpochMilli();
    }

    public static Policy convertPolicyToInner(RangerPolicy rangerPolicy) {
        RangerPolicy.RangerPolicyResource resource = (RangerPolicy.RangerPolicyResource)rangerPolicy.getResources().get("path");
        return Policy.builder().id(rangerPolicy.getId().longValue()).name(rangerPolicy.getName()).policyType(rangerPolicy.getPolicyType().intValue()).isExcludes(resource.getIsExcludes().booleanValue()).isRecursive(resource.getIsRecursive().booleanValue()).paths(resource.getValues()).policyEntryAllow(rangerPolicy.getPolicyItems().stream().map(RangerUtils::convertPolicyItemToInner).collect(Collectors.toList())).policyEntryAllowException(rangerPolicy.getAllowExceptions().stream().map(RangerUtils::convertPolicyItemToInner).collect(Collectors.toList())).policyEntryDeny(rangerPolicy.getDenyPolicyItems().stream().map(RangerUtils::convertPolicyItemToInner).collect(Collectors.toList())).policyEntryDenyException(rangerPolicy.getDenyExceptions().stream().map(RangerUtils::convertPolicyItemToInner).collect(Collectors.toList())).validitySchedules(rangerPolicy.getValiditySchedules().stream().map(RangerUtils::convertValidityScheduleToInner).collect(Collectors.toList())).isDenyAllElse(rangerPolicy.getIsDenyAllElse().booleanValue()).build();
    }

    static {
        PERMISSION_BIT_MAP.put("read", 4);
        PERMISSION_BIT_MAP.put("write", 2);
        PERMISSION_BIT_MAP.put("execute", 1);
    }
}

