/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry;

import com.huawei.osc.acl.sentry.thrift.TTransportWrapper;
import com.huawei.osc.acl.sentry.thrift.TransportPool;
import com.huawei.osc.acl.sentry.utils.CheckSentryJarUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryHdfsServiceException;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryAuthzUpdate;
import org.apache.sentry.hdfs.SentryHDFSServiceClient;
import org.apache.sentry.hdfs.service.thrift.SentryHDFSService;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateRequest;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateResponse;
import org.apache.sentry.hdfs.service.thrift.TPathsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPermissionsUpdate;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsServiceClient
implements SentryHDFSServiceClient {
    private static final Logger logger = LoggerFactory.getLogger(HdfsServiceClient.class);
    private final boolean isCompactTransport;
    private final long maxMsgSize;
    private final int maxRetryCount;
    private final long connRetryDelayMilli;
    private final TransportPool pool;
    private SentryHDFSService.Client client;
    private TTransportWrapper transportWrapper;
    private boolean isOld = false;

    public HdfsServiceClient(Configuration configuration, TransportPool pool) {
        this.isCompactTransport = configuration.getBoolean("sentry.hdfs.service.client.compact.transport", false);
        this.maxMsgSize = configuration.getLong("sentry.hdfs.thrift.max.message.size", 0x6400000L);
        this.maxRetryCount = configuration.getInt("sentry.service.client.rpc.retry-total", 2);
        this.connRetryDelayMilli = configuration.getLong("sentry.service.client.rpc.retry.interval.msec", 500L);
        this.isOld = configuration.getBoolean("sentry.hdfs.service.client.old.server", false);
        this.pool = pool;
    }

    private SentryAuthzUpdate getAuthzUpdates(long permissionSeqN, long pathSeqN, long pathImgN) throws SentryHdfsServiceException {
        try {
            TAuthzUpdateRequest request = new TAuthzUpdateRequest(permissionSeqN, pathSeqN, pathImgN);
            logger.debug("get_authz_updates :{}, isOld: {}", (Object)request, (Object)this.isOld);
            Method getAuthzUpdates = null;
            Object updateResponse = null;
            if (CheckSentryJarUtils.isCustomizedSentry()) {
                getAuthzUpdates = this.client.getClass().getMethod("get_authz_updates", TAuthzUpdateRequest.class, Boolean.TYPE);
                updateResponse = getAuthzUpdates.invoke((Object)this.client, request, this.isOld);
            } else {
                getAuthzUpdates = this.client.getClass().getMethod("get_authz_updates", TAuthzUpdateRequest.class);
                updateResponse = getAuthzUpdates.invoke((Object)this.client, request);
            }
            TAuthzUpdateResponse response = null;
            if (updateResponse instanceof TAuthzUpdateResponse) {
                response = (TAuthzUpdateResponse)updateResponse;
            }
            List pathsUpdates = Collections.emptyList();
            List authzPathUpdate = response.getAuthzPathUpdate();
            if (authzPathUpdate != null) {
                pathsUpdates = new ArrayList(authzPathUpdate.size());
                for (TPathsUpdate tPathsUpdate : authzPathUpdate) {
                    pathsUpdates.add(new PathsUpdate(tPathsUpdate));
                }
            }
            List permissionsUpdates = Collections.emptyList();
            List authzPermUpdate = response.getAuthzPermUpdate();
            if (authzPermUpdate != null) {
                permissionsUpdates = new ArrayList(authzPermUpdate.size());
                for (TPermissionsUpdate tPermissionsUpdate : authzPermUpdate) {
                    permissionsUpdates.add(new PermissionsUpdate(tPermissionsUpdate));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[getAuthzUpdates] -> got permUpdates[size:{}]: {}, pathUpdates[size:{}]: {}", new Object[]{permissionsUpdates.size(), permissionsUpdates, pathsUpdates.size(), pathsUpdates});
            }
            return new SentryAuthzUpdate(permissionsUpdates, pathsUpdates);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TException) {
                throw new SentryHdfsServiceException("Thrift failed. ", cause);
            }
            throw new SentryHdfsServiceException("Sentry jars error. ", cause);
        }
    }

    private void connect() throws SentryHdfsServiceException, InterruptedException {
        Exception throwable = null;
        for (int retry = 0; retry < this.maxRetryCount; ++retry) {
            try {
                this.retryConnect();
                return;
            }
            catch (Exception e) {
                throwable = e;
                Thread.sleep(this.connRetryDelayMilli);
                continue;
            }
        }
        throw new SentryHdfsServiceException("Connect failed.", (Throwable)throwable);
    }

    private void retryConnect() throws Exception {
        if (this.transportWrapper != null && this.transportWrapper.isOpen()) {
            return;
        }
        this.transportWrapper = this.pool.getTransportWrapper();
        Object protocol = this.isCompactTransport ? new TCompactProtocol(this.transportWrapper.getTransport(), this.maxMsgSize, this.maxMsgSize) : new TBinaryProtocol(this.transportWrapper.getTransport(), this.maxMsgSize, this.maxMsgSize, true, true);
        TMultiplexedProtocol multiplexedProtocol = new TMultiplexedProtocol((TProtocol)protocol, "SentryHDFSService");
        this.client = new SentryHDFSService.Client((TProtocol)multiplexedProtocol);
    }

    private void invalidate() {
        if (this.transportWrapper != null) {
            this.pool.invalidateTransport(this.transportWrapper);
            if (logger.isDebugEnabled()) {
                logger.debug("invalidate transportWrapper: {}", (Object)this.transportWrapper);
            }
            this.transportWrapper = null;
        }
    }

    public SentryAuthzUpdate getAllUpdatesFrom(long permissionSeqN, long pathSeqN) throws SentryHdfsServiceException {
        return this.getAllUpdatesFrom(permissionSeqN, pathSeqN, -1L);
    }

    public SentryAuthzUpdate getAllUpdatesFrom(long permissionSeqN, long pathSeqN, long pathImgN) throws SentryHdfsServiceException {
        try {
            this.connect();
        }
        catch (InterruptedException e) {
            throw new SentryHdfsServiceException("interrupted exception when connect.", (Throwable)e);
        }
        SentryHdfsServiceException throwable = null;
        for (int retry = 0; retry < this.maxRetryCount; ++retry) {
            try {
                return this.getAuthzUpdates(permissionSeqN, pathSeqN, pathImgN);
            }
            catch (SentryHdfsServiceException e) {
                throwable = e;
                if (!(e.getCause() instanceof TTransportException)) {
                    throw e;
                }
                logger.error("failed to connect thrift server.", (Throwable)e);
                this.invalidate();
                continue;
            }
        }
        throw new SentryHdfsServiceException("getAllUpdatesFrom failed.", (Throwable)throwable);
    }

    public void close() throws Exception {
        if (this.transportWrapper != null) {
            this.pool.returnTransport(this.transportWrapper);
            this.transportWrapper = null;
            this.pool.close();
        }
    }

    public boolean isClosed() {
        return this.pool.getIsClose();
    }
}

