/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry;

import com.huawei.osc.acl.auth.KerberosUtil;
import com.huawei.osc.acl.common.ConfigurationWrapper;
import com.huawei.osc.acl.sentry.HdfsServiceClient;
import com.huawei.osc.acl.sentry.thrift.TransportConfig;
import com.huawei.osc.acl.sentry.thrift.TransportFactory;
import com.huawei.osc.acl.sentry.thrift.TransportPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsServiceClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(HdfsServiceClientFactory.class);
    private static final Map<ConfigurationWrapper, HdfsServiceClient> CACHED_CLIENT = new ConcurrentHashMap<ConfigurationWrapper, HdfsServiceClient>();

    public static HdfsServiceClient create(ConfigurationWrapper configWrapper) {
        HdfsServiceClient client = CACHED_CLIENT.get(configWrapper);
        if (client != null && !client.isClosed()) {
            return client;
        }
        Configuration configuration = configWrapper.getConfiguration();
        String securityMode = configuration.get("sentry.hdfs.service.security.mode", "kerberos").trim();
        if ("kerberos".equals(securityMode)) {
            UserGroupInformation ugi = KerberosUtil.configKerberos(configuration);
            configWrapper.setUgi(ugi);
        }
        TransportConfig transportConfig = new TransportConfig(configuration, configWrapper.getUgi());
        TransportFactory sentryTransportFactory = new TransportFactory(transportConfig);
        TransportPool transportPool = new TransportPool(transportConfig, sentryTransportFactory);
        HdfsServiceClient newClient = new HdfsServiceClient(configuration, transportPool);
        CACHED_CLIENT.put(configWrapper, newClient);
        logger.debug("create HdfsServiceClient with Conf: {}", (Object)configWrapper);
        return newClient;
    }

    public static void close(ConfigurationWrapper configurationWrapper) {
        HdfsServiceClient client = CACHED_CLIENT.get(configurationWrapper);
        if (client == null) {
            return;
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            logger.error("close HdfsServiceClient failed. {}", (Object)exception.getMessage(), (Object)exception);
        }
        CACHED_CLIENT.remove(configurationWrapper);
    }
}

