/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry;

import com.huawei.osc.acl.AclInfoAdapter;
import com.huawei.osc.acl.alarm.ThirdAclServerStatusMonitor;
import com.huawei.osc.acl.common.ConfigurationWrapper;
import com.huawei.osc.acl.common.GeneralThreadFactoryBuilder;
import com.huawei.osc.acl.common.SyncResult;
import com.huawei.osc.acl.common.ValidationFailure;
import com.huawei.osc.acl.sentry.HdfsServiceClientFactory;
import com.huawei.osc.acl.sentry.utils.CheckSentryJarUtils;
import com.huawei.osc.acl.task.MemcacheAction;
import com.huawei.osc.acl.task.MemcacheActionProcessor;
import com.huawei.osc.acl.task.MemcacheActionType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.core.common.exception.SentryHdfsServiceException;
import org.apache.sentry.hdfs.SentryAuthorizationConstants;
import org.apache.sentry.hdfs.SentryAuthzUpdate;
import org.apache.sentry.hdfs.SentryHDFSServiceClient;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.UpdateableAuthzPaths;
import org.apache.sentry.hdfs.UpdateableAuthzPermissions;
import org.apache.sentry.hdfs.service.thrift.TPathEntry;
import org.apache.sentry.hdfs.service.thrift.TPathsDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.eds.client.Policy;
import uds.eds.client.PolicyEntry;
import uds.eds.client.ThirdAclPolicy;

public class SentryAuthorizationInfoAdapter
implements Runnable,
AclInfoAdapter {
    private static final Logger logger = LoggerFactory.getLogger(SentryAuthorizationInfoAdapter.class);
    private static final int SENTRY_TYPE = 2;
    private static final int SENTRY_POLICY_TYPE_INCLUDE_HDFS = 1;
    private static final int SENTRY_POLICY_TYPE_PREFIX_PATH = 2;
    private static final String COM_L = "RULE:[2:$1@$0](.*@%s$)s/@%s//L";
    private ScheduledExecutorService executorService;
    private String[] syncPathPrefixes;
    private int syncIntervalMillSec;
    private int staleThresholdMillSec;
    private final ConfigurationWrapper configWrapper;
    private boolean isOld = false;
    private SentrySync sentrySync;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile UpdateableAuthzPaths updateableAuthzPaths;
    private volatile UpdateableAuthzPermissions updateableAuthzPermissions;
    private int namespaceId;
    private String sentryAddr;
    private long continuousFailTimes = 0L;
    private boolean isStale = false;
    private long lastUpdateTime;
    private String user;
    private String group;
    private int userPermission;
    private int groupPermission;
    private int otherPermission;
    private boolean isIncludeOriginHdfsAcl;
    private int maxSentryPolicySize;
    private int maxUGSize;

    public SentryAuthorizationInfoAdapter(ConfigurationWrapper configWrapper) {
        this.configWrapper = configWrapper;
        Configuration configuration = configWrapper.getConfiguration();
        this.sentryAddr = configuration.get("sentry.hdfs.service.client.server.rpc-addresses");
        String nsIdStr = configuration.get("plugin.hdfs.namespace.id");
        this.isOld = configuration.getBoolean("sentry.hdfs.service.client.old.server", false);
        try {
            this.namespaceId = Integer.parseInt(nsIdStr);
        }
        catch (NumberFormatException exception) {
            logger.error("Wrong format namespace id.", (Throwable)exception);
            throw new IllegalArgumentException("Invalid format namespace id");
        }
        this.verifySentryJar();
        String[] syncPathPrefix = configuration.getTrimmedStrings("sentry.authorization-provider.hdfs-path-prefixes", SentryAuthorizationConstants.HDFS_PATH_PREFIXES_DEFAULT);
        if (syncPathPrefix.length == 0) {
            logger.warn("HDFS Path for sync prefix is empty. so Sentry Auth is ignored.");
            return;
        }
        String delimiter = "/";
        this.syncPathPrefixes = new String[syncPathPrefix.length];
        for (int i = 0; i < syncPathPrefix.length; ++i) {
            if (!syncPathPrefix[i].startsWith(delimiter)) {
                logger.warn("Sync prefix [" + syncPathPrefix[i] + "] is not start with [/].");
                throw new IllegalArgumentException("Sync prefix [" + syncPathPrefix[i] + "] is not start with [/].");
            }
            this.syncPathPrefixes[i] = syncPathPrefix[i];
        }
        this.setSentryParams(configuration, syncPathPrefix);
        this.updateableAuthzPaths = new UpdateableAuthzPaths(syncPathPrefix);
        this.updateableAuthzPermissions = new UpdateableAuthzPermissions();
        this.sentrySync = new SentrySync();
    }

    private void verifySentryJar() {
        List<String> sentryPluginJarList = CheckSentryJarUtils.getSentryJar(new File("/opt/dfv/obs_service_layer/objectwebservice/osc/third/jetty/webapps/root/WEB-INF/lib/"));
        if (sentryPluginJarList.size() != 4) {
            logger.error("sentry plugin jars counts are [{}], not correct.", (Object)sentryPluginJarList.size());
            String alarmInfo = String.format(Locale.ROOT, "[%s] namespaceId[%d] sentry plugin jars counts are [%d] not correct.", this.sentryAddr, this.namespaceId, sentryPluginJarList.size());
            throw new IllegalArgumentException("sentry plugin jars counts are " + sentryPluginJarList.size() + ", not correct.");
        }
        try {
            CheckSentryJarUtils.setIsCustomizedSentry(CheckSentryJarUtils.hasCustomizedJar(sentryPluginJarList));
            if (!CheckSentryJarUtils.isCustomizedSentry()) {
                CheckSentryJarUtils.hasTargetOpenSourceJar(this.isOld, sentryPluginJarList);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error("error sentry jar.");
            throw new IllegalArgumentException("error sentry jar.");
        }
    }

    private void setSentryParams(Configuration configuration, String[] syncPathPrefix) {
        this.isIncludeOriginHdfsAcl = configuration.getBoolean("sentry.authorization-provider.include-hdfs-authz-as-acl", false);
        this.user = configuration.get("sentry.authorization-provider.hdfs-user", "hive");
        this.group = configuration.get("sentry.authorization-provider.hdfs-group", "hive");
        this.longPermFormat(configuration.getLong("sentry.authorization-provider.hdfs-permission", 505L));
        logger.info("Sentry Auth is starting to sync these HDFS locations: [{}] with namespace ID [{}]", (Object)Arrays.deepToString(syncPathPrefix), (Object)this.namespaceId);
        this.syncIntervalMillSec = configuration.getInt("sentry.authorization-provider.cache-refresh-interval.ms", 500);
        this.staleThresholdMillSec = configuration.getInt("sentry.authorization-provider.cache-stale-threshold.ms", 60000);
        this.isStale = 0 != this.staleThresholdMillSec;
        logger.info("Sentry Auth sync with Sync Interval: [{}]ms, Stale Threshold: [{}]ms, Stale Switch: {}", new Object[]{this.syncIntervalMillSec, this.staleThresholdMillSec, this.isStale});
    }

    private void longPermFormat(long perm) {
        this.userPermission = (int)(perm >>> 6 & 7L);
        this.groupPermission = (int)(perm >>> 3 & 7L);
        this.otherPermission = (int)(perm & 7L);
    }

    @Override
    public void start() {
        SyncResult result;
        try {
            result = this.update(true);
        }
        catch (Exception e) {
            logger.warn("Failed to do start update full auth info and will retry in [{}]ms, error: ", (Object)e.getMessage(), (Object)e);
            result = SyncResult.FAILED;
        }
        switch (result) {
            case FAILED: {
                ++this.continuousFailTimes;
                break;
            }
            case NODATA: {
                this.continuousFailTimes = 0L;
                break;
            }
            case DATA: {
                this.continuousFailTimes = 0L;
                this.sync();
            }
        }
        if (this.executorService == null) {
            ThreadFactory sentryAuthSyncThreadFactory = new GeneralThreadFactoryBuilder().setNameFormat("Sentry-Ns:" + this.namespaceId + "-" + this.getHost().replace(':', '-')).setDaemon(true).build();
            this.executorService = new ScheduledThreadPoolExecutor(10, sentryAuthSyncThreadFactory);
        }
        logger.info("executor service: scheduling...");
        this.executorService.scheduleWithFixedDelay(this, this.syncIntervalMillSec, this.syncIntervalMillSec, TimeUnit.MILLISECONDS);
        ThirdAclServerStatusMonitor.getInstance().register(this);
    }

    @Override
    public void stop() {
        if (this.updateableAuthzPaths != null) {
            this.executorService.shutdownNow();
            this.sentrySync.close();
            UserGroupInformation ugi = this.configWrapper.getUgi();
            if (ugi != null) {
                try {
                    ugi.logoutUserFromKeytab();
                }
                catch (IOException e) {
                    logger.error("Ugi logout failed.", (Throwable)e);
                }
            }
            logger.info("Sentry sync {} : Stopping", (Object)this.getClass().getSimpleName());
        }
        ThirdAclServerStatusMonitor.getInstance().unregister(this);
    }

    @Override
    public String getHost() {
        Configuration configuration = this.configWrapper.getConfiguration();
        return configuration.get("sentry.hdfs.service.client.server.rpc-addresses") + ":" + configuration.get("sentry.hdfs.service.client.server.rpc-port");
    }

    @Override
    public int getNamespaceId() {
        return this.namespaceId;
    }

    @Override
    public Configuration getConfig() {
        return this.configWrapper.getConfiguration();
    }

    @Override
    public long getContinuousFailedNums() {
        return this.continuousFailTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncResult update(boolean isFull) {
        SentryAuthzUpdate update = isFull ? this.sentrySync.getFullUpdates() : this.sentrySync.getIncUpdates();
        if (update == null) {
            return SyncResult.FAILED;
        }
        this.lastUpdateTime = System.currentTimeMillis();
        if (update.isEmpty()) {
            return SyncResult.NODATA;
        }
        update = this.sentrySync.getFullUpdates();
        UpdateableAuthzPaths newAuthzPaths = this.process(update.getPathUpdates(), this.updateableAuthzPaths);
        UpdateableAuthzPermissions newAuthzPermissions = this.process(update.getPermUpdates(), this.updateableAuthzPermissions);
        if (newAuthzPaths == this.updateableAuthzPaths && newAuthzPermissions == this.updateableAuthzPermissions) {
            this.debugLogWhenEquals(update);
            return SyncResult.DATA;
        }
        this.lock.writeLock().lock();
        try {
            logger.debug("Got updates: {}", (Object)update.dumpContent());
            if (newAuthzPaths != this.updateableAuthzPaths) {
                logger.info("Full updated paths seq number [old:{}] [new:{}]", (Object)this.updateableAuthzPaths.getLastUpdatedSeqNum(), (Object)newAuthzPaths.getLastUpdatedSeqNum());
                this.updateableAuthzPaths = newAuthzPaths;
                logger.trace("Merge path updates: {}", (Object)this.updateableAuthzPaths.dumpContent());
            }
            if (newAuthzPermissions != this.updateableAuthzPermissions) {
                logger.info("Full updated permission seq number [old:{}] [new:{}]", (Object)this.updateableAuthzPermissions.getLastUpdatedSeqNum(), (Object)newAuthzPermissions.getLastUpdatedSeqNum());
                this.updateableAuthzPermissions = newAuthzPermissions;
                logger.trace("Merge permission updates: {}", (Object)this.updateableAuthzPermissions.dumpContent());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return SyncResult.DATA;
    }

    private void debugLogWhenEquals(SentryAuthzUpdate update) {
        this.lock.writeLock().lock();
        try {
            logger.debug("Got updates: {}", (Object)update.dumpContent());
            logger.debug("Merge path updates: {}", (Object)this.updateableAuthzPaths.dumpContent());
            logger.debug("Merge permission updates: {}", (Object)this.updateableAuthzPermissions.dumpContent());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private <E extends Updateable.Update, S extends Updateable<E>> S process(List<E> updates, S originUpdates) {
        Object newUpdates = originUpdates;
        if (updates.isEmpty()) {
            return newUpdates;
        }
        if (((Updateable.Update)updates.get(0)).hasFullImage()) {
            logger.info("Process Update : Full update [{}] - [{}] - [{}]", new Object[]{newUpdates.getClass().getSimpleName(), ((Updateable.Update)updates.get(0)).getSeqNum(), ((Updateable.Update)updates.get(0)).getImgNum()});
            newUpdates = newUpdates.updateFull((Updateable.Update)updates.remove(0));
        }
        if (!updates.isEmpty()) {
            logger.info("Process Update : More updates [{}] - [{}] - [{}] - [{}]", new Object[]{newUpdates.getClass().getSimpleName(), newUpdates.getLastUpdatedSeqNum(), newUpdates.getLastUpdatedImgNum(), updates.size()});
            newUpdates.updatePartial(updates, this.lock);
        }
        logger.debug("Process Update : Finished updates. [{}] - [{}] - [{}]", new Object[]{newUpdates.getClass().getSimpleName(), newUpdates.getLastUpdatedSeqNum(), newUpdates.getLastUpdatedImgNum()});
        return newUpdates;
    }

    @Override
    public void run() {
        try {
            SyncResult result = this.update(false);
            switch (result) {
                case FAILED: {
                    ++this.continuousFailTimes;
                    logger.info("==>continuousFailTimes [{}]", (Object)this.continuousFailTimes);
                    return;
                }
                case NODATA: {
                    this.continuousFailTimes = 0L;
                    return;
                }
                case DATA: {
                    this.continuousFailTimes = 0L;
                    this.sync();
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Failed to sync, {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void sync() {
        ThirdAclPolicy thirdAclPolicy;
        List<Policy> originPolicies = this.getOriginPolicy();
        ArrayList<ValidationFailure> validationFailureList = new ArrayList<ValidationFailure>();
        this.loadSpecification();
        long now = System.currentTimeMillis();
        long lag = now - this.lastUpdateTime;
        if (this.isStale && lag > (long)this.staleThresholdMillSec) {
            logger.warn("Acl info has been stale for {}ms", (Object)lag);
            thirdAclPolicy = ThirdAclPolicy.builder().namespaceId(this.namespaceId).type(2).build();
            logger.warn("update for sentry policy: [{}]", (Object)thirdAclPolicy);
        } else {
            HashMap<String, List<String>> pathList = new HashMap<String, List<String>>();
            TPathsDump pathsDump = this.updateableAuthzPaths.getPathsDump().createPathsDump(false);
            Map nodeMap = pathsDump.getNodeMap();
            int rootId = pathsDump.getRootId();
            String path = "";
            this.getFullPath(nodeMap, rootId, path, pathList);
            logger.debug("pathList: {}", (Object)((Object)pathList).toString());
            AtomicInteger size = new AtomicInteger();
            ArrayList policies = new ArrayList();
            pathList.forEach((node, authObjs) -> size.addAndGet(this.translateAuthObjs(policies, (String)node, (List<String>)authObjs, (List<ValidationFailure>)validationFailureList, this.maxUGSize)));
            this.validatePathCount(validationFailureList, size.get(), this.maxSentryPolicySize);
            thirdAclPolicy = ThirdAclPolicy.builder().namespaceId(this.namespaceId).type(2).policies(policies).build();
        }
        if (validationFailureList.size() > 0) {
            String errorMsg = ValidationFailure.serializeFailures(validationFailureList);
            logger.error("NS:{}. policy validation failed, ignore... {}", (Object)this.namespaceId, (Object)errorMsg);
            return;
        }
        thirdAclPolicy.getPolicies().addAll(originPolicies);
        logger.info("update for sentry policy: {}", (Object)this.prettyFormat(thirdAclPolicy));
        String version = String.format(Locale.ENGLISH, "%s#%d#%d", "sentry", this.namespaceId, now);
        thirdAclPolicy.setVersion(version);
        MemcacheAction action = MemcacheAction.builder().policy(thirdAclPolicy).type(MemcacheActionType.UPDATE).build();
        MemcacheActionProcessor.getInstance().put(this.namespaceId, action);
    }

    private void loadSpecification() {
        this.maxSentryPolicySize = OBSConfig.getInstance().getInt("sentry_policy_max_number_of_namespace", 200);
        this.maxUGSize = OBSConfig.getInstance().getInt("sentry_policy_max_ug_count_of_path", 10);
    }

    private void validatePathCount(List<ValidationFailure> validationFailureList, int size, int maxSentryPolicySize) {
        if (maxSentryPolicySize < size) {
            validationFailureList.add(ValidationFailure.builder().field("policy size").msg("exceeds the limit " + maxSentryPolicySize + ", with count: " + size).build());
        }
    }

    private List<Policy> getOriginPolicy() {
        List<String> userIds = Collections.singletonList(this.user);
        List<String> groupIds = Collections.singletonList(this.group);
        ArrayList<Policy> originPolicies = new ArrayList<Policy>();
        for (String syncPathPrefix : this.syncPathPrefixes) {
            Policy prefixPolicy;
            List<String> paths = Collections.singletonList(syncPathPrefix);
            if (!this.isIncludeOriginHdfsAcl) {
                originPolicies.add(Policy.builder().policyType(1).paths(paths).isRecursive(true).policyEntryAllow(Collections.singletonList(PolicyEntry.builder().userIds(userIds).permissions(this.userPermission).build())).build());
                originPolicies.add(Policy.builder().policyType(1).paths(paths).isRecursive(true).policyEntryAllow(Collections.singletonList(PolicyEntry.builder().groupIds(groupIds).permissions(this.groupPermission).build())).build());
                prefixPolicy = Policy.builder().policyType(2).paths(paths).isRecursive(true).policyEntryAllow(Collections.singletonList(PolicyEntry.builder().permissions(this.otherPermission).build())).build();
            } else {
                prefixPolicy = Policy.builder().policyType(2).paths(paths).isRecursive(true).build();
            }
            originPolicies.add(prefixPolicy);
        }
        return originPolicies;
    }

    private String prettyFormat(ThirdAclPolicy thirdAclPolicy) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ThirdAclPolicy] nsId=").append(thirdAclPolicy.getNamespaceId()).append(", policies=[");
        List policies = thirdAclPolicy.getPolicies();
        if (!policies.isEmpty()) {
            builder.append(System.lineSeparator());
            for (Policy policy : policies) {
                builder.append('\t').append("[path=").append(policy.getPaths()).append(", type=").append(policy.getPolicyType()).append(", recur=").append(policy.isRecursive()).append(", perm=[").append(policy.getPolicyEntryAllow()).append("]]").append(System.lineSeparator());
            }
        }
        builder.append("]");
        return builder.toString();
    }

    private int translateAuthObjs(List<Policy> policies, String node, List<String> authObjs, List<ValidationFailure> validationFailureList, int maxUgCount) {
        ArrayList aclEntryList = new ArrayList();
        for (String authObj : authObjs) {
            List aclEntries = this.updateableAuthzPermissions.getAcls(authObj);
            aclEntryList.addAll(aclEntries);
            for (AclEntry aclEntry2 : aclEntries) {
                logger.debug("path: {} authObj: {} aclEntry: {}", new Object[]{node, authObj, aclEntry2});
                policies.add(this.convert(node, aclEntry2));
            }
        }
        Map<String, List<AclEntry>> groupedAcls = aclEntryList.stream().collect(Collectors.groupingBy(aclEntry -> aclEntry.getType().toString() + aclEntry.getScope() + aclEntry.getName()));
        this.validateUgCount(validationFailureList, groupedAcls.size(), maxUgCount);
        return aclEntryList.size() > 0 ? 1 : 0;
    }

    private void validateUgCount(List<ValidationFailure> validationFailureList, int groupedSize, int maxUgCount) {
        if (groupedSize > maxUgCount) {
            validationFailureList.add(ValidationFailure.builder().field("role size").msg("exceeds the limit " + maxUgCount + ", with count: " + groupedSize).build());
        }
    }

    private Policy convert(String node, AclEntry aclEntry) {
        PolicyEntry.PolicyEntryBuilder builder = PolicyEntry.builder();
        switch (aclEntry.getType()) {
            case USER: {
                builder.userIds(Collections.singletonList(aclEntry.getName()));
                break;
            }
            case GROUP: {
                builder.groupIds(Collections.singletonList(aclEntry.getName()));
                break;
            }
        }
        PolicyEntry policyEntry = builder.permissions(aclEntry.getPermission().ordinal()).build();
        return Policy.builder().paths(Collections.singletonList(node)).isRecursive(AclEntryScope.ACCESS.equals((Object)aclEntry.getScope())).policyEntryAllow(Collections.singletonList(policyEntry)).build();
    }

    private void getFullPath(Map<Integer, TPathEntry> pathMap, int id, String path, Map<String, List<String>> pathList) {
        String newPath = path;
        TPathEntry node = pathMap.get(id);
        String pathElement = node.getPathElement();
        if (!pathElement.equals("/")) {
            newPath = newPath + pathElement;
        }
        if (node.getChildrenSize() == 0) {
            List authObjs = node.getAuthzObjs();
            if (authObjs != null && authObjs.size() > 0) {
                pathList.put(newPath, authObjs);
            }
        } else {
            newPath = newPath + "/";
            for (Integer child : node.getChildren()) {
                TPathEntry childNode = pathMap.get(child);
                List authObjs = childNode.getAuthzObjs();
                if (authObjs != null && authObjs.size() > 0) {
                    pathList.put(newPath + childNode.getPathElement(), childNode.getAuthzObjs());
                }
                this.getFullPath(pathMap, child, newPath, pathList);
            }
        }
    }

    class SentrySync {
        private SentryHDFSServiceClient client;

        SentrySync() {
        }

        SentryAuthzUpdate getIncUpdates() {
            return this.getUpdates(SentryAuthorizationInfoAdapter.this.updateableAuthzPermissions.getLastUpdatedSeqNum() + 1L, SentryAuthorizationInfoAdapter.this.updateableAuthzPaths.getLastUpdatedSeqNum() + 1L, SentryAuthorizationInfoAdapter.this.updateableAuthzPaths.getLastUpdatedImgNum());
        }

        SentryAuthzUpdate getFullUpdates() {
            return this.getUpdates(-1L, -1L, 0L);
        }

        SentryAuthzUpdate getUpdates(long permissionSeqNum, long authPathSeqNum, long authPathImgNum) {
            if (this.client == null && this.buildClient() == null) {
                return null;
            }
            try {
                return this.client.getAllUpdatesFrom(permissionSeqNum, authPathSeqNum, authPathImgNum);
            }
            catch (SentryHdfsServiceException exception) {
                logger.error("Error occurs when sync auth infos from Sentry Server.", (Throwable)exception);
                this.client = null;
                return null;
            }
        }

        private SentryHDFSServiceClient buildClient() {
            try {
                this.client = HdfsServiceClientFactory.create(SentryAuthorizationInfoAdapter.this.configWrapper);
            }
            catch (Exception exception) {
                logger.error("Error occurs when create connection to Sentry Server.", (Throwable)exception);
                return null;
            }
            return this.client;
        }

        private void close() {
            HdfsServiceClientFactory.close(SentryAuthorizationInfoAdapter.this.configWrapper);
        }
    }
}

