/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry.thrift;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.core.common.exception.MissingConfigurationException;

public class TransportConfig {
    private final Configuration configuration;
    private final UserGroupInformation ugi;

    public TransportConfig(Configuration configuration) {
        this(configuration, null);
    }

    public TransportConfig(Configuration configuration, UserGroupInformation ugi) {
        this.configuration = configuration;
        this.ugi = ugi;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public String getAddress() {
        String address = this.configuration.get("sentry.hdfs.service.client.server.rpc-addresses");
        if (StringUtils.isEmpty((CharSequence)address)) {
            throw new MissingConfigurationException("sentry.hdfs.service.client.server.rpc-addresses");
        }
        return address;
    }

    public int getPort() {
        try {
            return this.configuration.getInt("sentry.hdfs.service.client.server.rpc-port", 8038);
        }
        catch (NumberFormatException ignore) {
            return 8038;
        }
    }

    public boolean isUseKerberos() {
        return "kerberos".equals(this.configuration.get("sentry.hdfs.service.security.mode", "kerberos").trim());
    }

    public String getPrincipal() {
        String principal = this.configuration.get("sentry.hdfs.service.server.principal");
        if (StringUtils.isEmpty((CharSequence)principal)) {
            throw new MissingConfigurationException("sentry.hdfs.service.server.principal");
        }
        return principal;
    }

    public int getTimeout() {
        return this.configuration.getInt("sentry.hdfs.service.client.server.rpc-connection-timeout", 1200000);
    }

    public int getMaxTotalOfPool() {
        return this.configuration.getInt("sentry.hdfs.service.client.connection.pool.max-total", 16);
    }

    public int getMinIdleOfPool() {
        return this.configuration.getInt("sentry.service.client.connection.pool.min-idle", 0);
    }

    public int getMaxIdleOfPool() {
        return this.configuration.getInt("sentry.service.client.connection.pool.max-idle", 8);
    }

    public long getMinEvictableIdleTimeSec() {
        return this.configuration.getLong("sentry.hdfs.service.client.connection.pool.eviction.mintime.sec", 0L);
    }

    public long getTimeBetweenEvictionRunsSec() {
        return this.configuration.getLong("sentry.hdfs.service.client.connection.pool.eviction.interval.sec", -1L);
    }

    public boolean isLoadBalancing() {
        return this.configuration.getBoolean("sentry.service.client.connection.loadbalance", true);
    }

    public boolean isPoolEnabled() {
        return this.configuration.getBoolean("sentry.hdfs.service.client.connection.pool.enable", false);
    }
}

