/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry.thrift;

import com.huawei.osc.acl.common.HostInfo;
import com.huawei.osc.acl.sentry.thrift.TTransportWrapper;
import com.huawei.osc.acl.sentry.thrift.TransportConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportFactory {
    private static final Logger logger = LoggerFactory.getLogger(TransportFactory.class);
    private static final Map<String, String> SASL_PROPERTIES = new HashMap<String, String>();
    private final String principal;
    private final boolean isUseKerberos;
    private final UserGroupInformation ugi;
    private final int connTimeout;

    public TransportFactory(TransportConfig config) {
        if (config == null) {
            throw new NullPointerException("Config of TransportConfig is null.");
        }
        this.connTimeout = config.getTimeout();
        this.isUseKerberos = config.isUseKerberos();
        this.ugi = config.getUgi();
        this.principal = this.isUseKerberos ? config.getPrincipal() : null;
    }

    public TTransportWrapper getTransport(HostInfo hostInfo) throws IOException, TTransportException {
        TTransport transport = this.create(hostInfo);
        transport.open();
        return new TTransportWrapper(transport, hostInfo);
    }

    private TTransport create(HostInfo hostInfo) throws TTransportException, IOException {
        String host = hostInfo.getHost();
        int port = hostInfo.getPort();
        TSocket transport = new TSocket(null, host, port, this.connTimeout);
        if (!this.isUseKerberos) {
            if (logger.isDebugEnabled()) {
                logger.debug("created connection without kerberos: {} {}", (Object)host, (Object)port);
            }
            return transport;
        }
        String[] principalParts = SaslRpcServer.splitKerberosName((String)this.principal);
        if (principalParts.length != 3) {
            throw new IOException("Principal of kerberos not match 3 parts: " + this.principal);
        }
        UgiSaslTransport con = new UgiSaslTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), principalParts[0], principalParts[1], (TTransport)transport, this.ugi);
        if (logger.isDebugEnabled()) {
            logger.debug("created connection with kerberos: {} {}", (Object)host, (Object)port);
        }
        return con;
    }

    static {
        SASL_PROPERTIES.put("javax.security.sasl.server.authentication", "true");
        SASL_PROPERTIES.put("javax.security.sasl.qop", "auth-conf");
    }

    static class UgiSaslTransport
    extends TSaslClientTransport {
        private UserGroupInformation ugi = null;

        public UgiSaslTransport(String mechanism, String protocol, String serverName, TTransport transport, UserGroupInformation ugi) throws IOException, TTransportException {
            super(mechanism, null, protocol, serverName, SASL_PROPERTIES, null, transport);
            if (ugi != null) {
                this.ugi = ugi;
            }
        }

        public void open() throws TTransportException {
            if (this.ugi == null) {
                this.superOpen();
                return;
            }
            try {
                if (this.ugi.isFromKeytab()) {
                    this.ugi.checkTGTAndReloginFromKeytab();
                }
                this.ugi.doAs(() -> {
                    this.superOpen();
                    return null;
                });
            }
            catch (IOException e) {
                throw new TTransportException("open sasl transport failed: " + e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new TTransportException("interrupted happen when open transport: " + e.getMessage(), (Throwable)e);
            }
        }

        private void superOpen() throws TTransportException {
            super.open();
        }
    }
}

