/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry.thrift;

import com.huawei.osc.acl.common.HostInfo;
import com.huawei.osc.acl.sentry.thrift.TTransportWrapper;
import com.huawei.osc.acl.sentry.thrift.TransportConfig;
import com.huawei.osc.acl.sentry.thrift.TransportFactory;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportPool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TransportPool.class);
    private static final int TRANSPORT_RETRY_TIMES = 2;
    private final boolean isPoolEnabled;
    private final boolean isLoadBalancing;
    private final List<HostInfo> hostInfos;
    private final KeyedObjectPool<HostInfo, TTransportWrapper> pool;
    private final TransportFactory transportFactory;
    private final AtomicBoolean isClose = new AtomicBoolean();

    public TransportPool(TransportConfig config, TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
        this.isPoolEnabled = config.isPoolEnabled();
        this.isLoadBalancing = config.isLoadBalancing();
        String address = config.getAddress();
        int port = config.getPort();
        String[] hosts = address.split(",", -1);
        this.hostInfos = new ArrayList<HostInfo>(hosts.length);
        for (String host : hosts) {
            HostInfo hostInfo = HostInfo.fromString(HostInfo.Scheme.THRIFT, host, port);
            this.hostInfos.add(hostInfo);
            logger.info("add host info {}", (Object)hostInfo);
        }
        if (!this.isPoolEnabled) {
            this.pool = null;
            logger.info("switch of connection pool is closed.");
            return;
        }
        logger.info("switch of connection pool is opened");
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setMaxTotal(-1);
        poolConfig.setMaxIdlePerKey(config.getMaxIdleOfPool());
        poolConfig.setMinIdlePerKey(config.getMinIdleOfPool());
        poolConfig.setTestOnReturn(true);
        poolConfig.setBlockWhenExhausted(false);
        poolConfig.setMaxIdlePerKey(config.getMaxTotalOfPool());
        poolConfig.setMinEvictableIdleTimeMillis(config.getMinEvictableIdleTimeSec());
        poolConfig.setTimeBetweenEvictionRunsMillis(config.getTimeBetweenEvictionRunsSec());
        this.pool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new KeyPoolFactory(transportFactory));
    }

    public TTransportWrapper getTransportWrapper() throws Exception {
        List<HostInfo> addresses;
        if (this.hostInfos.size() > 1 && this.isLoadBalancing) {
            addresses = new ArrayList<HostInfo>(this.hostInfos);
            Collections.shuffle(addresses);
        } else {
            addresses = this.hostInfos;
        }
        boolean isSkipEmptyPool = true;
        Exception exception = null;
        for (int i = 0; i < 2; ++i) {
            for (HostInfo address : addresses) {
                if (this.isPoolEnabled && isSkipEmptyPool && this.pool.getNumIdle((Object)address) == 0) {
                    isSkipEmptyPool = false;
                    continue;
                }
                try {
                    TTransportWrapper transportWrapper = this.isPoolEnabled ? (TTransportWrapper)this.pool.borrowObject((Object)address) : this.transportFactory.getTransport(address);
                    this.logWhenBorrowed(transportWrapper);
                    return transportWrapper;
                }
                catch (Exception e) {
                    exception = e;
                    logger.error("Got transport error .", (Throwable)e);
                }
            }
            isSkipEmptyPool = false;
        }
        if (exception == null) {
            throw new UnexpectedException("Unexpected error happened when got connection");
        }
        throw exception;
    }

    private void logWhenBorrowed(TTransportWrapper transportWrapper) {
        if (logger.isDebugEnabled()) {
            if (this.isPoolEnabled) {
                logger.debug("Got transportWrapper {} from pool with numActive {} and numIdle {}", new Object[]{transportWrapper, this.pool.getNumActive(), this.pool.getNumIdle()});
            } else {
                logger.debug("Got transportWrapper {}", (Object)transportWrapper);
            }
        }
    }

    public void returnTransport(TTransportWrapper transportWrapper) {
        if (this.isClose.get()) {
            logger.debug("returning a {} to a closed pool", (Object)transportWrapper);
            transportWrapper.close();
            return;
        }
        try {
            if (this.isPoolEnabled) {
                logger.debug("returning a {} to a pool", (Object)transportWrapper);
                this.pool.returnObject((Object)transportWrapper.getHostInfo(), (Object)transportWrapper);
            } else {
                logger.debug("closing {}", (Object)transportWrapper);
                transportWrapper.close();
            }
        }
        catch (Exception e) {
            logger.error("failed to return {}", (Object)transportWrapper, (Object)e);
        }
    }

    public void invalidateTransport(TTransportWrapper transportWrapper) {
        if (this.isClose.get()) {
            logger.debug("invalidate a {} for a closed pool", (Object)transportWrapper);
            transportWrapper.close();
            return;
        }
        try {
            logger.debug("invalidate [{}]", (Object)transportWrapper);
            if (this.isPoolEnabled) {
                this.pool.invalidateObject((Object)transportWrapper.getHostInfo(), (Object)transportWrapper);
                this.pool.clear((Object)transportWrapper.getHostInfo());
            } else {
                transportWrapper.close();
            }
        }
        catch (Exception e) {
            logger.error("failed to invalidate {}", (Object)transportWrapper, (Object)e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.isClose.get()) {
            return;
        }
        logger.info("closing transport pool...");
        if (this.pool != null) {
            this.pool.close();
        }
        this.isClose.compareAndSet(false, true);
    }

    public boolean getIsClose() {
        return this.isPoolEnabled || this.isClose.get();
    }

    private static class KeyPoolFactory
    extends BaseKeyedPooledObjectFactory<HostInfo, TTransportWrapper> {
        private final TransportFactory factory;

        public KeyPoolFactory(TransportFactory factory) {
            this.factory = factory;
        }

        public TTransportWrapper create(HostInfo hostInfo) throws Exception {
            TTransportWrapper transportWrapper = this.factory.getTransport(hostInfo);
            if (logger.isDebugEnabled()) {
                logger.debug("Pool created transport [{}]", (Object)transportWrapper);
            }
            return transportWrapper;
        }

        public PooledObject<TTransportWrapper> wrap(TTransportWrapper transportWrapper) {
            return new DefaultPooledObject((Object)transportWrapper);
        }

        public void destroyObject(HostInfo key, PooledObject<TTransportWrapper> pooledObject) throws Exception {
            TTransportWrapper transportWrapper = (TTransportWrapper)pooledObject.getObject();
            if (transportWrapper != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Pool destroy object [{}]", (Object)transportWrapper);
                }
                try {
                    transportWrapper.close();
                }
                catch (RuntimeException e) {
                    logger.error("Pool destroy object failed.", (Throwable)e);
                }
            }
        }

        public boolean validateObject(HostInfo key, PooledObject<TTransportWrapper> pooledObject) {
            TTransportWrapper transportWrapper = (TTransportWrapper)pooledObject.getObject();
            if (transportWrapper == null) {
                logger.error("Failed to get transport when validate");
                return false;
            }
            if (transportWrapper.getHostInfo() != key) {
                logger.error("Invalid transport {} for no matching {}", (Object)transportWrapper, (Object)key);
                return false;
            }
            return true;
        }
    }
}

