/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.sentry.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSentryJarUtils {
    public static final String JAR_BASE_PATH = "/opt/dfv/obs_service_layer/objectwebservice/osc/third/jetty/webapps/root/WEB-INF/lib/";
    public static final int SENTRY_JAR_CNT = 4;
    public static final String CUSTOMIZED_SENTRY_CORE_COMMON = "sentry-core-common-2.2.0-h0.dsiv.oceanstor_pacific_18510.r2.jar";
    public static final String CUSTOMIZED_SENTRY_HDFS_COMMON = "sentry-hdfs-common-2.2.0-h0.dsiv.oceanstor_pacific_18510.r2.jar";
    public static final String CUSTOMIZED_SENTRY_HDFS_NAMENODE_PLUGIN = "sentry-hdfs-namenode-plugin-2.2.0-h0.dsiv.oceanstor_pacific_18510.r2.jar";
    public static final String CUSTOMIZED_SENTRY_HDFS_SERVICE = "sentry-hdfs-service-2.2.0-h0.dsiv.oceanstor_pacific_18510.r2.jar";
    public static final String SENTRY_OLD_VERSION = "2.0.1";
    public static final String SENTRY_CORE_COMMON_2_0_1 = "sentry-core-common-2.0.1.jar";
    public static final String SENTRY_HDFS_COMMON_2_0_1 = "sentry-hdfs-common-2.0.1.jar";
    public static final String SENTRY_HDFS_NAMENODE_PLUGIN_2_0_1 = "sentry-hdfs-namenode-plugin-2.0.1.jar";
    public static final String SENTRY_HDFS_SERVICE_2_0_1 = "sentry-hdfs-service-2.0.1.jar";
    public static final String SENTRY_CORE_COMMON_2_1_0 = "sentry-core-common-2.1.0.jar";
    public static final String SENTRY_HDFS_COMMON_2_1_0 = "sentry-hdfs-common-2.1.0.jar";
    public static final String SENTRY_HDFS_NAMENODE_PLUGIN_2_1_0 = "sentry-hdfs-namenode-plugin-2.1.0.jar";
    public static final String SENTRY_HDFS_SERVICE_2_1_0 = "sentry-hdfs-service-2.1.0.jar";
    private static final Logger logger = LoggerFactory.getLogger(CheckSentryJarUtils.class);
    private static final String SENTRY_CORE_COMMON_2_0_1_DIGEST = "663e8d290b9a7671fcccab971d4c854d3251f67cfbac7fcc1bae551a1cb0b07d3986bf41d385f6b5acfe5abb27cbd82a18dac87ba95169d20fe165ee5a4ceec8";
    private static final String SENTRY_HDFS_COMMON_2_0_1_DIGEST = "b2d589ceb882958b6cfad2c6b96667f455e69854e04b965fda061cb1be0a36749ece6e568cc0f33d5e067d1c80786a2353cc9700b236ccc263ce37dcb9b9e77d";
    private static final String SENTRY_HDFS_NAMENODE_PLUGIN_2_0_1_DIGEST = "81e59c1c5792c5923f0ae7d251f40b64fa5205e1773e8c062a97f7abc35c3e75309d834114bb4e915641be408523e9053693744c3b6420b5081c9c310df942e1";
    private static final String SENTRY_HDFS_SERVICE_2_0_1_DIGEST = "814403883c18896361c9b3c0615dcc7a82caca725f169451eaf5e22dafe345a7c0f7515e1b84cc3df28e1f77f31204d42adc61059918b308577ffa10816ff53a";
    private static final String SENTRY_CORE_COMMON_2_1_0_DIGEST = "4dcd2abd226e496899b65f11a7f13c6f034438732a15abc9d7d1aa492a71ac8fdadf02556532ff1c977eb79cfebd97a393c36349bdb8b58d07db691d7022b173";
    private static final String SENTRY_HDFS_COMMON_2_1_0_DIGEST = "afba300d69f23b8a0487d3e549412c2eb8c6d233a266f637a859392a2e4ce6a97f0b1b75d2c85c6cce004cb34c26469e3002296c8226fd929b471cc1b7e1215d";
    private static final String SENTRY_HDFS_NAMENODE_PLUGIN_2_1_0_DIGEST = "e4e3b302f3a6ba34817e336692be50432cd6f32eb4217f67b06b3dc6339ea8dcdc4a05ceffaa5931227d1770dd58b2ef7817d76a3ccf908ec26c0f1a89b207fa";
    private static final String SENTRY_HDFS_SERVICE_2_1_0_DIGEST = "7e245924f487d84cf35a95e0eca47af3019fefeb5cbab8d8c086dd636130b848a3f4321900cedc74aa5f43fdcab8e4b646a65ab4be79c6fb0e3e2618eafdb303";
    private static boolean isCustomizedSentry;

    public static boolean isCustomizedSentry() {
        return isCustomizedSentry;
    }

    public static void setIsCustomizedSentry(boolean isCustomizedSentry) {
        CheckSentryJarUtils.isCustomizedSentry = isCustomizedSentry;
    }

    public static boolean hasCustomizedJar(List<String> sentryPluginJarList) {
        HashSet<String> customizedJarSet = new HashSet<String>();
        customizedJarSet.add(CUSTOMIZED_SENTRY_CORE_COMMON);
        customizedJarSet.add(CUSTOMIZED_SENTRY_HDFS_COMMON);
        customizedJarSet.add(CUSTOMIZED_SENTRY_HDFS_NAMENODE_PLUGIN);
        customizedJarSet.add(CUSTOMIZED_SENTRY_HDFS_SERVICE);
        return customizedJarSet.containsAll(sentryPluginJarList);
    }

    public static boolean hasTargetOpenSourceJar(boolean isOldVersion, List<String> sentryJarList) {
        HashMap<String, String> targetJarMap = new HashMap<String, String>();
        if (isOldVersion) {
            targetJarMap.put(SENTRY_CORE_COMMON_2_0_1, SENTRY_CORE_COMMON_2_0_1_DIGEST);
            targetJarMap.put(SENTRY_HDFS_COMMON_2_0_1, SENTRY_HDFS_COMMON_2_0_1_DIGEST);
            targetJarMap.put(SENTRY_HDFS_NAMENODE_PLUGIN_2_0_1, SENTRY_HDFS_NAMENODE_PLUGIN_2_0_1_DIGEST);
            targetJarMap.put(SENTRY_HDFS_SERVICE_2_0_1, SENTRY_HDFS_SERVICE_2_0_1_DIGEST);
        } else {
            targetJarMap.put(SENTRY_CORE_COMMON_2_1_0, SENTRY_CORE_COMMON_2_1_0_DIGEST);
            targetJarMap.put(SENTRY_HDFS_COMMON_2_1_0, SENTRY_HDFS_COMMON_2_1_0_DIGEST);
            targetJarMap.put(SENTRY_HDFS_NAMENODE_PLUGIN_2_1_0, SENTRY_HDFS_NAMENODE_PLUGIN_2_1_0_DIGEST);
            targetJarMap.put(SENTRY_HDFS_SERVICE_2_1_0, SENTRY_HDFS_SERVICE_2_1_0_DIGEST);
        }
        block0: for (String sentryJar : sentryJarList) {
            if (targetJarMap.isEmpty()) break;
            for (Map.Entry<String, String> entry : targetJarMap.entrySet()) {
                if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)sentryJar)) continue;
                CheckSentryJarUtils.checkDigest(sentryJar, entry);
                targetJarMap.remove(sentryJar);
                continue block0;
            }
        }
        for (String jarName : targetJarMap.keySet()) {
            logger.error("missing sentry plugin jar: [{}]", (Object)jarName);
        }
        return targetJarMap.isEmpty();
    }

    private static void checkDigest(String sentryJar, Map.Entry<String, String> jarEntry) {
        String digest = "";
        try {
            digest = new DigestUtils("SHA-512").digestAsHex(new File(JAR_BASE_PATH + sentryJar));
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Generate sentry jar's digest failed: %s", sentryJar), exception);
        }
        if (!StringUtils.equals((CharSequence)digest, (CharSequence)jarEntry.getValue())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "error sentry jar: %s", sentryJar));
        }
    }

    public static List<String> getSentryJar(File file) {
        ArrayList<String> sentryPluginJarList = new ArrayList<String>();
        File[] files = file.listFiles();
        if (files != null) {
            for (File jar : files) {
                if (!jar.getName().startsWith("sentry")) continue;
                sentryPluginJarList.add(jar.getName());
            }
        }
        return sentryPluginJarList;
    }
}

