/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.task.GetAclValueTaskListener;
import com.huawei.osc.acl.task.utils.ExecutorShutdownSupport;
import java.io.File;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAclValueControlTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GetAclValueControlTask.class);
    ExecutorShutdownSupport executorShutdownSupport = new ExecutorShutdownSupport();

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (Exception e) {
            log.error("GetAclValueControlTask meet Exception", (Throwable)e);
        }
    }

    private void doTask() {
        if (this.isConfigWatchDirHaveConf()) {
            if (GetAclValueTaskListener.getInstance().isExecutorOk()) {
                return;
            }
            GetAclValueTaskListener.getInstance().initialize();
        } else {
            if (!GetAclValueTaskListener.getInstance().isExecutorOk()) {
                return;
            }
            if (!GetAclValueTaskListener.getInstance().isAllAclPoliciesCleared()) {
                log.warn("Some namespaces still have policies, wait for next period to stop GetAclValueTask.");
                return;
            }
            log.warn("no acl config exist, stop GetAclValueTask.");
            boolean isShutdownSuccess = this.executorShutdownSupport.shutdown(GetAclValueTaskListener.getInstance().getExecutor(), true);
            if (!isShutdownSuccess) {
                this.executorShutdownSupport.shutdown(GetAclValueTaskListener.getInstance().getExecutor(), false);
            }
            GetAclValueTaskListener.getInstance().setExecutor(null);
        }
    }

    private boolean isConfigWatchDirHaveConf() {
        Collection localFiles = FileUtils.listFiles((File)new File("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl"), (String[])new String[]{"xml"}, (boolean)false);
        return CollectionUtils.isNotEmpty((Collection)localFiles);
    }
}

