/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.osc.acl.AclConstants;
import com.huawei.osc.acl.common.CommonMemCacheUtil;
import com.huawei.osc.acl.common.ThirdAclException;
import com.huawei.osc.acl.dao.ThirdAclPolicyDao;
import com.huawei.osc.acl.dao.ThirdAclPolicyDaoSpi;
import com.huawei.osc.acl.dao.ThirdAclPolicyInfo;
import com.huawei.osc.acl.task.PolicyLocalCacheProcessor;
import com.huawei.osc.acl.task.SubNotifyTask;
import com.huawei.osc.acl.task.entity.AclCacheData;
import com.huawei.osc.acl.task.entity.AclLocalFile;
import com.huawei.osc.acl.task.entity.AclMemCacheVersion;
import com.huawei.osc.acl.task.entity.RangerPolicy;
import com.huawei.osc.acl.task.entity.utils.AclPolicyConverter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.storage.exception.StorEngineException;
import uds.eds.adapter.EdsClientWrapper;
import uds.eds.client.ThirdAclPolicy;

public class GetAclValueTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GetAclValueTask.class);
    private static final int REFRESH_INTERVAL = 120;
    final Map<Integer, String> typeStringMap = new HashMap<Integer, String>();
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean isFirstStart = true;
    private Map<String, AclLocalFile> lastAclMap = new HashMap<String, AclLocalFile>();
    private String oldLastVersion = "";
    private int oldLastNamespaceId = -1;
    private boolean isOldLastIntegrated = false;
    private ThirdAclPolicyDao dao = ThirdAclPolicyDaoSpi.getInstance();
    private final PolicyLocalCacheProcessor localCache = PolicyLocalCacheProcessor.getInstance();
    private boolean isWriteFlag = false;
    private boolean isLastUpdateSuccess = true;
    private long nextForceUpdateTimestamp;

    public GetAclValueTask() {
        this.typeStringMap.put(0, "none");
        this.typeStringMap.put(1, "ranger");
        this.typeStringMap.put(2, "sentry");
        this.nextForceUpdateTimestamp = System.currentTimeMillis() / 1000L + (long)new Random(System.currentTimeMillis()).nextInt(120);
    }

    @Override
    public void run() {
        try {
            this.init();
            this.doTask();
            if (!this.isLastUpdateSuccess) {
                Thread.sleep(2000L);
            }
        }
        catch (StorEngineException e) {
            this.isLastUpdateSuccess = false;
            log.error("StorEngineException in GetAclValueTask", (Throwable)e);
        }
        catch (Exception e) {
            this.isLastUpdateSuccess = false;
            log.error("unknown Exception in GetAclValueTask", (Throwable)e);
        }
    }

    public void init() throws StorEngineException {
        if (this.isFirstStart) {
            this.startWithLocalCache();
            if (this.lastAclMap.isEmpty()) {
                log.warn("can load policy from local cache, load from 810 memcache");
                this.upgradedVersionCompatible();
            }
            SubNotifyTask.getInstance().start();
            this.isFirstStart = false;
        }
    }

    private void doTask() throws StorEngineException {
        long currentSec = System.currentTimeMillis() / 1000L;
        if (currentSec > this.nextForceUpdateTimestamp) {
            this.isLastUpdateSuccess = false;
            this.nextForceUpdateTimestamp = currentSec + 120L;
            log.info("force update, nextForceUpdateTimestamp={}", (Object)this.nextForceUpdateTimestamp);
        }
        boolean isUpdateFlag = SubNotifyTask.getInstance().getUpdateFlag();
        boolean isLocalCache = OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile();
        if ((isUpdateFlag || !this.isLastUpdateSuccess) && (!isLocalCache || isLocalCache && this.localCache.isGetPolicy())) {
            log.info("do set third acl, updateFlag={}, lastUpdateSuccess={}", (Object)isUpdateFlag, (Object)this.isLastUpdateSuccess);
            SubNotifyTask.getInstance().clearUpdateFlag();
            this.isLastUpdateSuccess = this.updateFromCcdb();
        }
        if (isLocalCache && currentSec % 3600L == 0L) {
            this.isWriteFlag = true;
            if (this.localCache.isGetPolicy()) {
                this.updateLocalFile();
            }
        }
    }

    private boolean updateLocalFile() {
        List<ThirdAclPolicyInfo> versions = this.localCache.getAllPolicyVersionInfo();
        log.info("start update localfile versions=[{}]", versions);
        Map<String, AclMemCacheVersion> versionMap = this.convertVersionToInner(versions);
        Set<String> memCacheIds = versionMap.keySet();
        Collection localFiles = FileUtils.listFiles((File)new File(AclConstants.FileData.DIRECTORY_PATH.getValue()), (String[])new String[]{AclConstants.FileData.ACL_DATA_SUFFIX.getValue()}, (boolean)false);
        Map<String, AclLocalFile> localFileMap = this.parseLocalFile(localFiles);
        Set<String> localIds = localFileMap.keySet();
        Collection deleteNamespaceIds = CollectionUtils.subtract(localIds, memCacheIds);
        Collection newNamespaceIds = CollectionUtils.subtract(memCacheIds, localIds);
        List<String> changedNamespaceIds = CollectionUtils.intersection(localIds, memCacheIds).stream().filter(id -> ((AclMemCacheVersion)versionMap.get(id)).getVersion().compareTo(((AclLocalFile)localFileMap.get(id)).getVersion()) > 0).collect(Collectors.toList());
        boolean isSuccess = this.insertOrUpdateAcl(newNamespaceIds, versionMap, true);
        isSuccess = isSuccess && this.insertOrUpdateAcl(changedNamespaceIds, versionMap, false);
        isSuccess = isSuccess && this.deleteAcl(deleteNamespaceIds);
        this.isWriteFlag = false;
        return isSuccess;
    }

    private boolean updateFromCcdb() throws StorEngineException {
        List<ThirdAclPolicyInfo> versions = OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile() ? this.localCache.getAllPolicyVersionInfo() : this.dao.getAllPolicyVersionInfo();
        log.info("start updateFromCcdb versions=[{}]", versions);
        Map<String, AclMemCacheVersion> versionMap = this.convertVersionToInner(versions);
        Set<String> memCacheIds = versionMap.keySet();
        Set<String> localIds = this.lastAclMap.keySet();
        Collection deleteNamespaceIds = CollectionUtils.subtract(localIds, memCacheIds);
        Collection newNamespaceIds = CollectionUtils.subtract(memCacheIds, localIds);
        List<String> changedNamespaceIds = CollectionUtils.intersection(localIds, memCacheIds).stream().filter(id -> ((AclMemCacheVersion)versionMap.get(id)).getVersion().compareTo(this.lastAclMap.get(id).getVersion()) > 0).collect(Collectors.toList());
        boolean isSuccess = this.insertOrUpdateAcl(newNamespaceIds, versionMap, true);
        isSuccess = isSuccess && this.insertOrUpdateAcl(changedNamespaceIds, versionMap, false);
        isSuccess = isSuccess && this.deleteAcl(deleteNamespaceIds);
        return isSuccess;
    }

    private boolean deleteAcl(Collection<String> deleteNamespaceIds) {
        AtomicBoolean result = new AtomicBoolean(true);
        deleteNamespaceIds.forEach(id -> {
            log.debug("the namespaceId need to delete. namespaceId : [{}], current lastAclMap is {}", id, this.lastAclMap);
            File needDeleteFile = this.lastAclMap.get(id).getFile();
            FileUtils.deleteQuietly((File)needDeleteFile);
            if (!OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile() || !this.isWriteFlag) {
                ThirdAclPolicy deleteThirdAclPolicy = ThirdAclPolicy.builder().namespaceId(NumberUtils.toInt((String)id)).type(0).build();
                boolean isDeleteSuccess = EdsClientWrapper.getInstance().setThirdAclPolicies(deleteThirdAclPolicy);
                if (isDeleteSuccess) {
                    this.lastAclMap.remove(id);
                } else {
                    result.set(false);
                }
            }
        });
        return result.get();
    }

    private boolean insertOrUpdateAcl(Collection<String> changedNamespaceIds, Map<String, AclMemCacheVersion> memCacheVersionMap, boolean isInsert) {
        boolean isSuccess = true;
        for (String changedNamespaceId : changedNamespaceIds) {
            AclMemCacheVersion aclMemCacheVersion = memCacheVersionMap.get(changedNamespaceId);
            isSuccess = isSuccess && this.insertOrUpdateAcl(isInsert, changedNamespaceId, aclMemCacheVersion);
        }
        return isSuccess;
    }

    private boolean insertOrUpdateAcl(boolean isInsert, String namespaceId, AclMemCacheVersion aclMemCacheVersion) {
        ThirdAclPolicy data = null;
        boolean isLocalCache = OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile();
        try {
            data = isLocalCache ? this.localCache.getAclPolicyByNamespaceId(NumberUtils.toInt((String)namespaceId)) : this.dao.getAclPolicyByNamespaceId(NumberUtils.toInt((String)namespaceId));
        }
        catch (StorEngineException e) {
            log.error("get policy from db failed", (Throwable)e);
            return false;
        }
        log.debug("get policy from db namespaceId={}, policy={}", (Object)namespaceId, (Object)data.getVersion());
        if (data == null) {
            log.error("can not get data from MemCache by key : {}", (Object)("3osc_hdfs_acl_data_" + namespaceId));
            return false;
        }
        String fileValue = "";
        AclCacheData newAclCacheData = new AclCacheData().setThirdAclPolicy(data).setFiledWithOutFile(aclMemCacheVersion);
        if (isLocalCache && !this.isWriteFlag && !isInsert) {
            return this.changeAcl(isInsert, namespaceId, newAclCacheData, this.lastAclMap.get(namespaceId).getFile(), true);
        }
        try {
            fileValue = this.objectMapper.writeValueAsString((Object)newAclCacheData);
            log.debug("fileValue : {}", (Object)fileValue.substring(0, fileValue.indexOf("policies") + 1));
        }
        catch (JsonProcessingException e) {
            log.error(String.format(Locale.ROOT, "writeValueAsString meet JsonProcessingException ,can not change RangerPolicy : [%s] to String", aclMemCacheVersion), (Throwable)e);
        }
        String tempPathname = AclConstants.FileData.DIRECTORY_PATH.getValue() + File.separator + aclMemCacheVersion.getTempFileName();
        String pathname = AclConstants.FileData.DIRECTORY_PATH.getValue() + File.separator + aclMemCacheVersion.getFileName();
        log.debug("insertOrUpdateAcl will be write , tempFile path : [{}], File path : [{}]", (Object)tempPathname, (Object)pathname);
        File tempFile = new File(tempPathname);
        File file = new File(pathname);
        boolean isWriteFileSuccess = true;
        try {
            FileUtils.writeStringToFile((File)tempFile, (String)fileValue, (Charset)StandardCharsets.UTF_8, (boolean)false);
            if (file.exists()) {
                file.delete();
            }
            FileUtils.moveFile((File)tempFile, (File)file);
        }
        catch (IOException e) {
            isWriteFileSuccess = false;
            log.error(String.format(Locale.ROOT, "write or move tempFile failed ,tempFile path is : [%s], file path : [%s], fileValue is : [%s]", tempPathname, pathname, fileValue.substring(0, fileValue.indexOf("policies") + 1)), (Throwable)e);
        }
        log.debug("new file already be written, file path : [{}] ,file name : [{}]", (Object)file.getPath(), (Object)file.getName());
        if (isLocalCache && this.isWriteFlag) {
            return isWriteFileSuccess;
        }
        return this.changeAcl(isInsert, namespaceId, newAclCacheData, file, isWriteFileSuccess);
    }

    private boolean changeAcl(boolean isInsert, String changedNamespaceId, AclCacheData newAclCacheData, File file, boolean isWriteFileSuccess) {
        boolean isSetPolicySuccess = EdsClientWrapper.getInstance().setThirdAclPolicies(newAclCacheData.getThirdAclPolicy());
        log.debug("need to refresh old map : [{}], write file success : [{}]", (Object)isSetPolicySuccess, (Object)isWriteFileSuccess);
        if (!isSetPolicySuccess || !isWriteFileSuccess) {
            return false;
        }
        AclLocalFile newValue = isInsert ? new AclLocalFile().setFiledWithOutFile(newAclCacheData).setFile(file) : Optional.ofNullable(this.lastAclMap.get(changedNamespaceId).setFiledWithOutFile(newAclCacheData).setFile(file)).orElseGet(() -> new AclLocalFile().setFiledWithOutFile(newAclCacheData).setFile(file));
        log.debug("new value of AclLocalFile : [{}]", (Object)newValue.toString());
        this.lastAclMap.put(changedNamespaceId, newValue);
        return true;
    }

    private void startWithLocalCache() {
        Collection localFiles = FileUtils.listFiles((File)new File(AclConstants.FileData.DIRECTORY_PATH.getValue()), (String[])new String[]{AclConstants.FileData.ACL_DATA_SUFFIX.getValue()}, (boolean)false);
        this.lastAclMap = this.parseLocalFile(localFiles);
        if (this.lastAclMap.isEmpty()) {
            log.warn("did not find any localFile can change to Map<String, AclLocalFile>");
        }
        localFiles.stream().map(file -> {
            try {
                log.debug("local file path : [{}], file name : [{}]", (Object)file.getPath(), (Object)file.getName());
                return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error(String.format(Locale.ROOT, "file can not change to String, file name : [%s]", file.getPath()), (Throwable)e);
                return "";
            }
        }).map(strFileValue -> {
            try {
                log.debug("file data is : [{}]", (Object)strFileValue.substring(0, strFileValue.indexOf("policies") + 1));
                AclCacheData aclCacheData = (AclCacheData)this.objectMapper.readValue(strFileValue, AclCacheData.class);
                log.debug("AclLocalFile is : [{}]", (Object)aclCacheData.toString().substring(0, aclCacheData.toString().indexOf("policies") + 1));
                return aclCacheData;
            }
            catch (JsonProcessingException e) {
                log.error(String.format(Locale.ROOT, "the string can not change to AclCacheData.class, string : [%s]", strFileValue.substring(0, strFileValue.indexOf("policies") + 1)), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).forEach(localFile -> {
            boolean isSetSuccess = EdsClientWrapper.getInstance().setThirdAclPolicies(localFile.getThirdAclPolicy());
            if (!isSetSuccess) {
                this.lastAclMap.remove(localFile.getNamespaceId());
            }
        });
    }

    private Map<String, AclLocalFile> parseLocalFile(Collection<File> files) {
        HashMap<String, AclLocalFile> result = new HashMap<String, AclLocalFile>();
        for (File file : files) {
            AclCacheData aclLocalFileFromLocal;
            String fileDataStr;
            try {
                log.debug("file name is : [{}], file path : [{}]", (Object)file.getName(), (Object)file.getPath());
                fileDataStr = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error(String.format(Locale.ROOT, "can not get file data, file path : [%s], file name : [%s]", file.getPath(), file.getName()), (Throwable)e);
                continue;
            }
            try {
                log.debug("file content is : [{}]", (Object)fileDataStr.substring(0, fileDataStr.indexOf("policies") + 1));
                aclLocalFileFromLocal = (AclCacheData)this.objectMapper.readValue(fileDataStr, AclCacheData.class);
            }
            catch (JsonProcessingException e) {
                log.error(String.format(Locale.ROOT, "can not change string to AclCacheData, String : [%s]", fileDataStr), (Throwable)e);
                continue;
            }
            AclLocalFile aclLocalFile = new AclLocalFile().setFiledWithOutFile(aclLocalFileFromLocal).setFile(file);
            result.put(aclLocalFile.getNamespaceId(), aclLocalFile);
        }
        return result;
    }

    private Map<String, AclMemCacheVersion> convertVersionToInner(List<ThirdAclPolicyInfo> versions) {
        return versions.stream().collect(Collectors.toMap(policyInfo -> String.valueOf(policyInfo.getNamespaceId()), policyInfo -> AclMemCacheVersion.builder().namespaceId(String.valueOf(policyInfo.getNamespaceId())).type(this.typeStringMap.get(policyInfo.getType())).version(policyInfo.getVersion().split("#")[2]).build()));
    }

    private void upgradedVersionCompatible() {
        Optional<String> oldMemCacheVersion = CommonMemCacheUtil.INSTANCE.get("3osc_ranger_version_", String.class);
        if (!oldMemCacheVersion.isPresent()) {
            return;
        }
        String rangerVersion = oldMemCacheVersion.get();
        if (StringUtils.equals((CharSequence)this.oldLastVersion, (CharSequence)rangerVersion)) {
            return;
        }
        Optional<RangerPolicy> rangerPolicy = CommonMemCacheUtil.INSTANCE.get("3osc_ranger_data_", RangerPolicy.class);
        if (!rangerPolicy.isPresent()) {
            return;
        }
        RangerPolicy policy = rangerPolicy.get();
        if (!this.cleanOldLastNamespacePolicy(policy)) {
            return;
        }
        this.setOldCurrentNamespacePolicy(rangerVersion, policy);
    }

    private boolean cleanOldLastNamespacePolicy(RangerPolicy policy) {
        if (policy.getNamespaceId() != this.oldLastNamespaceId && this.oldLastNamespaceId >= 0 && this.isOldLastIntegrated) {
            ThirdAclPolicy deleteThirdAclPolicy = ThirdAclPolicy.builder().namespaceId(this.oldLastNamespaceId).type(0).build();
            log.debug("clean last namespacePolicy");
            return EdsClientWrapper.getInstance().setThirdAclPolicies(deleteThirdAclPolicy);
        }
        return true;
    }

    private void setOldCurrentNamespacePolicy(String version, RangerPolicy policy) {
        if (policy.getNamespaceId() >= 0) {
            ThirdAclPolicy thirdAclPolicy = new ThirdAclPolicy();
            try {
                thirdAclPolicy = AclPolicyConverter.ranger2thirdAcl(policy);
            }
            catch (ThirdAclException e) {
                log.error("change rangerPolicy to thirdAclPolicy failed", (Throwable)e);
            }
            if (!EdsClientWrapper.getInstance().setThirdAclPolicies(thirdAclPolicy)) {
                return;
            }
            this.oldLastVersion = version;
            this.oldLastNamespaceId = policy.getNamespaceId();
            this.isOldLastIntegrated = policy.isIntegrated();
            log.debug("setOldCurrentNamespacePolicy success");
        }
    }

    public Map<String, AclLocalFile> getLastAclMap() {
        return this.lastAclMap;
    }
}

